/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.xmlbeans;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.mojo.xmlbeans.FilteredJarFile;
import org.codehaus.mojo.xmlbeans.XmlBeansException;

public class SchemaArtifact {
    private static final String[] XSD_SUFFIXES = new String[]{"xsd", "XSD"};

    public static Map getFilePaths(Artifact artifact, Log logger, File prefix) throws XmlBeansException {
        HashMap<String, File> xsds = new HashMap<String, File>();
        File artifactFile = artifact.getFile();
        if (artifactFile != null) {
            try {
                FilteredJarFile jarFile = new FilteredJarFile(artifactFile, logger);
                List nextSet = jarFile.getEntryPathsAndExtract(XSD_SUFFIXES, prefix);
                Iterator i = nextSet.iterator();
                while (i.hasNext()) {
                    String fileName = (String)i.next();
                    logger.debug((CharSequence)("Adding " + fileName + "from an artifact."));
                    xsds.put(fileName, new File(prefix, fileName));
                }
            }
            catch (IOException ioe) {
                throw new XmlBeansException(XmlBeansException.XSD_ARTIFACT_JAR, ioe);
            }
        } else {
            throw new XmlBeansException(XmlBeansException.ARTIFACT_FILE_PATH, artifact.toString());
        }
        return xsds;
    }
}

