/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.webstart.sign;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.shared.jarsigner.JarSignerRequest;
import org.apache.maven.shared.jarsigner.JarSignerSignRequest;
import org.apache.maven.shared.jarsigner.JarSignerVerifyRequest;
import org.codehaus.mojo.keytool.requests.KeyToolGenerateKeyPairRequest;
import org.codehaus.mojo.webstart.sign.KeystoreConfig;
import org.codehaus.mojo.webstart.sign.SignTool;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcher;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcherException;

public class SignConfig {
    private File workDirectory;
    private boolean verbose;
    private KeystoreConfig keystoreConfig;
    private String keystore;
    private File workingKeystore;
    private String keyalg;
    private String keysize;
    private String sigalg;
    private String sigfile;
    private String storetype;
    private String storepass;
    private String keypass;
    private String validity;
    private String dnameCn;
    private String dnameOu;
    private String dnameL;
    private String dnameSt;
    private String dnameO;
    private String dnameC;
    private String alias;
    private boolean verify;
    private String maxMemory;
    private String tsaLocation;
    private SecDispatcher securityDispatcher;
    private List<String> arguments;
    private String httpProxyHost;
    private String httpProxyPort;
    private String httpsProxyHost;
    private String httpsProxyPort;

    public void init(File workDirectory, boolean verbose, SignTool signTool, SecDispatcher securityDispatcher, ClassLoader classLoader) throws MojoExecutionException {
        File keystoreFile;
        this.workDirectory = workDirectory;
        this.securityDispatcher = securityDispatcher;
        this.setVerbose(verbose);
        if (this.workingKeystore == null) {
            this.workingKeystore = new File(workDirectory, "workingKeystore");
        }
        if (this.keystoreConfig != null && this.keystoreConfig.isGen()) {
            keystoreFile = new File(this.getKeystore());
            if (this.keystoreConfig.isDelete()) {
                signTool.deleteKeyStore(keystoreFile, this.isVerbose());
            }
            signTool.generateKey(this, keystoreFile);
        } else {
            keystoreFile = signTool.getKeyStoreFile(this.getKeystore(), this.workingKeystore, classLoader);
            this.setKeystore(keystoreFile.getAbsolutePath());
        }
        keystoreFile = new File(this.getKeystore());
        if (!keystoreFile.exists()) {
            throw new MojoExecutionException("Could not obtain key store location at " + this.keystore);
        }
        this.arguments = new ArrayList<String>();
    }

    public JarSignerRequest createSignRequest(File jarToSign, File signedJar) throws MojoExecutionException {
        JarSignerSignRequest request = new JarSignerSignRequest();
        request.setAlias(this.getAlias());
        request.setKeystore(this.getKeystore());
        request.setSigfile(this.getSigfile());
        request.setStoretype(this.getStoretype());
        request.setWorkingDirectory(this.workDirectory);
        request.setMaxMemory(this.getMaxMemory());
        request.setVerbose(this.isVerbose());
        request.setArchive(jarToSign);
        request.setSignedjar(signedJar);
        request.setTsaLocation(this.getTsaLocation());
        request.setKeypass(this.decrypt(this.keypass));
        request.setStorepass(this.decrypt(this.storepass));
        if (this.httpProxyHost != null) {
            this.arguments.add("-J-Dhttp.proxyHost=" + this.httpProxyHost);
        }
        if (this.httpProxyPort != null) {
            this.arguments.add("-J-Dhttp.proxyPort=" + this.httpProxyPort);
        }
        if (this.httpsProxyHost != null) {
            this.arguments.add("-J-Dhttps.proxyHost=" + this.httpsProxyHost);
        }
        if (this.httpsProxyPort != null) {
            this.arguments.add("-J-Dhttps.proxyPort=" + this.httpsProxyPort);
        }
        if (!this.arguments.isEmpty()) {
            request.setArguments(this.arguments.toArray(new String[this.arguments.size()]));
        }
        return request;
    }

    public JarSignerRequest createVerifyRequest(File jarFile, boolean certs) {
        JarSignerVerifyRequest request = new JarSignerVerifyRequest();
        request.setCerts(certs);
        request.setWorkingDirectory(this.workDirectory);
        request.setMaxMemory(this.getMaxMemory());
        request.setVerbose(this.isVerbose());
        request.setArchive(jarFile);
        return request;
    }

    public KeyToolGenerateKeyPairRequest createKeyGenRequest(File keystoreFile) {
        KeyToolGenerateKeyPairRequest request = new KeyToolGenerateKeyPairRequest();
        request.setAlias(this.getAlias());
        request.setDname(this.getDname());
        request.setKeyalg(this.getKeyalg());
        request.setKeypass(this.getKeypass());
        request.setKeysize(this.getKeysize());
        request.setKeystore(this.getKeystore());
        request.setSigalg(this.getSigalg());
        request.setStorepass(this.getStorepass());
        request.setStoretype(this.getStoretype());
        request.setValidity(this.getValidity());
        request.setVerbose(this.isVerbose());
        request.setWorkingDirectory(this.workDirectory);
        return request;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setWorkDirectory(File workDirectory) {
        this.workDirectory = workDirectory;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setMaxMemory(String maxMemory) {
        this.maxMemory = maxMemory;
    }

    public void setKeystoreConfig(KeystoreConfig keystoreConfig) {
        this.keystoreConfig = keystoreConfig;
    }

    public void setKeystore(String keystore) {
        this.keystore = keystore;
    }

    public void setWorkingKeystore(File workingKeystore) {
        this.workingKeystore = workingKeystore;
    }

    public void setKeyalg(String keyalg) {
        this.keyalg = keyalg;
    }

    public void setKeysize(String keysize) {
        this.keysize = keysize;
    }

    public void setSigalg(String sigalg) {
        this.sigalg = sigalg;
    }

    public void setSigfile(String sigfile) {
        this.sigfile = sigfile;
    }

    public void setStoretype(String storetype) {
        this.storetype = storetype;
    }

    public void setStorepass(String storepass) {
        this.storepass = storepass;
    }

    public void setKeypass(String keypass) {
        this.keypass = keypass;
    }

    public void setValidity(String validity) {
        this.validity = validity;
    }

    public void setDnameCn(String dnameCn) {
        this.dnameCn = dnameCn;
    }

    public void setDnameOu(String dnameOu) {
        this.dnameOu = dnameOu;
    }

    public void setDnameL(String dnameL) {
        this.dnameL = dnameL;
    }

    public void setDnameSt(String dnameSt) {
        this.dnameSt = dnameSt;
    }

    public void setDnameO(String dnameO) {
        this.dnameO = dnameO;
    }

    public void setDnameC(String dnameC) {
        this.dnameC = dnameC;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public void setVerify(boolean verify) {
        this.verify = verify;
    }

    public void setTsaLocation(String tsaLocation) {
        this.tsaLocation = tsaLocation;
    }

    public void setArguments(String[] arguments) {
        Collections.addAll(this.arguments, arguments);
    }

    public String getKeystore() {
        return this.keystore;
    }

    public String getKeyalg() {
        return this.keyalg;
    }

    public String getKeysize() {
        return this.keysize;
    }

    public String getSigalg() {
        return this.sigalg;
    }

    public String getSigfile() {
        return this.sigfile;
    }

    public String getStoretype() {
        return this.storetype;
    }

    public String getStorepass() {
        return this.storepass;
    }

    public String getKeypass() {
        return this.keypass;
    }

    public String getValidity() {
        return this.validity;
    }

    public String getDnameCn() {
        return this.dnameCn;
    }

    public String getDnameOu() {
        return this.dnameOu;
    }

    public String getDnameL() {
        return this.dnameL;
    }

    public String getDnameSt() {
        return this.dnameSt;
    }

    public String getDnameO() {
        return this.dnameO;
    }

    public String getDnameC() {
        return this.dnameC;
    }

    public String getAlias() {
        return this.alias;
    }

    public boolean isVerify() {
        return this.verify;
    }

    public String getTsaLocation() {
        return this.tsaLocation;
    }

    public String getMaxMemory() {
        return this.maxMemory;
    }

    public String[] getArguments() {
        return this.arguments.toArray(new String[this.arguments.size()]);
    }

    public String getHttpProxyHost() {
        return this.httpProxyHost;
    }

    public void setHttpProxyHost(String httpProxyHost) {
        this.httpProxyHost = httpProxyHost;
    }

    public String getHttpProxyPort() {
        return this.httpProxyPort;
    }

    public void setHttpProxyPort(String httpProxyPort) {
        this.httpProxyPort = httpProxyPort;
    }

    public String getHttpsProxyHost() {
        return this.httpsProxyHost;
    }

    public void setHttpsProxyHost(String httpsProxyHost) {
        this.httpsProxyHost = httpsProxyHost;
    }

    public String getHttpsProxyPort() {
        return this.httpsProxyPort;
    }

    public void setHttpsProxyPort(String httpsProxyPort) {
        this.httpsProxyPort = httpsProxyPort;
    }

    public String getDname() {
        StringBuffer buffer = new StringBuffer(128);
        this.appendToDnameBuffer(this.dnameCn, buffer, "CN");
        this.appendToDnameBuffer(this.dnameOu, buffer, "OU");
        this.appendToDnameBuffer(this.dnameL, buffer, "L");
        this.appendToDnameBuffer(this.dnameSt, buffer, "ST");
        this.appendToDnameBuffer(this.dnameO, buffer, "O");
        this.appendToDnameBuffer(this.dnameC, buffer, "C");
        return buffer.toString();
    }

    private void appendToDnameBuffer(String property, StringBuffer buffer, String prefix) {
        if (property != null) {
            if (buffer.length() > 0) {
                buffer.append(", ");
            }
            buffer.append(prefix).append("=");
            buffer.append(property.replaceAll(",", "\\\\,"));
        }
    }

    private String decrypt(String encoded) throws MojoExecutionException {
        try {
            return this.securityDispatcher.decrypt(encoded);
        }
        catch (SecDispatcherException e) {
            throw new MojoExecutionException("error using security dispatcher: " + e.getMessage(), (Exception)((Object)e));
        }
    }
}

