/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.io.File;
import java.util.List;
import java.util.Locale;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.artifact.metadata.ArtifactMetadataRetrievalException;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.siterenderer.Renderer;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.path.PathTranslator;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.apache.maven.settings.Settings;
import org.codehaus.mojo.versions.api.ArtifactVersions;
import org.codehaus.mojo.versions.api.DefaultVersionsHelper;
import org.codehaus.mojo.versions.api.VersionsHelper;
import org.codehaus.plexus.i18n.I18N;

public abstract class AbstractVersionsReport
extends AbstractMavenReport {
    private Renderer siteRenderer;
    private I18N i18n;
    private MavenProject project;
    protected ArtifactFactory artifactFactory;
    private ArtifactResolver resolver;
    private File outputDirectory;
    private Boolean skip;
    protected ArtifactMetadataSource artifactMetadataSource;
    protected List remoteArtifactRepositories;
    protected List remotePluginRepositories;
    protected ArtifactRepository localRepository;
    private WagonManager wagonManager;
    private Settings settings;
    private String serverId;
    private String rulesUri;
    protected String comparisonMethod;
    protected Boolean allowSnapshots;
    private VersionsHelper helper;
    protected MavenSession session;
    protected PathTranslator pathTranslator;
    protected ArtifactResolver artifactResolver;

    public VersionsHelper getHelper() throws MavenReportException {
        if (this.helper == null) {
            try {
                this.helper = new DefaultVersionsHelper(this.artifactFactory, this.artifactResolver, this.artifactMetadataSource, this.remoteArtifactRepositories, this.remotePluginRepositories, this.localRepository, this.wagonManager, this.settings, this.serverId, this.rulesUri, this.getLog(), this.session, this.pathTranslator);
            }
            catch (MojoExecutionException e) {
                throw new MavenReportException(e.getMessage(), (Exception)((Object)e));
            }
        }
        return this.helper;
    }

    protected void executeReport(Locale locale) throws MavenReportException {
        if (!Boolean.TRUE.equals(this.skip)) {
            try {
                this.doGenerateReport(locale, this.getSink());
            }
            catch (MojoExecutionException e) {
                throw new MavenReportException(e.getMessage(), (Exception)((Object)e));
            }
        }
    }

    protected abstract void doGenerateReport(Locale var1, Sink var2) throws MavenReportException, MojoExecutionException;

    protected ArtifactVersion findLatestVersion(Artifact artifact, VersionRange versionRange, Boolean allowingSnapshots, boolean usePluginRepositories) throws MavenReportException {
        boolean includeSnapshots = Boolean.TRUE.equals(this.allowSnapshots);
        if (Boolean.TRUE.equals(allowingSnapshots)) {
            includeSnapshots = true;
        }
        if (Boolean.FALSE.equals(allowingSnapshots)) {
            includeSnapshots = false;
        }
        try {
            ArtifactVersions artifactVersions = this.getHelper().lookupArtifactVersions(artifact, usePluginRepositories);
            return artifactVersions.getNewestVersion(versionRange, includeSnapshots);
        }
        catch (ArtifactMetadataRetrievalException e) {
            throw new MavenReportException(e.getMessage(), (Exception)((Object)e));
        }
    }

    protected MavenProject getProject() {
        return this.project;
    }

    protected String getOutputDirectory() {
        if (!this.outputDirectory.isAbsolute()) {
            this.outputDirectory = new File(this.project.getBasedir(), this.outputDirectory.getPath());
        }
        return this.outputDirectory.getAbsolutePath();
    }

    protected Renderer getSiteRenderer() {
        return this.siteRenderer;
    }

    public String getDescription(Locale locale) {
        return this.getText(locale, "report.description");
    }

    public String getName(Locale locale) {
        return this.getText(locale, "report.title");
    }

    public String getText(Locale locale, String key) {
        return this.i18n.getString(this.getOutputName(), locale, key);
    }

    public Boolean getAllowSnapshots() {
        return this.allowSnapshots;
    }

    public String getComparisonMethod() {
        return this.comparisonMethod;
    }

    public ArtifactResolver getResolver() {
        return this.resolver;
    }

    public I18N getI18n() {
        return this.i18n;
    }
}

