/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.MavenReportException;
import org.apache.maven.wagon.Wagon;
import org.codehaus.mojo.versions.AbstractDependencyUpdatesReportMojo;
import org.codehaus.mojo.versions.reporting.ReportRendererFactory;
import org.codehaus.mojo.versions.reporting.util.AggregateReportUtils;
import org.codehaus.plexus.i18n.I18N;
import org.eclipse.aether.RepositorySystem;

@Mojo(name="dependency-updates-aggregate-report", requiresDependencyResolution=ResolutionScope.RUNTIME, threadSafe=true, aggregator=true)
public class DependencyUpdatesAggregateReportMojo
extends AbstractDependencyUpdatesReportMojo {
    @Inject
    protected DependencyUpdatesAggregateReportMojo(I18N i18n, ArtifactHandlerManager artifactHandlerManager, RepositorySystem repositorySystem, Map<String, Wagon> wagonMap, ReportRendererFactory rendererFactory) {
        super(i18n, artifactHandlerManager, repositorySystem, wagonMap, rendererFactory);
    }

    @Override
    protected void populateDependencies(Set<Dependency> dependenciesCollector) {
        this.getLog().debug((CharSequence)String.format("Collecting dependencies for project %s", this.project.getName()));
        for (MavenProject project : AggregateReportUtils.getProjectsToProcess(this.getProject())) {
            dependenciesCollector.addAll(project.getDependencies());
        }
    }

    @Override
    protected void populateDependencyManagement(Set<Dependency> dependencyManagementCollector, Set<Dependency> dependencies) throws MavenReportException {
        for (MavenProject project : AggregateReportUtils.getProjectsToProcess(this.getProject())) {
            this.getLog().debug((CharSequence)String.format("Collecting managed dependencies for project %s", project.getName()));
            this.handleDependencyManagementTransitive(project, dependencyManagementCollector);
        }
    }

    @Override
    public String getOutputName() {
        return "dependency-updates-aggregate-report";
    }
}

