/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions.reporting;

import java.util.Arrays;
import java.util.Locale;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.reporting.AbstractMavenReportRenderer;
import org.codehaus.plexus.i18n.I18N;

public abstract class VersionsReportRendererBase
extends AbstractMavenReportRenderer {
    protected final I18N i18n;
    protected Locale locale;
    protected String bundleName;

    public VersionsReportRendererBase(Sink sink, I18N i18n, Locale locale, String bundleName) {
        super(sink);
        this.i18n = i18n;
        this.locale = locale;
        this.bundleName = bundleName;
    }

    public String getTitle() {
        return this.getText("report.title");
    }

    public String getText(String key) {
        return this.i18n.getString(this.bundleName, this.locale, key);
    }

    protected void renderWarningIcon() {
        this.sink.figureGraphics("images/icon_warning_sml.gif");
    }

    protected void renderSuccessIcon() {
        this.sink.figureGraphics("images/icon_success_sml.gif");
    }

    protected boolean equals(ArtifactVersion v1, ArtifactVersion v2) {
        return v1 == v2 || v1 != null && v1.equals(v2) || v1 != null && v2 != null && v1.toString().equals(v2.toString());
    }

    protected void safeBold() {
        try {
            this.sink.bold();
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
    }

    protected void safeBold_() {
        try {
            this.sink.bold_();
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
    }

    protected void safeItalic() {
        try {
            this.sink.italic();
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
    }

    protected void safeItalic_() {
        try {
            this.sink.italic_();
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
    }

    protected void renderTableHeaderCells(String ... keys) {
        Arrays.stream(keys).map(this::getText).forEachOrdered(str -> {
            this.sink.tableHeaderCell();
            this.sink.text(str);
            this.sink.tableHeaderCell_();
        });
    }

    protected void renderBoldCell(Object object) {
        this.renderBoldCell(true, object);
    }

    protected void renderCell(Object object) {
        this.renderBoldCell(false, object);
    }

    protected void renderCells(Object ... objects) {
        for (Object object : objects) {
            this.renderBoldCell(false, object);
        }
    }

    protected void renderBoldCell(boolean bold, Object object) {
        this.sink.tableCell();
        this.renderBoldText(bold, object);
        this.sink.tableCell_();
    }

    protected void renderBoldText(boolean bold, Object object) {
        String text;
        if (object != null && !(text = object.toString()).isEmpty()) {
            if (bold) {
                this.safeBold();
            }
            this.sink.text(text);
            if (bold) {
                this.safeBold_();
            }
        }
    }
}

