/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions.reporting;

import java.util.Collection;
import java.util.Optional;
import org.codehaus.mojo.versions.api.AbstractVersionDetails;
import org.codehaus.mojo.versions.api.ArtifactVersionsCache;
import org.codehaus.mojo.versions.api.PluginUpdatesDetails;
import org.codehaus.mojo.versions.api.Segment;
import org.codehaus.mojo.versions.reporting.OverviewStats;

public class PluginOverviewStats
extends OverviewStats {
    private int dependencies;

    public int getDependencies() {
        return this.dependencies;
    }

    public void incrementDependencies() {
        ++this.dependencies;
    }

    public static <T extends OverviewStats, V extends AbstractVersionDetails> T fromUpdates(Collection<V> updates, ArtifactVersionsCache cache) {
        PluginOverviewStats stats = new PluginOverviewStats();
        updates.forEach(details -> {
            if (PluginOverviewStats.getNewestUpdate(cache, details, Optional.of(Segment.SUBINCREMENTAL)) != null) {
                stats.incrementAny();
            } else if (PluginOverviewStats.getNewestUpdate(cache, details, Optional.of(Segment.INCREMENTAL)) != null) {
                stats.incrementIncremental();
            } else if (PluginOverviewStats.getNewestUpdate(cache, details, Optional.of(Segment.MINOR)) != null) {
                stats.incrementMinor();
            } else if (PluginOverviewStats.getNewestUpdate(cache, details, Optional.of(Segment.MAJOR)) != null) {
                stats.incrementMajor();
            } else {
                stats.incrementUpToDate();
            }
            if (((PluginUpdatesDetails)details).isDependencyUpdateAvailable()) {
                stats.incrementDependencies();
            }
        });
        return (T)stats;
    }
}

