/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions.xml;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.maven.model.Dependency;
import org.codehaus.mojo.versions.api.AbstractVersionDetails;
import org.codehaus.mojo.versions.api.ArtifactVersions;
import org.codehaus.mojo.versions.api.ArtifactVersionsCache;
import org.codehaus.mojo.versions.api.ReportRenderer;
import org.codehaus.mojo.versions.api.Segment;
import org.codehaus.mojo.versions.reporting.OverviewStats;
import org.codehaus.mojo.versions.reporting.model.DependencyInfo;
import org.codehaus.mojo.versions.reporting.model.DependencyReportSummary;
import org.codehaus.mojo.versions.reporting.model.DependencyUpdatesModel;
import org.codehaus.mojo.versions.reporting.model.DependencyUpdatesReport;
import org.codehaus.mojo.versions.reporting.model.io.xpp3.DependencyUpdatesReportXpp3Writer;

public class DependencyUpdatesXmlReportRenderer
implements ReportRenderer {
    private final DependencyUpdatesModel model;
    private final Path outputFile;
    private final ArtifactVersionsCache newestUpdateCache = new ArtifactVersionsCache(AbstractVersionDetails::getNewestUpdate);

    public DependencyUpdatesXmlReportRenderer(DependencyUpdatesModel model, Path outputFile) {
        this.model = model;
        this.outputFile = outputFile;
    }

    @Override
    public void render() {
        try (BufferedWriter writer = Files.newBufferedWriter(this.outputFile, StandardCharsets.UTF_8, new OpenOption[0]);){
            new DependencyUpdatesReportXpp3Writer().write(writer, new DependencyUpdatesReport(){
                {
                    this.setSummary(new DependencyReportSummary(){
                        {
                            Object overviewStats = OverviewStats.fromUpdates(DependencyUpdatesXmlReportRenderer.this.model.getAllUpdates().values(), DependencyUpdatesXmlReportRenderer.this.newestUpdateCache);
                            this.setUsingLastVersion(String.valueOf(((OverviewStats)overviewStats).getUpToDate()));
                            this.setNextVersionAvailable(String.valueOf(((OverviewStats)overviewStats).getAny()));
                            this.setNextIncrementalAvailable(String.valueOf(((OverviewStats)overviewStats).getIncremental()));
                            this.setNextMinorAvailable(String.valueOf(((OverviewStats)overviewStats).getMinor()));
                            this.setNextMajorAvailable(String.valueOf(((OverviewStats)overviewStats).getMajor()));
                        }
                    });
                    this.setDependencyManagements(DependencyUpdatesXmlReportRenderer.createDependencyInfo(DependencyUpdatesXmlReportRenderer.this.model.getArtifactManagementUpdates()));
                    this.setDependencies(DependencyUpdatesXmlReportRenderer.createDependencyInfo(DependencyUpdatesXmlReportRenderer.this.model.getArtifactUpdates()));
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void setSection(ArtifactVersions versions, Segment segment, Consumer<List<String>> setterFunction) {
        Optional.ofNullable(versions.getAllUpdates(Optional.of(segment))).map(v -> Arrays.stream(v).map(Object::toString).collect(Collectors.toList())).ifPresent(setterFunction);
    }

    private static List<DependencyInfo> createDependencyInfo(Map<Dependency, ArtifactVersions> versions) {
        return versions.entrySet().stream().map(e -> new DependencyInfo((Map.Entry)e){
            final /* synthetic */ Map.Entry val$e;
            {
                this.val$e = entry;
                this.setGroupId(((Dependency)this.val$e.getKey()).getGroupId());
                this.setArtifactId(((Dependency)this.val$e.getKey()).getArtifactId());
                this.setCurrentVersion(((Dependency)this.val$e.getKey()).getVersion());
                this.setScope(((Dependency)this.val$e.getKey()).getScope());
                this.setType(((Dependency)this.val$e.getKey()).getType());
                this.setClassifier(((Dependency)this.val$e.getKey()).getClassifier());
                Optional.ofNullable(((ArtifactVersions)this.val$e.getValue()).getNewestUpdate(Optional.empty())).map(Object::toString).ifPresent(this::setLastVersion);
                DependencyUpdatesXmlReportRenderer.setSection((ArtifactVersions)this.val$e.getValue(), Segment.INCREMENTAL, this::setIncrementals);
                DependencyUpdatesXmlReportRenderer.setSection((ArtifactVersions)this.val$e.getValue(), Segment.MINOR, this::setMinors);
                DependencyUpdatesXmlReportRenderer.setSection((ArtifactVersions)this.val$e.getValue(), Segment.MAJOR, this::setMajors);
                this.setStatus(this.getLastVersion() == null ? "no new available" : (this.getIncrementals() != null ? "incremental available" : (this.getMinors() != null ? "minor available" : "major available")));
            }
        }).collect(Collectors.toList());
    }
}

