/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions.ordering;

import java.util.Iterator;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.codehaus.mojo.versions.api.Segment;
import org.codehaus.mojo.versions.ordering.ComparableVersion;

public class BoundArtifactVersion
extends DefaultArtifactVersion {
    private final Segment segment;
    private final BoundComparableVersion comparator;

    public BoundArtifactVersion(ArtifactVersion artifactVersion, Segment segment) {
        super(artifactVersion.toString());
        this.segment = segment;
        this.comparator = new BoundComparableVersion(this);
    }

    public Segment getSegment() {
        return this.segment;
    }

    public int compareTo(ArtifactVersion other) {
        if (other == null) {
            return -1;
        }
        return this.comparator.compareTo(new ComparableVersion(other.toString()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BoundArtifactVersion)) {
            return false;
        }
        BoundArtifactVersion that = (BoundArtifactVersion)((Object)o);
        return new EqualsBuilder().appendSuper(super.equals(o)).append((Object)this.getSegment(), (Object)that.getSegment()).append((Object)this.comparator, (Object)that.comparator).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).appendSuper(super.hashCode()).append((Object)this.getSegment()).append((Object)this.comparator).toHashCode();
    }

    protected static class BoundComparableVersion
    extends ComparableVersion {
        private BoundArtifactVersion artifactVersion;

        protected BoundComparableVersion(BoundArtifactVersion artifactVersion) {
            super(artifactVersion.toString());
            this.artifactVersion = artifactVersion;
        }

        @Override
        public int compareTo(ComparableVersion o) {
            return this.compareTo(this.items.iterator(), o.items.iterator(), this.artifactVersion.segment.value());
        }

        private int compareTo(Iterator<ComparableVersion.Item> left, Iterator<ComparableVersion.Item> right, int comparisonsLeft) {
            if (comparisonsLeft <= 0) {
                return 1;
            }
            int result = left.hasNext() && right.hasNext() ? BoundComparableVersion.integerItemOrZero(left.next()).compareTo(right.next()) : (left.hasNext() || right.hasNext() ? BoundComparableVersion.compareToZero(left, right) : 1);
            return result != 0 ? result : this.compareTo(left, right, comparisonsLeft - 1);
        }

        private static int compareToZero(Iterator<ComparableVersion.Item> left, Iterator<ComparableVersion.Item> right) {
            return left.hasNext() ? BoundComparableVersion.integerItemOrZero(left.next()).compareTo(ComparableVersion.IntegerItem.ZERO) : -right.next().compareTo(ComparableVersion.IntegerItem.ZERO);
        }

        private static ComparableVersion.Item integerItemOrZero(ComparableVersion.Item item) {
            return item instanceof ComparableVersion.IntegerItem ? item : ComparableVersion.IntegerItem.ZERO;
        }
    }
}

