/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.TreeSet;
import javax.inject.Inject;
import javax.xml.stream.XMLStreamException;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.artifact.metadata.ArtifactMetadataRetrievalException;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.repository.RepositorySystem;
import org.codehaus.mojo.versions.AbstractVersionsDisplayMojo;
import org.codehaus.mojo.versions.Property;
import org.codehaus.mojo.versions.api.PropertyVersions;
import org.codehaus.mojo.versions.api.Segment;
import org.codehaus.mojo.versions.ordering.InvalidSegmentException;
import org.codehaus.mojo.versions.rewriting.ModifiedPomXMLEventReader;
import org.codehaus.mojo.versions.utils.SegmentUtils;

@Mojo(name="display-property-updates", threadSafe=true)
public class DisplayPropertyUpdatesMojo
extends AbstractVersionsDisplayMojo {
    private static final int INFO_PAD_SIZE = 68;
    @Parameter
    private Property[] properties;
    @Parameter(property="includeProperties")
    private String includeProperties = null;
    @Parameter(property="excludeProperties")
    private String excludeProperties = null;
    @Parameter(property="autoLinkItems", defaultValue="true")
    private boolean autoLinkItems;
    @Parameter(property="allowMajorUpdates", defaultValue="true")
    private boolean allowMajorUpdates;
    @Parameter(property="allowMinorUpdates", defaultValue="true")
    private boolean allowMinorUpdates;
    @Parameter(property="allowIncrementalUpdates", defaultValue="true")
    private boolean allowIncrementalUpdates;

    @Inject
    public DisplayPropertyUpdatesMojo(RepositorySystem repositorySystem, MavenProjectBuilder projectBuilder, ArtifactMetadataSource artifactMetadataSource, WagonManager wagonManager, ArtifactResolver artifactResolver) {
        super(repositorySystem, projectBuilder, artifactMetadataSource, wagonManager, artifactResolver);
    }

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        this.logInit();
        ArrayList<String> current = new ArrayList<String>();
        ArrayList<String> updates = new ArrayList<String>();
        Map<Property, PropertyVersions> propertyVersions = this.getHelper().getVersionPropertiesMap(this.getProject(), this.properties, this.includeProperties, this.excludeProperties, this.autoLinkItems);
        for (Map.Entry<Property, PropertyVersions> entry : propertyVersions.entrySet()) {
            Property property = entry.getKey();
            PropertyVersions version = entry.getValue();
            String currentVersion = this.getProject().getProperties().getProperty(property.getName());
            if (currentVersion == null) continue;
            Optional<Segment> unchangedSegment = SegmentUtils.determineUnchangedSegment(this.allowMajorUpdates, this.allowMinorUpdates, this.allowIncrementalUpdates, this.getLog());
            try {
                StringBuilder buf;
                ArtifactVersion winner = version.getNewestVersion(currentVersion, property, this.allowSnapshots, this.reactorProjects, this.getHelper(), false, unchangedSegment);
                if (winner != null && !currentVersion.equals(winner.toString())) {
                    buf = new StringBuilder();
                    buf.append("${");
                    buf.append(property.getName());
                    buf.append("} ");
                    String newVersion = winner.toString();
                    int padding = 68 - currentVersion.length() - newVersion.length() - 4 + this.getOutputLineWidthOffset();
                    while (buf.length() < padding) {
                        buf.append('.');
                    }
                    buf.append(' ');
                    buf.append(currentVersion);
                    buf.append(" -> ");
                    buf.append(newVersion);
                    updates.add(buf.toString());
                    continue;
                }
                buf = new StringBuilder();
                buf.append("${");
                buf.append(property.getName());
                buf.append("} ");
                int padding = 68 - currentVersion.length() + this.getOutputLineWidthOffset();
                while (buf.length() < padding) {
                    buf.append('.');
                }
                buf.append(' ');
                buf.append(currentVersion);
                current.add(buf.toString());
            }
            catch (InvalidVersionSpecificationException | InvalidSegmentException e) {
                this.getLog().warn((CharSequence)String.format("Skipping the processing of %s:%s due to: %s", property.getName(), property.getVersion(), e.getMessage()));
            }
        }
        this.logLine(false, "");
        if (!current.isEmpty()) {
            this.logLine(false, "The following version properties are referencing the newest available version:");
            for (String s : new TreeSet(current)) {
                this.logLine(false, "  " + s);
            }
        }
        if (updates.isEmpty() && current.isEmpty()) {
            this.logLine(false, "This project does not have any properties associated with versions.");
        } else if (updates.isEmpty()) {
            this.logLine(false, "All version properties are referencing the newest version available.");
        }
        if (!updates.isEmpty()) {
            this.logLine(false, "The following version property updates are available:");
            for (String update : new TreeSet(updates)) {
                this.logLine(false, "  " + update);
            }
        }
        this.logLine(false, "");
    }

    @Override
    protected void update(ModifiedPomXMLEventReader pom) throws MojoExecutionException, MojoFailureException, XMLStreamException, ArtifactMetadataRetrievalException {
    }
}

