/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.io.File;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import org.apache.maven.artifact.metadata.ArtifactMetadataRetrievalException;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.mojo.versions.AbstractVersionsReport;
import org.codehaus.mojo.versions.DependencyUpdatesRenderer;
import org.codehaus.mojo.versions.DependencyUpdatesXmlRenderer;
import org.codehaus.mojo.versions.api.ArtifactVersions;
import org.codehaus.mojo.versions.utils.DependencyComparator;
import org.codehaus.mojo.versions.utils.MiscUtils;

@Mojo(name="dependency-updates-report", requiresDependencyResolution=ResolutionScope.RUNTIME, threadSafe=true)
public class DependencyUpdatesReport
extends AbstractVersionsReport {
    @Parameter(property="processDependencyManagement", defaultValue="true")
    protected boolean processDependencyManagement;
    @Parameter(property="processDependencyManagementTransitive", defaultValue="true")
    protected boolean processDependencyManagementTransitive;
    @Parameter(property="dependencyUpdatesReportFormats", defaultValue="html")
    protected String[] formats = new String[]{"html"};
    @Parameter(property="onlyProjectDependencies", defaultValue="false")
    protected boolean onlyProjectDependencies;
    @Parameter(property="onlyUpgradable", defaultValue="false")
    protected boolean onlyUpgradable;

    public boolean isExternalReport() {
        return false;
    }

    public boolean canGenerateReport() {
        return true;
    }

    @Override
    protected void doGenerateReport(Locale locale, Sink sink) throws MavenReportException {
        TreeSet<Dependency> dependencies = new TreeSet<Dependency>(new DependencyComparator());
        dependencies.addAll(this.getProject().getDependencies());
        TreeSet<Dependency> dependencyManagement = new TreeSet<Dependency>(new DependencyComparator());
        if (this.processDependencyManagement) {
            if (this.processDependencyManagementTransitive) {
                if (this.getProject().getDependencyManagement() != null && this.getProject().getDependencyManagement().getDependencies() != null) {
                    for (Dependency dep2 : this.getProject().getDependencyManagement().getDependencies()) {
                        this.getLog().debug((CharSequence)("Dpmg: " + dep2.getGroupId() + ":" + dep2.getArtifactId() + ":" + dep2.getVersion() + ":" + dep2.getType() + ":" + dep2.getScope()));
                    }
                    dependencyManagement.addAll(this.getProject().getDependencyManagement().getDependencies());
                }
            } else if (this.getProject().getOriginalModel().getDependencyManagement() != null && this.getProject().getOriginalModel().getDependencyManagement().getDependencies() != null) {
                for (Dependency dep2 : this.getProject().getOriginalModel().getDependencyManagement().getDependencies()) {
                    this.getLog().debug((CharSequence)("Original Dpmg: " + dep2.getGroupId() + ":" + dep2.getArtifactId() + ":" + dep2.getVersion() + ":" + dep2.getType() + ":" + dep2.getScope()));
                }
                dependencyManagement.addAll(this.getProject().getOriginalModel().getDependencyManagement().getDependencies());
            }
            if (!this.onlyProjectDependencies) {
                dependencies.removeIf(dep -> dependencyManagement.stream().anyMatch(dmDep -> this.match((Dependency)dep, (Dependency)dmDep)));
            } else {
                dependencyManagement.removeIf(dep -> dependencies.stream().noneMatch(dmDep -> this.match((Dependency)dep, (Dependency)dmDep)));
            }
        }
        try {
            Map<Dependency, ArtifactVersions> dependencyManagementUpdates;
            Map<Dependency, ArtifactVersions> dependencyUpdates = this.getHelper().lookupDependenciesUpdates(dependencies, false);
            Map<Dependency, ArtifactVersions> map = dependencyManagementUpdates = this.processDependencyManagement ? this.getHelper().lookupDependenciesUpdates(dependencyManagement, false) : Collections.EMPTY_MAP;
            if (this.onlyUpgradable) {
                dependencyUpdates = MiscUtils.filter(dependencyUpdates, e -> e.getVersions().length > 1);
                dependencyManagementUpdates = MiscUtils.filter(dependencyManagementUpdates, e -> e.getVersions().length > 1);
            }
            for (String format : this.formats) {
                if ("html".equals(format)) {
                    DependencyUpdatesRenderer renderer = new DependencyUpdatesRenderer(sink, this.getI18n(), this.getOutputName(), locale, dependencyUpdates, dependencyManagementUpdates);
                    renderer.render();
                    continue;
                }
                if (!"xml".equals(format)) continue;
                File outputDir = new File(this.getProject().getBuild().getDirectory());
                if (!outputDir.exists() && !outputDir.mkdirs()) {
                    throw new MavenReportException("Could not create output directory");
                }
                String outputFile = outputDir.getAbsolutePath() + File.separator + this.getOutputName() + ".xml";
                DependencyUpdatesXmlRenderer xmlGenerator = new DependencyUpdatesXmlRenderer(dependencyUpdates, dependencyManagementUpdates, outputFile);
                xmlGenerator.render();
            }
        }
        catch (ArtifactMetadataRetrievalException e2) {
            throw new MavenReportException(e2.getMessage(), (Exception)((Object)e2));
        }
    }

    private boolean match(Dependency dep, Dependency dmDep) {
        return !(!dmDep.getGroupId().equals(dep.getGroupId()) || !dmDep.getArtifactId().equals(dep.getArtifactId()) || dmDep.getScope() != null && !dmDep.getScope().equals(dep.getScope()) || dmDep.getClassifier() != null && !dmDep.getClassifier().equals(dep.getClassifier()) || dep.getVersion() != null && dmDep.getVersion() != null && !dmDep.getVersion().equals(dep.getVersion()));
    }

    public String getOutputName() {
        return "dependency-updates-report";
    }
}

