/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.mrm.impl.digest;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.codehaus.mojo.mrm.api.BaseFileEntry;
import org.codehaus.mojo.mrm.api.DirectoryEntry;
import org.codehaus.mojo.mrm.api.FileEntry;
import org.codehaus.mojo.mrm.api.FileSystem;
import org.codehaus.mojo.mrm.impl.digest.BaseDigestFileEntryFactory;

public class SHA1DigestFileEntry
extends BaseFileEntry {
    private static final long serialVersionUID = 1L;
    private final FileEntry entry;

    public SHA1DigestFileEntry(FileSystem fileSystem, DirectoryEntry parent, FileEntry entry) {
        super(fileSystem, parent, entry.getName() + ".sha1");
        this.entry = entry;
    }

    public long getLastModified() throws IOException {
        return this.entry.getLastModified();
    }

    public long getSize() throws IOException {
        return 40L;
    }

    public InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream(this.getContent());
    }

    private byte[] getContent() throws IOException {
        byte[] byArray;
        InputStream is = null;
        try {
            MessageDigest digest;
            block7: {
                digest = MessageDigest.getInstance("SHA1");
                digest.reset();
                byte[] buffer = new byte[8192];
                try {
                    int read;
                    is = this.entry.getInputStream();
                    while ((read = is.read(buffer)) > 0) {
                        digest.update(buffer, 0, read);
                    }
                }
                catch (IOException e) {
                    if (is == null) break block7;
                    throw e;
                }
            }
            String md5 = StringUtils.leftPad((String)new BigInteger(1, digest.digest()).toString(16), (int)40, (String)"0");
            byArray = md5.getBytes();
        }
        catch (NoSuchAlgorithmException e) {
            try {
                IOException ioe = new IOException("Unable to calculate hash");
                ioe.initCause(e);
                throw ioe;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)is);
        return byArray;
    }

    public static class Factory
    extends BaseDigestFileEntryFactory {
        @Override
        public String getType() {
            return ".sha1";
        }

        @Override
        public FileEntry create(FileSystem fileSystem, DirectoryEntry parent, FileEntry entry) {
            return new SHA1DigestFileEntry(fileSystem, parent, entry);
        }
    }
}

