/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.mrm.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.TreeMap;
import org.codehaus.mojo.mrm.api.DefaultDirectoryEntry;
import org.codehaus.mojo.mrm.api.DirectoryEntry;
import org.codehaus.mojo.mrm.api.Entry;
import org.codehaus.mojo.mrm.api.FileEntry;
import org.codehaus.mojo.mrm.api.FileSystem;
import org.codehaus.mojo.mrm.impl.LinkFileEntry;

public class CompositeFileSystem
implements FileSystem {
    private static final long serialVersionUID = 1L;
    private final FileSystem[] delegates;
    private final DirectoryEntry root = new DefaultDirectoryEntry((FileSystem)this, null, "");

    public CompositeFileSystem(FileSystem[] delegates) {
        delegates.getClass();
        this.delegates = delegates;
    }

    public Entry[] listEntries(DirectoryEntry directory) {
        TreeMap<String, Object> result = new TreeMap<String, Object>();
        for (FileSystem delegate : this.delegates) {
            Entry[] entries = delegate.listEntries(DefaultDirectoryEntry.equivalent((FileSystem)delegate, (DirectoryEntry)directory));
            if (entries == null) continue;
            for (Entry entry : entries) {
                if (result.containsKey(entry.getName())) continue;
                if (entry instanceof DirectoryEntry) {
                    result.put(entry.getName(), new DefaultDirectoryEntry((FileSystem)this, directory, entry.getName()));
                    continue;
                }
                if (!(entry instanceof FileEntry)) continue;
                result.put(entry.getName(), (Object)new LinkFileEntry(this, directory, (FileEntry)entry));
            }
        }
        return result.values().toArray(new Entry[result.size()]);
    }

    public Entry get(String path) {
        for (FileSystem delegate : this.delegates) {
            Entry entry = delegate.get(path);
            if (entry == null) continue;
            if (entry instanceof DirectoryEntry) {
                return DefaultDirectoryEntry.equivalent((FileSystem)this, (DirectoryEntry)((DirectoryEntry)entry));
            }
            return entry;
        }
        return null;
    }

    public long getLastModified(DirectoryEntry entry) throws IOException {
        long lastModified = 0L;
        for (FileSystem delegate : this.delegates) {
            try {
                lastModified = Math.max(lastModified, delegate.getLastModified(entry));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return lastModified;
    }

    public DirectoryEntry getRoot() {
        return this.root;
    }

    public DirectoryEntry mkdir(DirectoryEntry parent, String name) {
        throw new UnsupportedOperationException();
    }

    public FileEntry put(DirectoryEntry parent, String name, InputStream content) throws IOException {
        throw new UnsupportedOperationException();
    }

    public FileEntry put(DirectoryEntry parent, String name, byte[] content) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void remove(Entry entry) {
        throw new UnsupportedOperationException();
    }
}

