/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.jaxws;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Formatter;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Settings;
import org.codehaus.mojo.jaxws.AbstractJaxwsMojo;

abstract class WsImportMojo
extends AbstractJaxwsMojo {
    private static final String STALE_FILE_PREFIX = ".";
    private static final String PATTERN = "[^\\s]+\\.wsdl$";
    @Parameter
    private String packageName;
    @Parameter
    private File catalog;
    @Parameter
    private String httpproxy;
    @Parameter(defaultValue="${project.basedir}/src/wsdl")
    private File wsdlDirectory;
    @Parameter
    protected List<String> wsdlFiles;
    @Parameter
    private List<?> wsdlUrls;
    @Parameter(defaultValue="${project.basedir}/src/jaxws")
    protected File bindingDirectory;
    @Parameter
    protected List<String> bindingFiles;
    @Parameter
    private String wsdlLocation;
    @Parameter
    private String target;
    @Parameter(defaultValue="false")
    private boolean quiet;
    @Parameter
    private String implServiceName;
    @Parameter
    private String implPortName;
    @Parameter(defaultValue="false")
    private boolean genJWS;
    @Parameter(defaultValue="true")
    private boolean xnocompile;
    @Parameter(defaultValue="false")
    private boolean xadditionalHeaders;
    @Parameter(defaultValue="false")
    private boolean xdebug;
    @Parameter(defaultValue="false")
    private boolean xnoAddressingDataBinding;
    @Parameter
    protected File xauthFile;
    @Parameter(defaultValue="false")
    private boolean xdisableSSLHostnameVerification;
    @Parameter(defaultValue="false")
    private boolean xuseBaseResourceAndURLToLoadWSDL;
    @Parameter(defaultValue="false")
    private boolean xdisableAuthenticator;
    @Parameter
    private List<String> xjcArgs;
    @Parameter(defaultValue="${project.build.directory}/jaxws/stale")
    private File staleFile;
    @Parameter(defaultValue="${settings}", readonly=true, required=true)
    private Settings settings;
    private static final FileFilter XML_FILE_FILTER = f -> f.getName().endsWith(".xml");
    private static final FileFilter WSDL_FILE_FILTER = f -> f.getName().endsWith(".wsdl");

    WsImportMojo() {
    }

    protected abstract File getImplDestDir();

    protected abstract List<String> getWSDLFileLookupClasspathElements();

    @Override
    public void executeJaxws() throws MojoExecutionException {
        try {
            URL[] wsdls = this.getWSDLFiles();
            if (wsdls.length == 0 && (this.wsdlUrls == null || this.wsdlUrls.isEmpty())) {
                this.getLog().info((CharSequence)"No WSDLs are found to process, Specify at least one of the following parameters: wsdlFiles, wsdlDirectory or wsdlUrls.");
                return;
            }
            this.processWsdlViaUrls();
            this.processLocalWsdlFiles(wsdls);
        }
        catch (MojoExecutionException e) {
            throw e;
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    @Override
    protected String getMain() {
        return "com.sun.tools.ws.wscompile.WsimportTool";
    }

    @Override
    protected String getToolName() {
        return "wsimport";
    }

    @Override
    protected boolean isXnocompile() {
        return this.xnocompile;
    }

    private void processLocalWsdlFiles(URL[] wsdls) throws MojoExecutionException, IOException {
        for (URL u : wsdls) {
            String url = u.toExternalForm();
            if (this.isOutputStale(url)) {
                this.getLog().info((CharSequence)("Processing: " + url));
                String relPath = null;
                if ("file".equals(u.getProtocol())) {
                    relPath = this.getRelativePath(new File(u.getPath()));
                }
                ArrayList<String> args = this.getWsImportArgs(relPath);
                args.add("\"" + url + "\"");
                this.getLog().info((CharSequence)("jaxws:wsimport args: " + args));
                this.exec(args);
                this.touchStaleFile(url);
            } else {
                this.getLog().info((CharSequence)("Ignoring: " + url));
            }
            this.addSourceRoot(this.getSourceDestDir().getAbsolutePath());
        }
    }

    private void processWsdlViaUrls() throws MojoExecutionException, IOException {
        for (int i = 0; this.wsdlUrls != null && i < this.wsdlUrls.size(); ++i) {
            String wsdlUrl = this.wsdlUrls.get(i).toString();
            if (this.isOutputStale(wsdlUrl)) {
                this.getLog().info((CharSequence)("Processing: " + wsdlUrl));
                ArrayList<String> args = this.getWsImportArgs(null);
                args.add("\"" + wsdlUrl + "\"");
                this.getLog().info((CharSequence)("jaxws:wsimport args: " + args));
                this.exec(args);
                this.touchStaleFile(wsdlUrl);
            }
            this.addSourceRoot(this.getSourceDestDir().getAbsolutePath());
        }
    }

    private ArrayList<String> getWsImportArgs(String relativePath) throws MojoExecutionException {
        File[] bindings;
        ArrayList<String> args = new ArrayList<String>();
        args.addAll(this.getCommonArgs());
        if (this.httpproxy != null) {
            args.add("-httpproxy:" + this.httpproxy);
        } else if (this.settings != null) {
            String nonProxyHostsString;
            String proxyString = WsImportMojo.getActiveHttpProxy(this.settings);
            if (proxyString != null) {
                args.add("-httpproxy:" + proxyString);
            }
            if ((nonProxyHostsString = WsImportMojo.getActiveNonProxyHosts(this.settings)) != null) {
                this.addVmArg("-Dhttp.nonProxyHosts=" + nonProxyHostsString.replace("|", "^|"));
            }
        }
        if (this.packageName != null) {
            args.add("-p");
            args.add(this.packageName);
        }
        if (this.catalog != null) {
            args.add("-catalog");
            args.add("'" + this.catalog.getAbsolutePath() + "'");
        }
        if (this.wsdlLocation != null) {
            if (relativePath != null) {
                args.add("-wsdllocation");
                args.add(this.wsdlLocation.replaceAll("\\*", relativePath));
            } else if (!this.wsdlLocation.contains("*")) {
                args.add("-wsdllocation");
                args.add(this.wsdlLocation);
            }
        }
        if (this.target != null) {
            args.add("-target");
            args.add(this.target);
        }
        if (this.quiet) {
            args.add("-quiet");
        }
        if ((this.genJWS || this.implServiceName != null || this.implPortName != null) && this.isArgSupported("-generateJWS")) {
            Object implDestDir;
            args.add("-generateJWS");
            if (this.implServiceName != null && this.isArgSupported("-implServiceName")) {
                args.add("-implServiceName");
                args.add(this.implServiceName);
            }
            if (this.implPortName != null && this.isArgSupported("-implPortName")) {
                args.add("-implPortName");
                args.add(this.implPortName);
            }
            if (!((File)(implDestDir = this.getImplDestDir())).mkdirs() && !((File)implDestDir).exists()) {
                this.getLog().warn((CharSequence)("Cannot create directory: " + ((File)implDestDir).getAbsolutePath()));
            }
            args.add("-implDestDir");
            args.add("'" + ((File)implDestDir).getAbsolutePath() + "'");
            if (!this.project.getCompileSourceRoots().contains(((File)implDestDir).getAbsolutePath())) {
                this.project.addCompileSourceRoot(((File)implDestDir).getAbsolutePath());
            }
        }
        if (this.xdebug) {
            args.add("-Xdebug");
        }
        if (this.xnoAddressingDataBinding) {
            args.add("-Xno-addressing-databinding");
        }
        if (this.xadditionalHeaders) {
            args.add("-XadditionalHeaders");
        }
        if (this.xauthFile != null) {
            args.add("-Xauthfile");
            args.add(this.xauthFile.getAbsolutePath());
        }
        if (this.xdisableSSLHostnameVerification) {
            args.add("-XdisableSSLHostnameVerification");
        }
        if (this.xuseBaseResourceAndURLToLoadWSDL) {
            args.add("-XuseBaseResourceAndURLToLoadWSDL");
        }
        if (this.xdisableAuthenticator && this.isArgSupported("-XdisableAuthenticator")) {
            args.add("-XdisableAuthenticator");
        }
        if (this.xjcArgs != null) {
            for (String xjcArg : this.xjcArgs) {
                if (xjcArg.startsWith("-")) {
                    args.add("-B" + xjcArg);
                    continue;
                }
                args.add(xjcArg);
            }
        }
        if ((bindings = this.getBindingFiles()).length > 0 && this.wsdlLocation != null && this.wsdlLocation.contains("*")) {
            throw new MojoExecutionException("External binding file(s) can not be bound to more WSDL files (" + this.wsdlLocation + ")\nPlease use either inline binding(s) or multiple execution tags.");
        }
        for (File binding : bindings) {
            args.add("-b");
            args.add("'" + binding.toURI() + "'");
        }
        return args;
    }

    public final File[] getBindingFiles() {
        File[] bindings;
        if (this.bindingFiles != null) {
            bindings = new File[this.bindingFiles.size()];
            for (int i = 0; i < this.bindingFiles.size(); ++i) {
                String schemaName = this.bindingFiles.get(i);
                File file = new File(schemaName);
                if (!file.isAbsolute()) {
                    file = new File(this.bindingDirectory, schemaName);
                }
                bindings[i] = file;
            }
        } else {
            this.getLog().debug((CharSequence)("The binding Directory is " + this.bindingDirectory));
            bindings = this.bindingDirectory.listFiles(XML_FILE_FILTER);
            if (bindings == null) {
                bindings = new File[]{};
            }
        }
        return bindings;
    }

    private URL[] getWSDLFiles() throws MojoExecutionException {
        ArrayList<URL> files;
        block45: {
            files = new ArrayList<URL>();
            List<String> classpathElements = this.getWSDLFileLookupClasspathElements();
            ArrayList<URL> urlCpath = new ArrayList<URL>(classpathElements.size());
            for (String el : classpathElements) {
                try {
                    URL u = new File(el).toURI().toURL();
                    urlCpath.add(u);
                }
                catch (MalformedURLException e) {
                    throw new MojoExecutionException("Error while retrieving list of WSDL files to process", (Exception)e);
                }
            }
            try (URLClassLoader loader = new URLClassLoader(urlCpath.toArray(new URL[0]));){
                if (this.wsdlFiles != null) {
                    for (String wsdlFileName : this.wsdlFiles) {
                        File wsdl = new File(wsdlFileName);
                        URL toAdd = null;
                        if (!wsdl.isAbsolute()) {
                            wsdl = new File(this.wsdlDirectory, wsdlFileName);
                        }
                        if (!wsdl.exists()) {
                            toAdd = loader.getResource(wsdlFileName);
                        } else {
                            try {
                                toAdd = wsdl.toURI().toURL();
                            }
                            catch (MalformedURLException ex) {
                                this.getLog().error((Throwable)ex);
                            }
                        }
                        this.getLog().debug((CharSequence)("The wsdl File is '" + wsdlFileName + "' from '" + toAdd + "'"));
                        if (toAdd != null) {
                            files.add(toAdd);
                            continue;
                        }
                        throw new MojoExecutionException("'" + wsdlFileName + "' not found.");
                    }
                    break block45;
                }
                this.getLog().debug((CharSequence)("The wsdl Directory is " + this.wsdlDirectory));
                if (this.wsdlDirectory.exists()) {
                    File[] wsdls;
                    for (File wsdl : wsdls = this.wsdlDirectory.listFiles(WSDL_FILE_FILTER)) {
                        files.add(wsdl.toURI().toURL());
                    }
                    break block45;
                }
                URI rel = this.project.getBasedir().toURI().relativize(this.wsdlDirectory.toURI());
                String dir = rel.getPath();
                URL u = loader.getResource(dir);
                if (u == null) {
                    dir = "WEB-INF/wsdl/";
                    u = loader.getResource(dir);
                }
                if (u == null) {
                    dir = "META-INF/wsdl/";
                    u = loader.getResource(dir);
                }
                if (u == null || !"jar".equalsIgnoreCase(u.getProtocol())) break block45;
                String path = u.getPath();
                Pattern p = Pattern.compile(dir.replace(File.separatorChar, '/') + PATTERN, 2);
                try (JarFile jarFile = new JarFile(path.substring(5, path.indexOf("!/")));){
                    Enumeration<JarEntry> jes = jarFile.entries();
                    while (jes.hasMoreElements()) {
                        JarEntry je = jes.nextElement();
                        Matcher m = p.matcher(je.getName());
                        if (!m.matches()) continue;
                        String s = "jar:" + path.substring(0, path.indexOf("!/") + 2) + je.getName();
                        files.add(new URL(s));
                    }
                }
                catch (IOException ex) {
                    this.getLog().error((Throwable)ex);
                }
            }
            catch (MojoExecutionException e) {
                throw e;
            }
            catch (Exception e) {
                throw new MojoExecutionException("Error while retrieving list of WSDL files to process", e);
            }
        }
        return files.toArray(new URL[0]);
    }

    private String getRelativePath(File f) {
        block3: {
            File[] wsdls;
            block2: {
                if (this.wsdlFiles == null) break block2;
                for (String s : this.wsdlFiles) {
                    String path = f.getPath().replace(File.separatorChar, '/');
                    if (!path.endsWith(s) || path.length() == s.length()) continue;
                    return s;
                }
                break block3;
            }
            if (this.wsdlDirectory == null || !this.wsdlDirectory.exists()) break block3;
            for (File wsdl : wsdls = this.wsdlDirectory.listFiles(WSDL_FILE_FILTER)) {
                String path = f.getPath().replace(File.separatorChar, '/');
                if (!path.endsWith(wsdl.getName())) continue;
                return wsdl.getName();
            }
        }
        return null;
    }

    private boolean isOutputStale(String resource) {
        boolean stale;
        File[] sourceBindings = this.getBindingFiles();
        File stFile = new File(this.staleFile, STALE_FILE_PREFIX + this.getHash(resource));
        boolean bl = stale = !stFile.exists();
        if (!stale) {
            this.getLog().debug((CharSequence)"Stale flag file exists, comparing to wsdls and bindings.");
            long staleMod = stFile.lastModified();
            try {
                URL sourceWsdl = new URL(resource);
                if (sourceWsdl.openConnection().getLastModified() > staleMod) {
                    this.getLog().debug((CharSequence)(resource + " is newer than the stale flag file."));
                    stale = true;
                }
            }
            catch (MalformedURLException mue) {
                File sourceWsdl = new File(resource);
                if (sourceWsdl.lastModified() > staleMod) {
                    this.getLog().debug((CharSequence)(resource + " is newer than the stale flag file."));
                    stale = true;
                }
            }
            catch (IOException ioe) {
                this.getLog().error((Throwable)ioe);
            }
            for (File sourceBinding : sourceBindings) {
                if (sourceBinding.lastModified() <= staleMod) continue;
                this.getLog().debug((CharSequence)(sourceBinding.getName() + " is newer than the stale flag file."));
                stale = true;
            }
        }
        return stale;
    }

    private void touchStaleFile(String resource) throws IOException {
        File stFile = new File(this.staleFile, STALE_FILE_PREFIX + this.getHash(resource));
        if (!stFile.exists()) {
            File staleDir = stFile.getParentFile();
            if (!staleDir.mkdirs() && !staleDir.exists()) {
                this.getLog().warn((CharSequence)("Cannot create directory: " + staleDir.getAbsolutePath()));
            }
            if (!stFile.createNewFile()) {
                this.getLog().warn((CharSequence)("Cannot create file: " + stFile.getAbsolutePath()));
            }
            this.getLog().debug((CharSequence)("Stale flag file created.[" + stFile.getAbsolutePath() + "]"));
        } else if (!stFile.setLastModified(System.currentTimeMillis())) {
            this.getLog().warn((CharSequence)"Stale file has not been updated!");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getHash(String s) {
        try (Formatter formatter = new Formatter();){
            MessageDigest md = MessageDigest.getInstance("SHA");
            for (byte b : md.digest(s.getBytes("UTF-8"))) {
                formatter.format("%02x", b);
            }
            String string = formatter.toString();
            return string;
        }
        catch (UnsupportedEncodingException ex) {
            this.getLog().debug((CharSequence)ex.getMessage(), (Throwable)ex);
        }
        catch (NoSuchAlgorithmException ex) {
            this.getLog().debug((CharSequence)ex.getMessage(), (Throwable)ex);
        }
        this.getLog().warn((CharSequence)("Could not compute hash for " + s + ". Using fallback method."));
        return s.substring(s.lastIndexOf(47)).replaceAll("\\.", "-");
    }

    static String getActiveHttpProxy(Settings s) {
        String retVal = null;
        for (Proxy p : s.getProxies()) {
            if (!p.isActive() || !"http".equals(p.getProtocol())) continue;
            StringBuilder sb = new StringBuilder();
            String user = p.getUsername();
            String pwd = p.getPassword();
            if (user != null) {
                sb.append(user);
                if (pwd != null) {
                    sb.append(":");
                    sb.append(pwd);
                }
                sb.append("@");
            }
            sb.append(p.getHost());
            sb.append(":");
            sb.append(p.getPort());
            retVal = sb.toString().trim();
            break;
        }
        return retVal;
    }

    static String getActiveNonProxyHosts(Settings s) {
        String retVal = null;
        for (Proxy p : s.getProxies()) {
            if (!p.isActive() || !"http".equals(p.getProtocol())) continue;
            retVal = p.getNonProxyHosts();
            break;
        }
        return retVal;
    }
}

