/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.jaxb2.shared.environment.sysprops;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.mojo.jaxb2.AbstractJaxbMojo;
import org.codehaus.mojo.jaxb2.shared.Validate;
import org.codehaus.mojo.jaxb2.shared.environment.AbstractLogAwareFacet;

public class SystemPropertyChangeEnvironmentFacet
extends AbstractLogAwareFacet {
    private ChangeType type;
    private String key;
    private String newValue;
    private String originalValue;

    private SystemPropertyChangeEnvironmentFacet(Log log, String key) {
        super(log);
        this.key = key;
        this.type = ChangeType.REMOVE;
    }

    private SystemPropertyChangeEnvironmentFacet(Log log, String key, String newValue) {
        super(log);
        this.key = key;
        this.originalValue = System.getProperty(key);
        this.newValue = newValue;
        this.type = this.existsAsSystemProperty(key) ? ChangeType.CHANGE : ChangeType.ADD;
    }

    @Override
    public void setup() {
        if (this.type == ChangeType.REMOVE) {
            System.clearProperty(this.key);
        } else {
            System.setProperty(this.key, this.newValue);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((CharSequence)("Setup " + this.toString()));
        }
    }

    @Override
    public void restore() {
        if (this.type == ChangeType.ADD) {
            System.clearProperty(this.key);
        } else {
            System.setProperty(this.key, this.originalValue);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((CharSequence)("Restored " + this.toString()));
        }
    }

    public String toString() {
        String toReturn = "SysProp key [" + this.key + "]\n  ... Original value: [" + this.originalValue + "]\n  ... Changed value : [" + this.newValue + "]";
        return toReturn.replace("\n", AbstractJaxbMojo.NEWLINE);
    }

    public static SystemPropertyChangesBuilder getBuilder(Log mavenLog) {
        return new SystemPropertyChangesBuilder(mavenLog);
    }

    private boolean existsAsSystemProperty(String key) {
        return System.getProperties().keySet().contains(key);
    }

    public static class SystemPropertyChangesBuilder {
        private List<SystemPropertyChangeEnvironmentFacet> toReturn;
        private Log mavenLog;

        private SystemPropertyChangesBuilder(Log mavenLog) {
            Validate.notNull(mavenLog, "mavenLog");
            this.toReturn = new ArrayList<SystemPropertyChangeEnvironmentFacet>();
            this.mavenLog = mavenLog;
        }

        public SystemPropertyChangesBuilder remove(String propertyName) {
            this.checkSanity(propertyName);
            this.toReturn.add(new SystemPropertyChangeEnvironmentFacet(this.mavenLog, propertyName));
            return this;
        }

        public SystemPropertyChangesBuilder addOrChange(String propertyName, String value) {
            this.checkSanity(propertyName);
            this.toReturn.add(new SystemPropertyChangeEnvironmentFacet(this.mavenLog, propertyName, value));
            return this;
        }

        public List<SystemPropertyChangeEnvironmentFacet> build() {
            return this.toReturn;
        }

        private void checkSanity(String propertyName) {
            Validate.notEmpty(propertyName, "propertyName");
            for (SystemPropertyChangeEnvironmentFacet current : this.toReturn) {
                if (!current.key.equals(propertyName)) continue;
                throw new IllegalArgumentException("A SystemPropertyChange for propertyName '" + propertyName + "' is already present. Only one SystemPropertyChange per propertyName should be supplied.");
            }
        }
    }

    public static enum ChangeType {
        ADD,
        REMOVE,
        CHANGE;

    }
}

