/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.jaxb2.shared.environment;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.mojo.jaxb2.shared.Validate;
import org.codehaus.mojo.jaxb2.shared.environment.AbstractLogAwareFacet;
import org.codehaus.mojo.jaxb2.shared.environment.EnvironmentFacet;
import org.codehaus.mojo.jaxb2.shared.environment.classloading.ThreadContextClassLoaderBuilder;
import org.codehaus.mojo.jaxb2.shared.environment.classloading.ThreadContextClassLoaderHolder;
import org.codehaus.mojo.jaxb2.shared.environment.locale.LocaleFacet;
import org.codehaus.mojo.jaxb2.shared.environment.logging.LoggingHandlerEnvironmentFacet;

public class ToolExecutionEnvironment
extends AbstractLogAwareFacet {
    private ThreadContextClassLoaderBuilder builder;
    private ThreadContextClassLoaderHolder holder;
    private LoggingHandlerEnvironmentFacet loggingHandlerEnvironmentFacet;
    private List<EnvironmentFacet> extraFacets;
    private LocaleFacet localeFacet;

    public ToolExecutionEnvironment(Log mavenLog, ThreadContextClassLoaderBuilder builder, LoggingHandlerEnvironmentFacet loggingHandlerFacet, LocaleFacet localeFacet) {
        super(mavenLog);
        Validate.notNull(builder, "builder");
        Validate.notNull(loggingHandlerFacet, "loggingHandlerFacet");
        this.builder = builder;
        this.loggingHandlerEnvironmentFacet = loggingHandlerFacet;
        this.localeFacet = localeFacet;
        this.extraFacets = new ArrayList<EnvironmentFacet>();
    }

    public void add(EnvironmentFacet facet) {
        Validate.notNull(facet, "facet");
        this.extraFacets.add(facet);
    }

    public String getClassPathAsArgument() {
        if (this.holder == null) {
            throw new IllegalStateException("Cannot retrieve the classpath argument before calling 'setup'");
        }
        return this.holder.getClassPathAsArgument();
    }

    @Override
    public final void setup() {
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug((CharSequence)"ToolExecutionEnvironment setup -- Starting.");
            }
            this.holder = this.builder.buildAndSet();
            this.loggingHandlerEnvironmentFacet.setup();
            if (this.localeFacet != null) {
                this.localeFacet.setup();
            }
            for (EnvironmentFacet current : this.extraFacets) {
                try {
                    current.setup();
                }
                catch (Exception e) {
                    throw new IllegalStateException("Could not setup()\u00a0EnvironmentFacet of type [" + current.getClass().getName() + "]", e);
                }
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((CharSequence)"ToolExecutionEnvironment setup -- Done.");
            }
        }
        catch (IllegalStateException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not setup() mandatory EnvironmentFacets.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final void restore() {
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug((CharSequence)"ToolExecutionEnvironment restore -- Starting.");
            }
            for (EnvironmentFacet current : this.extraFacets) {
                try {
                    current.restore();
                }
                catch (Exception e) {
                    throw new IllegalStateException("Could not restore()\u00a0EnvironmentFacet of type [" + current.getClass().getName() + "]", e);
                    return;
                }
            }
        }
        finally {
            this.loggingHandlerEnvironmentFacet.restore();
            if (this.localeFacet != null) {
                this.localeFacet.restore();
            }
            this.holder.restoreClassLoaderAndReleaseThread();
            if (this.log.isDebugEnabled()) {
                this.log.debug((CharSequence)"ToolExecutionEnvironment restore -- Done.");
            }
        }
    }
}

