/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.jaxb2.helpers;

import org.codehaus.mojo.jaxb2.helpers.NodeProcessor;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ChangeNamespacePrefixProcessor
implements NodeProcessor {
    private static final String REFERENCE_ATTRIBUTE_NAME = "ref";
    private static final String SCHEMA = "schema";
    private static final String XMLNS = "xmlns:";
    private String oldPrefix;
    private String newPrefix;

    public ChangeNamespacePrefixProcessor(String oldPrefix, String newPrefix) {
        this.oldPrefix = oldPrefix;
        this.newPrefix = newPrefix;
    }

    public boolean accept(Node aNode) {
        if (this.oldPrefix.equals(aNode.getPrefix())) {
            return true;
        }
        if (aNode instanceof Attr) {
            Attr attribute = (Attr)aNode;
            if (this.isNamespaceDefinition(attribute)) {
                return true;
            }
            if (this.isElementReference(attribute)) {
                return true;
            }
        }
        return false;
    }

    public void process(Node aNode) {
        if (aNode instanceof Attr) {
            Attr attribute = (Attr)aNode;
            Element parentElement = attribute.getOwnerElement();
            if (this.isNamespaceDefinition(attribute)) {
                parentElement.setAttributeNS(attribute.getNamespaceURI(), XMLNS + this.newPrefix, aNode.getNodeValue());
                parentElement.removeAttribute(XMLNS + this.oldPrefix);
            } else if (this.isElementReference(attribute)) {
                String value = attribute.getValue();
                String elementName = value.substring(value.indexOf(":") + 1);
                attribute.setValue(this.newPrefix + ":" + elementName);
            }
        }
        if (this.oldPrefix.equals(aNode.getPrefix())) {
            aNode.setPrefix(this.newPrefix);
        }
    }

    private boolean isNamespaceDefinition(Attr attribute) {
        Element parent = attribute.getOwnerElement();
        return "http://www.w3.org/2001/XMLSchema".equals(parent.getNamespaceURI()) && SCHEMA.equalsIgnoreCase(parent.getLocalName()) && this.oldPrefix.equals(attribute.getLocalName());
    }

    private boolean isElementReference(Attr attribute) {
        return REFERENCE_ATTRIBUTE_NAME.equals(attribute.getName()) && attribute.getValue().startsWith(this.oldPrefix + ":");
    }
}

