/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.hibernate3;

import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.util.FileUtils;
import org.hibernate.util.ReflectHelper;

public final class HibernateUtils {
    public static String getJavaVersion() {
        String version = System.getProperty("java.version");
        return version.startsWith("1.5") || version.startsWith("1.6") ? "jdk15" : "jdk14";
    }

    public static Object getClass(String className, String defaultClassName) {
        Object o = HibernateUtils.getClass(className);
        if (o == null) {
            o = HibernateUtils.getClass(defaultClassName);
        }
        return o;
    }

    public static Object getClass(String className) {
        try {
            return ReflectHelper.classForName((String)className).newInstance();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Object getClass(String className, Class caller) {
        try {
            return ReflectHelper.classForName((String)className, (Class)caller).newInstance();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static File getFile(File path, String filePath) {
        File file = new File(path, filePath);
        if (file.exists() && file.isFile()) {
            return file;
        }
        return null;
    }

    public static String getPath(File path, String filePath) {
        File file = HibernateUtils.getFile(path, filePath);
        if (file == null) {
            return null;
        }
        return file.getPath();
    }

    public static File prepareDirectory(File parent, String directoryPath, String parameter) throws MojoExecutionException {
        return HibernateUtils.prepareDirectory(new File(parent, directoryPath), parameter);
    }

    public static File prepareDirectory(File directory, String parameter) throws MojoExecutionException {
        if (!directory.exists()) {
            FileUtils.mkdir((String)directory.getPath());
        } else if (!directory.isDirectory()) {
            throw new MojoExecutionException("<" + parameter + "> is not a directory.");
        }
        return directory;
    }

    public static File prepareFile(File parent, String filePath, String parameter) throws MojoExecutionException {
        File file = new File(parent, filePath);
        if (!file.exists()) {
            FileUtils.mkdir((String)FileUtils.getPath((String)file.getPath()));
        } else if (!file.isFile()) {
            throw new MojoExecutionException("<" + parameter + "> is not a file.");
        }
        return file;
    }
}

