/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.extraenforcer.dependencies;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.maven.artifact.Artifact;
import org.codehaus.mojo.extraenforcer.dependencies.InputStreamSupplier;

public class ClassFile {
    private final String classFilePath;
    private final Artifact artifactThisClassWasFoundIn;
    private String hash;

    public ClassFile(String classFilePath, Artifact artifactThisClassWasFoundIn, InputStreamSupplier inputStreamSupplier) throws IOException {
        this.classFilePath = classFilePath;
        this.artifactThisClassWasFoundIn = artifactThisClassWasFoundIn;
        this.hash = this.computeHash(inputStreamSupplier);
    }

    private String computeHash(InputStreamSupplier inputStreamSupplier) throws IOException {
        try (InputStream inputStream = inputStreamSupplier.get();){
            String string = DigestUtils.md5Hex((InputStream)inputStream);
            return string;
        }
    }

    public String getClassFilePath() {
        return this.classFilePath;
    }

    public Artifact getArtifactThisClassWasFoundIn() {
        return this.artifactThisClassWasFoundIn;
    }

    public String getHash() {
        return this.hash;
    }
}

