/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.aspectj;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        if (this.lineLength <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'lineLength' should be positive, using '80' as default.");
            this.lineLength = 80;
        }
        if (this.indentSize <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'indentSize' should be positive, using '2' as default.");
            this.indentSize = 2;
        }
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.codehaus.mojo:aspectj-maven-plugin:1.2", 0);
        this.append(sb, "", 0);
        this.append(sb, "AspectJ compiler Maven Plugin", 0);
        this.append(sb, "Handles AspectJ usage within maven. Functionality provided is: weaving of aspects (or existing aspects from libraries) with the test and/or main classes, weaving of pre-existing jars and ajdoc reporting.", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 4 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "aspectj-report".equals(this.goal)) {
            this.append(sb, "aspectj:aspectj-report", 0);
            this.append(sb, "Creates a ajdoc report in html format.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "ajdtBuildDefFile", 2);
                this.append(sb, "Where to find the ajdt build definition file. If set this will override the use of project sourcedirs.", 3);
                this.append(sb, "", 0);
                this.append(sb, "aspectDirectory (Default: src/main/aspect)", 2);
                this.append(sb, "The source directory for the aspects", 3);
                this.append(sb, "", 0);
                this.append(sb, "basedir", 2);
                this.append(sb, "The basedir of the project.", 3);
                this.append(sb, "", 0);
                this.append(sb, "complianceLevel", 2);
                this.append(sb, "Specify compiler compliance setting (1.3 to 1.6, default is 1.4)", 3);
                this.append(sb, "", 0);
                this.append(sb, "doctitle", 2);
                this.append(sb, "Specifies the title to be placed near the top of the overview summary file. The title will be placed as a centered, level-one heading directly beneath the upper navigation bar. The title may contain html tags and white space, though if it does, it must be enclosed in quotes. Any internal quotation marks within title may have to be escaped.", 3);
                this.append(sb, "", 0);
                this.append(sb, "overview", 2);
                this.append(sb, "Specifies that javadoc should retrieve the text for the overview documentation from the 'source' file specified by path/filename and place it on the Overview page (overview-summary.html). The path/filename is relative to the ${basedir}. While you can use any name you want for filename and place it anywhere you want for path, a typical thing to do is to name it overview.html and place it in the source tree at the directory that contains the topmost package directories. In this location, no path is needed when documenting packages, since -sourcepath will point to this file. For example, if the source tree for the java.lang package is /src/classes/java/lang/, then you could place the overview file at /src/classes/overview.html. See Real World Example. For information about the file specified by path/filename, see overview comment file.Note that the overview page is created only if you pass into javadoc two or more package names. For further explanation, see HTML Frames.) The title on the overview page is set by -doctitle.", 3);
                this.append(sb, "", 0);
                this.append(sb, "packageScope", 2);
                this.append(sb, "Shows only package, protected, and public classes and members.", 3);
                this.append(sb, "", 0);
                this.append(sb, "privateScope", 2);
                this.append(sb, "Shows all classes and members.", 3);
                this.append(sb, "", 0);
                this.append(sb, "project", 2);
                this.append(sb, "The maven project.", 3);
                this.append(sb, "", 0);
                this.append(sb, "protectedScope", 2);
                this.append(sb, "Shows only protected and public classes and members. This is the default.", 3);
                this.append(sb, "", 0);
                this.append(sb, "publicScope", 2);
                this.append(sb, "Shows only public classes and members.", 3);
                this.append(sb, "", 0);
                this.append(sb, "testAspectDirectory (Default: src/test/aspect)", 2);
                this.append(sb, "The source directory for the test aspects", 3);
                this.append(sb, "", 0);
                this.append(sb, "verbose", 2);
                this.append(sb, "Provides more detailed messages while javadoc is running. Without the verbose option, messages appear for loading the source files, generating the documentation (one message per source file), and sorting. The verbose option causes the printing of additional messages specifying the number of milliseconds to parse each java source file.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "compile".equals(this.goal)) {
            this.append(sb, "aspectj:compile", 0);
            this.append(sb, "Weaves all main classes.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "ajdtBuildDefFile", 2);
                this.append(sb, "Where to find the ajdt build definition file. If set this will override the use of project sourcedirs.", 3);
                this.append(sb, "", 0);
                this.append(sb, "argumentFileName (Default: builddef.lst)", 2);
                this.append(sb, "The filename to store build configuration in. This file will be placed in the project build output directory, and will contain all the arguments passed to the compiler in the last run, and also all the filenames included in the build. Aspects as well as java files.", 3);
                this.append(sb, "", 0);
                this.append(sb, "aspectDirectory (Default: src/main/aspect)", 2);
                this.append(sb, "The source directory for the aspects", 3);
                this.append(sb, "", 0);
                this.append(sb, "aspectLibraries", 2);
                this.append(sb, "Weave binary aspects from the jars. The aspects should have been output by the same version of the compiler. The modules must also be dependencies of the project. Corresponds to ajc -aspectpath option", 3);
                this.append(sb, "", 0);
                this.append(sb, "basedir", 2);
                this.append(sb, "The basedir of the project.", 3);
                this.append(sb, "", 0);
                this.append(sb, "bootclasspath", 2);
                this.append(sb, "Override location of VM's bootclasspath for purposes of evaluating types when compiling. Path is a single argument containing a list of paths to zip files or directories, delimited by the platform-specific path delimiter.", 3);
                this.append(sb, "", 0);
                this.append(sb, "complianceLevel", 2);
                this.append(sb, "Specify compiler compliance setting (1.3 to 1.6) default is 1.4", 3);
                this.append(sb, "", 0);
                this.append(sb, "deprecation", 2);
                this.append(sb, "Toggle warningmessages on deprecations", 3);
                this.append(sb, "", 0);
                this.append(sb, "emacssym", 2);
                this.append(sb, "Generate .ajesym symbol files for emacs support", 3);
                this.append(sb, "", 0);
                this.append(sb, "encoding", 2);
                this.append(sb, "Specify default source encoding format.", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludes", 2);
                this.append(sb, "List of ant-style patterns used to specify the aspects that should be excluded when compiling. When none specified all .java and .aj files in the project source directories, or directories spesified by the ajdtDefFile property are included. *", 3);
                this.append(sb, "", 0);
                this.append(sb, "includes", 2);
                this.append(sb, "List of ant-style patterns used to specify the aspects that should be included when compiling. When none specified all .java and .aj files in the project source directories, or directories spesified by the ajdtDefFile property are included. *", 3);
                this.append(sb, "", 0);
                this.append(sb, "noImportError", 2);
                this.append(sb, "Emit no errors for unresolved imports;", 3);
                this.append(sb, "", 0);
                this.append(sb, "outxml", 2);
                this.append(sb, "Generate aop.xml file for load-time weaving with default name.(/META-INF/aop.xml)", 3);
                this.append(sb, "", 0);
                this.append(sb, "outxmlfile", 2);
                this.append(sb, "Generate aop.xml file for load-time weaving with custom name.", 3);
                this.append(sb, "", 0);
                this.append(sb, "preserveAllLocals", 2);
                this.append(sb, "Preserve all local variables during code generation (to facilitate debugging).", 3);
                this.append(sb, "", 0);
                this.append(sb, "proceedOnError", 2);
                this.append(sb, "Keep compiling after error, dumping class files with problem methods", 3);
                this.append(sb, "", 0);
                this.append(sb, "project", 2);
                this.append(sb, "The maven project.", 3);
                this.append(sb, "", 0);
                this.append(sb, "referenceInfo", 2);
                this.append(sb, "Compute reference information.", 3);
                this.append(sb, "", 0);
                this.append(sb, "repeat", 2);
                this.append(sb, "Repeat compilation process N times (typically to do performance analysis).", 3);
                this.append(sb, "", 0);
                this.append(sb, "showWeaveInfo", 2);
                this.append(sb, "Emit messages about weaving", 3);
                this.append(sb, "", 0);
                this.append(sb, "source", 2);
                this.append(sb, "Toggle assertions (1.3, 1.4, or 1.6 - default is 1.4). When using -source 1.3, an assert() statement valid under Java 1.4 will result in a compiler error. When using -source 1.4, treat assert as a keyword and implement assertions according to the 1.4 language spec. When using -source 1.5 or higher, Java 5 language features are permitted.", 3);
                this.append(sb, "", 0);
                this.append(sb, "target", 2);
                this.append(sb, "Specify classfile target setting (1.1 to 1.6) default is 1.2", 3);
                this.append(sb, "", 0);
                this.append(sb, "testAspectDirectory (Default: src/test/aspect)", 2);
                this.append(sb, "The source directory for the test aspects", 3);
                this.append(sb, "", 0);
                this.append(sb, "verbose", 2);
                this.append(sb, "Emit messages about accessed/processed compilation units", 3);
                this.append(sb, "", 0);
                this.append(sb, "warn", 2);
                this.append(sb, "Emit warnings for any instances of the comma-delimited list of questionable code (eg 'unusedLocals,deprecation'): see http://www.eclipse.org/aspectj/doc/released/devguide/ajc-ref.html#ajc for available settings", 3);
                this.append(sb, "", 0);
                this.append(sb, "weaveDependencies", 2);
                this.append(sb, "List of of modules to weave (into target directory). Corresponds to ajc -inpath option (or -injars for pre-1.2 (which is not supported)).", 3);
                this.append(sb, "", 0);
                this.append(sb, "XaddSerialVersionUID", 2);
                this.append(sb, "Causes the compiler to calculate and add the SerialVersionUID field to any type implementing Serializable that is affected by an aspect. The field is calculated based on the class before weaving has taken place.", 3);
                this.append(sb, "", 0);
                this.append(sb, "Xlint", 2);
                this.append(sb, "Set default level for messages about potential programming mistakes in crosscutting code. {level} may be ignore, warning, or error. This overrides entries in org/aspectj/weaver/XlintDefault.properties from aspectjtools.jar.", 3);
                this.append(sb, "", 0);
                this.append(sb, "XnoInline", 2);
                this.append(sb, "(Experimental) do not inline around advice", 3);
                this.append(sb, "", 0);
                this.append(sb, "Xreweavable", 2);
                this.append(sb, "(Experimental) runs weaver in reweavable mode which causes it to create woven classes that can be rewoven, subject to the restriction that on attempting a reweave all the types that advised the woven type must be accessible.", 3);
                this.append(sb, "", 0);
                this.append(sb, "XserializableAspects", 2);
                this.append(sb, "(Experimental) Normally it is an error to declare aspects Serializable. This option removes that restriction.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "aspectj:help", 0);
            this.append(sb, "Display help information on aspectj-maven-plugin.\nCall\n\u00a0\u00a0mvn\u00a0aspectj:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level, should be positive.", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line, should be positive.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "test-compile".equals(this.goal)) {
            this.append(sb, "aspectj:test-compile", 0);
            this.append(sb, "Weaves all test classes.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "ajdtBuildDefFile", 2);
                this.append(sb, "Where to find the ajdt build definition file. If set this will override the use of project sourcedirs.", 3);
                this.append(sb, "", 0);
                this.append(sb, "argumentFileName (Default: builddef.lst)", 2);
                this.append(sb, "The filename to store build configuration in. This file will be placed in the project build output directory, and will contain all the arguments passed to the compiler in the last run, and also all the filenames included in the build. Aspects as well as java files.", 3);
                this.append(sb, "", 0);
                this.append(sb, "aspectDirectory (Default: src/main/aspect)", 2);
                this.append(sb, "The source directory for the aspects", 3);
                this.append(sb, "", 0);
                this.append(sb, "aspectLibraries", 2);
                this.append(sb, "Weave binary aspects from the jars. The aspects should have been output by the same version of the compiler. The modules must also be dependencies of the project. Corresponds to ajc -aspectpath option", 3);
                this.append(sb, "", 0);
                this.append(sb, "basedir", 2);
                this.append(sb, "The basedir of the project.", 3);
                this.append(sb, "", 0);
                this.append(sb, "bootclasspath", 2);
                this.append(sb, "Override location of VM's bootclasspath for purposes of evaluating types when compiling. Path is a single argument containing a list of paths to zip files or directories, delimited by the platform-specific path delimiter.", 3);
                this.append(sb, "", 0);
                this.append(sb, "complianceLevel", 2);
                this.append(sb, "Specify compiler compliance setting (1.3 to 1.6) default is 1.4", 3);
                this.append(sb, "", 0);
                this.append(sb, "deprecation", 2);
                this.append(sb, "Toggle warningmessages on deprecations", 3);
                this.append(sb, "", 0);
                this.append(sb, "emacssym", 2);
                this.append(sb, "Generate .ajesym symbol files for emacs support", 3);
                this.append(sb, "", 0);
                this.append(sb, "encoding", 2);
                this.append(sb, "Specify default source encoding format.", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludes", 2);
                this.append(sb, "List of ant-style patterns used to specify the aspects that should be excluded when compiling. When none specified all .java and .aj files in the project source directories, or directories spesified by the ajdtDefFile property are included. *", 3);
                this.append(sb, "", 0);
                this.append(sb, "includes", 2);
                this.append(sb, "List of ant-style patterns used to specify the aspects that should be included when compiling. When none specified all .java and .aj files in the project source directories, or directories spesified by the ajdtDefFile property are included. *", 3);
                this.append(sb, "", 0);
                this.append(sb, "noImportError", 2);
                this.append(sb, "Emit no errors for unresolved imports;", 3);
                this.append(sb, "", 0);
                this.append(sb, "outxml", 2);
                this.append(sb, "Generate aop.xml file for load-time weaving with default name.(/META-INF/aop.xml)", 3);
                this.append(sb, "", 0);
                this.append(sb, "outxmlfile", 2);
                this.append(sb, "Generate aop.xml file for load-time weaving with custom name.", 3);
                this.append(sb, "", 0);
                this.append(sb, "preserveAllLocals", 2);
                this.append(sb, "Preserve all local variables during code generation (to facilitate debugging).", 3);
                this.append(sb, "", 0);
                this.append(sb, "proceedOnError", 2);
                this.append(sb, "Keep compiling after error, dumping class files with problem methods", 3);
                this.append(sb, "", 0);
                this.append(sb, "project", 2);
                this.append(sb, "The maven project.", 3);
                this.append(sb, "", 0);
                this.append(sb, "referenceInfo", 2);
                this.append(sb, "Compute reference information.", 3);
                this.append(sb, "", 0);
                this.append(sb, "repeat", 2);
                this.append(sb, "Repeat compilation process N times (typically to do performance analysis).", 3);
                this.append(sb, "", 0);
                this.append(sb, "showWeaveInfo", 2);
                this.append(sb, "Emit messages about weaving", 3);
                this.append(sb, "", 0);
                this.append(sb, "source", 2);
                this.append(sb, "Toggle assertions (1.3, 1.4, or 1.6 - default is 1.4). When using -source 1.3, an assert() statement valid under Java 1.4 will result in a compiler error. When using -source 1.4, treat assert as a keyword and implement assertions according to the 1.4 language spec. When using -source 1.5 or higher, Java 5 language features are permitted.", 3);
                this.append(sb, "", 0);
                this.append(sb, "target", 2);
                this.append(sb, "Specify classfile target setting (1.1 to 1.6) default is 1.2", 3);
                this.append(sb, "", 0);
                this.append(sb, "testAspectDirectory (Default: src/test/aspect)", 2);
                this.append(sb, "The source directory for the test aspects", 3);
                this.append(sb, "", 0);
                this.append(sb, "verbose", 2);
                this.append(sb, "Emit messages about accessed/processed compilation units", 3);
                this.append(sb, "", 0);
                this.append(sb, "warn", 2);
                this.append(sb, "Emit warnings for any instances of the comma-delimited list of questionable code (eg 'unusedLocals,deprecation'): see http://www.eclipse.org/aspectj/doc/released/devguide/ajc-ref.html#ajc for available settings", 3);
                this.append(sb, "", 0);
                this.append(sb, "weaveDependencies", 2);
                this.append(sb, "List of of modules to weave (into target directory). Corresponds to ajc -inpath option (or -injars for pre-1.2 (which is not supported)).", 3);
                this.append(sb, "", 0);
                this.append(sb, "weaveMainSourceFolder (Default: false)", 2);
                this.append(sb, "Flag to indicate if the main source dirs should be a part of the compile process. Note this will make all classes in main source dir appare in the test output dir also, potentially overwriting test resources.", 3);
                this.append(sb, "", 0);
                this.append(sb, "weaveWithAspectsInMainSourceFolder (Default: true)", 2);
                this.append(sb, "Flag to indicate if aspects in the the main source dirs should be a part of the compile process", 3);
                this.append(sb, "", 0);
                this.append(sb, "XaddSerialVersionUID", 2);
                this.append(sb, "Causes the compiler to calculate and add the SerialVersionUID field to any type implementing Serializable that is affected by an aspect. The field is calculated based on the class before weaving has taken place.", 3);
                this.append(sb, "", 0);
                this.append(sb, "Xlint", 2);
                this.append(sb, "Set default level for messages about potential programming mistakes in crosscutting code. {level} may be ignore, warning, or error. This overrides entries in org/aspectj/weaver/XlintDefault.properties from aspectjtools.jar.", 3);
                this.append(sb, "", 0);
                this.append(sb, "XnoInline", 2);
                this.append(sb, "(Experimental) do not inline around advice", 3);
                this.append(sb, "", 0);
                this.append(sb, "Xreweavable", 2);
                this.append(sb, "(Experimental) runs weaver in reweavable mode which causes it to create woven classes that can be rewoven, subject to the restriction that on attempting a reweave all the types that advised the woven type must be accessible.", 3);
                this.append(sb, "", 0);
                this.append(sb, "XserializableAspects", 2);
                this.append(sb, "(Experimental) Normally it is an error to declare aspects Serializable. This option removes that restriction.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = HelpMojo.toLines(description, indent, this.indentSize, this.lineLength).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private static List toLines(String text, int indent, int indentSize, int lineLength) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            HelpMojo.toLines(lines, ind + plainLines[i], indentSize, lineLength);
        }
        return lines;
    }

    private static void toLines(List lines, String line, int indentSize, int lineLength) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", indentSize - buf.length() % indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

