/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.commons.compiler.jdk;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;
import org.codehaus.commons.compiler.AbstractCompiler;
import org.codehaus.commons.compiler.CompileException;
import org.codehaus.commons.compiler.jdk.JavaSourceClassLoader;
import org.codehaus.commons.compiler.jdk.util.JavaFileManagers;
import org.codehaus.commons.compiler.jdk.util.JavaFileObjects;
import org.codehaus.commons.compiler.util.reflect.ApiLog;
import org.codehaus.commons.compiler.util.resource.Resource;
import org.codehaus.commons.nullanalysis.Nullable;

public class Compiler
extends AbstractCompiler {
    private static final JavaCompiler SYSTEM_JAVA_COMPILER = Compiler.getSystemJavaCompiler();
    private Collection<String> compilerOptions = new ArrayList<String>();
    @Nullable
    private JavaFileManager fileManagerEnn;

    public void setVerbose(boolean verbose) {
    }

    public void setCompilerOptions(String[] compilerOptions) {
        this.compilerOptions = Arrays.asList(compilerOptions);
    }

    public void compile(Resource[] sourceResources) throws CompileException, IOException {
        ArrayList<JavaFileObject> sourceFileObjects = new ArrayList<JavaFileObject>();
        for (int i = 0; i < sourceResources.length; ++i) {
            Resource sourceResource = sourceResources[i];
            String fn = sourceResource.getFileName();
            String className = fn.substring(fn.lastIndexOf(File.separatorChar) + 1, fn.length() - 5).replace('/', '.');
            sourceFileObjects.add(JavaFileObjects.fromResource(sourceResource, className, JavaFileObject.Kind.SOURCE, this.sourceCharset));
        }
        ArrayList<String> options = new ArrayList<String>(this.compilerOptions);
        ArrayList<String> l = new ArrayList<String>();
        if (this.debugLines) {
            l.add("lines");
        }
        if (this.debugSource) {
            l.add("source");
        }
        if (this.debugVars) {
            l.add("vars");
        }
        if (l.isEmpty()) {
            l.add("none");
        }
        Iterator it = l.iterator();
        String o = "-g:" + (String)it.next();
        while (it.hasNext()) {
            o = o + "," + (String)it.next();
        }
        options.add(o);
        if (this.sourceVersion != -1) {
            options.add("-source");
            options.add(Integer.toString(this.sourceVersion));
        }
        if (this.targetVersion != -1) {
            options.add("-target");
            options.add(Integer.toString(this.targetVersion));
        }
        JavaFileManager fileManager = this.getJavaFileManager();
        fileManager = (JavaFileManager)ApiLog.logMethodInvocations((Object)fileManager);
        try {
            if (!SYSTEM_JAVA_COMPILER.getTask(null, fileManager, (DiagnosticListener<? super JavaFileObject>)new DiagnosticListener<JavaFileObject>(){

                @Override
                public void report(@Nullable Diagnostic<? extends JavaFileObject> diagnostic) {
                    assert (diagnostic != null);
                    if (diagnostic.getKind() == Diagnostic.Kind.ERROR) {
                        throw new JavaSourceClassLoader.DiagnosticException(diagnostic);
                    }
                }
            }, options, null, sourceFileObjects).call().booleanValue()) {
                throw new CompileException("Compilation failed", null);
            }
        }
        catch (RuntimeException re) {
            Throwable cause = re.getCause();
            if (cause instanceof JavaSourceClassLoader.DiagnosticException) {
                CompileException ce = new CompileException(((JavaSourceClassLoader.DiagnosticException)cause).getMessage(), null);
                ce.initCause((Throwable)re);
                throw ce;
            }
            throw re;
        }
    }

    private static JavaCompiler getSystemJavaCompiler() {
        JavaCompiler c = ToolProvider.getSystemJavaCompiler();
        if (c == null) {
            throw new UnsupportedOperationException("JDK Java compiler not available - probably you're running a JRE, not a JDK");
        }
        return c;
    }

    private JavaFileManager getJavaFileManager() {
        if (this.fileManagerEnn != null) {
            return this.fileManagerEnn;
        }
        this.fileManagerEnn = this.getJavaFileManager2();
        return this.fileManagerEnn;
    }

    private JavaFileManager getJavaFileManager2() {
        JavaFileManager jfm = SYSTEM_JAVA_COMPILER.getStandardFileManager(null, null, null);
        jfm = JavaFileManagers.fromResourceCreator(jfm, StandardLocation.CLASS_OUTPUT, JavaFileObject.Kind.CLASS, this.classFileCreator, Charset.defaultCharset());
        jfm = JavaFileManagers.fromResourceFinder(jfm, StandardLocation.CLASS_PATH, JavaFileObject.Kind.CLASS, this.classFileFinder, Charset.defaultCharset());
        jfm = JavaFileManagers.fromResourceFinder(jfm, StandardLocation.SOURCE_PATH, JavaFileObject.Kind.SOURCE, this.sourceFinder, this.sourceCharset);
        this.fileManagerEnn = jfm;
        return this.fileManagerEnn;
    }
}

