/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map.type;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.jackson.map.type.ArrayType;
import org.codehaus.jackson.map.type.CollectionType;
import org.codehaus.jackson.map.type.MapType;
import org.codehaus.jackson.map.type.SimpleType;
import org.codehaus.jackson.type.JavaType;
import org.codehaus.jackson.type.TypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeFactory {
    public static final TypeFactory instance = new TypeFactory();
    protected final HashMap<String, JavaType> _commonTypeCache = new HashMap();

    protected TypeFactory() {
        SimpleType.addCommonTypes(this._commonTypeCache);
        ArrayType.addCommonTypes(this._commonTypeCache);
    }

    public static JavaType fromClass(Class<?> clz) {
        return instance._fromClass(clz, null);
    }

    public static JavaType fromTypeReference(TypeReference<?> ref) {
        return TypeFactory.fromType(ref.getType());
    }

    public static JavaType fromType(Type type) {
        return instance._fromType(type, null);
    }

    public static JavaType fromType(Type type, JavaType context) {
        return instance._fromType(type, context);
    }

    protected JavaType _fromClass(Class<?> clz, Map<String, JavaType> genericParams) {
        String clzName = clz.getName();
        JavaType type = this._commonTypeCache.get(clzName);
        if (type != null) {
            return type;
        }
        if (clz.isArray()) {
            return ArrayType.construct(TypeFactory.fromClass(clz.getComponentType()));
        }
        if (Map.class.isAssignableFrom(clz)) {
            JavaType unknownType = TypeFactory.fromClass(Object.class);
            return MapType.untyped(clz, unknownType, unknownType);
        }
        if (Collection.class.isAssignableFrom(clz)) {
            JavaType unknownType = TypeFactory.fromClass(Object.class);
            return CollectionType.untyped(clz, unknownType);
        }
        return SimpleType.construct(clz, genericParams);
    }

    public JavaType _fromType(Type type, JavaType context) {
        if (type instanceof Class) {
            return this._fromClass((Class)type, null);
        }
        if (type instanceof ParameterizedType) {
            return this._fromParamType((ParameterizedType)type, context);
        }
        if (type instanceof GenericArrayType) {
            return this._fromArrayType((GenericArrayType)type, context);
        }
        if (type instanceof TypeVariable) {
            return this._fromVariable((TypeVariable)type, context);
        }
        if (type instanceof WildcardType) {
            return this._fromWildcard((WildcardType)type, context);
        }
        throw new IllegalArgumentException("Unrecognized Type: " + type.toString());
    }

    protected JavaType _fromParamType(ParameterizedType type, JavaType context) {
        Class rawType = (Class)type.getRawType();
        if (Map.class.isAssignableFrom(rawType)) {
            Type[] args = type.getActualTypeArguments();
            return MapType.typed(rawType, TypeFactory.fromType(args[0]), TypeFactory.fromType(args[1]));
        }
        if (Collection.class.isAssignableFrom(rawType)) {
            return CollectionType.typed(rawType, TypeFactory.fromType(type.getActualTypeArguments()[0]));
        }
        Type[] args = type.getActualTypeArguments();
        HashMap<String, JavaType> types = null;
        if (args != null && args.length > 0) {
            TypeVariable<Class<T>>[] vars = rawType.getTypeParameters();
            if (vars.length != args.length) {
                throw new IllegalArgumentException("Strange parametrized type (raw: " + rawType + "): number of type arguments != number of type parameters (" + args.length + " vs " + vars.length + ")");
            }
            types = new HashMap<String, JavaType>();
            int len = args.length;
            for (int i = 0; i < len; ++i) {
                types.put(vars[i].getName(), this._fromType(args[i], context));
            }
        }
        return this._fromClass(rawType, types);
    }

    protected JavaType _fromArrayType(GenericArrayType type, JavaType context) {
        JavaType compType = this._fromType(type.getGenericComponentType(), context);
        return ArrayType.construct(compType);
    }

    protected JavaType _fromVariable(TypeVariable<?> type, JavaType context) {
        String name = type.getName();
        JavaType actualType = context.findVariableType(name);
        if (actualType != null) {
            return actualType;
        }
        throw new IllegalArgumentException("Unresolved TypeVariable <" + name + "> (from " + type.getGenericDeclaration() + ")");
    }

    protected JavaType _fromWildcard(WildcardType type, JavaType context) {
        return this._fromType(type.getUpperBounds()[0], context);
    }
}

