/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map.ser;

import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.SerializerProvider;
import org.codehaus.jackson.map.type.CollectionType;
import org.codehaus.jackson.map.type.TypeFactory;
import org.codehaus.jackson.node.JsonNodeFactory;
import org.codehaus.jackson.node.ObjectNode;
import org.codehaus.jackson.schema.JsonSchema;
import org.codehaus.jackson.schema.SchemaAware;
import org.codehaus.jackson.type.JavaType;

public final class ContainerSerializers {
    private ContainerSerializers() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class EnumMapSerializer
    extends JsonSerializer<EnumMap<? extends Enum<?>, ?>>
    implements SchemaAware {
        @Override
        public void serialize(EnumMap<? extends Enum<?>, ?> value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
            jgen.writeStartObject();
            JsonSerializer<Object> prevSerializer = null;
            Class<?> prevClass = null;
            for (Map.Entry<Enum<?>, ?> entry : value.entrySet()) {
                JsonSerializer<Object> currSerializer;
                jgen.writeFieldName(provider.getConfig().getAnnotationIntrospector().findEnumValue(entry.getKey()));
                Object valueElem = entry.getValue();
                if (valueElem == null) {
                    provider.getNullValueSerializer().serialize(null, jgen, provider);
                    continue;
                }
                Class<?> cc = valueElem.getClass();
                if (cc == prevClass) {
                    currSerializer = prevSerializer;
                } else {
                    prevSerializer = currSerializer = provider.findValueSerializer(cc);
                    prevClass = cc;
                }
                try {
                    currSerializer.serialize(valueElem, jgen, provider);
                }
                catch (IOException ioe) {
                    throw ioe;
                }
                catch (Exception e) {
                    throw JsonMappingException.wrapWithPath((Throwable)e, value, entry.getKey().name());
                }
            }
            jgen.writeEndObject();
        }

        @Override
        public JsonNode getSchema(SerializerProvider provider, Type typeHint) throws JsonMappingException {
            Type[] typeArgs;
            ObjectNode o = JsonNodeFactory.instance.objectNode();
            o.put("type", "object");
            if (typeHint instanceof ParameterizedType && (typeArgs = ((ParameterizedType)typeHint).getActualTypeArguments()).length == 2) {
                JavaType enumType = TypeFactory.fromType(typeArgs[0]);
                JavaType valueType = TypeFactory.fromType(typeArgs[1]);
                ObjectNode propsNode = JsonNodeFactory.instance.objectNode();
                Class enumClass = enumType.getRawClass();
                for (Enum enumValue : (Enum[])enumClass.getEnumConstants()) {
                    JsonSerializer<Object> ser = provider.findValueSerializer(valueType.getRawClass());
                    JsonNode schemaNode = ser instanceof SchemaAware ? ((SchemaAware)((Object)ser)).getSchema(provider, null) : JsonSchema.getDefaultSchemaNode();
                    propsNode.put(provider.getConfig().getAnnotationIntrospector().findEnumValue(enumValue), schemaNode);
                }
                o.put("properties", propsNode);
            }
            o.put("optional", true);
            return o;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class MapSerializer
    extends JsonSerializer<Map<?, ?>>
    implements SchemaAware {
        public static final MapSerializer instance = new MapSerializer();

        @Override
        public void serialize(Map<?, ?> value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
            jgen.writeStartObject();
            if (!value.isEmpty()) {
                JsonSerializer<Object> keySerializer = provider.getKeySerializer();
                JsonSerializer<Object> prevValueSerializer = null;
                Class<?> prevValueClass = null;
                for (Map.Entry<?, ?> entry : value.entrySet()) {
                    JsonSerializer<Object> currSerializer;
                    Object keyElem = entry.getKey();
                    if (keyElem == null) {
                        provider.getNullKeySerializer().serialize(null, jgen, provider);
                    } else {
                        keySerializer.serialize(keyElem, jgen, provider);
                    }
                    Object valueElem = entry.getValue();
                    if (valueElem == null) {
                        provider.getNullValueSerializer().serialize(null, jgen, provider);
                        continue;
                    }
                    Class<?> cc = valueElem.getClass();
                    if (cc == prevValueClass) {
                        currSerializer = prevValueSerializer;
                    } else {
                        prevValueSerializer = currSerializer = provider.findValueSerializer(cc);
                        prevValueClass = cc;
                    }
                    try {
                        currSerializer.serialize(valueElem, jgen, provider);
                    }
                    catch (IOException ioe) {
                        throw ioe;
                    }
                    catch (Exception e) {
                        String keyDesc = "" + keyElem;
                        throw JsonMappingException.wrapWithPath((Throwable)e, value, keyDesc);
                    }
                }
            }
            jgen.writeEndObject();
        }

        @Override
        public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
            ObjectNode o = JsonNodeFactory.instance.objectNode();
            o.put("type", "object");
            o.put("optional", true);
            return o;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class EnumSetSerializer
    extends JsonSerializer<EnumSet<? extends Enum<?>>>
    implements SchemaAware {
        public static final CollectionSerializer instance = new CollectionSerializer();

        @Override
        public void serialize(EnumSet<? extends Enum<?>> value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
            jgen.writeStartArray();
            for (Enum enum_ : value) {
                jgen.writeString(provider.getConfig().getAnnotationIntrospector().findEnumValue(enum_));
            }
            jgen.writeEndArray();
        }

        @Override
        public JsonNode getSchema(SerializerProvider provider, Type typeHint) throws JsonMappingException {
            Type[] typeArgs;
            ObjectNode o = JsonNodeFactory.instance.objectNode();
            o.put("type", "array");
            if (typeHint instanceof ParameterizedType && (typeArgs = ((ParameterizedType)typeHint).getActualTypeArguments()).length == 1) {
                JavaType javaType = TypeFactory.fromType(typeArgs[0]);
                JsonSerializer<Object> ser = provider.findValueSerializer(javaType.getRawClass());
                JsonNode schemaNode = ser instanceof SchemaAware ? ((SchemaAware)((Object)ser)).getSchema(provider, null) : JsonSchema.getDefaultSchemaNode();
                o.put("items", schemaNode);
            }
            o.put("optional", true);
            return o;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class IterableSerializer
    extends JsonSerializer<Iterable<?>>
    implements SchemaAware {
        public static final IterableSerializer instance = new IterableSerializer();

        @Override
        public void serialize(Iterable<?> value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
            jgen.writeStartArray();
            Iterator<?> it = value.iterator();
            if (it.hasNext()) {
                JsonSerializer<Object> prevSerializer = null;
                Class<?> prevClass = null;
                do {
                    JsonSerializer<Object> currSerializer;
                    Object elem;
                    if ((elem = it.next()) == null) {
                        provider.getNullValueSerializer().serialize(null, jgen, provider);
                        continue;
                    }
                    Class<?> cc = elem.getClass();
                    if (cc == prevClass) {
                        currSerializer = prevSerializer;
                    } else {
                        prevSerializer = currSerializer = provider.findValueSerializer(cc);
                        prevClass = cc;
                    }
                    currSerializer.serialize(elem, jgen, provider);
                } while (it.hasNext());
            }
            jgen.writeEndArray();
        }

        @Override
        public JsonNode getSchema(SerializerProvider provider, Type typeHint) throws JsonMappingException {
            Type[] typeArgs;
            ObjectNode o = JsonNodeFactory.instance.objectNode();
            o.put("type", "array");
            if (typeHint instanceof ParameterizedType && (typeArgs = ((ParameterizedType)typeHint).getActualTypeArguments()).length == 1) {
                JavaType javaType = TypeFactory.fromType(typeArgs[0]);
                JsonSerializer<Object> ser = provider.findValueSerializer(javaType.getRawClass());
                JsonNode schemaNode = ser instanceof SchemaAware ? ((SchemaAware)((Object)ser)).getSchema(provider, null) : JsonSchema.getDefaultSchemaNode();
                o.put("items", schemaNode);
            }
            o.put("optional", true);
            return o;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class IteratorSerializer
    extends JsonSerializer<Iterator<?>>
    implements SchemaAware {
        public static final IteratorSerializer instance = new IteratorSerializer();

        @Override
        public void serialize(Iterator<?> value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
            jgen.writeStartArray();
            if (value.hasNext()) {
                JsonSerializer<Object> prevSerializer = null;
                Class<?> prevClass = null;
                do {
                    JsonSerializer<Object> currSerializer;
                    Object elem;
                    if ((elem = value.next()) == null) {
                        provider.getNullValueSerializer().serialize(null, jgen, provider);
                        continue;
                    }
                    Class<?> cc = elem.getClass();
                    if (cc == prevClass) {
                        currSerializer = prevSerializer;
                    } else {
                        prevSerializer = currSerializer = provider.findValueSerializer(cc);
                        prevClass = cc;
                    }
                    currSerializer.serialize(elem, jgen, provider);
                } while (value.hasNext());
            }
            jgen.writeEndArray();
        }

        @Override
        public JsonNode getSchema(SerializerProvider provider, Type typeHint) throws JsonMappingException {
            Type[] typeArgs;
            ObjectNode o = JsonNodeFactory.instance.objectNode();
            o.put("type", "array");
            if (typeHint instanceof ParameterizedType && (typeArgs = ((ParameterizedType)typeHint).getActualTypeArguments()).length == 1) {
                JavaType javaType = TypeFactory.fromType(typeArgs[0]);
                JsonSerializer<Object> ser = provider.findValueSerializer(javaType.getRawClass());
                JsonNode schemaNode = ser instanceof SchemaAware ? ((SchemaAware)((Object)ser)).getSchema(provider, null) : JsonSchema.getDefaultSchemaNode();
                o.put("items", schemaNode);
            }
            o.put("optional", true);
            return o;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class CollectionSerializer
    extends JsonSerializer<Collection<?>>
    implements SchemaAware {
        public static final CollectionSerializer instance = new CollectionSerializer();

        @Override
        public void serialize(Collection<?> value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
            jgen.writeStartArray();
            Iterator<?> it = value.iterator();
            if (it.hasNext()) {
                JsonSerializer<Object> prevSerializer = null;
                Class<?> prevClass = null;
                int i = 0;
                try {
                    do {
                        Object elem;
                        if ((elem = it.next()) == null) {
                            provider.getNullValueSerializer().serialize(null, jgen, provider);
                        } else {
                            JsonSerializer<Object> currSerializer;
                            Class<?> cc = elem.getClass();
                            if (cc == prevClass) {
                                currSerializer = prevSerializer;
                            } else {
                                prevSerializer = currSerializer = provider.findValueSerializer(cc);
                                prevClass = cc;
                            }
                            currSerializer.serialize(elem, jgen, provider);
                        }
                        ++i;
                    } while (it.hasNext());
                }
                catch (IOException ioe) {
                    throw ioe;
                }
                catch (Exception e) {
                    throw JsonMappingException.wrapWithPath((Throwable)e, value, i);
                }
            }
            jgen.writeEndArray();
        }

        @Override
        public JsonNode getSchema(SerializerProvider provider, Type typeHint) throws JsonMappingException {
            JavaType javaType;
            ObjectNode o = JsonNodeFactory.instance.objectNode();
            o.put("type", "array");
            if (typeHint != null && (javaType = TypeFactory.fromType(typeHint)) instanceof CollectionType) {
                Class componentType = ((CollectionType)javaType).getElementType().getRawClass();
                JsonSerializer<Object> ser = provider.findValueSerializer(componentType);
                JsonNode schemaNode = ser instanceof SchemaAware ? ((SchemaAware)((Object)ser)).getSchema(provider, null) : JsonSchema.getDefaultSchemaNode();
                o.put("items", schemaNode);
            }
            o.put("optional", true);
            return o;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class IndexedListSerializer
    extends JsonSerializer<List<?>>
    implements SchemaAware {
        public static final IndexedListSerializer instance = new IndexedListSerializer();

        @Override
        public void serialize(List<?> value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
            jgen.writeStartArray();
            int len = value.size();
            if (len > 0) {
                int i;
                JsonSerializer<Object> prevSerializer = null;
                Class<?> prevClass = null;
                try {
                    for (i = 0; i < len; ++i) {
                        JsonSerializer<Object> currSerializer;
                        Object elem = value.get(i);
                        if (elem == null) {
                            provider.getNullValueSerializer().serialize(null, jgen, provider);
                            continue;
                        }
                        Class<?> cc = elem.getClass();
                        if (cc == prevClass) {
                            currSerializer = prevSerializer;
                        } else {
                            prevSerializer = currSerializer = provider.findValueSerializer(cc);
                            prevClass = cc;
                        }
                        currSerializer.serialize(elem, jgen, provider);
                    }
                }
                catch (IOException ioe) {
                    throw ioe;
                }
                catch (Exception e) {
                    throw JsonMappingException.wrapWithPath((Throwable)e, value, i);
                }
            }
            jgen.writeEndArray();
        }

        @Override
        public JsonNode getSchema(SerializerProvider provider, Type typeHint) throws JsonMappingException {
            JavaType javaType;
            ObjectNode o = JsonNodeFactory.instance.objectNode();
            o.put("type", "array");
            if (typeHint != null && (javaType = TypeFactory.fromType(typeHint)) instanceof CollectionType) {
                Class componentType = ((CollectionType)javaType).getElementType().getRawClass();
                JsonSerializer<Object> ser = provider.findValueSerializer(componentType);
                JsonNode schemaNode = ser instanceof SchemaAware ? ((SchemaAware)((Object)ser)).getSchema(provider, null) : JsonSchema.getDefaultSchemaNode();
                o.put("items", schemaNode);
            }
            o.put("optional", true);
            return o;
        }
    }
}

