/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map.ser;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.SerializerProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BeanPropertyWriter {
    protected final String _name;
    protected final Class<?> _cfgSerializationType;
    protected final JsonSerializer<Object> _serializer;

    public BeanPropertyWriter(String name, JsonSerializer<Object> ser, Class<?> serType) {
        this._name = name;
        this._serializer = ser;
        this._cfgSerializationType = serType;
    }

    public abstract BeanPropertyWriter withSerializer(JsonSerializer<Object> var1);

    public final boolean hasSerializer() {
        return this._serializer != null;
    }

    public final Class<?> getSerializationType() {
        return this._cfgSerializationType;
    }

    public abstract Class<?> getReturnType();

    public final String getName() {
        return this._name;
    }

    public abstract void serializeAsField(Object var1, JsonGenerator var2, SerializerProvider var3) throws Exception;

    public abstract Object get(Object var1) throws Exception;

    public abstract Type getGenericPropertyType();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class NonDefaultField
    extends FieldBasedWriter {
        final Object _defaultValue;

        public NonDefaultField(String name, JsonSerializer<Object> ser, Class<?> serType, Field acc, Object defaultValue) {
            super(name, ser, serType, acc);
            if (defaultValue == null) {
                throw new IllegalArgumentException("Can not have null default value");
            }
            this._defaultValue = defaultValue;
        }

        @Override
        public BeanPropertyWriter withSerializer(JsonSerializer<Object> ser) {
            return new NonDefaultField(this._name, ser, this._cfgSerializationType, this._field, this._defaultValue);
        }

        @Override
        public void serializeAsField(Object bean, JsonGenerator jgen, SerializerProvider prov) throws Exception {
            JsonSerializer<Object> ser;
            Object value = this.get(bean);
            if (value == null) {
                ser = prov.getNullValueSerializer();
            } else {
                if (this._defaultValue.equals(value)) {
                    return;
                }
                ser = this._serializer;
                if (ser == null) {
                    ser = prov.findValueSerializer(value.getClass());
                }
            }
            jgen.writeFieldName(this._name);
            ser.serialize(value, jgen, prov);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class NonNullField
    extends FieldBasedWriter {
        public NonNullField(String name, JsonSerializer<Object> ser, Class<?> serType, Field acc) {
            super(name, ser, serType, acc);
        }

        @Override
        public BeanPropertyWriter withSerializer(JsonSerializer<Object> ser) {
            return new NonNullField(this._name, ser, this._cfgSerializationType, this._field);
        }

        @Override
        public void serializeAsField(Object bean, JsonGenerator jgen, SerializerProvider prov) throws Exception {
            Object value = this.get(bean);
            if (value != null) {
                JsonSerializer<Object> ser = this._serializer;
                if (ser == null) {
                    ser = prov.findValueSerializer(value.getClass());
                }
                jgen.writeFieldName(this._name);
                ser.serialize(value, jgen, prov);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class StdField
    extends FieldBasedWriter {
        public StdField(String name, JsonSerializer<Object> ser, Class<?> serType, Field acc) {
            super(name, ser, serType, acc);
        }

        @Override
        public BeanPropertyWriter withSerializer(JsonSerializer<Object> ser) {
            return new StdField(this._name, ser, this._cfgSerializationType, this._field);
        }

        @Override
        public void serializeAsField(Object bean, JsonGenerator jgen, SerializerProvider prov) throws Exception {
            JsonSerializer<Object> ser;
            Object value = this.get(bean);
            if (value == null) {
                ser = prov.getNullValueSerializer();
            } else {
                ser = this._serializer;
                if (ser == null) {
                    ser = prov.findValueSerializer(value.getClass());
                }
            }
            jgen.writeFieldName(this._name);
            ser.serialize(value, jgen, prov);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class NonDefaultMethod
    extends MethodBasedWriter {
        final Object _defaultValue;

        public NonDefaultMethod(String name, JsonSerializer<Object> ser, Class<?> serType, Method acc, Object defaultValue) {
            super(name, ser, serType, acc);
            if (defaultValue == null) {
                throw new IllegalArgumentException("Can not have null default value");
            }
            this._defaultValue = defaultValue;
        }

        @Override
        public BeanPropertyWriter withSerializer(JsonSerializer<Object> ser) {
            return new NonDefaultMethod(this._name, ser, this._cfgSerializationType, this._accessorMethod, this._defaultValue);
        }

        @Override
        public void serializeAsField(Object bean, JsonGenerator jgen, SerializerProvider prov) throws Exception {
            JsonSerializer<Object> ser;
            Object value = this.get(bean);
            if (value == null) {
                ser = prov.getNullValueSerializer();
            } else {
                if (this._defaultValue.equals(value)) {
                    return;
                }
                ser = this._serializer;
                if (ser == null) {
                    ser = prov.findValueSerializer(value.getClass());
                }
            }
            jgen.writeFieldName(this._name);
            ser.serialize(value, jgen, prov);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class NonNullMethod
    extends MethodBasedWriter {
        public NonNullMethod(String name, JsonSerializer<Object> ser, Class<?> serType, Method acc) {
            super(name, ser, serType, acc);
        }

        @Override
        public BeanPropertyWriter withSerializer(JsonSerializer<Object> ser) {
            return new NonNullMethod(this._name, ser, this._cfgSerializationType, this._accessorMethod);
        }

        @Override
        public void serializeAsField(Object bean, JsonGenerator jgen, SerializerProvider prov) throws Exception {
            Object value = this.get(bean);
            if (value != null) {
                JsonSerializer<Object> ser = this._serializer;
                if (ser == null) {
                    ser = prov.findValueSerializer(value.getClass());
                }
                jgen.writeFieldName(this._name);
                ser.serialize(value, jgen, prov);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class StdMethod
    extends MethodBasedWriter {
        public StdMethod(String name, JsonSerializer<Object> ser, Class<?> serType, Method acc) {
            super(name, ser, serType, acc);
        }

        @Override
        public BeanPropertyWriter withSerializer(JsonSerializer<Object> ser) {
            return new StdMethod(this._name, ser, this._cfgSerializationType, this._accessorMethod);
        }

        @Override
        public void serializeAsField(Object bean, JsonGenerator jgen, SerializerProvider prov) throws Exception {
            JsonSerializer<Object> ser;
            Object value = this.get(bean);
            if (value == null) {
                ser = prov.getNullValueSerializer();
            } else {
                ser = this._serializer;
                if (ser == null) {
                    ser = prov.findValueSerializer(value.getClass());
                }
            }
            jgen.writeFieldName(this._name);
            ser.serialize(value, jgen, prov);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class FieldBasedWriter
    extends BeanPropertyWriter {
        protected final Field _field;

        protected FieldBasedWriter(String name, JsonSerializer<Object> ser, Class<?> serType, Field f) {
            super(name, ser, serType);
            this._field = f;
        }

        @Override
        public final Class<?> getReturnType() {
            return this._field.getType();
        }

        @Override
        public final Object get(Object bean) throws Exception {
            return this._field.get(bean);
        }

        @Override
        public Type getGenericPropertyType() {
            return this._field.getGenericType();
        }

        public String toString() {
            return "property '" + this.getName() + "' (field " + this._field.getDeclaringClass().getName() + "#" + this._field.getName() + "))";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class MethodBasedWriter
    extends BeanPropertyWriter {
        protected final Method _accessorMethod;

        protected MethodBasedWriter(String name, JsonSerializer<Object> ser, Class<?> serType, Method acc) {
            super(name, ser, serType);
            this._accessorMethod = acc;
        }

        @Override
        public final Class<?> getReturnType() {
            return this._accessorMethod.getReturnType();
        }

        @Override
        public final Object get(Object bean) throws Exception {
            return this._accessorMethod.invoke(bean, new Object[0]);
        }

        public String toString() {
            return "property '" + this.getName() + "' (via method " + this._accessorMethod.getDeclaringClass().getName() + "#" + this._accessorMethod.getName() + "))";
        }

        @Override
        public Type getGenericPropertyType() {
            return this._accessorMethod.getGenericReturnType();
        }
    }
}

