/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jdt.groovy.integration.internal;

import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.ImportNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.AnnotationConstantExpression;
import org.codehaus.groovy.ast.expr.ArrayExpression;
import org.codehaus.groovy.ast.expr.AttributeExpression;
import org.codehaus.groovy.ast.expr.CastExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.FieldExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.NamedArgumentListExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.eclipse.jdt.groovy.core.util.DepthFirstVisitor;
import org.eclipse.jdt.groovy.core.util.GroovyUtils;
import org.eclipse.jdt.groovy.search.AccessorSupport;
import org.eclipse.jdt.internal.compiler.ISourceElementRequestor;

public class GroovyIndexingVisitor
extends DepthFirstVisitor {
    private MethodNode enclosingMethod;
    private final ISourceElementRequestor requestor;

    public GroovyIndexingVisitor(ISourceElementRequestor requestor) {
        this.requestor = requestor;
    }

    @Override
    public void visitImport(ImportNode node) {
        String fieldName;
        if (node.getType() != null) {
            this.visitTypeReference(node.getType(), false, true);
        }
        if ((fieldName = node.getFieldName()) != null) {
            this.requestor.acceptUnknownReference(fieldName.toCharArray(), node.getFieldNameExpr().getStart());
        }
        super.visitImport(node);
    }

    @Override
    public void visitClass(ClassNode node) {
        if (!node.isSynthetic()) {
            this.visitTypeReference(node, false, false);
            this.visitTypeReference(node.getSuperClass(), false, true);
            ClassNode[] classNodeArray = node.getInterfaces();
            int n = classNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ClassNode face = classNodeArray[n2];
                this.visitTypeReference(face, false, true);
                ++n2;
            }
        }
        super.visitClass(node);
    }

    @Override
    public void visitField(FieldNode node) {
        if (node.getType() != node.getDeclaringClass() && node.getEnd() > 0) {
            this.visitTypeReference(node.getType(), false, true);
        }
        super.visitField(node);
    }

    @Override
    public void visitMethod(MethodNode node) {
        MethodNode meth = this.enclosingMethod;
        this.enclosingMethod = node;
        if (node != this.runMethod && node.getEnd() > 0) {
            if (GroovyIndexingVisitor.isNotEmpty(node.getGenericsTypes())) {
                this.visitTypeParameters(node.getGenericsTypes(), null);
            }
            this.visitTypeReference(node.getReturnType(), false, true);
            if (GroovyIndexingVisitor.isNotEmpty(node.getExceptions())) {
                ClassNode[] classNodeArray = node.getExceptions();
                int n = classNodeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ClassNode type = classNodeArray[n2];
                    this.visitTypeReference(type, false, true);
                    ++n2;
                }
            }
        }
        super.visitMethod(node);
        this.enclosingMethod = meth;
    }

    @Override
    protected void visitAnnotation(AnnotationNode node) {
        this.visitTypeReference(node.getClassNode(), true, true);
        super.visitAnnotation(node);
    }

    @Override
    protected void visitParameter(Parameter parameter) {
        this.visitTypeReference(parameter.getType(), false, true);
        super.visitParameter(parameter);
    }

    @Override
    public void visitArrayExpression(ArrayExpression expression) {
        if (expression.getEnd() > 0) {
            this.visitTypeReference(expression.getType(), false, true);
        }
        super.visitArrayExpression(expression);
    }

    @Override
    public void visitCastExpression(CastExpression expression) {
        if (expression.getEnd() > 0 && (expression.getStart() == expression.getType().getStart() || expression.getEnd() == expression.getType().getEnd())) {
            this.visitTypeReference(expression.getType(), false, true);
        }
        super.visitCastExpression(expression);
    }

    @Override
    public void visitClassExpression(ClassExpression expression) {
        this.visitTypeReference(expression.getType(), false, true);
        super.visitClassExpression(expression);
    }

    @Override
    public void visitConstantExpression(ConstantExpression expression) {
        if (!(expression.isNullExpression() || expression.isTrueExpression() || expression.isFalseExpression() || expression.isEmptyStringExpression())) {
            if (expression instanceof AnnotationConstantExpression) {
                this.visitTypeReference(expression.getType(), true, true);
            }
            char[] constName = expression.getValue().toString().toCharArray();
            this.requestor.acceptFieldReference(constName, expression.getStart());
            int i = 0;
            while (i <= 7) {
                this.requestor.acceptMethodReference(constName, i, expression.getStart());
                ++i;
            }
        }
        super.visitConstantExpression(expression);
    }

    @Override
    public void visitConstructorCallExpression(ConstructorCallExpression expression) {
        ClassNode type = expression.getType();
        if (expression.isSpecialCall()) {
            type = this.enclosingMethod.getDeclaringClass();
            if (expression.isSuperCall()) {
                type = type.getUnresolvedSuperClass(false);
            }
        } else if (expression.isUsingAnonymousInnerClass() && (type = expression.getType().getUnresolvedSuperClass(false)) == ClassHelper.OBJECT_TYPE) {
            type = expression.getType().getUnresolvedInterfaces(false)[0];
        }
        char[] typeName = type.getName().toCharArray();
        int i = 0;
        while (i <= 9) {
            this.requestor.acceptConstructorReference(typeName, i, expression.getNameStart());
            ++i;
        }
        ((TupleExpression)expression.getArguments()).getExpressions().stream().filter(e -> e instanceof NamedArgumentListExpression).flatMap(e -> ((NamedArgumentListExpression)e).getMapEntryExpressions().stream()).forEach(kv -> {
            if (kv.getKeyExpression() instanceof ConstantExpression) {
                this.visitNameReference(AccessorSupport.SETTER, kv.getKeyExpression().getText(), kv.getKeyExpression().getStart());
            }
        });
        super.visitConstructorCallExpression(expression);
    }

    @Override
    public void visitDeclarationExpression(DeclarationExpression expression) {
        this.visitTypeReference(expression.getLeftExpression().getType(), false, true);
        this.visitAnnotations(expression.getAnnotations());
        expression.getRightExpression().visit(this);
    }

    @Override
    public void visitFieldExpression(FieldExpression expression) {
        this.requestor.acceptFieldReference(expression.getFieldName().toCharArray(), expression.getStart());
        super.visitFieldExpression(expression);
    }

    @Override
    public void visitMethodCallExpression(MethodCallExpression expression) {
        String methodStr = expression.getMethodAsString();
        if (methodStr != null) {
            char[] methodName = methodStr.toCharArray();
            this.requestor.acceptFieldReference(methodName, expression.getStart());
            int i = 0;
            while (i <= 7) {
                this.requestor.acceptMethodReference(methodName, i, expression.getStart());
                ++i;
            }
        }
        if (expression.isUsingGenerics() && GroovyIndexingVisitor.isNotEmpty(expression.getGenericsTypes())) {
            this.visitTypeParameters(expression.getGenericsTypes(), null);
        }
        super.visitMethodCallExpression(expression);
    }

    @Override
    public void visitPropertyExpression(PropertyExpression expression) {
        if (!(expression instanceof AttributeExpression) && expression.getProperty() instanceof ConstantExpression) {
            int offset = expression.getProperty().getStart();
            String name = expression.getProperty().getText();
            this.visitNameReference(AccessorSupport.ISSER, name, offset);
            this.visitNameReference(AccessorSupport.GETTER, name, offset);
            this.visitNameReference(AccessorSupport.SETTER, name, offset);
        }
        super.visitPropertyExpression(expression);
    }

    @Override
    public void visitStaticMethodCallExpression(StaticMethodCallExpression expression) {
        ClassNode ownerType = expression.getOwnerType();
        if (ownerType != ownerType.redirect()) {
            this.visitTypeReference(ownerType, false, true);
        }
        super.visitStaticMethodCallExpression(expression);
    }

    @Override
    public void visitVariableExpression(VariableExpression expression) {
        this.requestor.acceptUnknownReference(expression.getName().toCharArray(), expression.getStart());
    }

    private void visitNameReference(AccessorSupport kind, String name, int offset) {
        String methodName = kind.createAccessorName(name);
        if (methodName != null) {
            int params = kind == AccessorSupport.SETTER ? 1 : 0;
            this.requestor.acceptMethodReference(methodName.toCharArray(), params, offset);
        }
    }

    private void visitTypeReference(ClassNode type, boolean isAnnotation, boolean useQualifiedName) {
        if (isAnnotation) {
            this.requestor.acceptAnnotationTypeReference(GroovyIndexingVisitor.splitName(type, useQualifiedName), type.getStart(), type.getEnd());
        } else {
            this.requestor.acceptTypeReference(GroovyIndexingVisitor.splitName(GroovyUtils.getBaseType(type), useQualifiedName), type.getStart(), type.getEnd());
        }
        this.visitTypeParameters(type);
    }

    private void visitTypeParameters(ClassNode type) {
        if (type.isUsingGenerics() && GroovyIndexingVisitor.isNotEmpty(type.getGenericsTypes())) {
            this.visitTypeParameters(type.getGenericsTypes(), type.getName());
        }
    }

    private void visitTypeParameters(GenericsType[] generics, String typeName) {
        GenericsType[] genericsTypeArray = generics;
        int n = generics.length;
        int n2 = 0;
        while (n2 < n) {
            GenericsType generic = genericsTypeArray[n2];
            if (generic.getType() != null && generic.getType().getName().charAt(0) != '?') {
                this.visitTypeReference(generic.getType(), generic.getType().isAnnotationDefinition(), true);
            }
            if (generic.getLowerBound() != null) {
                this.visitTypeReference(generic.getLowerBound(), generic.getLowerBound().isAnnotationDefinition(), true);
            }
            if (generic.getUpperBounds() != null) {
                ClassNode[] classNodeArray = generic.getUpperBounds();
                int n3 = classNodeArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    ClassNode bound = classNodeArray[n4];
                    if (!bound.getName().equals(typeName)) {
                        this.visitTypeReference(bound, bound.isAnnotationDefinition(), true);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    private static char[][] splitName(ClassNode type, boolean useQualifiedName) {
        String name = useQualifiedName ? type.getName() : type.getNameWithoutPackage();
        String[] nameArr = name.split("\\.");
        char[][] nameCharArr = new char[nameArr.length][];
        int i = 0;
        while (i < nameArr.length) {
            nameCharArr[i] = nameArr[i].toCharArray();
            ++i;
        }
        return nameCharArr;
    }
}

