/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.builder;

import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.ProviderNotFoundException;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.function.Predicate;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.classfmt.ExternalAnnotationDecorator;
import org.eclipse.jdt.internal.compiler.env.AccessRuleSet;
import org.eclipse.jdt.internal.compiler.env.IBinaryModule;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.env.IModule;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.jdt.internal.compiler.util.SimpleSet;
import org.eclipse.jdt.internal.compiler.util.SuffixConstants;
import org.eclipse.jdt.internal.core.builder.ClasspathJar;
import org.eclipse.jdt.internal.core.util.Util;

public class ClasspathMultiReleaseJar
extends ClasspathJar {
    private FileSystem fs;
    Path releasePath;
    Path rootPath;
    Path[] supportedVersions;

    ClasspathMultiReleaseJar(IFile resource, AccessRuleSet accessRuleSet, IPath externalAnnotationPath, boolean isOnModulePath, String compliance) {
        super(resource, accessRuleSet, externalAnnotationPath, isOnModulePath);
        this.compliance = compliance;
        ClasspathMultiReleaseJar.initializeVersions(this);
    }

    ClasspathMultiReleaseJar(String zipFilename, long lastModified, AccessRuleSet accessRuleSet, IPath externalAnnotationPath, boolean isOnModulePath, String compliance) {
        super(zipFilename, lastModified, accessRuleSet, externalAnnotationPath, isOnModulePath);
        this.compliance = compliance;
        ClasspathMultiReleaseJar.initializeVersions(this);
    }

    public ClasspathMultiReleaseJar(ZipFile zipFile, AccessRuleSet accessRuleSet, IPath externalAnnotationPath, boolean isOnModulePath, String compliance) {
        this(zipFile.getName(), accessRuleSet, externalAnnotationPath, isOnModulePath, compliance);
        this.zipFile = zipFile;
        this.closeZipFileAtEnd = true;
    }

    public ClasspathMultiReleaseJar(String fileName, AccessRuleSet accessRuleSet, IPath externalAnnotationPath, boolean isOnModulePath, String compliance) {
        this(fileName, 0L, accessRuleSet, externalAnnotationPath, isOnModulePath, compliance);
        if (externalAnnotationPath != null) {
            this.externalAnnotationPath = externalAnnotationPath.toString();
        }
    }

    @Override
    IModule initializeModule() {
        IBinaryModule mod = null;
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (ZipFile file = new ZipFile(this.zipFilename);){
                ClassFileReader classfile = null;
                try {
                    Path[] pathArray = this.supportedVersions;
                    int n = this.supportedVersions.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Path path = pathArray[n2];
                        classfile = ClassFileReader.read(file, String.valueOf(path.toString()) + '/' + "module-info.class");
                        if (classfile == null) {
                            ++n2;
                            continue;
                        }
                        break;
                    }
                }
                catch (Exception e) {
                    Util.log(e, "Failed to initialize module for: " + this);
                }
                if (classfile == null) {
                    classfile = ClassFileReader.read(file, "module-info.class");
                }
                if (classfile != null) {
                    mod = classfile.getModuleDeclaration();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | ClassFormatException e) {
            Util.log(e, "Failed to initialize module for: " + this);
        }
        return mod;
    }

    private static synchronized void initializeVersions(ClasspathMultiReleaseJar jar) {
        block19: {
            Path filePath = Paths.get(jar.zipFilename, new String[0]);
            try {
                if (!Files.exists(filePath, new LinkOption[0])) break block19;
                URI uri = URI.create("jar:" + filePath.toUri());
                try {
                    try {
                        jar.fs = FileSystems.getFileSystem(uri);
                    }
                    catch (FileSystemNotFoundException fileSystemNotFoundException) {
                        // empty catch block
                    }
                    if (jar.fs == null) {
                        jar.fs = FileSystems.newFileSystem(uri, new HashMap());
                    }
                }
                catch (IOException | IllegalArgumentException | SecurityException | FileSystemAlreadyExistsException | FileSystemNotFoundException | ProviderNotFoundException e) {
                    Util.log(e, "Failed to initialize versions for: " + jar);
                    jar.supportedVersions = new Path[0];
                }
                if (jar.fs == null) {
                    return;
                }
                jar.rootPath = jar.fs.getPath("/", new String[0]);
                int earliestJavaVersion = 53;
                long latestJDK = CompilerOptions.versionToJdkLevel(jar.compliance);
                int latestJavaVer = (int)(latestJDK >> 16);
                ArrayList<Path> versions = new ArrayList<Path>();
                int i = latestJavaVer;
                while (i >= earliestJavaVersion) {
                    Path path = jar.fs.getPath("/", "META-INF", "versions", "" + (i - 44));
                    if (Files.exists(path, new LinkOption[0])) {
                        versions.add(jar.rootPath.relativize(path));
                    }
                    --i;
                }
                jar.supportedVersions = versions.toArray(new Path[versions.size()]);
            }
            finally {
                if ((jar.supportedVersions == null || jar.supportedVersions.length <= 0) && jar.fs != null && jar.fs.isOpen()) {
                    try {
                        jar.fs.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    @Override
    protected String readJarContent(final SimpleSet packageSet) {
        final String[] modInfo = new String[]{super.readJarContent(packageSet)};
        try {
            Path[] pathArray = this.supportedVersions;
            int n = this.supportedVersions.length;
            int n2 = 0;
            while (n2 < n) {
                Path path = pathArray[n2];
                final Path relativePath = this.rootPath.resolve(path);
                Files.walkFileTree(path, (FileVisitor<? super Path>)new FileVisitor<Path>(){

                    @Override
                    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        Path fileName;
                        Path p = relativePath.relativize(file);
                        ClasspathMultiReleaseJar.addToPackageSet(packageSet, p.toString(), false);
                        if (modInfo[0] == null && (fileName = p.getFileName()) != null && fileName.toString().equalsIgnoreCase("module-info.class")) {
                            modInfo[0] = relativePath.relativize(file).toString();
                        }
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                        return FileVisitResult.CONTINUE;
                    }
                });
                ++n2;
            }
        }
        catch (Exception e) {
            Util.log(e, "Failed to read jar content for: " + packageSet + " in: " + this);
        }
        return modInfo[0];
    }

    @Override
    public NameEnvironmentAnswer findClass(String binaryFileName, String qualifiedPackageName, String moduleName, String qualifiedBinaryFileName, boolean asBinaryOnly, Predicate<String> moduleNameFilter) {
        if (!this.isPackage(qualifiedPackageName, moduleName)) {
            return null;
        }
        Path[] pathArray = this.supportedVersions;
        int n = this.supportedVersions.length;
        int n2 = 0;
        while (n2 < n) {
            block14: {
                Path path = pathArray[n2];
                Path relativePath = this.rootPath.resolve(path);
                Path p = null;
                try {
                    char[] modName;
                    p = relativePath.resolve(qualifiedPackageName).resolve(binaryFileName);
                    if (!Files.exists(p, new LinkOption[0])) break block14;
                    byte[] content = Files.readAllBytes(p);
                    IBinaryType reader = null;
                    if (content != null) {
                        reader = new ClassFileReader(content, qualifiedBinaryFileName.toCharArray());
                    }
                    if (reader == null) break block14;
                    char[] cArray = modName = this.module == null ? null : this.module.name();
                    if (reader instanceof ClassFileReader) {
                        ClassFileReader classReader = reader;
                        if (classReader.moduleName == null) {
                            classReader.moduleName = modName;
                        } else {
                            modName = classReader.moduleName;
                        }
                    }
                    String fileNameWithoutExtension = qualifiedBinaryFileName.substring(0, qualifiedBinaryFileName.length() - SuffixConstants.SUFFIX_CLASS.length);
                    if (this.externalAnnotationPath != null) {
                        try {
                            if (this.annotationZipFile == null) {
                                this.annotationZipFile = ExternalAnnotationDecorator.getAnnotationZipFile(this.externalAnnotationPath, null);
                            }
                            reader = ExternalAnnotationDecorator.create(reader, this.externalAnnotationPath, fileNameWithoutExtension, this.annotationZipFile);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        if (reader.getExternalAnnotationStatus() == BinaryTypeBinding.ExternalAnnotationStatus.NOT_EEA_CONFIGURED) {
                            reader = new ExternalAnnotationDecorator(reader, null);
                        }
                    }
                    if (this.accessRuleSet == null) {
                        return new NameEnvironmentAnswer(reader, null, modName);
                    }
                    return new NameEnvironmentAnswer(reader, this.accessRuleSet.getViolatedRestriction(fileNameWithoutExtension.toCharArray()), modName);
                }
                catch (IOException | ClassFormatException e) {
                    Util.log(e, "Failed to find class for: " + p + " in: " + this);
                }
            }
            ++n2;
        }
        return super.findClass(binaryFileName, qualifiedPackageName, moduleName, qualifiedBinaryFileName, asBinaryOnly, moduleNameFilter);
    }

    @Override
    public void cleanup() {
        if (this.fs != null && this.fs.isOpen()) {
            try {
                this.fs.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        super.cleanup();
    }
}

