/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.groovy.core.util;

import groovy.lang.GroovySystem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.ImportNode;
import org.codehaus.groovy.ast.InnerClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.TernaryExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.transform.ASTTransformation;
import org.codehaus.groovy.transform.GroovyASTTransformation;
import org.codehaus.jdt.groovy.internal.compiler.ast.JDTClassNode;
import org.codehaus.jdt.groovy.internal.compiler.ast.JDTNode;
import org.eclipse.jdt.core.Signature;
import org.osgi.framework.Version;

public class GroovyUtils {
    private GroovyUtils() {
    }

    public static Version getGroovyVersion() {
        String version = GroovySystem.getVersion();
        version = version.replaceFirst("-", ".");
        return new Version(version);
    }

    public static int[] getSourceLineSeparatorsIn(char[] code) {
        ArrayList<Integer> lineSeparatorsCollection = new ArrayList<Integer>();
        int i = 0;
        int max = code.length;
        while (i < max) {
            if (code[i] == '\r') {
                if (i + 1 < max && code[i + 1] == '\n') {
                    lineSeparatorsCollection.add(i + 1);
                    ++i;
                } else {
                    lineSeparatorsCollection.add(i);
                }
            } else if (code[i] == '\n') {
                lineSeparatorsCollection.add(i);
            }
            ++i;
        }
        int[] lineSepPositions = new int[lineSeparatorsCollection.size()];
        int i2 = 0;
        while (i2 < lineSeparatorsCollection.size()) {
            lineSepPositions[i2] = (Integer)lineSeparatorsCollection.get(i2);
            ++i2;
        }
        return lineSepPositions;
    }

    public static ASTNode lastElement(AnnotationNode node) {
        ASTNode result = node;
        Iterable more = (Iterable)node.getNodeMetaData("AnnotationCollector");
        if (more != null) {
            Iterator<Object> iterator = more.iterator();
            while (iterator.hasNext()) {
                AnnotationNode an;
                result = an = (AnnotationNode)iterator.next();
            }
        }
        if (result.getMembers() != null) {
            for (Expression expr : result.getMembers().values()) {
                if ((expr = ClassCodeVisitorSupport.getNonInlinedExpression(expr)).getEnd() <= result.getEnd()) continue;
                result = expr;
            }
        }
        return result;
    }

    public static int startOffset(AnnotationNode node) {
        int start = -1;
        Long offsets = (Long)node.getNodeMetaData("source.offsets");
        if (offsets != null) {
            start = (int)(offsets >> 32);
        } else if (node.getEnd() > 0) {
            start = node.getStart() - 1;
        }
        return start;
    }

    public static int endOffset(AnnotationNode node) {
        int end = -1;
        Long offsets = (Long)node.getNodeMetaData("source.offsets");
        end = offsets != null ? (int)(offsets & 0xFFFFFFFFFFFFFFFFL) : GroovyUtils.lastElement(node).getEnd() + 1;
        return end;
    }

    public static String[] splitName(ClassNode node) {
        String name = node.getName();
        int index = name.lastIndexOf(36);
        if (index == -1) {
            index = name.lastIndexOf(46);
        }
        return new String[]{name.substring(0, Math.max(0, index)), name.substring(index + 1)};
    }

    public static Stream<AnnotationNode> getAnnotations(AnnotatedNode node, String name) {
        return node.getAnnotations().stream().filter(an -> an.getClassNode().getName().equals(name));
    }

    public static ClassNode getBaseType(ClassNode classNode) {
        while (classNode.isArray()) {
            classNode = classNode.getComponentType();
        }
        return classNode;
    }

    public static GenericsType[] getGenericsTypes(ClassNode classNode) {
        GenericsType[] generics = GroovyUtils.getBaseType(classNode).getGenericsTypes();
        if (generics == null) {
            return GenericsType.EMPTY_ARRAY;
        }
        return generics;
    }

    public static GenericsType[] getGenericsTypes(MethodNode methodNode) {
        GenericsType[] generics = methodNode.getGenericsTypes();
        if (generics == null) {
            return GenericsType.EMPTY_ARRAY;
        }
        return generics;
    }

    public static List<ClassNode> getParameterTypes(Parameter ... params) {
        int n = params.length;
        if (n == 0) {
            return Collections.emptyList();
        }
        ArrayList<ClassNode> types = new ArrayList<ClassNode>(n);
        Parameter[] parameterArray = params;
        int n2 = params.length;
        int n3 = 0;
        while (n3 < n2) {
            Parameter param = parameterArray[n3];
            types.add(param.getType());
            ++n3;
        }
        return types;
    }

    public static String[] getParameterTypeSignatures(MethodNode methodNode, boolean resolved) {
        List<ClassNode> types = GroovyUtils.getParameterTypes(methodNode.getParameters());
        String[] signatures = new String[types.size()];
        int i = 0;
        while (i < types.size()) {
            signatures[i] = GroovyUtils.getTypeSignatureWithoutGenerics(types.get(i), true, resolved);
            ++i;
        }
        return signatures;
    }

    public static Set<ASTNode> getTransformNodes(ClassNode classNode, Class<? extends ASTTransformation> xformType) {
        CompilePhase phase = xformType.getAnnotation(GroovyASTTransformation.class).phase();
        Map<Class<? extends ASTTransformation>, Set<ASTNode>> map = classNode.getTransforms(phase);
        Set<ASTNode> nodes = map.get(xformType);
        return nodes != null ? Collections.unmodifiableSet(nodes) : Collections.EMPTY_SET;
    }

    public static ClassNode[] getTypeParameterBounds(ClassNode typeParam) {
        if (typeParam.isGenericsPlaceHolder()) {
            ClassNode[] bounds;
            assert (typeParam.isUsingGenerics());
            GenericsType[] generics = typeParam.getGenericsTypes();
            if (generics != null && generics.length > 0 && (bounds = generics[0].getUpperBounds()) != null) {
                return bounds;
            }
        }
        return ClassNode.EMPTY_ARRAY;
    }

    public static String getTypeSignature(ClassNode node, boolean qualified, boolean resolved) {
        GenericsType[] generics;
        StringBuilder builder = new StringBuilder(GroovyUtils.getTypeSignatureWithoutGenerics(node, qualified, resolved));
        if (GroovyUtils.getBaseType(node).isUsingGenerics() && !GroovyUtils.getBaseType(node).isGenericsPlaceHolder() && (generics = GroovyUtils.getGenericsTypes(node)).length > 0) {
            builder.setCharAt(builder.length() - 1, '<');
            GenericsType[] genericsTypeArray = generics;
            int n = generics.length;
            int n2 = 0;
            while (n2 < n) {
                GenericsType gen = genericsTypeArray[n2];
                if (gen.isPlaceholder() || !gen.isWildcard()) {
                    builder.append(GroovyUtils.getTypeSignature(gen.getType(), qualified, resolved));
                } else if (gen.getLowerBound() != null) {
                    builder.append('-').append(GroovyUtils.getTypeSignature(gen.getLowerBound(), qualified, resolved));
                } else if (gen.getUpperBounds() != null && gen.getUpperBounds().length > 0) {
                    builder.append('+').append(GroovyUtils.getTypeSignature(gen.getUpperBounds()[0], qualified, resolved));
                } else {
                    builder.append('*');
                }
                ++n2;
            }
            builder.append('>').append(';');
        }
        return builder.toString();
    }

    public static String getTypeSignatureWithoutGenerics(ClassNode node, boolean qualified, boolean resolved) {
        StringBuilder builder = new StringBuilder();
        while (node.isArray()) {
            builder.append('[');
            node = node.getComponentType();
        }
        String name = node.getName();
        if (node.isGenericsPlaceHolder()) {
            name = node.getUnresolvedName();
        } else if (!qualified && (name = node.getNameWithoutPackage()).indexOf(36) > 0) {
            name = node.getUnresolvedName();
        }
        assert (!(name.startsWith("[") || name.contains("<") || name.endsWith(";")));
        int pos = builder.length();
        builder.append(Signature.createTypeSignature(name, resolved));
        if (resolved && node.isGenericsPlaceHolder()) {
            builder.setCharAt(pos, 'T');
        }
        return builder.toString();
    }

    public static ClassNode getWrapperTypeIfPrimitive(ClassNode type) {
        if (ClassHelper.isPrimitiveType(type) && !ClassHelper.VOID_TYPE.equals(type)) {
            return ClassHelper.getWrapper(type);
        }
        return type;
    }

    public static List<ImportNode> getAllImportNodes(ModuleNode moduleNode) {
        ArrayList<ImportNode> importNodes = new ArrayList<ImportNode>();
        importNodes.addAll(moduleNode.getImports());
        importNodes.addAll(moduleNode.getStarImports());
        importNodes.addAll(moduleNode.getStaticImports().values());
        importNodes.addAll(moduleNode.getStaticStarImports().values());
        Collections.sort(importNodes, Comparator.comparing(ASTNode::getEnd));
        return importNodes;
    }

    public static Expression getTraitFieldExpression(MethodCallExpression call) {
        Matcher m;
        Expression objExpr = call.getObjectExpression();
        if (objExpr instanceof TernaryExpression) {
            objExpr = ((TernaryExpression)objExpr).getTrueExpression();
        }
        if (objExpr.getType().getName().endsWith("$Trait$FieldHelper") && (m = Pattern.compile(".+__(\\p{javaJavaIdentifierPart}+)\\$[gs]et").matcher(call.getMethodAsString())).matches()) {
            String fieldName = m.group(1);
            List traitFields = (List)objExpr.getType().getOuterClass().getNodeMetaData("trait.fields");
            for (FieldNode field : traitFields) {
                if (!field.getName().equals(fieldName)) continue;
                VariableExpression expr = new VariableExpression(field);
                expr.setSourcePosition(call);
                return expr;
            }
        }
        return null;
    }

    public static boolean isAnonymous(ClassNode node) {
        if (node instanceof InnerClassNode) {
            return ((InnerClassNode)node).isAnonymous();
        }
        if (node != null && node.redirect() instanceof JDTClassNode) {
            return ((JDTClassNode)node.redirect()).isAnonymous();
        }
        return false;
    }

    public static boolean isAssignable(ClassNode source, ClassNode target) {
        return GroovyUtils.isAssignable(false, source, target);
    }

    private static boolean isAssignable(boolean array, ClassNode source, ClassNode target) {
        if (source.isArray() && target.isArray()) {
            return GroovyUtils.isAssignable(true, source.getComponentType(), target.getComponentType());
        }
        if (source.isArray() && !target.equals(ClassHelper.OBJECT_TYPE) && !target.isGenericsPlaceHolder() || target.isArray()) {
            return false;
        }
        boolean result = target.isInterface() ? source.equals(target) || source.implementsInterface(target) : (array ? ClassHelper.OBJECT_TYPE.equals(target) || source.isDerivedFrom(target) : GroovyUtils.getWrapperTypeIfPrimitive(source).isDerivedFrom(GroovyUtils.getWrapperTypeIfPrimitive(target)));
        ClassNode[] bounds = GroovyUtils.getTypeParameterBounds(target);
        int i = 1;
        while (i < bounds.length && result) {
            result = GroovyUtils.isAssignable(array, source, bounds[i]);
            ++i;
        }
        return result;
    }

    public static boolean isDeprecated(ASTNode node) {
        if (node instanceof PropertyNode && ((PropertyNode)node).getField() != null) {
            node = ((PropertyNode)node).getField();
        } else if (node instanceof ClassNode) {
            node = ((ClassNode)node).redirect();
        }
        if (node instanceof JDTNode) {
            return ((JDTNode)((Object)node)).isDeprecated();
        }
        int flags = 0;
        if (node instanceof ClassNode) {
            flags = ((ClassNode)node).getModifiers();
        } else if (node instanceof FieldNode) {
            flags = ((FieldNode)node).getModifiers();
        } else if (node instanceof MethodNode) {
            flags = ((MethodNode)node).getModifiers();
        }
        if ((flags & 0x20000) != 0) {
            return true;
        }
        if (flags > 0 || node instanceof AnnotatedNode) {
            return GroovyUtils.getAnnotations((AnnotatedNode)node, "java.lang.Deprecated").anyMatch(x -> true);
        }
        return false;
    }

    public static boolean isSynthetic(FieldNode node) {
        return (node.getModifiers() & 0x1000) != 0;
    }

    public static boolean isSynthetic(MethodNode node) {
        return (node.getModifiers() & 0x1000) != 0;
    }

    public static void updateClosureWithInferredTypes(ClassNode closure, ClassNode returnType, Parameter[] parameters) {
        if (!"groovy.lang.Closure".equals(closure.getName()) || closure == closure.redirect()) {
            return;
        }
        closure.setGenericsTypes(new GenericsType[]{new GenericsType(GroovyUtils.getWrapperTypeIfPrimitive(returnType))});
    }
}

