/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jdt.groovy.internal.compiler.ast;

import java.util.HashMap;
import java.util.Map;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.jdt.groovy.internal.compiler.ast.GroovyEclipseBug;
import org.codehaus.jdt.groovy.internal.compiler.ast.JDTClassNode;
import org.codehaus.jdt.groovy.internal.compiler.ast.JDTResolver;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.groovy.core.util.ReflectionUtils;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.RawTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.UnresolvedReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.WildcardBinding;

class JDTClassNodeBuilder {
    private final JDTResolver resolver;
    private Map<TypeVariableBinding, ClassNode> typeVariableConfigurationInProgress = new HashMap<TypeVariableBinding, ClassNode>();

    JDTClassNodeBuilder(JDTResolver resolver) {
        this.resolver = resolver;
    }

    protected ClassNode configureType(TypeBinding type) {
        char[][] compoundName;
        LookupEnvironment environment;
        if (type instanceof UnresolvedReferenceBinding && (type = (environment = this.resolver.getScope().environment).getType(compoundName = ((UnresolvedReferenceBinding)type).compoundName)) == null) {
            throw new IllegalStateException("Unable to resolve type: " + CharOperation.toString(compoundName));
        }
        if (type instanceof BaseTypeBinding) {
            return this.configureBaseType((BaseTypeBinding)type);
        }
        if (type instanceof BinaryTypeBinding) {
            return this.configureBinaryType((BinaryTypeBinding)type);
        }
        if (type instanceof SourceTypeBinding) {
            return this.configureSourceType((SourceTypeBinding)type);
        }
        if (type instanceof ArrayBinding) {
            return this.configureGenericArray((ArrayBinding)type);
        }
        if (type instanceof WildcardBinding) {
            return this.configureWildcardType((WildcardBinding)type);
        }
        if (type instanceof TypeVariableBinding) {
            return this.configureTypeVariableReference((TypeVariableBinding)type);
        }
        if (type instanceof ParameterizedTypeBinding) {
            return this.configureParameterizedType((ParameterizedTypeBinding)type);
        }
        throw new IllegalStateException("'type' was null or an unhandled type: " + (type == null ? "null" : type.getClass().getName()));
    }

    protected ClassNode[] configureTypes(TypeBinding[] bindings) {
        int n;
        if (bindings == null || (n = bindings.length) == 0) {
            return null;
        }
        ClassNode[] nodes = new ClassNode[n];
        int i = 0;
        while (i < n) {
            nodes[i] = this.configureType(bindings[i]);
            ++i;
        }
        return nodes;
    }

    protected GenericsType[] configureTypeArguments(TypeBinding[] bindings) {
        int n;
        if (bindings == null || (n = bindings.length) == 0) {
            return null;
        }
        GenericsType[] gts = new GenericsType[n];
        int i = 0;
        while (i < n) {
            ClassNode t = this.configureType(bindings[i]);
            gts[i] = bindings[i] instanceof WildcardBinding ? t.getGenericsTypes()[0] : new GenericsType(t);
            ++i;
        }
        return gts;
    }

    protected GenericsType[] configureTypeVariables(TypeVariableBinding[] bindings) {
        int n;
        if (bindings == null || (n = bindings.length) == 0) {
            return null;
        }
        GenericsType[] gts = new GenericsType[n];
        int i = 0;
        while (i < n) {
            gts[i] = this.configureTypeVariableDefinition(bindings[i]);
            ++i;
        }
        return gts;
    }

    protected TypeBinding toRawType(TypeBinding tb) {
        if (tb instanceof RawTypeBinding) {
            return tb;
        }
        if (tb instanceof ParameterizedTypeBinding) {
            ParameterizedTypeBinding ptb = (ParameterizedTypeBinding)tb;
            return ptb.environment().convertToRawType(ptb.genericType(), false);
        }
        if (tb instanceof TypeVariableBinding) {
            TypeBinding fb = ((TypeVariableBinding)tb).firstBound;
            return fb != null ? fb : tb.erasure();
        }
        if (tb instanceof BinaryTypeBinding) {
            if (tb.isGenericType()) {
                LookupEnvironment le = (LookupEnvironment)ReflectionUtils.getPrivateField(BinaryTypeBinding.class, "environment", tb);
                return le.convertToRawType(tb, false);
            }
            return tb;
        }
        if (tb instanceof ArrayBinding) {
            return tb;
        }
        if (tb instanceof BaseTypeBinding) {
            return tb;
        }
        if (tb instanceof SourceTypeBinding) {
            return tb;
        }
        throw new IllegalStateException("nyi " + tb.getClass());
    }

    private ClassNode configureGenericArray(ArrayBinding genericArrayType) {
        ClassNode node;
        TypeBinding component = genericArrayType.leafComponentType;
        ClassNode result = node = this.resolver.convertToClassNode(component);
        int n = genericArrayType.dimensions;
        while (n > 0) {
            result = result.makeArray();
            --n;
        }
        return result;
    }

    private ClassNode configureTypeVariableReference(TypeVariableBinding tv) {
        ClassNode node = this.typeVariableConfigurationInProgress.get(tv);
        if (node != null) {
            return node;
        }
        String name = String.valueOf(tv.sourceName);
        if (name.indexOf(64) >= 0) {
            throw new IllegalStateException("Invalid type variable name: " + name);
        }
        ClassNode cn = ClassHelper.makeWithoutCaching(name);
        cn.setGenericsPlaceHolder(true);
        ClassNode cn2 = ClassHelper.makeWithoutCaching(name);
        cn2.setGenericsPlaceHolder(true);
        cn.setGenericsTypes(new GenericsType[]{new GenericsType(cn2)});
        this.typeVariableConfigurationInProgress.put(tv, cn);
        if (tv.firstBound != null && tv.firstBound.id != 1) {
            JDTClassNodeBuilder.setRedirect(cn, this.configureType(tv.firstBound));
        } else {
            cn.setRedirect(ClassHelper.OBJECT_TYPE);
        }
        this.typeVariableConfigurationInProgress.remove(tv);
        return cn;
    }

    private GenericsType configureTypeVariableDefinition(TypeVariableBinding tv) {
        GenericsType gt;
        ClassNode cn = this.configureTypeVariableReference(tv);
        ClassNode redirect = JDTClassNodeBuilder.removeRedirect(cn);
        TypeBinding[] tBounds = this.getBounds(tv);
        if (tBounds.length == 0) {
            gt = new GenericsType(cn);
        } else {
            ClassNode[] cBounds = this.configureTypes(tBounds);
            gt = new GenericsType(cn, cBounds, null);
            gt.setName(cn.getName());
            gt.setPlaceholder(true);
        }
        JDTClassNodeBuilder.setRedirect(cn, redirect);
        return gt;
    }

    private TypeBinding[] getBounds(TypeVariableBinding tv) {
        if (tv.firstBound == null) {
            TypeBinding erasure = tv.erasure();
            if (erasure == null) {
                erasure = this.resolver.getScope().getJavaLangObject();
            }
            return new TypeBinding[]{erasure};
        }
        TypeBinding[] others = tv.otherUpperBounds();
        TypeBinding[] bounds = new TypeBinding[1 + others.length];
        System.arraycopy(others, 0, bounds, 1, others.length);
        bounds[0] = tv.firstBound;
        return bounds;
    }

    private ClassNode configureWildcardType(WildcardBinding wildcardType) {
        ClassNode base = ClassHelper.makeWithoutCaching("?");
        base.setRedirect(ClassHelper.OBJECT_TYPE);
        ClassNode[] uppers = this.configureTypes(this.getUpperBounds(wildcardType));
        ClassNode[] lowers = this.configureTypes(this.getLowerBounds(wildcardType));
        GenericsType t = new GenericsType(base, uppers, lowers != null && lowers.length > 0 ? lowers[0] : null);
        t.setWildcard(true);
        ClassNode ref = ClassHelper.makeWithoutCaching(Object.class, false);
        ref.setGenericsTypes(new GenericsType[]{t});
        return ref;
    }

    private TypeBinding[] getLowerBounds(WildcardBinding wildcardType) {
        if (wildcardType.boundKind == 2) {
            return new TypeBinding[]{wildcardType.bound};
        }
        return Binding.NO_TYPES;
    }

    private TypeBinding[] getUpperBounds(WildcardBinding wildcardType) {
        if (wildcardType.boundKind == 1) {
            int nBounds = wildcardType.otherBounds == null ? 1 : 1 + wildcardType.otherBounds.length;
            TypeBinding[] bounds = new TypeBinding[nBounds];
            bounds[0] = wildcardType.bound;
            if (--nBounds > 0) {
                System.arraycopy(wildcardType.otherBounds, 0, bounds, 1, nBounds);
            }
            return bounds;
        }
        return Binding.NO_TYPES;
    }

    private ClassNode configureParameterizedType(ParameterizedTypeBinding parameterizedType) {
        if (parameterizedType instanceof RawTypeBinding) {
            TypeBinding rt = this.toRawType(parameterizedType);
            assert (rt instanceof RawTypeBinding) : "yikes";
            return new JDTClassNode((RawTypeBinding)rt, this.resolver);
        }
        TypeBinding rt = this.toRawType(parameterizedType);
        if (rt instanceof ParameterizedTypeBinding && !(rt instanceof RawTypeBinding)) {
            return new JDTClassNode((ParameterizedTypeBinding)rt, this.resolver);
        }
        ClassNode cn = this.configureType(rt);
        if (cn instanceof JDTClassNode) {
            ((JDTClassNode)cn).setJdtBinding(parameterizedType);
            if (!(parameterizedType instanceof RawTypeBinding)) {
                JDTClassNodeBuilder.setRedirect(cn, this.configureType(parameterizedType.genericType()));
            }
        }
        cn.setGenericsTypes(this.configureTypeArguments(parameterizedType.arguments));
        return cn;
    }

    private ClassNode configureBaseType(BaseTypeBinding type) {
        switch (type.id) {
            case 5: {
                return ClassHelper.boolean_TYPE;
            }
            case 3: {
                return ClassHelper.byte_TYPE;
            }
            case 2: {
                return ClassHelper.char_TYPE;
            }
            case 8: {
                return ClassHelper.double_TYPE;
            }
            case 9: {
                return ClassHelper.float_TYPE;
            }
            case 10: {
                return ClassHelper.int_TYPE;
            }
            case 7: {
                return ClassHelper.long_TYPE;
            }
            case 4: {
                return ClassHelper.short_TYPE;
            }
        }
        throw new GroovyEclipseBug("Unexpected BaseTypeBinding: " + type + "(type.id=" + type.id + ")");
    }

    private ClassNode configureBinaryType(BinaryTypeBinding type) {
        switch (type.id) {
            case 33: {
                return ClassHelper.Boolean_TYPE;
            }
            case 26: {
                return ClassHelper.Byte_TYPE;
            }
            case 28: {
                return ClassHelper.Character_TYPE;
            }
            case 32: {
                return ClassHelper.Double_TYPE;
            }
            case 31: {
                return ClassHelper.Float_TYPE;
            }
            case 29: {
                return ClassHelper.Integer_TYPE;
            }
            case 30: {
                return ClassHelper.Long_TYPE;
            }
            case 27: {
                return ClassHelper.Short_TYPE;
            }
            case 6: {
                return ClassHelper.VOID_TYPE;
            }
            case 34: {
                return ClassHelper.void_WRAPPER_TYPE;
            }
            case 1: {
                return ClassHelper.OBJECT_TYPE;
            }
            case 11: {
                return ClassHelper.STRING_TYPE;
            }
        }
        return new JDTClassNode(type, this.resolver);
    }

    private ClassNode configureSourceType(SourceTypeBinding type) {
        return new JDTClassNode(type, this.resolver);
    }

    static ClassNode removeRedirect(ClassNode node) {
        ClassNode redirect = (ClassNode)ReflectionUtils.getPrivateField(ClassNode.class, "redirect", node);
        node.setRedirect(null);
        return redirect;
    }

    static void setRedirect(ClassNode node, ClassNode redirect) {
        if (node.isPrimaryClassNode()) {
            throw new GroovyEclipseBug("Tried to set a redirect for a primary ClassNode (" + node.getName() + "->" + redirect.getName() + ")");
        }
        if (node != redirect) {
            ReflectionUtils.setPrivateField(ClassNode.class, "redirect", node, redirect);
        }
    }
}

