/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.builder;

import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.ProviderNotFoundException;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.function.Predicate;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.classfmt.ExternalAnnotationDecorator;
import org.eclipse.jdt.internal.compiler.env.AccessRuleSet;
import org.eclipse.jdt.internal.compiler.env.IBinaryModule;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.env.IModule;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.jdt.internal.compiler.util.SimpleSet;
import org.eclipse.jdt.internal.compiler.util.SuffixConstants;
import org.eclipse.jdt.internal.core.builder.ClasspathJar;

public class ClasspathMultiReleaseJar
extends ClasspathJar {
    private FileSystem fs = null;
    Path releasePath = null;
    Path rootPath = null;
    Path[] supportedVersions;

    ClasspathMultiReleaseJar(IFile resource, AccessRuleSet accessRuleSet, IPath externalAnnotationPath, boolean isOnModulePath, String compliance) {
        super(resource, accessRuleSet, externalAnnotationPath, isOnModulePath);
        this.compliance = compliance;
        this.initializeVersions();
    }

    ClasspathMultiReleaseJar(String zipFilename, long lastModified, AccessRuleSet accessRuleSet, IPath externalAnnotationPath, boolean isOnModulePath, String compliance) {
        super(zipFilename, lastModified, accessRuleSet, externalAnnotationPath, isOnModulePath);
        this.compliance = compliance;
        this.initializeVersions();
    }

    public ClasspathMultiReleaseJar(ZipFile zipFile, AccessRuleSet accessRuleSet, IPath externalAnnotationPath, boolean isOnModulePath, String compliance) {
        this(zipFile.getName(), accessRuleSet, externalAnnotationPath, isOnModulePath, compliance);
        this.zipFile = zipFile;
        this.closeZipFileAtEnd = true;
    }

    public ClasspathMultiReleaseJar(String fileName, AccessRuleSet accessRuleSet, IPath externalAnnotationPath, boolean isOnModulePath, String compliance) {
        this(fileName, 0L, accessRuleSet, externalAnnotationPath, isOnModulePath, compliance);
        if (externalAnnotationPath != null) {
            this.externalAnnotationPath = externalAnnotationPath.toString();
        }
    }

    @Override
    IModule initializeModule() {
        IBinaryModule mod = null;
        ZipFile file = null;
        try {
            try {
                file = new ZipFile(this.zipFilename);
                ClassFileReader classfile = null;
                try {
                    Path[] pathArray = this.supportedVersions;
                    int n = this.supportedVersions.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Path path = pathArray[n2];
                        classfile = ClassFileReader.read(file, String.valueOf(path.toString()) + '/' + "module-info.class");
                        if (classfile == null) {
                            ++n2;
                            continue;
                        }
                        break;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (classfile == null) {
                    classfile = ClassFileReader.read(file, "module-info.class");
                }
                if (classfile != null) {
                    mod = classfile.getModuleDeclaration();
                }
            }
            catch (IOException | ClassFormatException exception) {
                try {
                    if (file != null) {
                        file.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                if (file != null) {
                    file.close();
                }
            }
            catch (IOException iOException) {}
        }
        return mod;
    }

    private void initializeVersions() {
        Path filePath = Paths.get(this.zipFilename, new String[0]);
        if (Files.exists(filePath, new LinkOption[0])) {
            URI uri = URI.create("jar:" + filePath.toUri());
            try {
                try {
                    this.fs = FileSystems.getFileSystem(uri);
                }
                catch (FileSystemNotFoundException fileSystemNotFoundException) {
                    // empty catch block
                }
                if (this.fs == null) {
                    HashMap env = new HashMap();
                    this.fs = FileSystems.newFileSystem(uri, env);
                }
            }
            catch (FileSystemNotFoundException | ProviderNotFoundException env) {
            }
            catch (IOException env) {
                // empty catch block
            }
            if (this.fs == null) {
                return;
            }
            this.rootPath = this.fs.getPath("/", new String[0]);
            int earliestJavaVersion = 53;
            long latestJDK = CompilerOptions.releaseToJDKLevel(this.compliance);
            int latestJavaVer = (int)(latestJDK >> 16);
            ArrayList<Path> versions = new ArrayList<Path>();
            int i = latestJavaVer;
            while (i >= earliestJavaVersion) {
                Path path = this.fs.getPath("/", "META-INF", "versions", "" + (i - 44));
                if (Files.exists(path, new LinkOption[0])) {
                    versions.add(this.rootPath.relativize(path));
                }
                --i;
            }
            this.supportedVersions = versions.toArray(new Path[versions.size()]);
            if (this.supportedVersions.length <= 0) {
                try {
                    this.fs.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    protected String readJarContent(final SimpleSet packageSet) {
        final String[] modInfo = new String[]{super.readJarContent(packageSet)};
        try {
            Path[] pathArray = this.supportedVersions;
            int n = this.supportedVersions.length;
            int n2 = 0;
            while (n2 < n) {
                Path path = pathArray[n2];
                final Path relativePath = this.rootPath.resolve(path);
                Files.walkFileTree(path, (FileVisitor<? super Path>)new FileVisitor<Path>(){

                    @Override
                    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        Path p = relativePath.relativize(file);
                        ClasspathMultiReleaseJar.addToPackageSet(packageSet, p.toString(), false);
                        if (modInfo[0] == null && p.getFileName().toString().equalsIgnoreCase("module-info.class")) {
                            modInfo[0] = relativePath.relativize(file).toString();
                        }
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                        return FileVisitResult.CONTINUE;
                    }
                });
                ++n2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return modInfo[0];
    }

    @Override
    public NameEnvironmentAnswer findClass(String binaryFileName, String qualifiedPackageName, String moduleName, String qualifiedBinaryFileName, boolean asBinaryOnly, Predicate<String> moduleNameFilter) {
        if (!this.isPackage(qualifiedPackageName, moduleName)) {
            return null;
        }
        Path[] pathArray = this.supportedVersions;
        int n = this.supportedVersions.length;
        int n2 = 0;
        while (n2 < n) {
            block14: {
                Path path = pathArray[n2];
                Path relativePath = this.rootPath.resolve(path);
                try {
                    char[] modName;
                    Path p = relativePath.resolve(qualifiedPackageName).resolve(binaryFileName);
                    if (!Files.exists(p, new LinkOption[0])) break block14;
                    byte[] content = Files.readAllBytes(p);
                    IBinaryType reader = null;
                    if (content != null) {
                        reader = new ClassFileReader(content, qualifiedBinaryFileName.toCharArray());
                    }
                    if (reader == null) break block14;
                    char[] cArray = modName = this.module == null ? null : this.module.name();
                    if (reader instanceof ClassFileReader) {
                        ClassFileReader classReader = reader;
                        if (classReader.moduleName == null) {
                            classReader.moduleName = modName;
                        } else {
                            modName = classReader.moduleName;
                        }
                    }
                    String fileNameWithoutExtension = qualifiedBinaryFileName.substring(0, qualifiedBinaryFileName.length() - SuffixConstants.SUFFIX_CLASS.length);
                    if (this.externalAnnotationPath != null) {
                        try {
                            if (this.annotationZipFile == null) {
                                this.annotationZipFile = ExternalAnnotationDecorator.getAnnotationZipFile(this.externalAnnotationPath, null);
                            }
                            reader = ExternalAnnotationDecorator.create(reader, this.externalAnnotationPath, fileNameWithoutExtension, this.annotationZipFile);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        if (reader.getExternalAnnotationStatus() == BinaryTypeBinding.ExternalAnnotationStatus.NOT_EEA_CONFIGURED) {
                            reader = new ExternalAnnotationDecorator(reader, null);
                        }
                    }
                    if (this.accessRuleSet == null) {
                        return new NameEnvironmentAnswer(reader, null, modName);
                    }
                    return new NameEnvironmentAnswer(reader, this.accessRuleSet.getViolatedRestriction(fileNameWithoutExtension.toCharArray()), modName);
                }
                catch (IOException | ClassFormatException e) {
                    e.printStackTrace();
                }
            }
            ++n2;
        }
        return super.findClass(binaryFileName, qualifiedPackageName, moduleName, qualifiedBinaryFileName, asBinaryOnly, moduleNameFilter);
    }
}

