/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.builder;

import java.io.IOException;
import java.net.URI;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.ProviderNotFoundException;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashMap;
import java.util.function.Predicate;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.classfmt.ExternalAnnotationDecorator;
import org.eclipse.jdt.internal.compiler.env.AccessRuleSet;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.jdt.internal.compiler.util.SimpleSet;
import org.eclipse.jdt.internal.compiler.util.SuffixConstants;
import org.eclipse.jdt.internal.core.builder.ClasspathJar;

public class ClasspathMultiReleaseJar
extends ClasspathJar {
    private FileSystem fs = null;
    Path releasePath = null;

    ClasspathMultiReleaseJar(IFile resource, AccessRuleSet accessRuleSet, IPath externalAnnotationPath, boolean isOnModulePath, String compliance) {
        super(resource, accessRuleSet, externalAnnotationPath, isOnModulePath);
        this.compliance = compliance;
        this.initializeVersions();
    }

    ClasspathMultiReleaseJar(String zipFilename, long lastModified, AccessRuleSet accessRuleSet, IPath externalAnnotationPath, boolean isOnModulePath, String compliance) {
        super(zipFilename, lastModified, accessRuleSet, externalAnnotationPath, isOnModulePath);
        this.compliance = compliance;
        this.initializeVersions();
    }

    public ClasspathMultiReleaseJar(ZipFile zipFile, AccessRuleSet accessRuleSet, IPath externalAnnotationPath, boolean isOnModulePath, String compliance) {
        this(zipFile.getName(), accessRuleSet, externalAnnotationPath, isOnModulePath, compliance);
        this.zipFile = zipFile;
        this.closeZipFileAtEnd = true;
    }

    public ClasspathMultiReleaseJar(String fileName, AccessRuleSet accessRuleSet, IPath externalAnnotationPath, boolean isOnModulePath, String compliance) {
        this(fileName, 0L, accessRuleSet, externalAnnotationPath, isOnModulePath, compliance);
        if (externalAnnotationPath != null) {
            this.externalAnnotationPath = externalAnnotationPath.toString();
        }
    }

    private void initializeVersions() {
        Path filePath = Paths.get(this.zipFilename, new String[0]);
        if (Files.exists(filePath, new LinkOption[0])) {
            URI uri = URI.create("jar:" + filePath.toUri());
            try {
                this.fs = FileSystems.getFileSystem(uri);
                if (this.fs == null) {
                    HashMap env = new HashMap();
                    this.fs = FileSystems.newFileSystem(uri, env);
                }
            }
            catch (FileSystemNotFoundException | ProviderNotFoundException runtimeException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (this.fs == null) {
                this.releasePath = null;
            } else {
                this.releasePath = this.fs.getPath("/", "META-INF", "versions", this.compliance);
                if (!Files.exists(this.releasePath, new LinkOption[0])) {
                    this.releasePath = null;
                    try {
                        this.fs.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    @Override
    protected String readJarContent(final SimpleSet packageSet) {
        String[] modInfo;
        block12: {
            modInfo = new String[]{super.readJarContent(packageSet)};
            try {
                if (this.releasePath == null || !Files.exists(this.releasePath, new LinkOption[0])) break block12;
                Throwable throwable = null;
                Object var4_6 = null;
                try (DirectoryStream<Path> stream = Files.newDirectoryStream(this.releasePath);){
                    for (Path subdir : stream) {
                        Files.walkFileTree(subdir, (FileVisitor<? super Path>)new FileVisitor<Path>(){

                            @Override
                            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                                return FileVisitResult.CONTINUE;
                            }

                            @Override
                            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                                Path p = ClasspathMultiReleaseJar.this.releasePath.relativize(file);
                                ClasspathMultiReleaseJar.addToPackageSet(packageSet, p.toString(), false);
                                if (modInfo[0] == null && p.getFileName().toString().equalsIgnoreCase("module-info.class")) {
                                    modInfo[0] = ClasspathMultiReleaseJar.this.releasePath.relativize(file).toString();
                                }
                                return FileVisitResult.CONTINUE;
                            }

                            @Override
                            public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                                return FileVisitResult.CONTINUE;
                            }

                            @Override
                            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                                return FileVisitResult.CONTINUE;
                            }
                        });
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return modInfo[0];
    }

    @Override
    public NameEnvironmentAnswer findClass(String binaryFileName, String qualifiedPackageName, String moduleName, String qualifiedBinaryFileName, boolean asBinaryOnly, Predicate<String> moduleNameFilter) {
        block14: {
            if (!this.isPackage(qualifiedPackageName, moduleName)) {
                return null;
            }
            if (this.releasePath != null) {
                try {
                    char[] modName;
                    Path path = this.releasePath.resolve(qualifiedPackageName).resolve(binaryFileName);
                    byte[] content = Files.readAllBytes(path);
                    IBinaryType reader = null;
                    if (content != null) {
                        reader = new ClassFileReader(content, qualifiedBinaryFileName.toCharArray());
                    }
                    if (reader == null) break block14;
                    char[] cArray = modName = this.module == null ? null : this.module.name();
                    if (reader instanceof ClassFileReader) {
                        ClassFileReader classReader = reader;
                        if (classReader.moduleName == null) {
                            classReader.moduleName = modName;
                        } else {
                            modName = classReader.moduleName;
                        }
                    }
                    String fileNameWithoutExtension = qualifiedBinaryFileName.substring(0, qualifiedBinaryFileName.length() - SuffixConstants.SUFFIX_CLASS.length);
                    if (this.externalAnnotationPath != null) {
                        try {
                            if (this.annotationZipFile == null) {
                                this.annotationZipFile = ExternalAnnotationDecorator.getAnnotationZipFile(this.externalAnnotationPath, null);
                            }
                            reader = ExternalAnnotationDecorator.create(reader, this.externalAnnotationPath, fileNameWithoutExtension, this.annotationZipFile);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        if (reader.getExternalAnnotationStatus() == BinaryTypeBinding.ExternalAnnotationStatus.NOT_EEA_CONFIGURED) {
                            reader = new ExternalAnnotationDecorator(reader, null);
                        }
                    }
                    if (this.accessRuleSet == null) {
                        return new NameEnvironmentAnswer(reader, null, modName);
                    }
                    return new NameEnvironmentAnswer(reader, this.accessRuleSet.getViolatedRestriction(fileNameWithoutExtension.toCharArray()), modName);
                }
                catch (IOException | ClassFormatException exception) {
                    // empty catch block
                }
            }
        }
        return super.findClass(binaryFileName, qualifiedPackageName, moduleName, qualifiedBinaryFileName, asBinaryOnly, moduleNameFilter);
    }
}

