/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IModuleDescription;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.core.ClasspathEntry;
import org.eclipse.jdt.internal.core.JarEntryResource;
import org.eclipse.jdt.internal.core.JarPackageFragment;
import org.eclipse.jdt.internal.core.JarPackageFragmentRootInfo;
import org.eclipse.jdt.internal.core.JavaModel;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.OpenableElementInfo;
import org.eclipse.jdt.internal.core.PackageFragment;
import org.eclipse.jdt.internal.core.PackageFragmentRoot;
import org.eclipse.jdt.internal.core.nd.IReader;
import org.eclipse.jdt.internal.core.nd.java.JavaIndex;
import org.eclipse.jdt.internal.core.nd.java.NdResourceFile;
import org.eclipse.jdt.internal.core.nd.java.NdType;
import org.eclipse.jdt.internal.core.nd.java.NdZipEntry;
import org.eclipse.jdt.internal.core.util.HashtableOfArrayToObject;
import org.eclipse.jdt.internal.core.util.Util;

public class JarPackageFragmentRoot
extends PackageFragmentRoot {
    protected static final ArrayList EMPTY_LIST = new ArrayList();
    protected final IPath jarPath;
    boolean knownToBeModuleLess;
    private boolean multiVersion;
    public String versionPath;

    protected JarPackageFragmentRoot(IPath externalJarPath, JavaProject project) {
        super(null, project);
        this.jarPath = externalJarPath;
    }

    protected JarPackageFragmentRoot(IResource resource, JavaProject project) {
        super(resource, project);
        this.jarPath = resource.getFullPath();
    }

    @Override
    protected boolean computeChildren(OpenableElementInfo info, IResource underlyingResource) throws JavaModelException {
        IJavaElement[] children;
        HashtableOfArrayToObject rawPackageInfo = new HashtableOfArrayToObject();
        HashSet<String> overridden = new HashSet<String>();
        try {
            rawPackageInfo.put(CharOperation.NO_STRINGS, new ArrayList[]{EMPTY_LIST, EMPTY_LIST});
            boolean usedIndex = false;
            if (JavaIndex.isEnabled()) {
                JavaIndex index = JavaIndex.getIndex();
                Throwable throwable = null;
                Object var9_13 = null;
                try (IReader reader = index.getNd().acquireReadLock();){
                    NdResourceFile resourceFile;
                    IPath resourcePath = JavaIndex.getLocationForElement(this);
                    if (!resourcePath.isEmpty() && index.isUpToDate(resourceFile = index.getResourceFile(resourcePath.toString().toCharArray()))) {
                        usedIndex = true;
                        long level = resourceFile.getJdkLevel();
                        String compliance = CompilerOptions.versionFromJdkLevel(level);
                        for (NdZipEntry next : resourceFile.getZipEntries()) {
                            String filename = next.getFileName().getString();
                            this.initRawPackageInfo(rawPackageInfo, filename, filename.endsWith("/"), compliance);
                        }
                        for (NdType type : resourceFile.getTypes()) {
                            String path = String.valueOf(new String(type.getTypeId().getBinaryName())) + ".class";
                            this.initRawPackageInfo(rawPackageInfo, path, false, compliance);
                        }
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            if (!usedIndex) {
                Object file = JavaModel.getTarget(this.getPath(), true);
                long classLevel = Util.getJdkLevel(file);
                String projectCompliance = this.getJavaProject().getOption("org.eclipse.jdt.core.compiler.compliance", true);
                long projectLevel = CompilerOptions.versionToJdkLevel(projectCompliance);
                ZipFile jar = null;
                try {
                    jar = this.getJar();
                    String version = "META-INF/versions/" + projectCompliance + "/";
                    int versionPathLength = version.length();
                    if (projectLevel >= 0x350000L && jar.getEntry(version) != null) {
                        this.multiVersion = true;
                        this.versionPath = version;
                    }
                    Enumeration<? extends ZipEntry> e = jar.entries();
                    while (e.hasMoreElements()) {
                        ZipEntry member = e.nextElement();
                        String name = member.getName();
                        if (this.multiVersion && name.length() > versionPathLength && name.startsWith(version) && org.eclipse.jdt.internal.compiler.util.Util.isClassFileName(name = name.substring(version.length()))) {
                            overridden.add(name);
                        }
                        this.initRawPackageInfo(rawPackageInfo, name, member.isDirectory(), CompilerOptions.versionFromJdkLevel(classLevel));
                    }
                }
                finally {
                    JavaModelManager.getJavaModelManager().closeZipFile(jar);
                }
            }
            children = new IJavaElement[rawPackageInfo.size()];
            int index = 0;
            int i = 0;
            int length = rawPackageInfo.keyTable.length;
            while (i < length) {
                String[] pkgName = (String[])rawPackageInfo.keyTable[i];
                if (pkgName != null) {
                    children[index++] = this.getPackageFragment(pkgName);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            if (e.getCause() instanceof ZipException) {
                Util.log(4, "Invalid ZIP archive: " + this.toStringWithAncestors());
                children = NO_ELEMENTS;
            }
            if (e instanceof JavaModelException) {
                throw (JavaModelException)e;
            }
            throw new JavaModelException(e);
        }
        info.setChildren(children);
        ((JarPackageFragmentRootInfo)info).rawPackageInfo = rawPackageInfo;
        ((JarPackageFragmentRootInfo)info).overriddenClasses = overridden;
        return true;
    }

    protected IJavaElement[] createChildren(HashtableOfArrayToObject rawPackageInfo) {
        IJavaElement[] children = new IJavaElement[rawPackageInfo.size()];
        int index = 0;
        int i = 0;
        int length = rawPackageInfo.keyTable.length;
        while (i < length) {
            String[] pkgName = (String[])rawPackageInfo.keyTable[i];
            if (pkgName != null) {
                children[index++] = this.getPackageFragment(pkgName);
            }
            ++i;
        }
        return children;
    }

    @Override
    protected Object createElementInfo() {
        return new JarPackageFragmentRootInfo();
    }

    @Override
    protected int determineKind(IResource underlyingResource) {
        return 2;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof JarPackageFragmentRoot) {
            JarPackageFragmentRoot other = (JarPackageFragmentRoot)o;
            return this.jarPath.equals(other.jarPath);
        }
        return false;
    }

    @Override
    public String getElementName() {
        return this.jarPath.lastSegment();
    }

    public ZipFile getJar() throws CoreException {
        return JavaModelManager.getJavaModelManager().getZipFile(this.getPath());
    }

    @Override
    public int getKind() {
        return 2;
    }

    @Override
    int internalKind() throws JavaModelException {
        return 2;
    }

    @Override
    public Object[] getNonJavaResources() throws JavaModelException {
        Object[] defaultPkgResources = ((JarPackageFragment)this.getPackageFragment(CharOperation.NO_STRINGS)).storedNonJavaResources();
        int length = defaultPkgResources.length;
        if (length == 0) {
            return defaultPkgResources;
        }
        Object[] nonJavaResources = new Object[length];
        int i = 0;
        while (i < length) {
            JarEntryResource nonJavaResource = (JarEntryResource)defaultPkgResources[i];
            nonJavaResources[i] = nonJavaResource.clone(this);
            ++i;
        }
        return nonJavaResources;
    }

    @Override
    public PackageFragment getPackageFragment(String[] pkgName) {
        return new JarPackageFragment(this, pkgName);
    }

    @Override
    public PackageFragment getPackageFragment(String[] pkgName, String mod) {
        return new JarPackageFragment(this, pkgName);
    }

    @Override
    public String getClassFilePath(String classname) {
        if (this.multiVersion) {
            try {
                JarPackageFragmentRootInfo elementInfo = (JarPackageFragmentRootInfo)this.getElementInfo();
                if (elementInfo.overriddenClasses.contains(classname)) {
                    return this.versionPath == null ? classname : String.valueOf(this.versionPath) + classname;
                }
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
        }
        return classname;
    }

    @Override
    public IModuleDescription getModuleDescription() {
        if (this.knownToBeModuleLess) {
            return null;
        }
        IModuleDescription module = super.getModuleDescription();
        if (module == null) {
            this.knownToBeModuleLess = true;
        }
        return module;
    }

    @Override
    public IPath internalPath() {
        if (this.isExternal()) {
            return this.jarPath;
        }
        return super.internalPath();
    }

    @Override
    public IResource resource(PackageFragmentRoot root) {
        if (this.resource == null) {
            return null;
        }
        return super.resource(root);
    }

    @Override
    public IResource getUnderlyingResource() throws JavaModelException {
        if (this.isExternal()) {
            if (!this.exists()) {
                throw this.newNotPresentException();
            }
            return null;
        }
        return super.getUnderlyingResource();
    }

    @Override
    public int hashCode() {
        return this.jarPath.hashCode();
    }

    protected void initRawPackageInfo(HashtableOfArrayToObject rawPackageInfo, String entryName, boolean isDirectory, String compliance) {
        int length;
        int lastSeparator = isDirectory ? (entryName.charAt(entryName.length() - 1) == '/' ? entryName.length() - 1 : entryName.length()) : entryName.lastIndexOf(47);
        Object[] pkgName = Util.splitOn('/', entryName, 0, lastSeparator);
        Object[] existing = null;
        int existingLength = length = pkgName.length;
        while (existingLength >= 0) {
            existing = (String[])rawPackageInfo.getKey(pkgName, existingLength);
            if (existing != null) break;
            --existingLength;
        }
        JavaModelManager manager = JavaModelManager.getJavaModelManager();
        int i = existingLength;
        while (i < length) {
            if (!Util.isValidFolderNameForPackage((String)pkgName[i], null, compliance)) {
                if (!isDirectory) {
                    ArrayList[] children = (ArrayList[])rawPackageInfo.get(existing);
                    if (children[1] == EMPTY_LIST) {
                        children[1] = new ArrayList();
                    }
                    children[1].add(entryName);
                }
                return;
            }
            Object[] objectArray = existing;
            existing = new String[i + 1];
            System.arraycopy(objectArray, 0, existing, 0, i);
            existing[i] = manager.intern((String)pkgName[i]);
            rawPackageInfo.put(existing, new ArrayList[]{EMPTY_LIST, EMPTY_LIST});
            ++i;
        }
        if (isDirectory) {
            return;
        }
        ArrayList[] children = (ArrayList[])rawPackageInfo.get(pkgName);
        if (org.eclipse.jdt.internal.compiler.util.Util.isClassFileName(entryName)) {
            if (children[0] == EMPTY_LIST) {
                children[0] = new ArrayList();
            }
            String nameWithoutExtension = entryName.substring(lastSeparator + 1, entryName.length() - 6);
            children[0].add(nameWithoutExtension);
        } else {
            if (children[1] == EMPTY_LIST) {
                children[1] = new ArrayList();
            }
            children[1].add(entryName);
        }
    }

    @Override
    public boolean isArchive() {
        return true;
    }

    @Override
    public boolean isExternal() {
        return this.resource() == null;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    protected boolean resourceExists(IResource underlyingResource) {
        if (underlyingResource == null) {
            return JavaModel.getExternalTarget(this.getPath(), true) != null;
        }
        return super.resourceExists(underlyingResource);
    }

    @Override
    protected void toStringAncestors(StringBuffer buffer) {
        if (this.isExternal()) {
            return;
        }
        super.toStringAncestors(buffer);
    }

    public URL getIndexPath() {
        try {
            IClasspathEntry entry = ((JavaProject)this.getParent()).getClasspathEntryFor(this.getPath());
            if (entry != null) {
                return ((ClasspathEntry)entry).getLibraryIndexLocation();
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public Manifest getManifest() {
        ZipFile jar = null;
        try {
            jar = this.getJar();
            ZipEntry mfEntry = jar.getEntry("META-INF/MANIFEST.MF");
            if (mfEntry != null) {
                Manifest manifest = new Manifest(jar.getInputStream(mfEntry));
                return manifest;
            }
        }
        catch (IOException | CoreException exception) {
        }
        finally {
            JavaModelManager.getJavaModelManager().closeZipFile(jar);
        }
        return null;
    }
}

