/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.groovy.search;

import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.ImportNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ClosureListExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.GStringExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ForStatement;
import org.eclipse.jdt.groovy.search.ITypeLookupExtension;
import org.eclipse.jdt.groovy.search.TypeLookupResult;
import org.eclipse.jdt.groovy.search.VariableScope;

public abstract class AbstractSimplifiedTypeLookup
implements ITypeLookupExtension {
    private Boolean isStatic;
    private Expression currentExpression;

    protected TypeLookupResult.TypeConfidence checkConfidence(Expression node, TypeLookupResult.TypeConfidence originalConfidence, ASTNode declaration, String extraDoc) {
        return originalConfidence == null ? this.confidence() : originalConfidence;
    }

    protected TypeLookupResult.TypeConfidence confidence() {
        return TypeLookupResult.TypeConfidence.LOOSELY_INFERRED;
    }

    protected Expression getCurrentExpression() {
        return this.currentExpression;
    }

    protected Variable getDeclaredVariable(String name, VariableScope scope) {
        Variable var = null;
        VariableScope.VariableInfo info = scope.lookupName(name);
        if (info != null) {
            org.codehaus.groovy.ast.VariableScope groovyScope = null;
            if (info.scopeNode instanceof MethodNode) {
                groovyScope = ((MethodNode)info.scopeNode).getVariableScope();
            } else if (info.scopeNode instanceof ForStatement) {
                groovyScope = ((ForStatement)info.scopeNode).getVariableScope();
            } else if (info.scopeNode instanceof BlockStatement) {
                groovyScope = ((BlockStatement)info.scopeNode).getVariableScope();
            } else if (info.scopeNode instanceof ClosureExpression) {
                groovyScope = ((ClosureExpression)info.scopeNode).getVariableScope();
            } else if (info.scopeNode instanceof ClosureListExpression) {
                groovyScope = ((ClosureListExpression)info.scopeNode).getVariableScope();
            }
            while (groovyScope != null && (var = groovyScope.getDeclaredVariable(name)) == null) {
                groovyScope = groovyScope.getParent();
            }
        }
        return var;
    }

    protected boolean isQuotedString() {
        return this.currentExpression instanceof GStringExpression || this.currentExpression instanceof ConstantExpression && (this.currentExpression.getEnd() < 1 || this.currentExpression.getLength() != this.currentExpression.getText().length());
    }

    protected boolean isStatic() {
        return this.isStatic;
    }

    @Override
    public final TypeLookupResult lookupType(Expression expression, VariableScope scope, ClassNode objectExpressionType, boolean isStaticObjectExpression) {
        if (expression instanceof VariableExpression || expression instanceof ConstantExpression && (expression.getEnd() < 1 || expression.getLength() == expression.getText().length())) {
            ClassNode declaringType;
            String name = expression.getText();
            Variable variable = this.getDeclaredVariable(name, scope);
            if (variable != null && !variable.isDynamicTyped()) {
                return null;
            }
            if (objectExpressionType != null) {
                declaringType = objectExpressionType;
                if (isStaticObjectExpression && objectExpressionType.isUsingGenerics() && objectExpressionType.equals(VariableScope.CLASS_CLASS_NODE)) {
                    declaringType = objectExpressionType.getGenericsTypes()[0].getType();
                }
            } else {
                declaringType = scope.getDelegateOrThis();
                if (declaringType == null && (declaringType = scope.getEnclosingTypeDeclaration()) == null) {
                    declaringType = VariableScope.OBJECT_CLASS_NODE;
                }
            }
            try {
                this.currentExpression = expression;
                this.isStatic = isStaticObjectExpression;
                TypeAndDeclaration result = this.lookupTypeAndDeclaration(declaringType, name, scope);
                if (result != null) {
                    TypeLookupResult.TypeConfidence confidence = this.checkConfidence(expression, result.confidence, result.declaration, result.extraDoc);
                    TypeLookupResult typeLookupResult = new TypeLookupResult(result.type, result.declaringType == null ? declaringType : result.declaringType, result.declaration, confidence, scope, result.extraDoc);
                    return typeLookupResult;
                }
            }
            finally {
                this.currentExpression = null;
                this.isStatic = null;
            }
        }
        return null;
    }

    @Override
    public final TypeLookupResult lookupType(FieldNode node, VariableScope scope) {
        return null;
    }

    @Override
    public final TypeLookupResult lookupType(MethodNode node, VariableScope scope) {
        return null;
    }

    @Override
    public final TypeLookupResult lookupType(AnnotationNode node, VariableScope scope) {
        return null;
    }

    @Override
    public final TypeLookupResult lookupType(ImportNode node, VariableScope scope) {
        return null;
    }

    @Override
    public final TypeLookupResult lookupType(ClassNode node, VariableScope scope) {
        return null;
    }

    @Override
    public final TypeLookupResult lookupType(Parameter node, VariableScope scope) {
        return null;
    }

    protected abstract TypeAndDeclaration lookupTypeAndDeclaration(ClassNode var1, String var2, VariableScope var3);

    public static class TypeAndDeclaration {
        protected final ClassNode type;
        protected final ClassNode declaringType;
        protected final ASTNode declaration;
        protected final String extraDoc;
        protected final TypeLookupResult.TypeConfidence confidence;

        public TypeAndDeclaration(ClassNode type, ASTNode declaration) {
            this.type = type;
            this.declaration = declaration;
            this.declaringType = null;
            this.extraDoc = null;
            this.confidence = null;
        }

        public TypeAndDeclaration(ClassNode type, ASTNode declaration, ClassNode declaringType) {
            this.type = type;
            this.declaration = declaration;
            this.declaringType = declaringType;
            this.extraDoc = null;
            this.confidence = null;
        }

        public TypeAndDeclaration(ClassNode type, ASTNode declaration, ClassNode declaringType, String extraDoc) {
            this.type = type;
            this.declaration = declaration;
            this.declaringType = declaringType;
            this.extraDoc = extraDoc;
            this.confidence = null;
        }

        public TypeAndDeclaration(ClassNode type, ASTNode declaration, ClassNode declaringType, String extraDoc, TypeLookupResult.TypeConfidence confidence) {
            this.type = type;
            this.declaration = declaration;
            this.declaringType = declaringType;
            this.extraDoc = extraDoc;
            this.confidence = confidence;
        }
    }
}

