/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jdt.groovy.internal.compiler.ast;

import groovy.lang.GroovyClassLoader;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.jdt.groovy.control.EclipseSourceUnit;
import org.codehaus.jdt.groovy.integration.internal.GroovyLanguageSupport;
import org.codehaus.jdt.groovy.internal.compiler.GroovyClassLoaderFactory;
import org.codehaus.jdt.groovy.internal.compiler.ast.Grails20TestSupport;
import org.codehaus.jdt.groovy.internal.compiler.ast.GrailsGlobalPluginAwareEntityInjector;
import org.codehaus.jdt.groovy.internal.compiler.ast.GrailsInjector;
import org.codehaus.jdt.groovy.internal.compiler.ast.GroovyCompilationUnitDeclaration;
import org.codehaus.jdt.groovy.internal.compiler.ast.GroovyErrorCollectorForJDT;
import org.codehaus.jdt.groovy.internal.compiler.ast.GroovyTypeDeclaration;
import org.codehaus.jdt.groovy.internal.compiler.ast.IGroovyDebugRequestor;
import org.codehaus.jdt.groovy.internal.compiler.ast.JDTResolver;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.groovy.core.util.GroovyUtils;
import org.eclipse.jdt.groovy.core.util.ReflectionUtils;
import org.eclipse.jdt.groovy.core.util.ScriptFolderSelector;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.Compiler;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.batch.BatchCompilerRequestor;
import org.eclipse.jdt.internal.compiler.batch.Main;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.ReferenceContext;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilationUnit;
import org.eclipse.jdt.internal.compiler.problem.AbortMethod;
import org.eclipse.jdt.internal.compiler.problem.AbortType;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.jdt.internal.core.builder.AbstractImageBuilder;
import org.eclipse.jdt.internal.core.builder.BuildNotifier;
import org.eclipse.jdt.internal.core.builder.SourceFile;

public class GroovyParser {
    public Object requestor;
    private JDTResolver resolver;
    public final ProblemReporter problemReporter;
    public static IGroovyDebugRequestor debugRequestor;
    private final Supplier<CompilationUnit> unitFactory;
    private CompilationUnit compilationUnit;
    private CompilerOptions compilerOptions;
    private static Map<String, ScriptFolderSelector> scriptFolderSelectorCache;

    static {
        scriptFolderSelectorCache = new ConcurrentHashMap<String, ScriptFolderSelector>();
    }

    public CompilerOptions getCompilerOptions() {
        return this.compilerOptions;
    }

    public static void clearCache(String projectName) {
        scriptFolderSelectorCache.remove(projectName);
        GroovyClassLoaderFactory.clearCache(projectName);
    }

    public GroovyParser(CompilerOptions compilerOptions, ProblemReporter problemReporter, boolean allowTransforms, boolean isReconcile) {
        this(null, compilerOptions, problemReporter, allowTransforms, isReconcile);
    }

    public GroovyParser(Object requestor, CompilerOptions compilerOptions, ProblemReporter problemReporter, boolean allowTransforms, boolean isReconcile) {
        this.requestor = requestor;
        this.compilerOptions = compilerOptions;
        this.problemReporter = problemReporter;
        GroovyClassLoaderFactory loaderFactory = new GroovyClassLoaderFactory(compilerOptions, requestor);
        this.unitFactory = () -> {
            CompilerConfiguration compilerConfiguration = GroovyLanguageSupport.newCompilerConfiguration(compilerOptions, problemReporter);
            GroovyClassLoader[] classLoaders = loaderFactory.getGroovyClassLoaders(compilerConfiguration);
            CompilationUnit unit = new CompilationUnit(compilerConfiguration, null, classLoaders[0], classLoaders[1], allowTransforms, compilerOptions.groovyExcludeGlobalASTScan);
            this.resolver = new JDTResolver(unit);
            unit.removeOutputPhaseOperation();
            unit.setResolveVisitor(this.resolver);
            unit.tweak(isReconcile);
            if (allowTransforms && (compilerOptions.groovyFlags & 1) != 0) {
                unit.addPhaseOperation(new GrailsInjector(classLoaders[1]), 5);
                new Grails20TestSupport(compilerOptions, classLoaders[1]).addGrailsTestCompilerCustomizers(unit);
                unit.addPhaseOperation(new GrailsGlobalPluginAwareEntityInjector(classLoaders[1]), 5);
            }
            return unit;
        };
    }

    public void reset() {
        this.compilationUnit = null;
        this.resolver = null;
    }

    public CompilationUnitDeclaration dietParse(ICompilationUnit iCompilationUnit, CompilationResult compilationResult) {
        boolean isScript;
        IFile eclipseFile;
        String fileName = String.valueOf(iCompilationUnit.getFileName());
        Path filePath = new Path(fileName);
        if (filePath.segmentCount() > 1 && ResourcesPlugin.getPlugin() != null) {
            eclipseFile = ResourcesPlugin.getWorkspace().getRoot().getFile(filePath);
            IPath location = eclipseFile.getLocation();
            if (location != null) {
                fileName = location.toFile().getAbsolutePath();
            }
            isScript = GroovyParser.isScript(eclipseFile, this.compilerOptions.groovyProjectName);
        } else {
            eclipseFile = null;
            isScript = false;
        }
        if (this.problemReporter.referenceContext == null) {
            this.problemReporter.referenceContext = new ReferenceContextImpl(compilationResult);
        }
        if (this.compilationUnit == null) {
            if (isScript || eclipseFile != null && eclipseFile.getProject().isAccessible() && !JavaCore.create(eclipseFile.getProject()).isOnClasspath(eclipseFile)) {
                this.compilerOptions.groovyCompilerConfigScript = null;
            }
            this.compilationUnit = this.unitFactory.get();
        }
        char[] sourceCode = Optional.ofNullable(iCompilationUnit.getContents()).orElse(CharOperation.NO_CHAR);
        EclipseSourceUnit sourceUnit = new EclipseSourceUnit(eclipseFile, fileName, String.valueOf(sourceCode), this.compilationUnit.isReconcile, this.compilationUnit.getConfiguration(), this.compilationUnit.getClassLoader(), new GroovyErrorCollectorForJDT(this.compilationUnit.getConfiguration()), this.resolver);
        this.compilationUnit.addSource(sourceUnit);
        if (this.requestor instanceof Compiler) {
            Main main;
            Compiler compiler = (Compiler)this.requestor;
            if (compiler.requestor instanceof AbstractImageBuilder) {
                SourceFile sourceFile;
                AbstractImageBuilder builder = (AbstractImageBuilder)compiler.requestor;
                if (builder.notifier != null) {
                    this.compilationUnit.setProgressListener(new ProgressListenerImpl(builder.notifier));
                }
                if (eclipseFile != null && (sourceFile = (SourceFile)builder.fromIFile(eclipseFile)) != null) {
                    this.compilationUnit.getConfiguration().setTargetDirectory(sourceFile.getOutputLocation().toFile());
                }
            } else if (compiler.requestor instanceof BatchCompilerRequestor && (main = (Main)ReflectionUtils.getPrivateField(BatchCompilerRequestor.class, "compiler", compiler.requestor)) != null && main.destinationPath != null && main.destinationPath != "none") {
                this.compilationUnit.getConfiguration().setTargetDirectory(main.destinationPath);
            }
        }
        compilationResult.lineSeparatorPositions = GroovyUtils.getSourceLineSeparatorsIn(sourceCode);
        GroovyCompilationUnitDeclaration gcuDeclaration = new GroovyCompilationUnitDeclaration(this.problemReporter, compilationResult, sourceCode.length, this.compilationUnit, sourceUnit, this.compilerOptions);
        gcuDeclaration.processToPhase(3);
        if (gcuDeclaration.getModuleNode() != null) {
            gcuDeclaration.populateCompilationUnitDeclaration();
            TypeDeclaration[] typeDeclarationArray = gcuDeclaration.types;
            int n = gcuDeclaration.types.length;
            int n2 = 0;
            while (n2 < n) {
                TypeDeclaration decl = typeDeclarationArray[n2];
                this.resolver.record((GroovyTypeDeclaration)decl);
                ++n2;
            }
        }
        if (isScript) {
            gcuDeclaration.tagAsScript();
        }
        if (debugRequestor != null) {
            debugRequestor.acceptCompilationUnitDeclaration(gcuDeclaration);
        }
        return gcuDeclaration;
    }

    private static boolean isScript(IFile sourceFile, String projectName) {
        if (projectName != null) {
            assert (projectName == sourceFile.getProject().getName());
            ScriptFolderSelector scriptFolderSelector = scriptFolderSelectorCache.computeIfAbsent(projectName, key -> new ScriptFolderSelector(sourceFile.getProject()));
            return scriptFolderSelector.isScript(sourceFile);
        }
        return false;
    }

    private static class ProgressListenerImpl
    implements CompilationUnit.ProgressListener {
        private BuildNotifier notifier;

        ProgressListenerImpl(BuildNotifier notifier) {
            this.notifier = notifier;
        }

        @Override
        public void parseComplete(int phase, String sourceUnitName) {
            try {
                int lastSlash = sourceUnitName.lastIndexOf("/");
                if (lastSlash == -1) {
                    lastSlash = sourceUnitName.lastIndexOf("\\");
                }
                if (lastSlash != -1) {
                    StringBuffer msg = new StringBuffer();
                    msg.append("Parsing groovy source in ");
                    msg.append(sourceUnitName, 0, lastSlash);
                    this.notifier.subTask(msg.toString());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.notifier.checkCancel();
        }

        @Override
        public void generateComplete(int phase, ClassNode classNode) {
            try {
                String pkgName = classNode.getPackageName();
                if (pkgName != null && pkgName.length() > 0) {
                    StringBuffer msg = new StringBuffer();
                    msg.append("Generating groovy classes in ");
                    msg.append(pkgName);
                    this.notifier.subTask(msg.toString());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.notifier.checkCancel();
        }
    }

    private static class ReferenceContextImpl
    implements ReferenceContext {
        private boolean hasErrors;
        private final CompilationResult compilationResult;

        ReferenceContextImpl(CompilationResult compilationResult) {
            this.compilationResult = compilationResult;
        }

        @Override
        public boolean hasErrors() {
            return this.hasErrors;
        }

        @Override
        public void tagAsHavingErrors() {
            this.hasErrors = true;
        }

        @Override
        public void tagAsHavingIgnoredMandatoryErrors(int problemId) {
        }

        @Override
        public CompilationResult compilationResult() {
            return this.compilationResult;
        }

        @Override
        public CompilationUnitDeclaration getCompilationUnitDeclaration() {
            return null;
        }

        @Override
        public void abort(int abortLevel, CategorizedProblem problem) {
            switch (abortLevel) {
                case 8: {
                    throw new AbortType(this.compilationResult, problem);
                }
                case 16: {
                    throw new AbortMethod(this.compilationResult, problem);
                }
            }
            throw new AbortCompilationUnit(this.compilationResult, problem);
        }
    }
}

