/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jdt.groovy.internal.compiler.ast;

import groovy.lang.GroovyClassLoader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.classgen.GeneratorContext;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.SourceUnit;

public class GrailsInjector
extends CompilationUnit.PrimaryClassNodeOperation {
    private GroovyClassLoader groovyClassLoader;
    private boolean broken;
    private Class<?> injectorClazz;
    private Object injectorInstance;
    private Method injectorMethod;

    public GrailsInjector(GroovyClassLoader groovyClassLoader) {
        this.groovyClassLoader = groovyClassLoader;
    }

    @Override
    public void call(SourceUnit sourceUnit, GeneratorContext context, ClassNode classNode) throws CompilationFailedException {
        if (this.broken) {
            return;
        }
        if (this.injectorClazz == null) {
            try {
                this.injectorClazz = this.groovyClassLoader.loadClass("org.codehaus.groovy.grails.compiler.injection.DefaultGrailsDomainClassInjector");
                this.injectorInstance = this.injectorClazz.newInstance();
            }
            catch (Throwable t) {
                this.broken = true;
                System.err.println("GrailsInjector: Unable to load and create 'org.codehaus.groovy.grails.compiler.injection.DefaultGrailsDomainClassInjector'");
                t.printStackTrace();
                return;
            }
            try {
                this.injectorMethod = this.injectorClazz.getDeclaredMethod("performInjection", SourceUnit.class, GeneratorContext.class, ClassNode.class);
            }
            catch (SecurityException se) {
                this.broken = true;
                System.err.println("GrailsInjector: Cannot find correct performInjection method on 'org.codehaus.groovy.grails.compiler.injection.DefaultGrailsDomainClassInjector'");
                se.printStackTrace();
                return;
            }
            catch (NoSuchMethodException nsme) {
                this.broken = true;
                System.err.println("GrailsInjector: Cannot find correct performInjection method on 'org.codehaus.groovy.grails.compiler.injection.DefaultGrailsDomainClassInjector'");
                nsme.printStackTrace();
                return;
            }
            if (this.injectorMethod == null) {
                this.broken = true;
                return;
            }
        }
        try {
            if (sourceUnit.getName().indexOf("grails-app/domain/") != -1) {
                this.injectorMethod.invoke(this.injectorInstance, sourceUnit, context, classNode);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            System.err.println("GrailsInjector: Problem invoking performInjection");
            e.printStackTrace();
        }
    }
}

