/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.LambdaExpression;
import org.eclipse.jdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationHolder;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.ImplicitNullAnnotationVerifier;
import org.eclipse.jdt.internal.compiler.lookup.LazilyResolvedMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.MethodVerifier;
import org.eclipse.jdt.internal.compiler.lookup.NestedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SyntheticFieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.SyntheticMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.UnresolvedReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.WildcardBinding;
import org.eclipse.jdt.internal.compiler.util.SimpleLookupTable;
import org.eclipse.jdt.internal.compiler.util.Util;

public class SourceTypeBinding
extends ReferenceBinding {
    public ReferenceBinding superclass;
    public ReferenceBinding[] superInterfaces;
    private FieldBinding[] fields;
    private MethodBinding[] methods;
    public ReferenceBinding[] memberTypes;
    public TypeVariableBinding[] typeVariables;
    public ClassScope scope;
    protected SourceTypeBinding prototype;
    LookupEnvironment environment;
    private static final int METHOD_EMUL = 0;
    private static final int FIELD_EMUL = 1;
    private static final int CLASS_LITERAL_EMUL = 2;
    private static final int MAX_SYNTHETICS = 3;
    HashMap[] synthetics;
    char[] genericReferenceTypeSignature;
    private SimpleLookupTable storedAnnotations = null;
    public int defaultNullness;
    private int nullnessDefaultInitialized = 0;
    private int lambdaOrdinal = 0;
    private ReferenceBinding containerAnnotationType = null;

    public SourceTypeBinding(char[][] compoundName, PackageBinding fPackage, ClassScope scope) {
        this.compoundName = compoundName;
        this.fPackage = fPackage;
        this.fileName = scope.referenceCompilationUnit().getFileName();
        this.modifiers = scope.referenceContext.modifiers;
        this.sourceName = scope.referenceContext.name;
        this.scope = scope;
        this.environment = scope.environment();
        this.fields = Binding.UNINITIALIZED_FIELDS;
        this.methods = Binding.UNINITIALIZED_METHODS;
        this.prototype = this;
        this.computeId();
    }

    public SourceTypeBinding(SourceTypeBinding prototype) {
        super(prototype);
        this.prototype = prototype.prototype;
        this.prototype.tagBits |= 0x800000L;
        this.tagBits &= 0xFFFFFFFFFF7FFFFFL;
        this.superclass = prototype.superclass;
        this.superInterfaces = prototype.superInterfaces;
        this.fields = prototype.fields;
        this.methods = prototype.methods;
        this.memberTypes = prototype.memberTypes;
        this.typeVariables = prototype.typeVariables;
        this.environment = prototype.environment;
        this.synthetics = prototype.synthetics;
        this.genericReferenceTypeSignature = prototype.genericReferenceTypeSignature;
        this.storedAnnotations = prototype.storedAnnotations;
        this.defaultNullness = prototype.defaultNullness;
        this.nullnessDefaultInitialized = prototype.nullnessDefaultInitialized;
        this.lambdaOrdinal = prototype.lambdaOrdinal;
        this.containerAnnotationType = prototype.containerAnnotationType;
        this.tagBits |= 0x10000000L;
    }

    private void addDefaultAbstractMethods() {
        if (!this.isPrototype()) {
            throw new IllegalStateException();
        }
        if ((this.tagBits & 0x400L) != 0L) {
            return;
        }
        this.tagBits |= 0x400L;
        if (this.isClass() && this.isAbstract()) {
            if (this.scope.compilerOptions().targetJDK >= 0x2E0000L) {
                return;
            }
            ReferenceBinding[] itsInterfaces = this.superInterfaces();
            if (itsInterfaces != Binding.NO_SUPERINTERFACES) {
                MethodBinding[] defaultAbstracts = null;
                int defaultAbstractsCount = 0;
                ReferenceBinding[] interfacesToVisit = itsInterfaces;
                int nextPosition = interfacesToVisit.length;
                int i = 0;
                while (i < nextPosition) {
                    ReferenceBinding superType = interfacesToVisit[i];
                    if (superType.isValidBinding()) {
                        MethodBinding[] superMethods = superType.methods();
                        int m = superMethods.length;
                        block1: while (--m >= 0) {
                            MethodBinding method = superMethods[m];
                            if (this.implementsMethod(method)) continue;
                            if (defaultAbstractsCount == 0) {
                                defaultAbstracts = new MethodBinding[5];
                            } else {
                                int k = 0;
                                while (k < defaultAbstractsCount) {
                                    MethodBinding alreadyAdded = defaultAbstracts[k];
                                    if (CharOperation.equals(alreadyAdded.selector, method.selector) && alreadyAdded.areParametersEqual(method)) continue block1;
                                    ++k;
                                }
                            }
                            MethodBinding defaultAbstract = new MethodBinding(method.modifiers | 0x80000 | 0x1000, method.selector, method.returnType, method.parameters, method.thrownExceptions, this);
                            if (defaultAbstractsCount == defaultAbstracts.length) {
                                MethodBinding[] methodBindingArray = defaultAbstracts;
                                defaultAbstracts = new MethodBinding[2 * defaultAbstractsCount];
                                System.arraycopy(methodBindingArray, 0, defaultAbstracts, 0, defaultAbstractsCount);
                            }
                            defaultAbstracts[defaultAbstractsCount++] = defaultAbstract;
                        }
                        itsInterfaces = superType.superInterfaces();
                        if (itsInterfaces != Binding.NO_SUPERINTERFACES) {
                            int itsLength = itsInterfaces.length;
                            if (nextPosition + itsLength >= interfacesToVisit.length) {
                                ReferenceBinding[] referenceBindingArray = interfacesToVisit;
                                interfacesToVisit = new ReferenceBinding[nextPosition + itsLength + 5];
                                System.arraycopy(referenceBindingArray, 0, interfacesToVisit, 0, nextPosition);
                            }
                            int a = 0;
                            while (a < itsLength) {
                                block19: {
                                    ReferenceBinding next = itsInterfaces[a];
                                    int b = 0;
                                    while (b < nextPosition) {
                                        if (!TypeBinding.equalsEquals(next, interfacesToVisit[b])) {
                                            ++b;
                                            continue;
                                        }
                                        break block19;
                                    }
                                    interfacesToVisit[nextPosition++] = next;
                                }
                                ++a;
                            }
                        }
                    }
                    ++i;
                }
                if (defaultAbstractsCount > 0) {
                    int length = this.methods.length;
                    System.arraycopy(this.methods, 0, this.setMethods(new MethodBinding[length + defaultAbstractsCount]), 0, length);
                    System.arraycopy(defaultAbstracts, 0, this.methods, length, defaultAbstractsCount);
                    if ((length += defaultAbstractsCount) > 1) {
                        ReferenceBinding.sortMethods(this.methods, 0, length);
                    }
                }
            }
        }
    }

    public FieldBinding addSyntheticFieldForInnerclass(LocalVariableBinding actualOuterLocalVariable) {
        boolean needRecheck;
        FieldBinding synthField;
        if (!this.isPrototype()) {
            throw new IllegalStateException();
        }
        if (this.synthetics == null) {
            this.synthetics = new HashMap[3];
        }
        if (this.synthetics[1] == null) {
            this.synthetics[1] = new HashMap(5);
        }
        if ((synthField = (FieldBinding)this.synthetics[1].get(actualOuterLocalVariable)) == null) {
            synthField = new SyntheticFieldBinding(CharOperation.concat(TypeConstants.SYNTHETIC_OUTER_LOCAL_PREFIX, actualOuterLocalVariable.name), actualOuterLocalVariable.type, 4114, this, Constant.NotAConstant, this.synthetics[1].size());
            this.synthetics[1].put(actualOuterLocalVariable, synthField);
        }
        int index = 1;
        block0: do {
            needRecheck = false;
            FieldBinding existingField = this.getField(synthField.name, true);
            if (existingField == null) continue;
            TypeDeclaration typeDecl = this.scope.referenceContext;
            FieldDeclaration[] fieldDeclarations = typeDecl.fields;
            int max = fieldDeclarations == null ? 0 : fieldDeclarations.length;
            int i = 0;
            while (i < max) {
                FieldDeclaration fieldDecl = fieldDeclarations[i];
                if (fieldDecl.binding == existingField) {
                    synthField.name = CharOperation.concat(TypeConstants.SYNTHETIC_OUTER_LOCAL_PREFIX, actualOuterLocalVariable.name, ("$" + String.valueOf(index++)).toCharArray());
                    needRecheck = true;
                    continue block0;
                }
                ++i;
            }
        } while (needRecheck);
        return synthField;
    }

    public FieldBinding addSyntheticFieldForInnerclass(ReferenceBinding enclosingType) {
        boolean needRecheck;
        FieldBinding synthField;
        if (!this.isPrototype()) {
            throw new IllegalStateException();
        }
        if (this.synthetics == null) {
            this.synthetics = new HashMap[3];
        }
        if (this.synthetics[1] == null) {
            this.synthetics[1] = new HashMap(5);
        }
        if ((synthField = (FieldBinding)this.synthetics[1].get(enclosingType)) == null) {
            synthField = new SyntheticFieldBinding(CharOperation.concat(TypeConstants.SYNTHETIC_ENCLOSING_INSTANCE_PREFIX, String.valueOf(enclosingType.depth()).toCharArray()), enclosingType, 4112, this, Constant.NotAConstant, this.synthetics[1].size());
            this.synthetics[1].put(enclosingType, synthField);
        }
        block0: do {
            needRecheck = false;
            FieldBinding existingField = this.getField(synthField.name, true);
            if (existingField == null) continue;
            TypeDeclaration typeDecl = this.scope.referenceContext;
            FieldDeclaration[] fieldDeclarations = typeDecl.fields;
            int max = fieldDeclarations == null ? 0 : fieldDeclarations.length;
            int i = 0;
            while (i < max) {
                FieldDeclaration fieldDecl = fieldDeclarations[i];
                if (fieldDecl.binding == existingField) {
                    if (this.scope.compilerOptions().complianceLevel >= 0x310000L) {
                        synthField.name = CharOperation.concat(synthField.name, "$".toCharArray());
                        needRecheck = true;
                        continue block0;
                    }
                    this.scope.problemReporter().duplicateFieldInType(this, fieldDecl);
                    continue block0;
                }
                ++i;
            }
        } while (needRecheck);
        return synthField;
    }

    public FieldBinding addSyntheticFieldForClassLiteral(TypeBinding targetType, BlockScope blockScope) {
        FieldBinding existingField;
        FieldBinding synthField;
        if (!this.isPrototype()) {
            throw new IllegalStateException();
        }
        if (this.synthetics == null) {
            this.synthetics = new HashMap[3];
        }
        if (this.synthetics[2] == null) {
            this.synthetics[2] = new HashMap(5);
        }
        if ((synthField = (FieldBinding)this.synthetics[2].get(targetType)) == null) {
            synthField = new SyntheticFieldBinding(CharOperation.concat(TypeConstants.SYNTHETIC_CLASS, String.valueOf(this.synthetics[2].size()).toCharArray()), blockScope.getJavaLangClass(), 4104, this, Constant.NotAConstant, this.synthetics[2].size());
            this.synthetics[2].put(targetType, synthField);
        }
        if ((existingField = this.getField(synthField.name, true)) != null) {
            TypeDeclaration typeDecl = blockScope.referenceType();
            FieldDeclaration[] typeDeclarationFields = typeDecl.fields;
            int max = typeDeclarationFields == null ? 0 : typeDeclarationFields.length;
            int i = 0;
            while (i < max) {
                FieldDeclaration fieldDecl = typeDeclarationFields[i];
                if (fieldDecl.binding == existingField) {
                    blockScope.problemReporter().duplicateFieldInType(this, fieldDecl);
                    break;
                }
                ++i;
            }
        }
        return synthField;
    }

    public FieldBinding addSyntheticFieldForAssert(BlockScope blockScope) {
        boolean needRecheck;
        FieldBinding synthField;
        if (!this.isPrototype()) {
            throw new IllegalStateException();
        }
        if (this.synthetics == null) {
            this.synthetics = new HashMap[3];
        }
        if (this.synthetics[1] == null) {
            this.synthetics[1] = new HashMap(5);
        }
        if ((synthField = (FieldBinding)this.synthetics[1].get("assertionEmulation")) == null) {
            synthField = new SyntheticFieldBinding(TypeConstants.SYNTHETIC_ASSERT_DISABLED, TypeBinding.BOOLEAN, (this.isInterface() ? 1 : 0) | 8 | 0x1000 | 0x10, this, Constant.NotAConstant, this.synthetics[1].size());
            this.synthetics[1].put("assertionEmulation", synthField);
        }
        int index = 0;
        block0: do {
            needRecheck = false;
            FieldBinding existingField = this.getField(synthField.name, true);
            if (existingField == null) continue;
            TypeDeclaration typeDecl = this.scope.referenceContext;
            int max = typeDecl.fields == null ? 0 : typeDecl.fields.length;
            int i = 0;
            while (i < max) {
                FieldDeclaration fieldDecl = typeDecl.fields[i];
                if (fieldDecl.binding == existingField) {
                    synthField.name = CharOperation.concat(TypeConstants.SYNTHETIC_ASSERT_DISABLED, ("_" + String.valueOf(index++)).toCharArray());
                    needRecheck = true;
                    continue block0;
                }
                ++i;
            }
        } while (needRecheck);
        return synthField;
    }

    public FieldBinding addSyntheticFieldForEnumValues() {
        boolean needRecheck;
        FieldBinding synthField;
        if (!this.isPrototype()) {
            throw new IllegalStateException();
        }
        if (this.synthetics == null) {
            this.synthetics = new HashMap[3];
        }
        if (this.synthetics[1] == null) {
            this.synthetics[1] = new HashMap(5);
        }
        if ((synthField = (FieldBinding)this.synthetics[1].get("enumConstantValues")) == null) {
            synthField = new SyntheticFieldBinding(TypeConstants.SYNTHETIC_ENUM_VALUES, this.scope.createArrayType(this, 1), 4122, this, Constant.NotAConstant, this.synthetics[1].size());
            this.synthetics[1].put("enumConstantValues", synthField);
        }
        int index = 0;
        block0: do {
            needRecheck = false;
            FieldBinding existingField = this.getField(synthField.name, true);
            if (existingField == null) continue;
            TypeDeclaration typeDecl = this.scope.referenceContext;
            FieldDeclaration[] fieldDeclarations = typeDecl.fields;
            int max = fieldDeclarations == null ? 0 : fieldDeclarations.length;
            int i = 0;
            while (i < max) {
                FieldDeclaration fieldDecl = fieldDeclarations[i];
                if (fieldDecl.binding == existingField) {
                    synthField.name = CharOperation.concat(TypeConstants.SYNTHETIC_ENUM_VALUES, ("_" + String.valueOf(index++)).toCharArray());
                    needRecheck = true;
                    continue block0;
                }
                ++i;
            }
        } while (needRecheck);
        return synthField;
    }

    public SyntheticMethodBinding addSyntheticMethod(FieldBinding targetField, boolean isReadAccess, boolean isSuperAccess) {
        if (!this.isPrototype()) {
            throw new IllegalStateException();
        }
        if (this.synthetics == null) {
            this.synthetics = new HashMap[3];
        }
        if (this.synthetics[0] == null) {
            this.synthetics[0] = new HashMap(5);
        }
        SyntheticMethodBinding accessMethod = null;
        SyntheticMethodBinding[] accessors = (SyntheticMethodBinding[])this.synthetics[0].get(targetField);
        if (accessors == null) {
            accessMethod = new SyntheticMethodBinding(targetField, isReadAccess, isSuperAccess, (ReferenceBinding)this);
            accessors = new SyntheticMethodBinding[2];
            this.synthetics[0].put(targetField, accessors);
            accessors[isReadAccess ? 0 : 1] = accessMethod;
        } else {
            accessMethod = accessors[isReadAccess ? 0 : 1];
            if (accessMethod == null) {
                accessMethod = new SyntheticMethodBinding(targetField, isReadAccess, isSuperAccess, (ReferenceBinding)this);
                accessors[isReadAccess ? 0 : 1] = accessMethod;
            }
        }
        return accessMethod;
    }

    public SyntheticMethodBinding addSyntheticEnumMethod(char[] selector) {
        if (!this.isPrototype()) {
            throw new IllegalStateException();
        }
        if (this.synthetics == null) {
            this.synthetics = new HashMap[3];
        }
        if (this.synthetics[0] == null) {
            this.synthetics[0] = new HashMap(5);
        }
        SyntheticMethodBinding accessMethod = null;
        SyntheticMethodBinding[] accessors = (SyntheticMethodBinding[])this.synthetics[0].get(selector);
        if (accessors == null) {
            accessMethod = new SyntheticMethodBinding(this, selector);
            accessors = new SyntheticMethodBinding[2];
            this.synthetics[0].put(selector, accessors);
            accessors[0] = accessMethod;
        } else {
            accessMethod = accessors[0];
            if (accessMethod == null) {
                accessors[0] = accessMethod = new SyntheticMethodBinding(this, selector);
            }
        }
        return accessMethod;
    }

    public SyntheticFieldBinding addSyntheticFieldForSwitchEnum(char[] fieldName, String key) {
        boolean needRecheck;
        SyntheticFieldBinding synthField;
        if (!this.isPrototype()) {
            throw new IllegalStateException();
        }
        if (this.synthetics == null) {
            this.synthetics = new HashMap[3];
        }
        if (this.synthetics[1] == null) {
            this.synthetics[1] = new HashMap(5);
        }
        if ((synthField = (SyntheticFieldBinding)this.synthetics[1].get(key)) == null) {
            synthField = new SyntheticFieldBinding(fieldName, this.scope.createArrayType(TypeBinding.INT, 1), (this.isInterface() ? 17 : 2) | 8 | 0x1000, this, Constant.NotAConstant, this.synthetics[1].size());
            this.synthetics[1].put(key, synthField);
        }
        int index = 0;
        block0: do {
            needRecheck = false;
            FieldBinding existingField = this.getField(synthField.name, true);
            if (existingField == null) continue;
            TypeDeclaration typeDecl = this.scope.referenceContext;
            FieldDeclaration[] fieldDeclarations = typeDecl.fields;
            int max = fieldDeclarations == null ? 0 : fieldDeclarations.length;
            int i = 0;
            while (i < max) {
                FieldDeclaration fieldDecl = fieldDeclarations[i];
                if (fieldDecl.binding == existingField) {
                    synthField.name = CharOperation.concat(fieldName, ("_" + String.valueOf(index++)).toCharArray());
                    needRecheck = true;
                    continue block0;
                }
                ++i;
            }
        } while (needRecheck);
        return synthField;
    }

    public SyntheticMethodBinding addSyntheticMethodForSwitchEnum(TypeBinding enumBinding) {
        if (!this.isPrototype()) {
            throw new IllegalStateException();
        }
        if (this.synthetics == null) {
            this.synthetics = new HashMap[3];
        }
        if (this.synthetics[0] == null) {
            this.synthetics[0] = new HashMap(5);
        }
        SyntheticMethodBinding accessMethod = null;
        char[] selector = CharOperation.concat(TypeConstants.SYNTHETIC_SWITCH_ENUM_TABLE, enumBinding.constantPoolName());
        CharOperation.replace(selector, '/', '$');
        String key = new String(selector);
        SyntheticMethodBinding[] accessors = (SyntheticMethodBinding[])this.synthetics[0].get(key);
        if (accessors == null) {
            SyntheticFieldBinding fieldBinding = this.addSyntheticFieldForSwitchEnum(selector, key);
            accessMethod = new SyntheticMethodBinding((FieldBinding)fieldBinding, this, enumBinding, selector);
            accessors = new SyntheticMethodBinding[2];
            this.synthetics[0].put(key, accessors);
            accessors[0] = accessMethod;
        } else {
            accessMethod = accessors[0];
            if (accessMethod == null) {
                SyntheticFieldBinding fieldBinding = this.addSyntheticFieldForSwitchEnum(selector, key);
                accessors[0] = accessMethod = new SyntheticMethodBinding((FieldBinding)fieldBinding, this, enumBinding, selector);
            }
        }
        return accessMethod;
    }

    public SyntheticMethodBinding addSyntheticMethodForEnumInitialization(int begin, int end) {
        if (!this.isPrototype()) {
            throw new IllegalStateException();
        }
        if (this.synthetics == null) {
            this.synthetics = new HashMap[3];
        }
        if (this.synthetics[0] == null) {
            this.synthetics[0] = new HashMap(5);
        }
        SyntheticMethodBinding accessMethod = new SyntheticMethodBinding(this, begin, end);
        SyntheticMethodBinding[] accessors = new SyntheticMethodBinding[2];
        this.synthetics[0].put(accessMethod.selector, accessors);
        accessors[0] = accessMethod;
        return accessMethod;
    }

    public SyntheticMethodBinding addSyntheticMethod(LambdaExpression lambda) {
        SyntheticMethodBinding[] deserializeLambdaMethods;
        if (!this.isPrototype()) {
            throw new IllegalStateException();
        }
        if (this.synthetics == null) {
            this.synthetics = new HashMap[3];
        }
        if (this.synthetics[0] == null) {
            this.synthetics[0] = new HashMap(5);
        }
        SyntheticMethodBinding lambdaMethod = null;
        SyntheticMethodBinding[] lambdaMethods = (SyntheticMethodBinding[])this.synthetics[0].get(lambda);
        if (lambdaMethods == null) {
            lambdaMethod = new SyntheticMethodBinding(lambda, CharOperation.concat(TypeConstants.ANONYMOUS_METHOD, Integer.toString(this.lambdaOrdinal++).toCharArray()), this);
            lambdaMethods = new SyntheticMethodBinding[1];
            this.synthetics[0].put(lambda, lambdaMethods);
            lambdaMethods[0] = lambdaMethod;
        } else {
            lambdaMethod = lambdaMethods[0];
        }
        if (lambda.isSerializable && (deserializeLambdaMethods = (SyntheticMethodBinding[])this.synthetics[0].get(TypeConstants.DESERIALIZE_LAMBDA)) == null) {
            SyntheticMethodBinding deserializeLambdaMethod = new SyntheticMethodBinding(this);
            deserializeLambdaMethods = new SyntheticMethodBinding[1];
            this.synthetics[0].put(TypeConstants.DESERIALIZE_LAMBDA, deserializeLambdaMethods);
            deserializeLambdaMethods[0] = deserializeLambdaMethod;
        }
        return lambdaMethod;
    }

    public SyntheticMethodBinding addSyntheticMethod(MethodBinding targetMethod, boolean isSuperAccess) {
        if (!this.isPrototype()) {
            throw new IllegalStateException();
        }
        if (this.synthetics == null) {
            this.synthetics = new HashMap[3];
        }
        if (this.synthetics[0] == null) {
            this.synthetics[0] = new HashMap(5);
        }
        SyntheticMethodBinding accessMethod = null;
        SyntheticMethodBinding[] accessors = (SyntheticMethodBinding[])this.synthetics[0].get(targetMethod);
        if (accessors == null) {
            accessMethod = new SyntheticMethodBinding(targetMethod, isSuperAccess, (ReferenceBinding)this);
            accessors = new SyntheticMethodBinding[2];
            this.synthetics[0].put(targetMethod, accessors);
            accessors[isSuperAccess ? 0 : 1] = accessMethod;
        } else {
            accessMethod = accessors[isSuperAccess ? 0 : 1];
            if (accessMethod == null) {
                accessMethod = new SyntheticMethodBinding(targetMethod, isSuperAccess, (ReferenceBinding)this);
                accessors[isSuperAccess ? 0 : 1] = accessMethod;
            }
        }
        if (targetMethod.declaringClass.isStatic()) {
            if (targetMethod.isConstructor() && targetMethod.parameters.length >= 254 || targetMethod.parameters.length >= 255) {
                this.scope.problemReporter().tooManyParametersForSyntheticMethod(targetMethod.sourceMethod());
            }
        } else if (targetMethod.isConstructor() && targetMethod.parameters.length >= 253 || targetMethod.parameters.length >= 254) {
            this.scope.problemReporter().tooManyParametersForSyntheticMethod(targetMethod.sourceMethod());
        }
        return accessMethod;
    }

    public SyntheticMethodBinding addSyntheticArrayMethod(ArrayBinding arrayType, int purpose) {
        if (!this.isPrototype()) {
            throw new IllegalStateException();
        }
        if (this.synthetics == null) {
            this.synthetics = new HashMap[3];
        }
        if (this.synthetics[0] == null) {
            this.synthetics[0] = new HashMap(5);
        }
        SyntheticMethodBinding arrayMethod = null;
        SyntheticMethodBinding[] arrayMethods = (SyntheticMethodBinding[])this.synthetics[0].get(arrayType);
        if (arrayMethods == null) {
            char[] selector = CharOperation.concat(TypeConstants.ANONYMOUS_METHOD, Integer.toString(this.lambdaOrdinal++).toCharArray());
            arrayMethod = new SyntheticMethodBinding(purpose, arrayType, selector, this);
            arrayMethods = new SyntheticMethodBinding[2];
            this.synthetics[0].put(arrayType, arrayMethods);
            arrayMethods[purpose == 14 ? 0 : 1] = arrayMethod;
        } else {
            arrayMethod = arrayMethods[purpose == 14 ? 0 : 1];
            if (arrayMethod == null) {
                char[] selector = CharOperation.concat(TypeConstants.ANONYMOUS_METHOD, Integer.toString(this.lambdaOrdinal++).toCharArray());
                arrayMethod = new SyntheticMethodBinding(purpose, arrayType, selector, this);
                arrayMethods[purpose == 14 ? 0 : 1] = arrayMethod;
            }
        }
        return arrayMethod;
    }

    public SyntheticMethodBinding addSyntheticFactoryMethod(MethodBinding privateConstructor, MethodBinding publicConstructor, TypeBinding[] enclosingInstances) {
        if (!this.isPrototype()) {
            throw new IllegalStateException();
        }
        if (this.synthetics == null) {
            this.synthetics = new HashMap[3];
        }
        if (this.synthetics[0] == null) {
            this.synthetics[0] = new HashMap(5);
        }
        char[] selector = CharOperation.concat(TypeConstants.ANONYMOUS_METHOD, Integer.toString(this.lambdaOrdinal++).toCharArray());
        SyntheticMethodBinding factory = new SyntheticMethodBinding(privateConstructor, publicConstructor, selector, enclosingInstances, this);
        this.synthetics[0].put(selector, new SyntheticMethodBinding[]{factory});
        return factory;
    }

    public SyntheticMethodBinding addSyntheticBridgeMethod(MethodBinding inheritedMethodToBridge, MethodBinding targetMethod) {
        if (!this.isPrototype()) {
            throw new IllegalStateException();
        }
        if (this.isInterface() && this.scope.compilerOptions().sourceLevel <= 0x330000L) {
            return null;
        }
        if (TypeBinding.equalsEquals(inheritedMethodToBridge.returnType.erasure(), targetMethod.returnType.erasure()) && inheritedMethodToBridge.areParameterErasuresEqual(targetMethod)) {
            return null;
        }
        if (this.synthetics == null) {
            this.synthetics = new HashMap[3];
        }
        if (this.synthetics[0] == null) {
            this.synthetics[0] = new HashMap(5);
        } else {
            for (Object synthetic : this.synthetics[0].keySet()) {
                if (!(synthetic instanceof MethodBinding)) continue;
                MethodBinding method = (MethodBinding)synthetic;
                if (!CharOperation.equals(inheritedMethodToBridge.selector, method.selector) || !TypeBinding.equalsEquals(inheritedMethodToBridge.returnType.erasure(), method.returnType.erasure()) || !inheritedMethodToBridge.areParameterErasuresEqual(method)) continue;
                return null;
            }
        }
        SyntheticMethodBinding accessMethod = null;
        SyntheticMethodBinding[] accessors = (SyntheticMethodBinding[])this.synthetics[0].get(inheritedMethodToBridge);
        if (accessors == null) {
            accessMethod = new SyntheticMethodBinding(inheritedMethodToBridge, targetMethod, this);
            accessors = new SyntheticMethodBinding[2];
            this.synthetics[0].put(inheritedMethodToBridge, accessors);
            accessors[1] = accessMethod;
        } else {
            accessMethod = accessors[1];
            if (accessMethod == null) {
                accessors[1] = accessMethod = new SyntheticMethodBinding(inheritedMethodToBridge, targetMethod, this);
            }
        }
        return accessMethod;
    }

    public SyntheticMethodBinding addSyntheticBridgeMethod(MethodBinding inheritedMethodToBridge) {
        if (!this.isPrototype()) {
            throw new IllegalStateException();
        }
        if (this.scope.compilerOptions().complianceLevel <= 0x310000L) {
            return null;
        }
        if (this.isInterface() && !inheritedMethodToBridge.isDefaultMethod()) {
            return null;
        }
        if (inheritedMethodToBridge.isAbstract() || inheritedMethodToBridge.isFinal() || inheritedMethodToBridge.isStatic()) {
            return null;
        }
        if (this.synthetics == null) {
            this.synthetics = new HashMap[3];
        }
        if (this.synthetics[0] == null) {
            this.synthetics[0] = new HashMap(5);
        } else {
            for (Object synthetic : this.synthetics[0].keySet()) {
                if (!(synthetic instanceof MethodBinding)) continue;
                MethodBinding method = (MethodBinding)synthetic;
                if (!CharOperation.equals(inheritedMethodToBridge.selector, method.selector) || !TypeBinding.equalsEquals(inheritedMethodToBridge.returnType.erasure(), method.returnType.erasure()) || !inheritedMethodToBridge.areParameterErasuresEqual(method)) continue;
                return null;
            }
        }
        SyntheticMethodBinding accessMethod = null;
        SyntheticMethodBinding[] accessors = (SyntheticMethodBinding[])this.synthetics[0].get(inheritedMethodToBridge);
        if (accessors == null) {
            accessMethod = new SyntheticMethodBinding(inheritedMethodToBridge, this);
            accessors = new SyntheticMethodBinding[2];
            this.synthetics[0].put(inheritedMethodToBridge, accessors);
            accessors[0] = accessMethod;
        } else {
            accessMethod = accessors[0];
            if (accessMethod == null) {
                accessors[0] = accessMethod = new SyntheticMethodBinding(inheritedMethodToBridge, this);
            }
        }
        return accessMethod;
    }

    boolean areFieldsInitialized() {
        if (!this.isPrototype()) {
            return this.prototype.areFieldsInitialized();
        }
        return this.fields != Binding.UNINITIALIZED_FIELDS;
    }

    boolean areMethodsInitialized() {
        if (!this.isPrototype()) {
            return this.prototype.areMethodsInitialized();
        }
        return this.methods != Binding.UNINITIALIZED_METHODS;
    }

    @Override
    public int kind() {
        if (!this.isPrototype()) {
            return this.prototype.kind();
        }
        if (this.typeVariables != Binding.NO_TYPE_VARIABLES) {
            return 2052;
        }
        return 4;
    }

    @Override
    public TypeBinding clone(TypeBinding immaterial) {
        return new SourceTypeBinding(this);
    }

    @Override
    public char[] computeUniqueKey(boolean isLeaf) {
        if (!this.isPrototype()) {
            return this.prototype.computeUniqueKey();
        }
        char[] uniqueKey = super.computeUniqueKey(isLeaf);
        if (uniqueKey.length == 2) {
            return uniqueKey;
        }
        if (Util.isClassFileName(this.fileName)) {
            return uniqueKey;
        }
        int end = CharOperation.lastIndexOf('.', this.fileName);
        if (end != -1) {
            char[] topLevelType;
            int start = CharOperation.lastIndexOf('/', this.fileName) + 1;
            char[] mainTypeName = CharOperation.subarray(this.fileName, start, end);
            start = CharOperation.lastIndexOf('/', uniqueKey) + 1;
            if (start == 0) {
                start = 1;
            }
            if ((end = this.isMemberType() ? CharOperation.indexOf('$', uniqueKey, start) : -1) == -1) {
                end = CharOperation.indexOf('<', uniqueKey, start);
            }
            if (end == -1) {
                end = CharOperation.indexOf(';', uniqueKey, start);
            }
            if (!CharOperation.equals(topLevelType = CharOperation.subarray(uniqueKey, start, end), mainTypeName)) {
                StringBuffer buffer = new StringBuffer();
                buffer.append(uniqueKey, 0, start);
                buffer.append(mainTypeName);
                buffer.append('~');
                buffer.append(topLevelType);
                buffer.append(uniqueKey, end, uniqueKey.length - end);
                int length = buffer.length();
                uniqueKey = new char[length];
                buffer.getChars(0, length, uniqueKey, 0);
                return uniqueKey;
            }
        }
        return uniqueKey;
    }

    void faultInTypesForFieldsAndMethods() {
        if (!this.isPrototype()) {
            throw new IllegalStateException();
        }
        this.getAnnotationTagBits();
        ReferenceBinding enclosingType = this.enclosingType();
        if (enclosingType != null && enclosingType.isViewedAsDeprecated() && !this.isDeprecated()) {
            this.modifiers |= 0x200000;
        }
        this.fields();
        this.methods();
        int i = 0;
        int length = this.memberTypes.length;
        while (i < length) {
            ((SourceTypeBinding)this.memberTypes[i]).faultInTypesForFieldsAndMethods();
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public FieldBinding[] fields() {
        block14: {
            if (!this.isPrototype()) {
                if ((this.tagBits & 8192L) != 0L) {
                    return this.fields;
                }
                this.tagBits |= 8192L;
                this.fields = this.prototype.fields();
                return this.fields;
            }
            if ((this.tagBits & 8192L) != 0L) {
                return this.fields;
            }
            failed = 0;
            resolvedFields = this.fields;
            try {
                if ((this.tagBits & 4096L) == 0L) {
                    length = this.fields.length;
                    if (length > 1) {
                        ReferenceBinding.sortFields(this.fields, 0, length);
                    }
                    this.tagBits |= 4096L;
                }
                i = 0;
                length = this.fields.length;
                while (i < length) {
                    if (this.resolveTypeFor(this.fields[i]) == null) {
                        if (resolvedFields == this.fields) {
                            resolvedFields = new FieldBinding[length];
                            System.arraycopy(this.fields, 0, resolvedFields, 0, length);
                        }
                        resolvedFields[i] = null;
                        ++failed;
                    }
                    ++i;
                }
            }
            finally {
                if (failed <= 0) break block14;
                newSize = resolvedFields.length - failed;
                if (newSize == 0) {
                    return this.setFields(Binding.NO_FIELDS);
                }
                newFields = new FieldBinding[newSize];
                i = 0;
                j = 0;
                length = resolvedFields.length;
                ** while (i < length)
            }
lbl-1000:
            // 1 sources

            {
                if (resolvedFields[i] != null) {
                    newFields[j++] = resolvedFields[i];
                }
                ++i;
                continue;
            }
lbl43:
            // 1 sources

            this.setFields(newFields);
        }
        this.tagBits |= 8192L;
        return this.fields;
    }

    @Override
    public char[] genericTypeSignature() {
        if (!this.isPrototype()) {
            return this.prototype.genericTypeSignature();
        }
        if (this.genericReferenceTypeSignature == null) {
            this.genericReferenceTypeSignature = this.computeGenericTypeSignature(this.typeVariables);
        }
        return this.genericReferenceTypeSignature;
    }

    public char[] genericSignature() {
        int length;
        int i;
        if (!this.isPrototype()) {
            return this.prototype.genericSignature();
        }
        StringBuffer sig = null;
        if (this.typeVariables != Binding.NO_TYPE_VARIABLES) {
            sig = new StringBuffer(10);
            sig.append('<');
            i = 0;
            length = this.typeVariables.length;
            while (i < length) {
                sig.append(this.typeVariables[i].genericSignature());
                ++i;
            }
            sig.append('>');
        } else {
            block10: {
                if (this.superclass == null || !this.superclass.isParameterizedType()) {
                    i = 0;
                    length = this.superInterfaces.length;
                    while (i < length) {
                        if (!this.superInterfaces[i].isParameterizedType()) {
                            ++i;
                            continue;
                        }
                        break block10;
                    }
                    return null;
                }
            }
            sig = new StringBuffer(10);
        }
        if (this.superclass != null) {
            sig.append(this.superclass.genericTypeSignature());
        } else {
            sig.append(this.scope.getJavaLangObject().genericTypeSignature());
        }
        i = 0;
        length = this.superInterfaces.length;
        while (i < length) {
            sig.append(this.superInterfaces[i].genericTypeSignature());
            ++i;
        }
        return sig.toString().toCharArray();
    }

    @Override
    public long getAnnotationTagBits() {
        if (!this.isPrototype()) {
            return this.prototype.getAnnotationTagBits();
        }
        if ((this.tagBits & 0x200000000L) == 0L && this.scope != null) {
            TypeDeclaration typeDecl = this.scope.referenceContext;
            boolean old = typeDecl.staticInitializerScope.insideTypeAnnotation;
            try {
                typeDecl.staticInitializerScope.insideTypeAnnotation = true;
                ASTNode.resolveAnnotations((BlockScope)typeDecl.staticInitializerScope, typeDecl.annotations, (Binding)this);
            }
            finally {
                typeDecl.staticInitializerScope.insideTypeAnnotation = old;
            }
            if ((this.tagBits & 0x400000000000L) != 0L) {
                this.modifiers |= 0x100000;
            }
            this.evaluateNullAnnotations(this.tagBits);
        }
        return this.tagBits;
    }

    public MethodBinding[] getDefaultAbstractMethods() {
        if (!this.isPrototype()) {
            return this.prototype.getDefaultAbstractMethods();
        }
        int count = 0;
        int i = this.methods.length;
        while (--i >= 0) {
            if (!this.methods[i].isDefaultAbstract()) continue;
            ++count;
        }
        if (count == 0) {
            return Binding.NO_METHODS;
        }
        MethodBinding[] result = new MethodBinding[count];
        count = 0;
        int i2 = this.methods.length;
        while (--i2 >= 0) {
            if (!this.methods[i2].isDefaultAbstract()) continue;
            result[count++] = this.methods[i2];
        }
        return result;
    }

    @Override
    public MethodBinding getExactConstructor(TypeBinding[] argumentTypes) {
        block16: {
            long range;
            int argCount;
            block15: {
                if (!this.isPrototype()) {
                    return this.prototype.getExactConstructor(argumentTypes);
                }
                argCount = argumentTypes.length;
                if ((this.tagBits & 0x8000L) == 0L) break block15;
                long range2 = ReferenceBinding.binarySearch(TypeConstants.INIT, this.methods);
                if (range2 < 0L) break block16;
                int imethod = (int)range2;
                int end = (int)(range2 >> 32);
                while (imethod <= end) {
                    block13: {
                        MethodBinding method = this.methods[imethod];
                        if (method.parameters.length == argCount) {
                            TypeBinding[] toMatch = method.parameters;
                            int iarg = 0;
                            while (iarg < argCount) {
                                if (!TypeBinding.notEquals(toMatch[iarg], argumentTypes[iarg])) {
                                    ++iarg;
                                    continue;
                                }
                                break block13;
                            }
                            return method;
                        }
                    }
                    ++imethod;
                }
                break block16;
            }
            if ((this.tagBits & 0x4000L) == 0L) {
                int length = this.methods.length;
                if (length > 1) {
                    ReferenceBinding.sortMethods(this.methods, 0, length);
                }
                this.tagBits |= 0x4000L;
            }
            if ((range = ReferenceBinding.binarySearch(TypeConstants.INIT, this.methods)) >= 0L) {
                int imethod = (int)range;
                int end = (int)(range >> 32);
                while (imethod <= end) {
                    block14: {
                        MethodBinding method = this.methods[imethod];
                        if (this.resolveTypesFor(method) == null || method.returnType == null) {
                            this.methods();
                            return this.getExactConstructor(argumentTypes);
                        }
                        if (method.parameters.length == argCount) {
                            TypeBinding[] toMatch = method.parameters;
                            int iarg = 0;
                            while (iarg < argCount) {
                                if (!TypeBinding.notEquals(toMatch[iarg], argumentTypes[iarg])) {
                                    ++iarg;
                                    continue;
                                }
                                break block14;
                            }
                            return method;
                        }
                    }
                    ++imethod;
                }
            }
        }
        return null;
    }

    @Override
    public MethodBinding getExactMethod(char[] selector, TypeBinding[] argumentTypes, CompilationUnitScope refScope) {
        if (!this.isPrototype()) {
            return this.prototype.getExactMethod(selector, argumentTypes, refScope);
        }
        int argCount = argumentTypes.length;
        boolean foundNothing = true;
        if ((this.tagBits & 0x8000L) != 0L) {
            long range = ReferenceBinding.binarySearch(selector, this.methods);
            if (range >= 0L) {
                int imethod = (int)range;
                int end = (int)(range >> 32);
                while (imethod <= end) {
                    block27: {
                        MethodBinding method = this.methods[imethod];
                        foundNothing = false;
                        if (method.parameters.length == argCount) {
                            TypeBinding[] toMatch = method.parameters;
                            int iarg = 0;
                            while (iarg < argCount) {
                                if (!TypeBinding.notEquals(toMatch[iarg], argumentTypes[iarg])) {
                                    ++iarg;
                                    continue;
                                }
                                break block27;
                            }
                            return method;
                        }
                    }
                    ++imethod;
                }
            }
        } else {
            long range;
            if ((this.tagBits & 0x4000L) == 0L) {
                int length = this.methods.length;
                if (length > 1) {
                    ReferenceBinding.sortMethods(this.methods, 0, length);
                }
                this.tagBits |= 0x4000L;
            }
            if ((range = ReferenceBinding.binarySearch(selector, this.methods)) >= 0L) {
                int start = (int)range;
                int end = (int)(range >> 32);
                int imethod = start;
                while (imethod <= end) {
                    MethodBinding method = this.methods[imethod];
                    if (this.resolveTypesFor(method) == null || method.returnType == null) {
                        this.methods();
                        return this.getExactMethod(selector, argumentTypes, refScope);
                    }
                    ++imethod;
                }
                boolean isSource15 = this.scope.compilerOptions().sourceLevel >= 0x310000L;
                int i = start;
                while (i <= end) {
                    MethodBinding method1 = this.methods[i];
                    int j = end;
                    while (j > i) {
                        boolean paramsMatch;
                        MethodBinding method2 = this.methods[j];
                        boolean bl = paramsMatch = isSource15 ? method1.areParameterErasuresEqual(method2) : method1.areParametersEqual(method2);
                        if (paramsMatch) {
                            this.methods();
                            return this.getExactMethod(selector, argumentTypes, refScope);
                        }
                        --j;
                    }
                    ++i;
                }
                int imethod2 = start;
                while (imethod2 <= end) {
                    block28: {
                        MethodBinding method = this.methods[imethod2];
                        TypeBinding[] toMatch = method.parameters;
                        if (toMatch.length == argCount) {
                            int iarg = 0;
                            while (iarg < argCount) {
                                if (!TypeBinding.notEquals(toMatch[iarg], argumentTypes[iarg])) {
                                    ++iarg;
                                    continue;
                                }
                                break block28;
                            }
                            return method;
                        }
                    }
                    ++imethod2;
                }
            }
        }
        if (foundNothing) {
            if (this.isInterface()) {
                if (this.superInterfaces.length == 1) {
                    if (refScope != null) {
                        refScope.recordTypeReference(this.superInterfaces[0]);
                    }
                    return this.superInterfaces[0].getExactMethod(selector, argumentTypes, refScope);
                }
            } else if (this.superclass != null) {
                if (refScope != null) {
                    refScope.recordTypeReference(this.superclass);
                }
                return this.superclass.getExactMethod(selector, argumentTypes, refScope);
            }
        }
        return null;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public FieldBinding getField(char[] fieldName, boolean needResolve) {
        if (!this.isPrototype()) {
            return this.prototype.getField(fieldName, needResolve);
        }
        if ((this.tagBits & 8192L) != 0L) {
            return ReferenceBinding.binarySearch(fieldName, this.fields);
        }
        if ((this.tagBits & 4096L) == 0L) {
            length = this.fields.length;
            if (length > 1) {
                ReferenceBinding.sortFields(this.fields, 0, length);
            }
            this.tagBits |= 4096L;
        }
        if ((field = ReferenceBinding.binarySearch(fieldName, this.fields)) == null) return null;
        result = null;
        try {
            var6_6 = result = this.resolveTypeFor(field);
            return var6_6;
        }
        finally {
            if (result != null) return var6_6;
            newSize = this.fields.length - 1;
            if (newSize == 0) {
                this.setFields(Binding.NO_FIELDS);
                return var6_6;
            }
            newFields = new FieldBinding[newSize];
            index = 0;
            i = 0;
            length = this.fields.length;
            ** while (i < length)
        }
lbl-1000:
        // 1 sources

        {
            f = this.fields[i];
            if (f != field) {
                newFields[index++] = f;
            }
            ++i;
            continue;
        }
lbl32:
        // 1 sources

        this.setFields(newFields);
        return var6_6;
    }

    @Override
    public MethodBinding[] getAnyExtraMethods(char[] selector) {
        return this.scope == null ? null : this.scope.getAnyExtraMethods(selector);
    }

    @Override
    public MethodBinding[] getMethods(char[] selector) {
        MethodBinding method;
        int end;
        int start;
        long range;
        if (!this.isPrototype()) {
            return this.prototype.getMethods(selector);
        }
        if ((this.tagBits & 0x8000L) != 0L) {
            long range2 = ReferenceBinding.binarySearch(selector, this.methods);
            if (range2 >= 0L) {
                int start2 = (int)range2;
                int end2 = (int)(range2 >> 32);
                int length = end2 - start2 + 1;
                MethodBinding[] result = new MethodBinding[length];
                System.arraycopy(this.methods, start2, result, 0, length);
                return result;
            }
            return Binding.NO_METHODS;
        }
        if ((this.tagBits & 0x4000L) == 0L) {
            int length = this.methods.length;
            if (length > 1) {
                ReferenceBinding.sortMethods(this.methods, 0, length);
            }
            this.tagBits |= 0x4000L;
        }
        if ((range = ReferenceBinding.binarySearch(selector, this.methods)) >= 0L) {
            start = (int)range;
            end = (int)(range >> 32);
            int i = start;
            while (i <= end) {
                method = this.methods[i];
                if (this.resolveTypesFor(method) == null || method.returnType == null) {
                    this.methods();
                    return this.getMethods(selector);
                }
                ++i;
            }
        } else {
            return Binding.NO_METHODS;
        }
        int length = end - start + 1;
        MethodBinding[] result = new MethodBinding[length];
        System.arraycopy(this.methods, start, result, 0, length);
        boolean isSource15 = this.scope.compilerOptions().sourceLevel >= 0x310000L;
        int i = 0;
        length = result.length - 1;
        while (i < length) {
            method = result[i];
            int j = length;
            while (j > i) {
                boolean paramsMatch;
                boolean bl = paramsMatch = isSource15 ? method.areParameterErasuresEqual(result[j]) : method.areParametersEqual(result[j]);
                if (paramsMatch) {
                    this.methods();
                    return this.getMethods(selector);
                }
                --j;
            }
            ++i;
        }
        return result;
    }

    public FieldBinding getSyntheticField(LocalVariableBinding actualOuterLocalVariable) {
        if (!this.isPrototype()) {
            throw new IllegalStateException();
        }
        if (this.synthetics == null || this.synthetics[1] == null) {
            return null;
        }
        return (FieldBinding)this.synthetics[1].get(actualOuterLocalVariable);
    }

    public FieldBinding getSyntheticField(ReferenceBinding targetEnclosingType, boolean onlyExactMatch) {
        if (!this.isPrototype()) {
            throw new IllegalStateException();
        }
        if (this.synthetics == null || this.synthetics[1] == null) {
            return null;
        }
        FieldBinding field2 = (FieldBinding)this.synthetics[1].get(targetEnclosingType);
        if (field2 != null) {
            return field2;
        }
        if (!onlyExactMatch) {
            for (FieldBinding field2 : this.synthetics[1].values()) {
                if (!CharOperation.prefixEquals(TypeConstants.SYNTHETIC_ENCLOSING_INSTANCE_PREFIX, field2.name) || field2.type.findSuperTypeOriginatingFrom(targetEnclosingType) == null) continue;
                return field2;
            }
        }
        return null;
    }

    public SyntheticMethodBinding getSyntheticBridgeMethod(MethodBinding inheritedMethodToBridge) {
        if (!this.isPrototype()) {
            throw new IllegalStateException();
        }
        if (this.synthetics == null) {
            return null;
        }
        if (this.synthetics[0] == null) {
            return null;
        }
        SyntheticMethodBinding[] accessors = (SyntheticMethodBinding[])this.synthetics[0].get(inheritedMethodToBridge);
        if (accessors == null) {
            return null;
        }
        return accessors[1];
    }

    @Override
    public boolean hasTypeBit(int bit) {
        if (!this.isPrototype()) {
            return this.prototype.hasTypeBit(bit);
        }
        return (this.typeBits & bit) != 0;
    }

    @Override
    public void initializeDeprecatedAnnotationTagBits() {
        if (!this.isPrototype()) {
            this.prototype.initializeDeprecatedAnnotationTagBits();
            return;
        }
        if ((this.tagBits & 0x400000000L) == 0L) {
            TypeDeclaration typeDecl = this.scope.referenceContext;
            boolean old = typeDecl.staticInitializerScope.insideTypeAnnotation;
            try {
                typeDecl.staticInitializerScope.insideTypeAnnotation = true;
                ASTNode.resolveDeprecatedAnnotations(typeDecl.staticInitializerScope, typeDecl.annotations, this);
                this.tagBits |= 0x400000000L;
            }
            finally {
                typeDecl.staticInitializerScope.insideTypeAnnotation = old;
            }
            if ((this.tagBits & 0x400000000000L) != 0L) {
                this.modifiers |= 0x100000;
            }
        }
    }

    @Override
    void initializeForStaticImports() {
        if (!this.isPrototype()) {
            this.prototype.initializeForStaticImports();
            return;
        }
        if (this.scope == null) {
            return;
        }
        if (this.superInterfaces == null) {
            this.scope.connectTypeHierarchy();
        }
        this.scope.buildFields();
        this.scope.buildMethods();
    }

    @Override
    int getNullDefault() {
        if (!this.isPrototype()) {
            return this.prototype.getNullDefault();
        }
        switch (this.nullnessDefaultInitialized) {
            case 0: {
                this.getAnnotationTagBits();
            }
            case 1: {
                this.getPackage().isViewedAsDeprecated();
                this.nullnessDefaultInitialized = 2;
            }
        }
        return this.defaultNullness;
    }

    @Override
    public boolean isEquivalentTo(TypeBinding otherType) {
        if (!this.isPrototype()) {
            return this.prototype.isEquivalentTo(otherType);
        }
        if (TypeBinding.equalsEquals(this, otherType)) {
            return true;
        }
        if (otherType == null) {
            return false;
        }
        switch (otherType.kind()) {
            case 516: 
            case 8196: {
                return ((WildcardBinding)otherType).boundCheck(this);
            }
            case 260: {
                int otherLength;
                ReferenceBinding enclosing;
                if (!((otherType.tagBits & 0x40000000L) != 0L || this.isMemberType() && otherType.isMemberType())) {
                    return false;
                }
                ParameterizedTypeBinding otherParamType = (ParameterizedTypeBinding)otherType;
                if (TypeBinding.notEquals(this, otherParamType.genericType())) {
                    return false;
                }
                if (!this.isStatic() && (enclosing = this.enclosingType()) != null) {
                    ReferenceBinding otherEnclosing = otherParamType.enclosingType();
                    if (otherEnclosing == null) {
                        return false;
                    }
                    if ((otherEnclosing.tagBits & 0x40000000L) == 0L ? TypeBinding.notEquals(enclosing, otherEnclosing) : !enclosing.isEquivalentTo(otherParamType.enclosingType())) {
                        return false;
                    }
                }
                int length = this.typeVariables == null ? 0 : this.typeVariables.length;
                TypeBinding[] otherArguments = otherParamType.arguments;
                int n = otherLength = otherArguments == null ? 0 : otherArguments.length;
                if (otherLength != length) {
                    return false;
                }
                int i = 0;
                while (i < length) {
                    if (!this.typeVariables[i].isTypeArgumentContainedBy(otherArguments[i])) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            case 1028: {
                return TypeBinding.equalsEquals(otherType.erasure(), this);
            }
        }
        return false;
    }

    @Override
    public boolean isGenericType() {
        if (!this.isPrototype()) {
            return this.prototype.isGenericType();
        }
        return this.typeVariables != Binding.NO_TYPE_VARIABLES;
    }

    @Override
    public boolean isHierarchyConnected() {
        if (!this.isPrototype()) {
            return this.prototype.isHierarchyConnected();
        }
        return (this.tagBits & 0x200L) != 0L;
    }

    @Override
    public boolean isRepeatableAnnotationType() {
        if (!this.isPrototype()) {
            throw new IllegalStateException();
        }
        return this.containerAnnotationType != null;
    }

    @Override
    public boolean isTaggedRepeatable() {
        return (this.tagBits & 0x1000000000000000L) != 0L;
    }

    @Override
    public ReferenceBinding[] memberTypes() {
        if (!this.isPrototype()) {
            if ((this.tagBits & 0x10000000L) == 0L) {
                return this.memberTypes;
            }
            this.memberTypes = this.prototype.memberTypes();
            ReferenceBinding[] members = this.memberTypes;
            int membersLength = members == null ? 0 : members.length;
            this.memberTypes = new ReferenceBinding[membersLength];
            int i = 0;
            while (i < membersLength) {
                this.memberTypes[i] = this.environment.createMemberType(members[i], this);
                ++i;
            }
            this.tagBits &= 0xFFFFFFFFEFFFFFFFL;
        }
        return this.memberTypes;
    }

    @Override
    public boolean hasMemberTypes() {
        if (!this.isPrototype()) {
            return this.prototype.hasMemberTypes();
        }
        return this.memberTypes.length > 0;
    }

    /*
     * Exception decompiling
     */
    @Override
    public MethodBinding[] methods() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[DOLOOP]], but top level block is 6[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public TypeBinding prototype() {
        return this.prototype;
    }

    public boolean isPrototype() {
        return this == this.prototype;
    }

    @Override
    public ReferenceBinding containerAnnotationType() {
        if (!this.isPrototype()) {
            throw new IllegalStateException();
        }
        if (this.containerAnnotationType instanceof UnresolvedReferenceBinding) {
            this.containerAnnotationType = (ReferenceBinding)BinaryTypeBinding.resolveType(this.containerAnnotationType, this.scope.environment(), false);
        }
        return this.containerAnnotationType;
    }

    public FieldBinding resolveTypeFor(FieldBinding field) {
        FieldDeclaration[] fieldDecls;
        if (!this.isPrototype()) {
            return this.prototype.resolveTypeFor(field);
        }
        if ((field.modifiers & 0x2000000) == 0) {
            return field;
        }
        long sourceLevel = this.scope.compilerOptions().sourceLevel;
        if (sourceLevel >= 0x310000L && (field.getAnnotationTagBits() & 0x400000000000L) != 0L) {
            field.modifiers |= 0x100000;
        }
        if (this.isViewedAsDeprecated() && !field.isDeprecated()) {
            field.modifiers |= 0x200000;
        }
        if (this.hasRestrictedAccess()) {
            field.modifiers |= 0x40000;
        }
        int length = (fieldDecls = this.scope.referenceContext.fields) == null ? 0 : fieldDecls.length;
        int f = 0;
        while (f < length) {
            if (fieldDecls[f].binding == field) {
                MethodScope initializationScope = field.isStatic() ? this.scope.referenceContext.staticInitializerScope : this.scope.referenceContext.initializerScope;
                FieldBinding previousField = initializationScope.initializedField;
                try {
                    TypeBinding leafType;
                    TypeBinding fieldType;
                    initializationScope.initializedField = field;
                    FieldDeclaration fieldDecl = fieldDecls[f];
                    field.type = fieldType = fieldDecl.getKind() == 3 ? initializationScope.environment().convertToRawType(this, false) : fieldDecl.type.resolveType(initializationScope, true);
                    field.modifiers &= 0xFDFFFFFF;
                    if (fieldType == null) {
                        fieldDecl.binding = null;
                        return null;
                    }
                    if (fieldType == TypeBinding.VOID) {
                        this.scope.problemReporter().variableTypeCannotBeVoid(fieldDecl);
                        fieldDecl.binding = null;
                        return null;
                    }
                    if (fieldType.isArrayType() && ((ArrayBinding)fieldType).leafComponentType == TypeBinding.VOID) {
                        this.scope.problemReporter().variableTypeCannotBeVoidArray(fieldDecl);
                        fieldDecl.binding = null;
                        return null;
                    }
                    if ((fieldType.tagBits & 0x80L) != 0L) {
                        field.tagBits |= 0x80L;
                    }
                    if ((leafType = fieldType.leafComponentType()) instanceof ReferenceBinding && (((ReferenceBinding)leafType).modifiers & 0x40000000) != 0) {
                        field.modifiers |= 0x40000000;
                    }
                    if (sourceLevel >= 0x340000L) {
                        Annotation[] annotations = fieldDecl.annotations;
                        if (annotations != null && annotations.length != 0) {
                            ASTNode.copySE8AnnotationsToType(initializationScope, field, annotations, fieldDecl.getKind() != 3);
                        }
                        Annotation.isTypeUseCompatible(fieldDecl.type, this.scope, annotations);
                    }
                    if (this.environment.globalOptions.isAnnotationBasedNullAnalysisEnabled) {
                        if (fieldDecl.getKind() == 3) {
                            field.tagBits |= 0x100000000000000L;
                        } else {
                            if (this.hasNonNullDefaultFor(32, sourceLevel >= 0x340000L)) {
                                field.fillInDefaultNonNullness(fieldDecl, initializationScope);
                            }
                            if (!this.scope.validateNullAnnotation(field.tagBits, fieldDecl.type, fieldDecl.annotations)) {
                                field.tagBits &= 0xFE7FFFFFFFFFFFFFL;
                            }
                        }
                    }
                }
                finally {
                    initializationScope.initializedField = previousField;
                }
                return field;
            }
            ++f;
        }
        return null;
    }

    public MethodBinding resolveTypesFor(MethodBinding method) {
        long nullTagBits;
        TypeReference[] exceptionTypes;
        AbstractMethodDeclaration methodDecl;
        int i;
        if (!this.isPrototype()) {
            return this.prototype.resolveTypesFor(method);
        }
        if ((method.modifiers & 0x2000000) == 0) {
            return method;
        }
        long sourceLevel = this.scope.compilerOptions().sourceLevel;
        if (sourceLevel >= 0x310000L) {
            ReferenceBinding object = this.scope.getJavaLangObject();
            TypeVariableBinding[] tvb = method.typeVariables;
            i = 0;
            while (i < tvb.length) {
                tvb[i].superclass = object;
                ++i;
            }
            if ((method.getAnnotationTagBits() & 0x400000000000L) != 0L) {
                method.modifiers |= 0x100000;
            }
        }
        if (this.isViewedAsDeprecated() && !method.isDeprecated()) {
            method.modifiers |= 0x200000;
        }
        if (this.hasRestrictedAccess()) {
            method.modifiers |= 0x40000;
        }
        if ((methodDecl = method.sourceMethod()) == null) {
            if (method instanceof LazilyResolvedMethodBinding) {
                LazilyResolvedMethodBinding lrMethod = (LazilyResolvedMethodBinding)method;
                TypeBinding ptb = lrMethod.getParameterTypeBinding();
                method.parameters = ptb == null ? Binding.NO_PARAMETERS : new TypeBinding[]{ptb};
                method.returnType = lrMethod.getReturnTypeBinding();
                method.modifiers &= 0xFDFFFFFF;
                return method;
            }
            return null;
        }
        TypeParameter[] typeParameters = methodDecl.typeParameters();
        if (typeParameters != null) {
            methodDecl.scope.connectTypeVariables(typeParameters, true);
            i = 0;
            int paramLength = typeParameters.length;
            while (i < paramLength) {
                typeParameters[i].checkBounds(methodDecl.scope);
                ++i;
            }
        }
        if ((exceptionTypes = methodDecl.thrownExceptions) != null) {
            int size = exceptionTypes.length;
            method.thrownExceptions = new ReferenceBinding[size];
            int count = 0;
            int i2 = 0;
            while (i2 < size) {
                ReferenceBinding resolvedExceptionType = (ReferenceBinding)exceptionTypes[i2].resolveType(methodDecl.scope, true);
                if (resolvedExceptionType != null) {
                    if (resolvedExceptionType.isBoundParameterizedType()) {
                        methodDecl.scope.problemReporter().invalidParameterizedExceptionType(resolvedExceptionType, exceptionTypes[i2]);
                    } else if (resolvedExceptionType.findSuperTypeOriginatingFrom(21, true) == null && resolvedExceptionType.isValidBinding()) {
                        methodDecl.scope.problemReporter().cannotThrowType(exceptionTypes[i2], resolvedExceptionType);
                    } else {
                        if ((resolvedExceptionType.tagBits & 0x80L) != 0L) {
                            method.tagBits |= 0x80L;
                        }
                        if (resolvedExceptionType.hasNullTypeAnnotations()) {
                            methodDecl.scope.problemReporter().nullAnnotationUnsupportedLocation(exceptionTypes[i2]);
                        }
                        method.modifiers |= resolvedExceptionType.modifiers & 0x40000000;
                        method.thrownExceptions[count++] = resolvedExceptionType;
                    }
                }
                ++i2;
            }
            if (count < size) {
                method.thrownExceptions = new ReferenceBinding[count];
                System.arraycopy(method.thrownExceptions, 0, method.thrownExceptions, 0, count);
            }
        }
        if (methodDecl.receiver != null) {
            method.receiver = methodDecl.receiver.type.resolveType(methodDecl.scope, true);
        }
        boolean reportUnavoidableGenericTypeProblems = this.scope.compilerOptions().reportUnavoidableGenericTypeProblems;
        boolean foundArgProblem = false;
        Argument[] arguments = methodDecl.arguments;
        if (arguments != null) {
            int size = arguments.length;
            method.parameters = Binding.NO_PARAMETERS;
            TypeBinding[] newParameters = new TypeBinding[size];
            int i3 = 0;
            while (i3 < size) {
                TypeBinding parameterType;
                boolean deferRawTypeCheck;
                Argument arg = arguments[i3];
                if (arg.annotations != null) {
                    method.tagBits |= 0x400L;
                }
                boolean bl = deferRawTypeCheck = !reportUnavoidableGenericTypeProblems && !method.isConstructor() && (arg.type.bits & 0x40000000) == 0;
                if (deferRawTypeCheck) {
                    arg.type.bits |= 0x40000000;
                }
                try {
                    parameterType = arg.type.resolveType(methodDecl.scope, true);
                }
                finally {
                    if (deferRawTypeCheck) {
                        arg.type.bits &= 0xBFFFFFFF;
                    }
                }
                if (parameterType == null) {
                    foundArgProblem = true;
                } else if (parameterType == TypeBinding.VOID) {
                    methodDecl.scope.problemReporter().argumentTypeCannotBeVoid(methodDecl, arg);
                    foundArgProblem = true;
                } else {
                    TypeBinding leafType;
                    if ((parameterType.tagBits & 0x80L) != 0L) {
                        method.tagBits |= 0x80L;
                    }
                    if ((leafType = parameterType.leafComponentType()) instanceof ReferenceBinding && (((ReferenceBinding)leafType).modifiers & 0x40000000) != 0) {
                        method.modifiers |= 0x40000000;
                    }
                    newParameters[i3] = parameterType;
                    arg.binding = new LocalVariableBinding((LocalDeclaration)arg, parameterType, arg.modifiers, methodDecl.scope);
                }
                ++i3;
            }
            if (!foundArgProblem) {
                method.parameters = newParameters;
            }
        }
        if (sourceLevel >= 0x330000L) {
            if ((method.tagBits & 0x8000000000000L) != 0L) {
                if (!method.isVarargs()) {
                    methodDecl.scope.problemReporter().safeVarargsOnFixedArityMethod(method);
                } else if (!(method.isStatic() || method.isFinal() || method.isConstructor())) {
                    methodDecl.scope.problemReporter().safeVarargsOnNonFinalInstanceMethod(method);
                }
            } else if (method.parameters != null && method.parameters.length > 0 && method.isVarargs() && !method.parameters[method.parameters.length - 1].isReifiable()) {
                methodDecl.scope.problemReporter().possibleHeapPollutionFromVararg(methodDecl.arguments[methodDecl.arguments.length - 1]);
            }
        }
        boolean foundReturnTypeProblem = false;
        if (!method.isConstructor()) {
            TypeReference returnType;
            TypeReference typeReference = returnType = methodDecl instanceof MethodDeclaration ? ((MethodDeclaration)methodDecl).returnType : null;
            if (returnType == null) {
                methodDecl.scope.problemReporter().missingReturnType(methodDecl);
                method.returnType = null;
                foundReturnTypeProblem = true;
            } else {
                TypeBinding methodType;
                boolean deferRawTypeCheck;
                boolean bl = deferRawTypeCheck = !reportUnavoidableGenericTypeProblems && (returnType.bits & 0x40000000) == 0;
                if (deferRawTypeCheck) {
                    returnType.bits |= 0x40000000;
                }
                try {
                    methodType = returnType.resolveType(methodDecl.scope, true);
                }
                finally {
                    if (deferRawTypeCheck) {
                        returnType.bits &= 0xBFFFFFFF;
                    }
                }
                if (methodType == null) {
                    foundReturnTypeProblem = true;
                } else {
                    TypeBinding leafType;
                    if ((methodType.tagBits & 0x80L) != 0L) {
                        method.tagBits |= 0x80L;
                    }
                    method.returnType = methodType;
                    if (sourceLevel >= 0x340000L && !method.isVoidMethod()) {
                        Annotation[] annotations = methodDecl.annotations;
                        if (annotations != null && annotations.length != 0) {
                            ASTNode.copySE8AnnotationsToType(methodDecl.scope, method, methodDecl.annotations, true);
                        }
                        Annotation.isTypeUseCompatible(returnType, this.scope, methodDecl.annotations);
                    }
                    if ((leafType = methodType.leafComponentType()) instanceof ReferenceBinding && (((ReferenceBinding)leafType).modifiers & 0x40000000) != 0) {
                        method.modifiers |= 0x40000000;
                    } else if (leafType == TypeBinding.VOID && methodDecl.annotations != null) {
                        SourceTypeBinding.rejectTypeAnnotatedVoidMethod(methodDecl);
                    }
                }
            }
        }
        if (foundArgProblem) {
            methodDecl.binding = null;
            method.parameters = Binding.NO_PARAMETERS;
            if (typeParameters != null) {
                int i4 = 0;
                int length = typeParameters.length;
                while (i4 < length) {
                    typeParameters[i4].binding = null;
                    ++i4;
                }
            }
            return null;
        }
        CompilerOptions compilerOptions = this.scope.compilerOptions();
        if (compilerOptions.isAnnotationBasedNullAnalysisEnabled && !method.isConstructor() && method.returnType != null && (nullTagBits = method.tagBits & 0x180000000000000L) != 0L) {
            TypeReference returnTypeRef = ((MethodDeclaration)methodDecl).returnType;
            if (compilerOptions.sourceLevel < 0x340000L) {
                if (!this.scope.validateNullAnnotation(nullTagBits, returnTypeRef, methodDecl.annotations)) {
                    method.tagBits &= 0xFE7FFFFFFFFFFFFFL;
                }
            } else if (nullTagBits != (method.returnType.tagBits & 0x180000000000000L)) {
                if (!this.scope.validateNullAnnotation(nullTagBits, returnTypeRef, methodDecl.annotations)) {
                    method.returnType.tagBits &= 0xFE7FFFFFFFFFFFFFL;
                }
                method.tagBits &= 0xFE7FFFFFFFFFFFFFL;
            }
        }
        if (compilerOptions.storeAnnotations) {
            this.createArgumentBindings(method, compilerOptions);
        }
        if (foundReturnTypeProblem) {
            return method;
        }
        method.modifiers &= 0xFDFFFFFF;
        return method;
    }

    private static void rejectTypeAnnotatedVoidMethod(AbstractMethodDeclaration methodDecl) {
        Annotation[] annotations = methodDecl.annotations;
        int length = annotations == null ? 0 : annotations.length;
        int i = 0;
        while (i < length) {
            ReferenceBinding binding = (ReferenceBinding)annotations[i].resolvedType;
            if (binding != null && (binding.tagBits & 0x20000000000000L) != 0L && (binding.tagBits & 0x4000000000L) == 0L) {
                methodDecl.scope.problemReporter().illegalUsageOfTypeAnnotations(annotations[i]);
            }
            ++i;
        }
    }

    private void createArgumentBindings(MethodBinding method, CompilerOptions compilerOptions) {
        AbstractMethodDeclaration methodDecl;
        if (!this.isPrototype()) {
            throw new IllegalStateException();
        }
        if (compilerOptions.isAnnotationBasedNullAnalysisEnabled) {
            this.getNullDefault();
        }
        if ((methodDecl = method.sourceMethod()) != null) {
            if (method.parameters != Binding.NO_PARAMETERS) {
                methodDecl.createArgumentBindings();
            }
            if (compilerOptions.isAnnotationBasedNullAnalysisEnabled) {
                new ImplicitNullAnnotationVerifier(this.scope.environment()).checkImplicitNullAnnotations(method, methodDecl, true, this.scope);
            }
        }
    }

    private void evaluateNullAnnotations(long annotationTagBits) {
        boolean isJdk18;
        boolean isInDefaultPkg;
        if (!this.isPrototype()) {
            throw new IllegalStateException();
        }
        if (this.nullnessDefaultInitialized > 0 || !this.scope.compilerOptions().isAnnotationBasedNullAnalysisEnabled) {
            return;
        }
        boolean isPackageInfo = CharOperation.equals(this.sourceName, TypeConstants.PACKAGE_INFO_NAME);
        PackageBinding pkg = this.getPackage();
        boolean bl = isInDefaultPkg = pkg.compoundName == CharOperation.NO_CHAR_CHAR;
        if (!isPackageInfo) {
            boolean isInNullnessAnnotationPackage;
            boolean bl2 = isInNullnessAnnotationPackage = pkg == this.scope.environment().nonnullAnnotationPackage || pkg == this.scope.environment().nullableAnnotationPackage || pkg == this.scope.environment().nonnullByDefaultAnnotationPackage;
            if (!(pkg.defaultNullness != 0 || isInDefaultPkg || isInNullnessAnnotationPackage || this instanceof NestedTypeBinding)) {
                ReferenceBinding packageInfo = pkg.getType(TypeConstants.PACKAGE_INFO_NAME);
                if (packageInfo == null) {
                    this.scope.problemReporter().missingNonNullByDefaultAnnotation(this.scope.referenceContext);
                    pkg.defaultNullness = 2;
                } else {
                    packageInfo.getAnnotationTagBits();
                }
            }
        }
        this.nullnessDefaultInitialized = 1;
        boolean bl3 = isJdk18 = this.scope.compilerOptions().sourceLevel >= 0x340000L;
        if (isJdk18) {
            if (this.defaultNullness != 0) {
                if (isPackageInfo) {
                    pkg.defaultNullness = this.defaultNullness;
                } else {
                    TypeDeclaration typeDecl = this.scope.referenceContext;
                    this.checkRedundantNullnessDefaultRecurse(typeDecl, typeDecl.annotations, this.defaultNullness, isJdk18);
                }
            } else if (isPackageInfo || isInDefaultPkg && !(this instanceof NestedTypeBinding)) {
                this.scope.problemReporter().missingNonNullByDefaultAnnotation(this.scope.referenceContext);
                if (!isInDefaultPkg) {
                    pkg.defaultNullness = 2;
                }
            }
        } else {
            int newDefaultNullness = 0;
            if ((annotationTagBits & 0x400000000000000L) != 0L) {
                newDefaultNullness = 2;
            } else if ((annotationTagBits & 0x200000000000000L) != 0L) {
                newDefaultNullness = 1;
            }
            if (newDefaultNullness != 0) {
                if (isPackageInfo) {
                    pkg.defaultNullness = newDefaultNullness;
                } else {
                    this.defaultNullness = newDefaultNullness;
                    TypeDeclaration typeDecl = this.scope.referenceContext;
                    long nullDefaultBits = annotationTagBits & 0x600000000000000L;
                    this.checkRedundantNullnessDefaultRecurse(typeDecl, typeDecl.annotations, nullDefaultBits, false);
                }
            } else if (isPackageInfo || isInDefaultPkg && !(this instanceof NestedTypeBinding)) {
                this.scope.problemReporter().missingNonNullByDefaultAnnotation(this.scope.referenceContext);
                if (!isInDefaultPkg) {
                    pkg.defaultNullness = 2;
                }
            }
        }
        this.maybeMarkTypeParametersNonNull();
    }

    private void maybeMarkTypeParametersNonNull() {
        if (this.scope == null || !this.scope.hasDefaultNullnessFor(128)) {
            return;
        }
        if (this.typeVariables != null && this.typeVariables.length > 0) {
            AnnotationBinding[] annots = new AnnotationBinding[]{this.environment.getNonNullAnnotation()};
            int i = 0;
            while (i < this.typeVariables.length) {
                TypeVariableBinding tvb = this.typeVariables[i];
                if ((tvb.tagBits & 0x180000000000000L) == 0L) {
                    this.typeVariables[i] = (TypeVariableBinding)this.environment.createAnnotatedType((TypeBinding)tvb, annots);
                }
                ++i;
            }
        }
    }

    protected void checkRedundantNullnessDefaultRecurse(ASTNode location, Annotation[] annotations, long nullBits, boolean isJdk18) {
        if (!this.isPrototype()) {
            throw new IllegalStateException();
        }
        if (this.fPackage.defaultNullness != 0) {
            boolean isRedundant;
            boolean bl = isJdk18 ? (long)this.fPackage.defaultNullness == nullBits : (isRedundant = this.fPackage.defaultNullness == 1 && (nullBits & 0x200000000000000L) != 0L);
            if (isRedundant) {
                this.scope.problemReporter().nullDefaultAnnotationIsRedundant(location, annotations, this.fPackage);
            }
            return;
        }
    }

    protected boolean checkRedundantNullnessDefaultOne(ASTNode location, Annotation[] annotations, long nullBits, boolean isJdk18) {
        if (!this.isPrototype()) {
            throw new IllegalStateException();
        }
        int thisDefault = this.getNullDefault();
        if (thisDefault != 0) {
            boolean isRedundant;
            boolean bl = isJdk18 ? (long)thisDefault == nullBits : (isRedundant = (nullBits & 0x200000000000000L) != 0L);
            if (isRedundant) {
                this.scope.problemReporter().nullDefaultAnnotationIsRedundant(location, annotations, this);
            }
            return false;
        }
        return true;
    }

    @Override
    boolean hasNonNullDefaultFor(int location, boolean useTypeAnnotations) {
        if (!this.isPrototype()) {
            throw new IllegalStateException();
        }
        if (useTypeAnnotations) {
            if (this.scope == null) {
                return (this.defaultNullness & location) != 0;
            }
            return this.scope.hasDefaultNullnessFor(location);
        }
        ReferenceBinding currentType = null;
        Scope currentScope = this.scope;
        while (currentScope != null) {
            switch (currentScope.kind) {
                case 2: {
                    AbstractMethodDeclaration referenceMethod = ((MethodScope)currentScope).referenceMethod();
                    if (referenceMethod == null || referenceMethod.binding == null) break;
                    long methodTagBits = referenceMethod.binding.tagBits;
                    if ((methodTagBits & 0x200000000000000L) != 0L) {
                        return true;
                    }
                    if ((methodTagBits & 0x400000000000000L) == 0L) break;
                    return false;
                }
                case 3: {
                    currentType = currentScope.referenceContext.binding;
                    if (currentType == null) break;
                    int foundDefaultNullness = ((SourceTypeBinding)currentType).getNullDefault();
                    if ((foundDefaultNullness & 0x3FA) > 2) {
                        return true;
                    }
                    if (foundDefaultNullness == 0) break;
                    return foundDefaultNullness == 1;
                }
            }
            currentScope = currentScope.parent;
        }
        if (currentType != null) {
            return currentType.getPackage().defaultNullness == 1;
        }
        return false;
    }

    @Override
    public AnnotationHolder retrieveAnnotationHolder(Binding binding, boolean forceInitialization) {
        if (!this.isPrototype()) {
            return this.prototype.retrieveAnnotationHolder(binding, forceInitialization);
        }
        if (forceInitialization) {
            binding.getAnnotationTagBits();
        }
        return super.retrieveAnnotationHolder(binding, false);
    }

    @Override
    public void setContainerAnnotationType(ReferenceBinding value) {
        if (!this.isPrototype()) {
            throw new IllegalStateException();
        }
        this.containerAnnotationType = value;
    }

    @Override
    public void tagAsHavingDefectiveContainerType() {
        if (!this.isPrototype()) {
            throw new IllegalStateException();
        }
        if (this.containerAnnotationType != null && this.containerAnnotationType.isValidBinding()) {
            this.containerAnnotationType = new ProblemReferenceBinding(this.containerAnnotationType.compoundName, this.containerAnnotationType, 22);
        }
    }

    public FieldBinding[] setFields(FieldBinding[] fields) {
        if (!this.isPrototype()) {
            return this.prototype.setFields(fields);
        }
        if ((this.tagBits & 0x800000L) != 0L) {
            TypeBinding[] annotatedTypes = this.scope.environment().getAnnotatedTypes(this);
            int i = 0;
            int length = annotatedTypes == null ? 0 : annotatedTypes.length;
            while (i < length) {
                SourceTypeBinding annotatedType = (SourceTypeBinding)annotatedTypes[i];
                annotatedType.fields = fields;
                ++i;
            }
        }
        this.fields = fields;
        return fields;
    }

    public ReferenceBinding[] setMemberTypes(ReferenceBinding[] memberTypes) {
        if (!this.isPrototype()) {
            return this.prototype.setMemberTypes(memberTypes);
        }
        this.memberTypes = memberTypes;
        if ((this.tagBits & 0x800000L) != 0L) {
            TypeBinding[] annotatedTypes = this.scope.environment().getAnnotatedTypes(this);
            int i = 0;
            int length = annotatedTypes == null ? 0 : annotatedTypes.length;
            while (i < length) {
                SourceTypeBinding annotatedType = (SourceTypeBinding)annotatedTypes[i];
                annotatedType.tagBits |= 0x10000000L;
                annotatedType.memberTypes();
                ++i;
            }
        }
        return this.memberTypes;
    }

    public MethodBinding[] setMethods(MethodBinding[] methods) {
        if (!this.isPrototype()) {
            return this.prototype.setMethods(methods);
        }
        if ((this.tagBits & 0x800000L) != 0L) {
            TypeBinding[] annotatedTypes = this.scope.environment().getAnnotatedTypes(this);
            int i = 0;
            int length = annotatedTypes == null ? 0 : annotatedTypes.length;
            while (i < length) {
                SourceTypeBinding annotatedType = (SourceTypeBinding)annotatedTypes[i];
                annotatedType.methods = methods;
                ++i;
            }
        }
        this.methods = methods;
        return methods;
    }

    public ReferenceBinding setSuperClass(ReferenceBinding superClass) {
        if (!this.isPrototype()) {
            return this.prototype.setSuperClass(superClass);
        }
        if ((this.tagBits & 0x800000L) != 0L) {
            TypeBinding[] annotatedTypes = this.scope.environment().getAnnotatedTypes(this);
            int i = 0;
            int length = annotatedTypes == null ? 0 : annotatedTypes.length;
            while (i < length) {
                SourceTypeBinding annotatedType = (SourceTypeBinding)annotatedTypes[i];
                annotatedType.superclass = superClass;
                ++i;
            }
        }
        this.superclass = superClass;
        return this.superclass;
    }

    public ReferenceBinding[] setSuperInterfaces(ReferenceBinding[] superInterfaces) {
        if (!this.isPrototype()) {
            return this.prototype.setSuperInterfaces(superInterfaces);
        }
        if ((this.tagBits & 0x800000L) != 0L) {
            TypeBinding[] annotatedTypes = this.scope.environment().getAnnotatedTypes(this);
            int i = 0;
            int length = annotatedTypes == null ? 0 : annotatedTypes.length;
            while (i < length) {
                SourceTypeBinding annotatedType = (SourceTypeBinding)annotatedTypes[i];
                annotatedType.superInterfaces = superInterfaces;
                ++i;
            }
        }
        this.superInterfaces = superInterfaces;
        return superInterfaces;
    }

    public TypeVariableBinding[] setTypeVariables(TypeVariableBinding[] typeVariables) {
        if (!this.isPrototype()) {
            return this.prototype.setTypeVariables(typeVariables);
        }
        if ((this.tagBits & 0x800000L) != 0L) {
            TypeBinding[] annotatedTypes = this.scope.environment().getAnnotatedTypes(this);
            int i = 0;
            int length = annotatedTypes == null ? 0 : annotatedTypes.length;
            while (i < length) {
                SourceTypeBinding annotatedType = (SourceTypeBinding)annotatedTypes[i];
                annotatedType.typeVariables = typeVariables;
                ++i;
            }
        }
        this.typeVariables = typeVariables;
        return typeVariables;
    }

    public final int sourceEnd() {
        if (!this.isPrototype()) {
            return this.prototype.sourceEnd();
        }
        return this.scope.referenceContext.sourceEnd;
    }

    public final int sourceStart() {
        if (!this.isPrototype()) {
            return this.prototype.sourceStart();
        }
        return this.scope.referenceContext.sourceStart;
    }

    @Override
    SimpleLookupTable storedAnnotations(boolean forceInitialize) {
        if (!this.isPrototype()) {
            return this.prototype.storedAnnotations(forceInitialize);
        }
        if (forceInitialize && this.storedAnnotations == null && this.scope != null) {
            this.scope.referenceCompilationUnit().compilationResult.hasAnnotations = true;
            CompilerOptions globalOptions = this.scope.environment().globalOptions;
            if (!globalOptions.storeAnnotations) {
                return null;
            }
            this.storedAnnotations = new SimpleLookupTable(3);
        }
        return this.storedAnnotations;
    }

    @Override
    public ReferenceBinding superclass() {
        if (!this.isPrototype()) {
            this.superclass = this.prototype.superclass();
            return this.superclass;
        }
        return this.superclass;
    }

    @Override
    public ReferenceBinding[] superInterfaces() {
        ReferenceBinding[] referenceBindingArray;
        if (!this.isPrototype()) {
            this.superInterfaces = this.prototype.superInterfaces();
            return this.superInterfaces;
        }
        if (this.superInterfaces != null) {
            referenceBindingArray = this.superInterfaces;
        } else if (this.isAnnotationType()) {
            this.superInterfaces = new ReferenceBinding[]{this.scope.getJavaLangAnnotationAnnotation()};
            referenceBindingArray = this.superInterfaces;
        } else {
            referenceBindingArray = null;
        }
        return referenceBindingArray;
    }

    public SyntheticMethodBinding[] syntheticMethods() {
        if (!this.isPrototype()) {
            throw new IllegalStateException();
        }
        if (this.synthetics == null || this.synthetics[0] == null || this.synthetics[0].size() == 0) {
            return null;
        }
        int index = 0;
        SyntheticMethodBinding[] bindings = new SyntheticMethodBinding[1];
        for (SyntheticMethodBinding[] methodAccessors : this.synthetics[0].values()) {
            int i = 0;
            int max = methodAccessors.length;
            while (i < max) {
                if (methodAccessors[i] != null) {
                    if (index + 1 > bindings.length) {
                        SyntheticMethodBinding[] syntheticMethodBindingArray = bindings;
                        bindings = new SyntheticMethodBinding[index + 1];
                        System.arraycopy(syntheticMethodBindingArray, 0, bindings, 0, index);
                    }
                    bindings[index++] = methodAccessors[i];
                }
                ++i;
            }
        }
        int length = bindings.length;
        SyntheticMethodBinding[] sortedBindings = new SyntheticMethodBinding[length];
        int i = 0;
        while (i < length) {
            SyntheticMethodBinding binding;
            sortedBindings[binding.index] = binding = bindings[i];
            ++i;
        }
        return sortedBindings;
    }

    public FieldBinding[] syntheticFields() {
        SyntheticFieldBinding synthBinding;
        int i;
        Iterator elements;
        int literalSize;
        if (!this.isPrototype()) {
            throw new IllegalStateException();
        }
        if (this.synthetics == null) {
            return null;
        }
        int fieldSize = this.synthetics[1] == null ? 0 : this.synthetics[1].size();
        int totalSize = fieldSize + (literalSize = this.synthetics[2] == null ? 0 : this.synthetics[2].size());
        if (totalSize == 0) {
            return null;
        }
        FieldBinding[] bindings = new FieldBinding[totalSize];
        if (this.synthetics[1] != null) {
            elements = this.synthetics[1].values().iterator();
            i = 0;
            while (i < fieldSize) {
                synthBinding = (SyntheticFieldBinding)elements.next();
                bindings[synthBinding.index] = synthBinding;
                ++i;
            }
        }
        if (this.synthetics[2] != null) {
            elements = this.synthetics[2].values().iterator();
            i = 0;
            while (i < literalSize) {
                synthBinding = (SyntheticFieldBinding)elements.next();
                bindings[fieldSize + synthBinding.index] = synthBinding;
                ++i;
            }
        }
        return bindings;
    }

    public String toString() {
        int length;
        int i;
        if (this.hasTypeAnnotations()) {
            return this.annotatedDebugName();
        }
        StringBuffer buffer = new StringBuffer(30);
        buffer.append("(id=");
        if (this.id == Integer.MAX_VALUE) {
            buffer.append("NoId");
        } else {
            buffer.append(this.id);
        }
        buffer.append(")\n");
        if (this.isDeprecated()) {
            buffer.append("deprecated ");
        }
        if (this.isPublic()) {
            buffer.append("public ");
        }
        if (this.isProtected()) {
            buffer.append("protected ");
        }
        if (this.isPrivate()) {
            buffer.append("private ");
        }
        if (this.isAbstract() && this.isClass()) {
            buffer.append("abstract ");
        }
        if (this.isStatic() && this.isNestedType()) {
            buffer.append("static ");
        }
        if (this.isFinal()) {
            buffer.append("final ");
        }
        if (this.isEnum()) {
            buffer.append("enum ");
        } else if (this.isAnnotationType()) {
            buffer.append("@interface ");
        } else if (this.isClass()) {
            buffer.append("class ");
        } else {
            buffer.append("interface ");
        }
        buffer.append(this.compoundName != null ? CharOperation.toString(this.compoundName) : "UNNAMED TYPE");
        if (this.typeVariables == null) {
            buffer.append("<NULL TYPE VARIABLES>");
        } else if (this.typeVariables != Binding.NO_TYPE_VARIABLES) {
            buffer.append("<");
            i = 0;
            length = this.typeVariables.length;
            while (i < length) {
                if (i > 0) {
                    buffer.append(", ");
                }
                if (this.typeVariables[i] == null) {
                    buffer.append("NULL TYPE VARIABLE");
                } else {
                    char[] varChars = this.typeVariables[i].toString().toCharArray();
                    buffer.append(varChars, 1, varChars.length - 2);
                }
                ++i;
            }
            buffer.append(">");
        }
        buffer.append("\n\textends ");
        buffer.append(this.superclass != null ? this.superclass.debugName() : "NULL TYPE");
        if (this.superInterfaces != null) {
            if (this.superInterfaces != Binding.NO_SUPERINTERFACES) {
                buffer.append("\n\timplements : ");
                i = 0;
                length = this.superInterfaces.length;
                while (i < length) {
                    if (i > 0) {
                        buffer.append(", ");
                    }
                    buffer.append(this.superInterfaces[i] != null ? this.superInterfaces[i].debugName() : "NULL TYPE");
                    ++i;
                }
            }
        } else {
            buffer.append("NULL SUPERINTERFACES");
        }
        if (this.enclosingType() != null) {
            buffer.append("\n\tenclosing type : ");
            buffer.append(this.enclosingType().debugName());
        }
        if (this.fields != null) {
            if (this.fields != Binding.NO_FIELDS) {
                buffer.append("\n/*   fields   */");
                i = 0;
                length = this.fields.length;
                while (i < length) {
                    buffer.append('\n').append(this.fields[i] != null ? this.fields[i].toString() : "NULL FIELD");
                    ++i;
                }
            }
        } else {
            buffer.append("NULL FIELDS");
        }
        if (this.methods != null) {
            if (this.methods != Binding.NO_METHODS) {
                buffer.append("\n/*   methods   */");
                i = 0;
                length = this.methods.length;
                while (i < length) {
                    buffer.append('\n').append(this.methods[i] != null ? this.methods[i].toString() : "NULL METHOD");
                    ++i;
                }
            }
        } else {
            buffer.append("NULL METHODS");
        }
        if (this.memberTypes != null) {
            if (this.memberTypes != Binding.NO_MEMBER_TYPES) {
                buffer.append("\n/*   members   */");
                i = 0;
                length = this.memberTypes.length;
                while (i < length) {
                    buffer.append('\n').append(this.memberTypes[i] != null ? this.memberTypes[i].toString() : "NULL TYPE");
                    ++i;
                }
            }
        } else {
            buffer.append("NULL MEMBER TYPES");
        }
        buffer.append("\n\n");
        return buffer.toString();
    }

    @Override
    public TypeVariableBinding[] typeVariables() {
        if (!this.isPrototype()) {
            this.typeVariables = this.prototype.typeVariables();
            return this.typeVariables;
        }
        return this.typeVariables != null ? this.typeVariables : Binding.NO_TYPE_VARIABLES;
    }

    void verifyMethods(MethodVerifier verifier) {
        if (!this.isPrototype()) {
            throw new IllegalStateException();
        }
        verifier.verify(this);
        int i = this.memberTypes.length;
        while (--i >= 0) {
            ((SourceTypeBinding)this.memberTypes[i]).verifyMethods(verifier);
        }
    }

    @Override
    public TypeBinding unannotated(boolean removeOnlyNullAnnotations) {
        if (removeOnlyNullAnnotations) {
            if (!this.hasNullTypeAnnotations()) {
                return this;
            }
            AnnotationBinding[] newAnnotations = this.environment.filterNullTypeAnnotations(this.typeAnnotations);
            if (newAnnotations.length > 0) {
                return this.environment.createAnnotatedType((TypeBinding)this.prototype, newAnnotations);
            }
        }
        return this.prototype;
    }

    @Override
    public FieldBinding[] unResolvedFields() {
        if (!this.isPrototype()) {
            return this.prototype.unResolvedFields();
        }
        return this.fields;
    }

    public void tagIndirectlyAccessibleMembers() {
        if (!this.isPrototype()) {
            this.prototype.tagIndirectlyAccessibleMembers();
            return;
        }
        int i = 0;
        while (i < this.fields.length) {
            if (!this.fields[i].isPrivate()) {
                this.fields[i].modifiers |= 0x8000000;
            }
            ++i;
        }
        i = 0;
        while (i < this.memberTypes.length) {
            if (!this.memberTypes[i].isPrivate()) {
                this.memberTypes[i].modifiers |= 0x8000000;
            }
            ++i;
        }
        if (this.superclass.isPrivate() && this.superclass instanceof SourceTypeBinding) {
            ((SourceTypeBinding)this.superclass).tagIndirectlyAccessibleMembers();
        }
    }
}

