/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jdt.groovy.internal.compiler.ast;

import groovy.lang.GroovyClassLoader;
import java.beans.Introspector;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import org.codehaus.groovy.GroovyBugError;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.InnerClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.transform.trait.Traits;
import org.codehaus.groovy.vmplugin.v5.Java5;
import org.codehaus.jdt.groovy.internal.compiler.ast.GroovyCompilationUnitDeclaration;
import org.codehaus.jdt.groovy.internal.compiler.ast.GroovyTypeDeclaration;
import org.codehaus.jdt.groovy.internal.compiler.ast.JDTAnnotationNode;
import org.codehaus.jdt.groovy.internal.compiler.ast.JDTClassNodeBuilder;
import org.codehaus.jdt.groovy.internal.compiler.ast.JDTFieldNode;
import org.codehaus.jdt.groovy.internal.compiler.ast.JDTMethodNode;
import org.codehaus.jdt.groovy.internal.compiler.ast.JDTNode;
import org.codehaus.jdt.groovy.internal.compiler.ast.JDTResolver;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.groovy.core.util.ArrayUtils;
import org.eclipse.jdt.groovy.core.util.ReflectionUtils;
import org.eclipse.jdt.groovy.search.AccessorSupport;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.impl.BooleanConstant;
import org.eclipse.jdt.internal.compiler.impl.ByteConstant;
import org.eclipse.jdt.internal.compiler.impl.CharConstant;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.impl.DoubleConstant;
import org.eclipse.jdt.internal.compiler.impl.FloatConstant;
import org.eclipse.jdt.internal.compiler.impl.IntConstant;
import org.eclipse.jdt.internal.compiler.impl.LongConstant;
import org.eclipse.jdt.internal.compiler.impl.ShortConstant;
import org.eclipse.jdt.internal.compiler.impl.StringConstant;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LazilyResolvedMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MemberTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.RawTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.SyntheticMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;

public class JDTClassNode
extends ClassNode
implements JDTNode {
    private volatile int bits;
    private boolean beingInitialized;
    private boolean anyGenericsInitialized;
    private GroovyTypeDeclaration groovyTypeDecl;
    private ReferenceBinding jdtBinding;
    private final JDTResolver resolver;
    private boolean unfindable;

    @Override
    public ReferenceBinding getJdtBinding() {
        return this.jdtBinding;
    }

    public void setJdtBinding(ReferenceBinding jdtBinding) {
        this.jdtBinding = jdtBinding;
    }

    @Override
    public JDTResolver getResolver() {
        return this.resolver;
    }

    public JDTClassNode(ReferenceBinding jdtReferenceBinding, JDTResolver resolver) {
        super(JDTClassNode.getName(jdtReferenceBinding), JDTClassNode.getMods(jdtReferenceBinding), null);
        this.jdtBinding = jdtReferenceBinding;
        this.resolver = resolver;
        this.lazyInitDone = false;
        this.isPrimaryNode = false;
    }

    private static String getName(TypeBinding tb) {
        if (tb instanceof ArrayBinding) {
            return String.valueOf(((ArrayBinding)tb).signature());
        }
        if (tb instanceof MemberTypeBinding) {
            MemberTypeBinding mtb = (MemberTypeBinding)tb;
            return CharOperation.toString(mtb.compoundName);
        }
        if (tb instanceof ReferenceBinding) {
            return CharOperation.toString(((ReferenceBinding)tb).compoundName);
        }
        return String.valueOf(tb.sourceName());
    }

    private static int getMods(TypeBinding tb) {
        if (tb instanceof ReferenceBinding) {
            return ((ReferenceBinding)tb).modifiers;
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lazyClassInit() {
        Object object = this.lazyInitLock;
        synchronized (object) {
            if (this.lazyInitDone) {
                return;
            }
            this.initialize();
            this.lazyInitDone = true;
        }
    }

    private void initialize() {
        if (this.beingInitialized) {
            return;
        }
        try {
            ReferenceBinding[] superInterfaceBindings;
            ReferenceBinding superClass;
            this.beingInitialized = true;
            if (!this.jdtBinding.isInterface() && (superClass = this.jdtBinding.superclass()) != null) {
                this.setUnresolvedSuperClass(this.resolver.convertToClassNode(superClass));
            }
            if ((superInterfaceBindings = this.jdtBinding.superInterfaces()) == null) {
                superInterfaceBindings = Binding.NO_SUPERINTERFACES;
            }
            int n = superInterfaceBindings.length;
            ClassNode[] interfaces = new ClassNode[n];
            int i = 0;
            while (i < n) {
                interfaces[i] = this.resolver.convertToClassNode(superInterfaceBindings[i]);
                ++i;
            }
            this.setInterfaces(interfaces);
            this.initializeMembers();
        }
        finally {
            this.beingInitialized = false;
        }
    }

    private void initializeMembers() {
        if (this.jdtBinding instanceof SourceTypeBinding) {
            TypeDeclaration typeDecl;
            SourceTypeBinding sourceTypeBinding = (SourceTypeBinding)this.jdtBinding;
            if (sourceTypeBinding.scope != null && (typeDecl = sourceTypeBinding.scope.referenceContext) instanceof GroovyTypeDeclaration) {
                this.groovyTypeDecl = (GroovyTypeDeclaration)typeDecl;
            }
        }
        if (this.isRedirectNode()) {
            return;
        }
        try {
            SourceTypeBinding jdtSourceTypeBinding;
            int n;
            MethodBinding[] methodBindings;
            if (this.jdtBinding instanceof ParameterizedTypeBinding) {
                ReferenceBinding genericType = ((ParameterizedTypeBinding)this.jdtBinding).genericType();
                methodBindings = genericType.methods();
            } else {
                methodBindings = this.jdtBinding.methods();
            }
            if (methodBindings != null) {
                MethodBinding[] methodBindingArray = methodBindings;
                n = methodBindings.length;
                int n2 = 0;
                while (n2 < n) {
                    MethodBinding methodBinding = methodBindingArray[n2];
                    if (methodBinding.isConstructor()) {
                        ConstructorNode cNode = this.constructorBindingToConstructorNode(methodBinding);
                        this.addConstructor(cNode);
                    } else {
                        MethodNode mNode = this.methodBindingToMethodNode(methodBinding);
                        this.addMethod(mNode);
                    }
                    ++n2;
                }
            }
            if (this.jdtBinding instanceof BinaryTypeBinding) {
                MethodBinding[] infraBindings;
                MethodBinding[] methodBindingArray = infraBindings = ((BinaryTypeBinding)this.jdtBinding).infraMethods();
                int n3 = infraBindings.length;
                n = 0;
                while (n < n3) {
                    MethodBinding methodBinding = methodBindingArray[n];
                    if (methodBinding.isConstructor()) {
                        ConstructorNode cNode = this.constructorBindingToConstructorNode(methodBinding);
                        this.addConstructor(cNode);
                    } else {
                        MethodNode mNode = this.methodBindingToMethodNode(methodBinding);
                        this.addMethod(mNode);
                    }
                    ++n;
                }
            } else if (this.jdtBinding instanceof SourceTypeBinding && (this.jdtBinding.tagBits & 0x80L) == 0L && (jdtSourceTypeBinding = (SourceTypeBinding)this.jdtBinding).isPrototype()) {
                SyntheticMethodBinding[] syntheticMethodBindings;
                ClassScope classScope = jdtSourceTypeBinding.scope;
                if (classScope != null) {
                    CompilationUnitScope cuScope = classScope.compilationUnitScope();
                    LookupEnvironment environment = classScope.environment();
                    cuScope.verifyMethods(environment.methodVerifier());
                }
                if ((syntheticMethodBindings = jdtSourceTypeBinding.syntheticMethods()) != null) {
                    SyntheticMethodBinding[] syntheticMethodBindingArray = syntheticMethodBindings;
                    int mNode = syntheticMethodBindings.length;
                    int n4 = 0;
                    while (n4 < mNode) {
                        SyntheticMethodBinding syntheticBinding = syntheticMethodBindingArray[n4];
                        if (syntheticBinding.isConstructor()) {
                            ConstructorNode cNode = this.constructorBindingToConstructorNode(syntheticBinding);
                            this.addConstructor(cNode);
                        } else {
                            MethodNode mNode2 = this.methodBindingToMethodNode(syntheticBinding);
                            this.addMethod(mNode2);
                        }
                        ++n4;
                    }
                }
            }
            FieldBinding[] fieldBindings = this.jdtBinding instanceof ParameterizedTypeBinding ? ((ParameterizedTypeBinding)this.jdtBinding).genericType().fields() : this.jdtBinding.fields();
            if (fieldBindings != null) {
                FieldBinding[] fieldBindingArray = fieldBindings;
                int n5 = fieldBindings.length;
                int n6 = 0;
                while (n6 < n5) {
                    FieldBinding fieldBinding = fieldBindingArray[n6];
                    FieldNode fNode = this.fieldBindingToFieldNode(fieldBinding, this.groovyTypeDecl);
                    this.addField(fNode);
                    ++n6;
                }
            }
        }
        catch (AbortCompilation e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Failed to initialize members for type " + this.getName(), e);
        }
    }

    private MethodNode methodBindingToMethodNode(MethodBinding methodBinding) {
        try {
            int nExceptions;
            int modifiers = methodBinding.modifiers;
            if (!(!this.jdtBinding.isInterface() || Flags.isStatic(modifiers) || Flags.isSynthetic(modifiers) || Flags.isDefaultMethod(modifiers) || Traits.isTrait(this))) {
                modifiers |= 0x400;
            }
            ClassNode returnType = methodBinding.returnType != null ? this.resolver.convertToClassNode(methodBinding.returnType) : ClassHelper.DYNAMIC_TYPE;
            Parameter[] parameters = this.makeParameters(methodBinding.parameters, methodBinding.parameterNames);
            AnnotationBinding[][] parameterAnnotations = methodBinding.getParameterAnnotations();
            if (parameterAnnotations != null) {
                int i = 0;
                int n = parameters.length;
                while (i < n) {
                    AnnotationBinding[] annotationBindingArray = parameterAnnotations[i];
                    int n2 = annotationBindingArray.length;
                    int n3 = 0;
                    while (n3 < n2) {
                        AnnotationBinding annotationBinding = annotationBindingArray[n3];
                        parameters[i].addAnnotation(new JDTAnnotationNode(annotationBinding, this.resolver));
                        ++n3;
                    }
                    ++i;
                }
            }
            ClassNode[] exceptions = ClassNode.EMPTY_ARRAY;
            if (methodBinding.thrownExceptions != null && (nExceptions = methodBinding.thrownExceptions.length) > 0) {
                exceptions = new ClassNode[nExceptions];
                int i = 0;
                while (i < nExceptions) {
                    exceptions[i] = this.resolver.convertToClassNode(methodBinding.thrownExceptions[i]);
                    ++i;
                }
            }
            JDTMethodNode methodNode = new JDTMethodNode(methodBinding, this.resolver, String.valueOf(methodBinding.selector), modifiers, returnType, parameters, exceptions, null);
            methodNode.setGenericsTypes(new JDTClassNodeBuilder(this.resolver).configureTypeVariables(methodBinding.typeVariables()));
            methodNode.setSynthetic(methodBinding instanceof LazilyResolvedMethodBinding);
            return methodNode;
        }
        catch (AbortCompilation e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new IllegalStateException("Failed to resolve method node for " + String.valueOf(CharOperation.concatWith(this.jdtBinding.compoundName, methodBinding.selector, '.')), e);
        }
    }

    private Parameter[] makeParameters(TypeBinding[] parameterTypes, char[][] parameterNames) {
        int nParameters;
        Parameter[] parameters = Parameter.EMPTY_ARRAY;
        if (parameterTypes != null && (nParameters = parameterTypes.length) > 0) {
            parameters = new Parameter[nParameters];
            int i = 0;
            while (i < nParameters) {
                String parameterName = i < parameterNames.length ? String.valueOf(parameterNames[i]) : (i < Java5.ARGS.length ? Java5.ARGS[i] : "arg" + i);
                parameters[i] = this.makeParameter(parameterTypes[i], parameterName);
                ++i;
            }
        }
        return parameters;
    }

    private Parameter makeParameter(TypeBinding parameterType, String parameterName) {
        TypeBinding erasureType = parameterType instanceof ParameterizedTypeBinding ? ((ParameterizedTypeBinding)parameterType).genericType() : new JDTClassNodeBuilder(this.resolver).toRawType(parameterType);
        return new Parameter(this.makeClassNode(parameterType, erasureType), parameterName);
    }

    private ClassNode makeClassNode(TypeBinding t, TypeBinding c) {
        ClassNode back = this.resolver.convertToClassNode(c);
        if (!(t instanceof BinaryTypeBinding) && !(t instanceof SourceTypeBinding)) {
            ClassNode front = new JDTClassNodeBuilder(this.resolver).configureType(t);
            JDTClassNodeBuilder.setRedirect(front, back);
            return front;
        }
        return back;
    }

    private ConstructorNode constructorBindingToConstructorNode(MethodBinding methodBinding) {
        int modifiers = methodBinding.modifiers;
        Parameter[] parameters = this.makeParameters(methodBinding.parameters, methodBinding.parameterNames);
        ClassNode[] thrownExceptions = ClassNode.EMPTY_ARRAY;
        if (methodBinding.thrownExceptions != null) {
            thrownExceptions = new ClassNode[methodBinding.thrownExceptions.length];
            int i = 0;
            int n = methodBinding.thrownExceptions.length;
            while (i < n) {
                thrownExceptions[i] = this.resolver.convertToClassNode(methodBinding.thrownExceptions[i]);
                ++i;
            }
        }
        ConstructorNode ctorNode = new ConstructorNode(modifiers, parameters, thrownExceptions, null);
        ctorNode.setGenericsTypes(new JDTClassNodeBuilder(this.resolver).configureTypeVariables(methodBinding.typeVariables()));
        return ctorNode;
    }

    private FieldNode fieldBindingToFieldNode(FieldBinding fieldBinding, TypeDeclaration groovyTypeDecl) {
        String name = String.valueOf(fieldBinding.name);
        int modifiers = fieldBinding.modifiers;
        ClassNode fieldType = this.resolver.convertToClassNode(fieldBinding.type);
        Constant c = fieldBinding.constant();
        Expression initializerExpression = null;
        if (c == Constant.NotAConstant) {
            FieldDeclaration fieldDecl;
            if (groovyTypeDecl != null && (fieldDecl = groovyTypeDecl.declarationOf(fieldBinding)) instanceof GroovyCompilationUnitDeclaration.FieldDeclarationWithInitializer) {
                initializerExpression = ((GroovyCompilationUnitDeclaration.FieldDeclarationWithInitializer)fieldDecl).getGroovyInitializer();
            }
        } else if (c instanceof StringConstant) {
            initializerExpression = new ConstantExpression(((StringConstant)c).stringValue());
        } else if (c instanceof BooleanConstant) {
            initializerExpression = new ConstantExpression(((BooleanConstant)c).booleanValue());
        } else if (c instanceof IntConstant) {
            initializerExpression = new ConstantExpression(((IntConstant)c).intValue());
        } else if (c instanceof LongConstant) {
            initializerExpression = new ConstantExpression(((LongConstant)c).longValue());
        } else if (c instanceof DoubleConstant) {
            initializerExpression = new ConstantExpression(((DoubleConstant)c).doubleValue());
        } else if (c instanceof FloatConstant) {
            initializerExpression = new ConstantExpression(Float.valueOf(((FloatConstant)c).floatValue()));
        } else if (c instanceof ByteConstant) {
            initializerExpression = new ConstantExpression(((ByteConstant)c).byteValue());
        } else if (c instanceof CharConstant) {
            initializerExpression = new ConstantExpression(Character.valueOf(((CharConstant)c).charValue()));
        } else if (c instanceof ShortConstant) {
            initializerExpression = new ConstantExpression(((ShortConstant)c).shortValue());
        }
        JDTFieldNode fNode = new JDTFieldNode(fieldBinding, this.resolver, name, modifiers, fieldType, this, initializerExpression);
        return fNode;
    }

    @Override
    public String getClassInternalName() {
        return this.getName().replace('.', '/');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AnnotationNode> getAnnotations() {
        if ((this.bits & 1) == 0) {
            JDTClassNode jDTClassNode = this;
            synchronized (jDTClassNode) {
                if ((this.bits & 1) == 0) {
                    if (this.jdtBinding instanceof SourceTypeBinding) {
                        long l = ((SourceTypeBinding)this.jdtBinding).getAnnotationTagBits();
                    }
                    AnnotationBinding[] annotationBindingArray = this.jdtBinding.getAnnotations();
                    int n = annotationBindingArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        AnnotationBinding annotationBinding = annotationBindingArray[n2];
                        this.addAnnotation(new JDTAnnotationNode(annotationBinding, this.resolver));
                        ++n2;
                    }
                    this.bits |= 1;
                }
            }
        }
        return Collections.unmodifiableList(super.getAnnotations());
    }

    @Override
    public List<AnnotationNode> getAnnotations(ClassNode type) {
        if ((this.bits & 1) == 0) {
            List<AnnotationNode> list = this.getAnnotations();
        }
        return Collections.unmodifiableList(super.getAnnotations(type));
    }

    @Override
    public GenericsType[] getGenericsTypes() {
        if (!this.anyGenericsInitialized) {
            this.setUpGenerics();
        }
        return super.getGenericsTypes();
    }

    @Override
    public boolean isUsingGenerics() {
        if (!this.anyGenericsInitialized) {
            this.setUpGenerics();
        }
        return super.isUsingGenerics();
    }

    @Override
    public void setUsingGenerics(boolean b) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setGenericsPlaceHolder(boolean b) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setGenericsTypes(GenericsType[] genericsTypes) {
        this.anyGenericsInitialized = true;
        super.setGenericsTypes(genericsTypes);
    }

    void setUpGenerics() {
        if (!this.anyGenericsInitialized) {
            GenericsType[] generics = this.jdtBinding instanceof RawTypeBinding ? null : (this.jdtBinding instanceof ParameterizedTypeBinding ? new JDTClassNodeBuilder(this.resolver).configureTypeArguments(((ParameterizedTypeBinding)this.jdtBinding).arguments) : new JDTClassNodeBuilder(this.resolver).configureTypeVariables(this.jdtBinding.typeVariables()));
            this.setGenericsTypes(generics);
        }
    }

    @Override
    public void addProperty(PropertyNode node) {
        throw new UnsupportedOperationException("JDTClassNode is immutable, should not be called to add property: " + node.getName());
    }

    @Override
    public PropertyNode addProperty(String name, int modifiers, ClassNode type, Expression initialValueExpression, Statement getterBlock, Statement setterBlock) {
        throw new UnsupportedOperationException("JDTClassNode is immutable, should not be called to add property: " + name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PropertyNode> getProperties() {
        if ((this.bits & 4) == 0) {
            JDTClassNode jDTClassNode = this;
            synchronized (jDTClassNode) {
                if ((this.bits & 4) == 0) {
                    this.lazyClassInit();
                    if (this.groovyTypeDecl != null) {
                        HashSet names = new HashSet();
                        List<PropertyNode> nodes = super.getProperties();
                        this.getMethods().stream().filter(AccessorSupport::isGetter).forEach(methodNode -> {
                            String methodName;
                            String propertyName = Introspector.decapitalize(methodName.substring((methodName = methodNode.getName()).startsWith("is") ? 2 : 3));
                            if (names.add(propertyName)) {
                                boolean synth;
                                FieldNode field = this.getField(propertyName);
                                boolean bl = synth = field == null;
                                if (synth) {
                                    field = new FieldNode(propertyName, methodNode.getModifiers(), methodNode.getReturnType(), this, null);
                                    field.setDeclaringClass(this);
                                    field.setSynthetic(true);
                                }
                                PropertyNode property = new PropertyNode(field, methodNode.getModifiers(), null, null);
                                property.setDeclaringClass(this);
                                property.setSynthetic(synth);
                                nodes.add(property);
                            }
                        });
                    }
                    this.bits |= 4;
                }
            }
        }
        return Collections.unmodifiableList(super.getProperties());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<InnerClassNode> getInnerClasses() {
        if ((this.bits & 2) == 0) {
            JDTClassNode jDTClassNode = this;
            synchronized (jDTClassNode) {
                if ((this.bits & 2) == 0) {
                    this.bits |= 2;
                    if (this.mightHaveInners()) {
                        if (this.jdtBinding instanceof BinaryTypeBinding && this.jdtBinding == this.jdtBinding.prototype() && Traits.isTrait(this)) {
                            Object[] memberTypes = (ReferenceBinding[])ReflectionUtils.getPrivateField(BinaryTypeBinding.class, "memberTypes", this.jdtBinding);
                            int i = 0;
                            while (i < memberTypes.length) {
                                if (String.valueOf(memberTypes[i].sourceName).endsWith("$Trait$FieldHelper$1")) {
                                    memberTypes = (ReferenceBinding[])ArrayUtils.remove(memberTypes, i--);
                                }
                                ++i;
                            }
                            ReflectionUtils.setPrivateField(BinaryTypeBinding.class, "memberTypes", this.jdtBinding, memberTypes);
                        }
                        Stream.of(this.jdtBinding.memberTypes()).map(this.resolver::convertToClassNode).forEach(cn -> {
                            InnerClassNode innerClassNode = new InnerClassNode(this, cn.getName(), cn.getModifiers(), cn.getSuperClass(), (ClassNode)cn){
                                {
                                    this.isPrimaryNode = false;
                                    this.setRedirect(classNode);
                                }
                            };
                        });
                    }
                }
            }
        }
        return (this.innerClasses == null ? Collections.EMPTY_LIST : Collections.unmodifiableList(this.innerClasses)).iterator();
    }

    @Override
    public ClassNode getOuterClass() {
        if (this.jdtBinding.isNestedType()) {
            return this.resolver.convertToClassNode(this.jdtBinding.enclosingType());
        }
        return super.getOuterClass();
    }

    @Override
    public FieldNode getOuterField(String name) {
        return this.getOuterClass().getDeclaredField(name);
    }

    @Override
    public Class getTypeClass() {
        if (this.clazz != null || this.unfindable) {
            return this.clazz;
        }
        GroovyClassLoader transformLoader = this.resolver.compilationUnit.getTransformLoader();
        if (transformLoader != null) {
            try {
                this.clazz = Class.forName(this.getName(), false, transformLoader);
                return this.clazz;
            }
            catch (ClassNotFoundException e) {
                this.unfindable = true;
            }
        }
        throw new GroovyBugError("JDTClassNode.getTypeClass() cannot locate class for " + this.getName() + " using transform loader " + transformLoader);
    }

    public boolean isAnonymous() {
        return this.jdtBinding.isAnonymousType();
    }

    @Override
    public boolean isDeprecated() {
        return this.jdtBinding.isDeprecated();
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    @Override
    public boolean isResolved() {
        return true;
    }

    @Override
    public boolean mightHaveInners() {
        return this.jdtBinding.hasMemberTypes();
    }
}

