/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jdt.groovy.internal.compiler.ast;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Optional;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.runtime.MetaClassHelper;
import org.codehaus.jdt.groovy.internal.compiler.ast.EventListener;
import org.codehaus.jdt.groovy.internal.compiler.ast.GroovyCompilationUnitScope;
import org.codehaus.jdt.groovy.internal.compiler.ast.GroovyTypeDeclaration;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.QualifiedAllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.jdt.internal.compiler.lookup.ImportBinding;
import org.eclipse.jdt.internal.compiler.lookup.LazilyResolvedMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;

public class GroovyClassScope
extends ClassScope {
    public static EventListener debugListener;
    private final TraitHelper traitHelper = new TraitHelper();

    public GroovyClassScope(Scope parent, TypeDeclaration typeDecl) {
        super(parent, typeDecl);
    }

    public final ReferenceBinding getGroovyLangMetaClassBinding() {
        CompilationUnitScope unitScope = this.compilationUnitScope();
        unitScope.recordQualifiedReference(GroovyCompilationUnitScope.GROOVY_LANG_METACLASS);
        return unitScope.environment.getResolvedType(GroovyCompilationUnitScope.GROOVY_LANG_METACLASS, this);
    }

    @Override
    protected MethodBinding[] augmentMethodBindings(MethodBinding[] methodBindings) {
        SourceTypeBinding typeBinding = this.referenceContext.binding;
        if (typeBinding == null || typeBinding.isInterface() || typeBinding.isAnnotationType()) {
            return methodBindings;
        }
        ReferenceBinding[] superInterfaces = typeBinding.superInterfaces != null ? typeBinding.superInterfaces : Binding.NO_SUPERINTERFACES;
        boolean implementsGroovyLangObject = false;
        ReferenceBinding[] referenceBindingArray = superInterfaces;
        int n = superInterfaces.length;
        int n2 = 0;
        while (n2 < n) {
            ReferenceBinding face = referenceBindingArray[n2];
            if (CharOperation.equals(face.compoundName, GroovyCompilationUnitScope.GROOVY_LANG_GROOVYOBJECT)) {
                implementsGroovyLangObject = true;
                break;
            }
            ++n2;
        }
        ArrayList<MethodBinding> groovyMethods = new ArrayList<MethodBinding>();
        if (implementsGroovyLangObject) {
            if (debugListener != null) {
                debugListener.record("augment: type " + String.valueOf(this.referenceContext.name) + " having GroovyObject methods added");
            }
            ReferenceBinding bindingJLO = this.getJavaLangObject();
            ReferenceBinding bindingJLS = this.getJavaLangString();
            ReferenceBinding bindingGLM = this.getGroovyLangMetaClassBinding();
            this.createMethod("invokeMethod", false, new TypeBinding[]{bindingJLS, bindingJLO}, bindingJLO, methodBindings).ifPresent(groovyMethods::add);
            this.createMethod("getProperty", false, new TypeBinding[]{bindingJLS}, bindingJLO, methodBindings).ifPresent(groovyMethods::add);
            this.createMethod("setProperty", false, new TypeBinding[]{bindingJLS, bindingJLO}, TypeBinding.VOID, methodBindings).ifPresent(groovyMethods::add);
            this.createMethod("getMetaClass", false, Binding.NO_TYPES, bindingGLM, methodBindings).ifPresent(groovyMethods::add);
            this.createMethod("setMetaClass", false, new TypeBinding[]{bindingGLM}, TypeBinding.VOID, methodBindings).ifPresent(groovyMethods::add);
        }
        if (this.referenceContext instanceof GroovyTypeDeclaration) {
            for (PropertyNode property : ((GroovyTypeDeclaration)this.referenceContext).getClassNode().getProperties()) {
                String name = property.getName();
                String capitalizedName = MetaClassHelper.capitalize(name);
                this.createGetterMethod(name, "get" + capitalizedName, property.isStatic(), methodBindings).ifPresent(groovyMethods::add);
                if (ClassHelper.boolean_TYPE.equals(property.getType())) {
                    this.createGetterMethod(name, "is" + capitalizedName, property.isStatic(), methodBindings).ifPresent(groovyMethods::add);
                }
                if (Modifier.isFinal(property.getModifiers())) continue;
                this.createSetterMethod(name, "set" + capitalizedName, property.isStatic(), property.getType().getName(), methodBindings).ifPresent(groovyMethods::add);
            }
        }
        HashMap<String, MethodBinding> traitMethods = new HashMap<String, MethodBinding>();
        ReferenceBinding[] referenceBindingArray2 = superInterfaces;
        int capitalizedName = superInterfaces.length;
        int name = 0;
        while (name < capitalizedName) {
            ReferenceBinding face = referenceBindingArray2[name];
            if (this.traitHelper.isTrait(face)) {
                ReferenceBinding helperBinding = this.traitHelper.getHelperBinding(face);
                MethodBinding[] methodBindingArray = face.availableMethods();
                int n3 = methodBindingArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    MethodBinding method = methodBindingArray[n4];
                    if (!method.isPrivate() && !method.isStatic() && this.isNotActuallyAbstract(method, helperBinding)) {
                        traitMethods.put(this.getMethodAsString(method), method);
                    }
                    ++n4;
                }
            }
            ++name;
        }
        if (!traitMethods.isEmpty()) {
            MethodBinding[] methodBindingArray;
            HashSet<String> canBeOverridden = new HashSet<String>();
            ReferenceBinding superclass = typeBinding;
            while ((superclass = superclass.superclass()) != null) {
                methodBindingArray = superclass.availableMethods();
                int helperBinding = methodBindingArray.length;
                int n5 = 0;
                while (n5 < helperBinding) {
                    MethodBinding method = methodBindingArray[n5];
                    if (!(method.isPrivate() || method.isPublic() || method.isStatic())) {
                        canBeOverridden.add(this.getMethodAsString(method));
                    }
                    ++n5;
                }
            }
            methodBindingArray = methodBindings;
            int helperBinding = methodBindings.length;
            int n6 = 0;
            while (n6 < helperBinding) {
                MethodBinding method = methodBindingArray[n6];
                canBeOverridden.remove(this.getMethodAsString(method));
                ++n6;
            }
            for (String key : canBeOverridden) {
                MethodBinding method = (MethodBinding)traitMethods.remove(key);
                if (method == null) continue;
                method = new MethodBinding(method, typeBinding);
                method.modifiers &= 0xFFFFFBFF;
                groovyMethods.add(method);
            }
            for (MethodBinding method : traitMethods.values()) {
                method.modifiers &= 0xFFFFFBFF;
            }
        }
        MethodBinding[] newMethodBindings = groovyMethods.toArray(new MethodBinding[methodBindings.length + groovyMethods.size()]);
        System.arraycopy(methodBindings, 0, newMethodBindings, groovyMethods.size(), methodBindings.length);
        return newMethodBindings;
    }

    private String getMethodAsString(MethodBinding method) {
        StringBuilder key = new StringBuilder(new String(method.selector));
        key.append(" ");
        TypeBinding[] typeBindingArray = method.parameters;
        int n = method.parameters.length;
        int n2 = 0;
        while (n2 < n) {
            TypeBinding param = typeBindingArray[n2];
            char[] type = param.readableName();
            if (type != null) {
                key.append(type);
                key.append(" ");
            } else {
                key.append("null ");
            }
            ++n2;
        }
        return key.toString();
    }

    private boolean isNotActuallyAbstract(MethodBinding methodBinding, ReferenceBinding helperBinding) {
        if (methodBinding.declaringClass instanceof SourceTypeBinding) {
            AbstractMethodDeclaration methodDeclaration = ((SourceTypeBinding)methodBinding.declaringClass).scope.referenceContext.declarationOf(methodBinding);
            if (methodDeclaration != null) {
                return !Flags.isAbstract(methodDeclaration.modifiers);
            }
        } else if (methodBinding.declaringClass instanceof BinaryTypeBinding && helperBinding != null) {
            MethodBinding[] methodBindingArray = helperBinding.methods();
            int n = methodBindingArray.length;
            int n2 = 0;
            while (n2 < n) {
                TypeBinding[] expectedParameters;
                TypeBinding[] actualParameters;
                MethodBinding m = methodBindingArray[n2];
                if (Arrays.equals(methodBinding.selector, m.selector) && (actualParameters = m.parameters).length == (expectedParameters = methodBinding.parameters).length + 1 && actualParameters[0].equals(methodBinding.declaringClass)) {
                    boolean same = true;
                    int i = 0;
                    int n3 = expectedParameters.length;
                    while (i < n3) {
                        if (!actualParameters[i + 1].equals(expectedParameters[i])) {
                            same = false;
                            break;
                        }
                        ++i;
                    }
                    return same && !m.isAbstract();
                }
                ++n2;
            }
        }
        return true;
    }

    private Optional<MethodBinding> createMethod(String name, boolean isStatic, TypeBinding[] parameterTypes, TypeBinding returnType, MethodBinding[] existingMethods) {
        boolean found = false;
        char[] nameAsCharArray = name.toCharArray();
        MethodBinding[] methodBindingArray = existingMethods;
        int n = existingMethods.length;
        int n2 = 0;
        while (n2 < n) {
            MethodBinding existingMethod = methodBindingArray[n2];
            if (CharOperation.equals(nameAsCharArray, existingMethod.selector)) {
                boolean equalParameters;
                ((SourceTypeBinding)existingMethod.declaringClass).resolveTypesFor(existingMethod);
                boolean bl = equalParameters = parameterTypes.length == existingMethod.parameters.length;
                if (equalParameters) {
                    int i = 0;
                    int n3 = parameterTypes.length;
                    while (i < n3) {
                        if (!CharOperation.equals(parameterTypes[i].signature(), existingMethod.parameters[i].signature())) {
                            equalParameters = false;
                            break;
                        }
                        ++i;
                    }
                }
                if (equalParameters) {
                    found = true;
                    break;
                }
            }
            ++n2;
        }
        if (!found) {
            int modifiers = 1;
            if (isStatic) {
                modifiers |= 8;
            }
            if (this.referenceContext.binding.isInterface()) {
                modifiers |= 0x400;
            }
            return Optional.of(new MethodBinding(modifiers, nameAsCharArray, returnType, parameterTypes, null, this.referenceContext.binding));
        }
        return Optional.empty();
    }

    private Optional<MethodBinding> createGetterMethod(String propertyName, String name, boolean isStatic, MethodBinding[] existingMethods) {
        boolean found = false;
        char[] nameAsCharArray = name.toCharArray();
        MethodBinding[] methodBindingArray = existingMethods;
        int n = existingMethods.length;
        int n2 = 0;
        while (n2 < n) {
            MethodBinding existingMethod = methodBindingArray[n2];
            if (CharOperation.equals(nameAsCharArray, existingMethod.selector)) {
                if ((existingMethod.modifiers & 0x2000000) != 0) {
                    Argument[] arguments = existingMethod.sourceMethod().arguments;
                    if (arguments == null || arguments.length == 0) {
                        found = true;
                        break;
                    }
                } else {
                    TypeBinding[] parameters = existingMethod.parameters;
                    if (parameters == null || parameters.length == 0) {
                        found = true;
                        break;
                    }
                }
            }
            ++n2;
        }
        if (!found) {
            int modifiers = 1;
            if (isStatic) {
                modifiers |= 8;
            }
            if (this.referenceContext.binding.isInterface()) {
                modifiers |= 0x400;
            }
            return Optional.of(new LazilyResolvedMethodBinding(true, propertyName, modifiers, nameAsCharArray, null, (ReferenceBinding)this.referenceContext.binding));
        }
        return Optional.empty();
    }

    private Optional<MethodBinding> createSetterMethod(String propertyName, String name, boolean isStatic, String propertyType, MethodBinding[] existingMethods) {
        boolean found = false;
        char[] nameAsCharArray = name.toCharArray();
        MethodBinding[] methodBindingArray = existingMethods;
        int n = existingMethods.length;
        int n2 = 0;
        while (n2 < n) {
            MethodBinding existingMethod = methodBindingArray[n2];
            if (CharOperation.equals(nameAsCharArray, existingMethod.selector)) {
                if ((existingMethod.modifiers & 0x2000000) != 0) {
                    Argument[] arguments = existingMethod.sourceMethod().arguments;
                    if (arguments != null && arguments.length == 1) {
                        found = true;
                        break;
                    }
                } else {
                    TypeBinding[] parameters = existingMethod.parameters;
                    if (parameters != null && parameters.length == 1) {
                        found = true;
                        break;
                    }
                }
            }
            ++n2;
        }
        if (!found) {
            int modifiers = 1;
            if (isStatic) {
                modifiers |= 8;
            }
            if (this.referenceContext.binding.isInterface()) {
                modifiers |= 0x400;
            }
            return Optional.of(new LazilyResolvedMethodBinding(false, propertyName, modifiers, nameAsCharArray, null, (ReferenceBinding)this.referenceContext.binding));
        }
        return Optional.empty();
    }

    @Override
    protected void buildFieldsAndMethods() {
        super.buildFieldsAndMethods();
        Object[] objectArray = this.referenceContext.binding.methods();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            MethodBinding method = objectArray[n2];
            this.fixTypeParameters(method);
            ++n2;
        }
        objectArray = ((GroovyTypeDeclaration)this.referenceContext).getAnonymousTypes();
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            Object anonType = objectArray[n2];
            if (((GroovyTypeDeclaration)anonType).scope == null && ((GroovyTypeDeclaration)anonType).enclosingScope != null) {
                ((GroovyTypeDeclaration)anonType).allocation.resolveType(((GroovyTypeDeclaration)anonType).enclosingScope.get());
            }
            ++n2;
        }
        objectArray = this.referenceContext.fields;
        n = this.referenceContext.fields.length;
        n2 = 0;
        while (n2 < n) {
            Object field = objectArray[n2];
            if (((FieldDeclaration)field).initialization instanceof QualifiedAllocationExpression) {
                QualifiedAllocationExpression initialization = (QualifiedAllocationExpression)((FieldDeclaration)field).initialization;
                if (initialization.anonymousType != null && initialization.anonymousType.scope == null) {
                    MethodScope scope;
                    MethodScope methodScope = scope = ((FieldDeclaration)field).isStatic() ? this.referenceContext.staticInitializerScope : this.referenceContext.initializerScope;
                    if (((FieldDeclaration)field).binding.type == null) {
                        ((FieldDeclaration)field).binding.type = ((FieldDeclaration)field).getKind() == 3 ? scope.enclosingSourceType() : ((FieldDeclaration)field).type.resolveType(scope);
                    }
                    ((FieldDeclaration)field).resolve(scope);
                }
            }
            ++n2;
        }
    }

    private void fixTypeParameters(MethodBinding method) {
        if (method.typeVariables == null || method.typeVariables.length == 0) {
            return;
        }
        if (method.parameters == null || method.parameters.length == 0) {
            return;
        }
        HashMap<String, TypeVariableBinding> bindings = new HashMap<String, TypeVariableBinding>();
        TypeBinding[] typeBindingArray = method.typeVariables;
        int n = method.typeVariables.length;
        int n2 = 0;
        while (n2 < n) {
            TypeVariableBinding v = typeBindingArray[n2];
            bindings.put(new String(v.sourceName), v);
            ++n2;
        }
        typeBindingArray = method.parameters;
        n = method.parameters.length;
        n2 = 0;
        while (n2 < n) {
            TypeBinding[] arguments;
            TypeBinding parameter = typeBindingArray[n2];
            if (parameter instanceof ParameterizedTypeBinding && (arguments = ((ParameterizedTypeBinding)parameter).arguments) != null) {
                int i = 0;
                int n3 = arguments.length;
                while (i < n3) {
                    String name;
                    TypeBinding argument;
                    if (arguments[i] instanceof TypeVariableBinding && (argument = (TypeBinding)bindings.get(name = new String(arguments[i].sourceName()))) != null && arguments[i].id != argument.id) {
                        arguments[i] = argument;
                    }
                    ++i;
                }
            }
            ++n2;
        }
    }

    @Override
    public boolean shouldReport(int problem) {
        switch (problem) {
            case 16777528: 
            case 67109264: 
            case 67109265: 
            case 67109268: 
            case 67109273: 
            case 67109424: 
            case 67109627: 
            case 67109667: 
            case 0x8000082: {
                return false;
            }
        }
        return true;
    }

    private class TraitHelper {
        private boolean lookForTraitAlias;
        private boolean toBeInitialized = true;

        private TraitHelper() {
        }

        private void initialize() {
            ImportBinding[] imports = GroovyClassScope.this.referenceContext.scope.compilationUnitScope().imports;
            if (imports != null) {
                ImportBinding[] importBindingArray = imports;
                int n = imports.length;
                int n2 = 0;
                while (n2 < n) {
                    ImportBinding i = importBindingArray[n2];
                    String importedType = new String(i.readableName());
                    if ("groovy.transform.Trait".equals(importedType)) {
                        this.lookForTraitAlias = true;
                        break;
                    }
                    if (importedType.endsWith(".Trait")) {
                        this.lookForTraitAlias = false;
                        break;
                    }
                    if ("groovy.transform.*".equals(importedType)) {
                        this.lookForTraitAlias = true;
                    }
                    ++n2;
                }
                this.toBeInitialized = true;
            }
        }

        private boolean isTrait(ReferenceBinding referenceBinding) {
            if (referenceBinding != null) {
                AnnotationBinding[] annotations;
                if (this.toBeInitialized) {
                    this.initialize();
                }
                if ((annotations = referenceBinding.getAnnotations()) != null) {
                    AnnotationBinding[] annotationBindingArray = annotations;
                    int n = annotations.length;
                    int n2 = 0;
                    while (n2 < n) {
                        AnnotationBinding annotation = annotationBindingArray[n2];
                        if (annotation != null) {
                            ReferenceBinding annotationType = annotation.getAnnotationType();
                            String annotationName = CharOperation.toString(annotationType.compoundName);
                            if ("groovy.transform.Trait".equals(annotationName)) {
                                return true;
                            }
                            if (this.lookForTraitAlias && "Trait".equals(annotationName)) {
                                return true;
                            }
                        }
                        ++n2;
                    }
                }
            }
            return false;
        }

        private ReferenceBinding getHelperBinding(ReferenceBinding interfaceBinding) {
            if (interfaceBinding instanceof BinaryTypeBinding) {
                StringBuilder nameBuilder = new StringBuilder();
                nameBuilder.append(interfaceBinding.sourceName);
                nameBuilder.append("$Trait$Helper");
                ReferenceBinding helperBinding = GroovyClassScope.this.compilationUnitScope().findType(nameBuilder.toString().toCharArray(), interfaceBinding.fPackage, interfaceBinding.fPackage);
                if (helperBinding != null && helperBinding instanceof ProblemReferenceBinding) {
                    helperBinding = ((ProblemReferenceBinding)helperBinding).closestReferenceMatch();
                }
                return helperBinding;
            }
            return null;
        }
    }
}

