/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jdt.groovy.model;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.eclipse.GroovyLogManager;
import org.codehaus.groovy.eclipse.TraceCategory;
import org.codehaus.jdt.groovy.integration.internal.MultiplexingSourceElementRequestorParser;
import org.codehaus.jdt.groovy.internal.compiler.ast.GroovyCompilationUnitDeclaration;
import org.codehaus.jdt.groovy.model.CodeSelectHelperFactory;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnitStructureRequestor;
import org.codehaus.jdt.groovy.model.GroovyNature;
import org.codehaus.jdt.groovy.model.GroovyReconcileWorkingCopyOperation;
import org.codehaus.jdt.groovy.model.ICodeCompletionDelegate;
import org.codehaus.jdt.groovy.model.ModuleNodeMapper;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.PerformanceStats;
import org.eclipse.jdt.core.CompletionRequestor;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.util.CompilerUtils;
import org.eclipse.jdt.groovy.core.util.ReflectionUtils;
import org.eclipse.jdt.internal.compiler.IErrorHandlingPolicy;
import org.eclipse.jdt.internal.compiler.SourceElementParser;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.jdt.internal.core.ASTHolderCUInfo;
import org.eclipse.jdt.internal.core.CompilationUnit;
import org.eclipse.jdt.internal.core.CompilationUnitElementInfo;
import org.eclipse.jdt.internal.core.CompilationUnitProblemFinder;
import org.eclipse.jdt.internal.core.DefaultWorkingCopyOwner;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.OpenableElementInfo;
import org.eclipse.jdt.internal.core.PackageFragment;
import org.eclipse.jdt.internal.core.ReconcileWorkingCopyOperation;
import org.eclipse.jdt.internal.core.util.Util;

public class GroovyCompilationUnit
extends CompilationUnit {
    private static final ThreadLocalAtomicInteger depth = new ThreadLocalAtomicInteger();

    public GroovyCompilationUnit(PackageFragment parent, String name, WorkingCopyOwner owner) {
        super(parent, name, owner);
    }

    public ModuleNode getModuleNode() {
        ModuleNodeMapper.ModuleNodeInfo moduleInfo = this.getModuleInfo(true);
        return moduleInfo != null ? moduleInfo.module : null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ModuleNodeMapper.ModuleNodeInfo getModuleInfo(boolean force) {
        try {
            if (!this.isConsistent()) {
                this.makeConsistent(null);
            }
            boolean becameWorkingCopy = false;
            ModuleNodeMapper.getInstance().lock();
            try {
                JavaModelManager.PerWorkingCopyInfo info;
                boolean bl = becameWorkingCopy = force && !this.isWorkingCopy();
                if (becameWorkingCopy) {
                    this.becomeWorkingCopy(null);
                }
                if ((info = this.getPerWorkingCopyInfo()) == null) return null;
                ModuleNodeMapper.ModuleNodeInfo moduleNodeInfo = ModuleNodeMapper.getInstance().get(info);
                return moduleNodeInfo;
            }
            finally {
                try {
                    if (becameWorkingCopy) {
                        this.discardWorkingCopy();
                    }
                }
                finally {
                    ModuleNodeMapper.getInstance().unlock();
                }
            }
        }
        catch (JavaModelException e) {
            Util.log(e, "Exception thrown when trying to get Groovy module node for " + this.getElementName());
        }
        return null;
    }

    public ModuleNodeMapper.ModuleNodeInfo getNewModuleInfo() {
        try {
            this.openWhenClosed(this.createElementInfo(), false, new NullProgressMonitor());
        }
        catch (JavaModelException e) {
            Util.log(e, "Exception thrown when trying to get Groovy module node for " + this.getElementName());
        }
        return this.getModuleInfo(true);
    }

    @Override
    public void discardWorkingCopy() throws JavaModelException {
        ModuleNodeMapper.getInstance().lock();
        try {
            JavaModelManager.PerWorkingCopyInfo info = this.getPerWorkingCopyInfo();
            if (this.workingCopyInfoWillBeDiscarded(info)) {
                ModuleNodeMapper.getInstance().remove(info);
            }
            super.discardWorkingCopy();
        }
        finally {
            ModuleNodeMapper.getInstance().unlock();
        }
    }

    private boolean workingCopyInfoWillBeDiscarded(JavaModelManager.PerWorkingCopyInfo info) {
        return info != null && (Integer)ReflectionUtils.getPrivateField(JavaModelManager.PerWorkingCopyInfo.class, "useCount", info) <= 1;
    }

    @Override
    protected boolean buildStructure(OpenableElementInfo info, IProgressMonitor pm, Map newElements, IResource underlyingResource) throws JavaModelException {
        depth.increment();
        try {
            block40: {
                GroovyCompilationUnitDeclaration compilationUnitDeclaration;
                block39: {
                    HashMap problems;
                    int reconcileFlags;
                    boolean resolveBindings;
                    boolean createAST;
                    IBuffer buffer;
                    if (GroovyLogManager.manager.hasLoggers()) {
                        GroovyLogManager.manager.log(TraceCategory.COMPILER, "Build Structure starting for " + this.name);
                        GroovyLogManager.manager.logStart("Build structure: " + this.name + " : " + Thread.currentThread().getName());
                    }
                    if ((buffer = this.getBufferManager().getBuffer(this)) == null) {
                        this.openBuffer(pm, info);
                    }
                    GroovyCompilationUnitStructureRequestor requestor = new GroovyCompilationUnitStructureRequestor(this, (CompilationUnitElementInfo)info, newElements);
                    JavaModelManager.PerWorkingCopyInfo perWorkingCopyInfo = this.getPerWorkingCopyInfo();
                    JavaProject project = (JavaProject)this.getJavaProject();
                    if (info instanceof ASTHolderCUInfo) {
                        ASTHolderCUInfo astHolder = (ASTHolderCUInfo)info;
                        createAST = (Integer)ReflectionUtils.getPrivateField(ASTHolderCUInfo.class, "astLevel", astHolder) != 0;
                        resolveBindings = (Boolean)ReflectionUtils.getPrivateField(ASTHolderCUInfo.class, "resolveBindings", astHolder);
                        reconcileFlags = (Integer)ReflectionUtils.getPrivateField(ASTHolderCUInfo.class, "reconcileFlags", astHolder);
                        problems = (HashMap)HashMap.class.cast(ReflectionUtils.getPrivateField(ASTHolderCUInfo.class, "problems", astHolder));
                    } else {
                        createAST = false;
                        resolveBindings = false;
                        reconcileFlags = 0;
                        problems = null;
                    }
                    boolean computeProblems = perWorkingCopyInfo != null && perWorkingCopyInfo.isActive() && project != null && JavaProject.hasJavaNature(project.getProject());
                    Hashtable<String, String> options = project == null ? JavaCore.getOptions() : project.getOptions(true);
                    options.put("org.eclipse.jdt.core.compiler.groovy.buildGroovyFiles", "enabled");
                    if (!computeProblems) {
                        options.remove("org.eclipse.jdt.core.compiler.groovy.groovyCompilerConfigScript");
                        options.remove("org.eclipse.jdt.core.compiler.taskTags");
                    }
                    CompilerOptions compilerOptions = new CompilerOptions(options);
                    if (project != null) {
                        CompilerUtils.setGroovyClasspath(compilerOptions, (IJavaProject)project);
                    }
                    ProblemReporter reporter = new ProblemReporter(new GroovyErrorHandlingPolicy(!computeProblems), compilerOptions, new DefaultProblemFactory());
                    MultiplexingSourceElementRequestorParser parser = new MultiplexingSourceElementRequestorParser(reporter, requestor, reporter.problemFactory, compilerOptions, true, !createAST);
                    parser.reportOnlyOneSyntaxError = !computeProblems;
                    parser.setMethodsFullRecovery(true);
                    parser.setStatementsRecovery((reconcileFlags & 2) != 0);
                    if (!(computeProblems || resolveBindings || createAST)) {
                        parser.javadocParser.checkDocComment = false;
                    }
                    requestor.setParser(parser);
                    if (underlyingResource == null) {
                        underlyingResource = this.getResource();
                    }
                    if (underlyingResource != null) {
                        ReflectionUtils.setPrivateField(CompilationUnitElementInfo.class, "timestamp", info, underlyingResource.getModificationStamp());
                    }
                    compilationUnitDeclaration = null;
                    GroovyCompilationUnit source = this.cloneCachingContents();
                    try {
                        if (computeProblems || depth.intValue() < 2) {
                            if (problems == null) {
                                problems = new HashMap();
                                compilationUnitDeclaration = (GroovyCompilationUnitDeclaration)CompilationUnitProblemFinder.process(source, parser, this.owner, problems, createAST, reconcileFlags, pm);
                                if (computeProblems) {
                                    try {
                                        perWorkingCopyInfo.beginReporting();
                                        for (CategorizedProblem[] categorizedProblems : problems.values()) {
                                            if (categorizedProblems == null) continue;
                                            int i = 0;
                                            int n = categorizedProblems.length;
                                            while (i < n) {
                                                perWorkingCopyInfo.acceptProblem(categorizedProblems[i]);
                                                ++i;
                                            }
                                        }
                                    }
                                    finally {
                                        perWorkingCopyInfo.endReporting();
                                    }
                                }
                            } else {
                                compilationUnitDeclaration = (GroovyCompilationUnitDeclaration)CompilationUnitProblemFinder.process(source, parser, this.owner, problems, createAST, reconcileFlags, pm);
                            }
                        } else {
                            compilationUnitDeclaration = (GroovyCompilationUnitDeclaration)((SourceElementParser)parser).parseCompilationUnit(source, true, pm);
                        }
                        this.maybeCacheModuleNode(perWorkingCopyInfo, compilationUnitDeclaration);
                        if (!createAST) break block39;
                        try {
                            org.eclipse.jdt.core.dom.CompilationUnit ast = AST.convertCompilationUnit(9, compilationUnitDeclaration, options, computeProblems, source, reconcileFlags, pm);
                            ReflectionUtils.setPrivateField(ASTHolderCUInfo.class, "ast", info, ast);
                        }
                        catch (OperationCanceledException e) {
                            throw e;
                        }
                        catch (IllegalArgumentException e) {
                            Util.log(e, "Problem with build structure: Offset for AST node is incorrect in " + this.getParent().getElementName() + "." + this.getElementName());
                        }
                        catch (Exception e) {
                            Util.log(e, "Problem with build structure for " + this.getElementName());
                        }
                    }
                    catch (OperationCanceledException e) {
                        throw e;
                    }
                    catch (JavaModelException e) {
                        if (e.getStatus().getCode() != 969 || this.getJavaProject().exists()) {
                            Util.log(e, "Problem with build structure for " + this.getElementName());
                        }
                        if (compilationUnitDeclaration != null) {
                            compilationUnitDeclaration.cleanUp();
                        }
                        break block40;
                    }
                    catch (Exception e) {
                        try {
                            Util.log(e, "Problem with build structure for " + this.getElementName());
                            break block40;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            if (compilationUnitDeclaration != null) {
                                compilationUnitDeclaration.cleanUp();
                            }
                        }
                    }
                }
                if (compilationUnitDeclaration != null) {
                    compilationUnitDeclaration.cleanUp();
                }
            }
            boolean bl = info.isStructureKnown();
            return bl;
        }
        finally {
            depth.decrement();
            if (GroovyLogManager.manager.hasLoggers()) {
                GroovyLogManager.manager.logEnd("Build structure: " + this.name + " : " + Thread.currentThread().getName(), TraceCategory.COMPILER);
            }
        }
    }

    protected void maybeCacheModuleNode(JavaModelManager.PerWorkingCopyInfo perWorkingCopyInfo, GroovyCompilationUnitDeclaration compilationUnitDeclaration) {
        ModuleNodeMapper.getInstance().maybeCacheModuleNode(perWorkingCopyInfo, compilationUnitDeclaration);
    }

    @Override
    public org.eclipse.jdt.core.dom.CompilationUnit reconcile(int astLevel, int reconcileFlags, WorkingCopyOwner workingCopyOwner, IProgressMonitor monitor) throws JavaModelException {
        if (!this.isWorkingCopy()) {
            return null;
        }
        if (workingCopyOwner == null) {
            workingCopyOwner = DefaultWorkingCopyOwner.PRIMARY;
        }
        PerformanceStats stats = null;
        if (ReconcileWorkingCopyOperation.PERF) {
            stats = PerformanceStats.getStats("org.eclipse.jdt.core/perf/reconcile", this);
            stats.startRun(String.valueOf(this.getFileName()));
        }
        GroovyReconcileWorkingCopyOperation op = new GroovyReconcileWorkingCopyOperation(this, astLevel, reconcileFlags, workingCopyOwner);
        JavaModelManager manager = JavaModelManager.getJavaModelManager();
        try {
            manager.cacheZipFiles(this);
            op.runOperation(monitor);
        }
        finally {
            manager.flushZipFiles(this);
        }
        if (ReconcileWorkingCopyOperation.PERF) {
            stats.endRun();
        }
        return op.ast;
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        if (GroovyCompilationUnit.class.equals(adapter)) {
            return (T)this;
        }
        if (ModuleNode.class.equals(adapter)) {
            return (T)this.getModuleNode();
        }
        return super.getAdapter(adapter);
    }

    public GroovyCompilationUnit cloneCachingContents(char[] newContents) {
        return new CompilationUnitClone(newContents);
    }

    @Override
    public GroovyCompilationUnit cloneCachingContents() {
        return new CompilationUnitClone();
    }

    @Override
    public IJavaElement[] codeSelect(int offset, int length) throws JavaModelException {
        return this.codeSelect(offset, length, DefaultWorkingCopyOwner.PRIMARY);
    }

    @Override
    public IJavaElement[] codeSelect(int offset, int length, WorkingCopyOwner workingCopyOwner) throws JavaModelException {
        return this.codeSelect(this, offset, length, workingCopyOwner);
    }

    @Override
    protected IJavaElement[] codeSelect(ICompilationUnit cu, int offset, int length, WorkingCopyOwner o) throws JavaModelException {
        if (CodeSelectHelperFactory.selectHelper != null) {
            return CodeSelectHelperFactory.selectHelper.select(this, offset, length);
        }
        return new IJavaElement[0];
    }

    @Override
    public IType findPrimaryType() {
        block4: {
            IType type = super.findPrimaryType();
            if (type != null) {
                return type;
            }
            try {
                IType[] types;
                if (this.getResource().exists() && (types = this.getTypes()) != null && types.length > 0) {
                    return types[0];
                }
            }
            catch (JavaModelException e) {
                if (e.getStatus().getCode() == 1006) break block4;
                Util.log(e, "Error finding all types of " + this.getElementName());
            }
        }
        return null;
    }

    public boolean isOnBuildPath() {
        IJavaProject project = this.getJavaProject();
        if (!project.isOnClasspath(this)) {
            return false;
        }
        IProject resourceProject = project.getProject();
        return resourceProject != null && resourceProject.isAccessible() && GroovyNature.hasGroovyNature(resourceProject);
    }

    @Override
    public IResource getUnderlyingResource() throws JavaModelException {
        if (this.isOnBuildPath()) {
            return super.getUnderlyingResource();
        }
        IResource rsrc = this.getResource();
        try {
            Assert.isTrue(rsrc.getFullPath().toString().endsWith(this.name));
        }
        catch (Throwable e) {
            Util.log(e);
            return super.getUnderlyingResource();
        }
        return rsrc;
    }

    @Override
    public void rename(String newName, boolean force, IProgressMonitor monitor) throws JavaModelException {
        super.rename(newName, force, monitor);
        if (this.isWorkingCopy()) {
            this.discardWorkingCopy();
        }
    }

    @Override
    protected void codeComplete(ICompilationUnit cu, ICompilationUnit unitToSkip, int position, CompletionRequestor requestor, WorkingCopyOwner owner, ITypeRoot typeRoot, IProgressMonitor monitor) throws JavaModelException {
        ICodeCompletionDelegate delegate = Adapters.adapt(this, ICodeCompletionDelegate.class);
        if (delegate != null && delegate.shouldCodeComplete(requestor, typeRoot)) {
            delegate.codeComplete(cu, unitToSkip, position, requestor, owner, typeRoot, monitor);
        } else {
            super.codeComplete(cu, unitToSkip, position, requestor, owner, typeRoot, monitor);
        }
    }

    class CompilationUnitClone
    extends GroovyCompilationUnit {
        private char[] cachedContents;

        public CompilationUnitClone(char[] cachedContents) {
            this();
            this.cachedContents = cachedContents;
        }

        public CompilationUnitClone() {
            super((PackageFragment)GroovyCompilationUnit.this.parent, GroovyCompilationUnit.this.name, GroovyCompilationUnit.this.owner);
        }

        @Override
        public char[] getContents() {
            if (this.cachedContents == null) {
                this.cachedContents = GroovyCompilationUnit.this.getContents();
            }
            return this.cachedContents;
        }

        @Override
        public CompilationUnit originalFromClone() {
            return GroovyCompilationUnit.this;
        }

        @Override
        public char[] getFileName() {
            return GroovyCompilationUnit.this.getFileName();
        }
    }

    private class GroovyErrorHandlingPolicy
    implements IErrorHandlingPolicy {
        final boolean stopOnFirst;

        public GroovyErrorHandlingPolicy(boolean stopOnFirst) {
            this.stopOnFirst = stopOnFirst;
        }

        @Override
        public boolean proceedOnErrors() {
            return !this.stopOnFirst;
        }

        @Override
        public boolean stopOnFirstError() {
            return this.stopOnFirst;
        }

        @Override
        public boolean ignoreAllErrors() {
            return false;
        }
    }

    private static class ThreadLocalAtomicInteger
    extends ThreadLocal<AtomicInteger> {
        private ThreadLocalAtomicInteger() {
        }

        @Override
        protected AtomicInteger initialValue() {
            return new AtomicInteger();
        }

        int intValue() {
            return ((AtomicInteger)this.get()).get();
        }

        void increment() {
            ((AtomicInteger)this.get()).incrementAndGet();
        }

        void decrement() {
            ((AtomicInteger)this.get()).decrementAndGet();
        }
    }
}

