/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jdt.groovy.internal.compiler.ast;

import groovy.lang.GroovyClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.ResolveVisitor;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.jdt.groovy.internal.compiler.ast.AbortResolutionException;
import org.codehaus.jdt.groovy.internal.compiler.ast.GroovyCompilationUnitScope;
import org.codehaus.jdt.groovy.internal.compiler.ast.GroovyEclipseBug;
import org.codehaus.jdt.groovy.internal.compiler.ast.GroovyParser;
import org.codehaus.jdt.groovy.internal.compiler.ast.GroovyTypeDeclaration;
import org.codehaus.jdt.groovy.internal.compiler.ast.JDTClassNode;
import org.codehaus.jdt.groovy.internal.compiler.ast.JDTClassNodeBuilder;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.groovy.core.util.ReflectionUtils;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.SingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.env.AccessRestriction;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class JDTResolver
extends ResolveVisitor {
    private static final boolean DEBUG = false;
    private static final int BOOLEAN_LENGTH = "boolean".length();
    private static final Map<String, ClassNode> COMMON_TYPES;
    public static boolean recordInstances;
    public static List<JDTResolver> instances;
    protected GroovyCompilationUnitScope activeScope = null;
    private Map<ClassNode, GroovyTypeDeclaration> scopes = new HashMap<ClassNode, GroovyTypeDeclaration>();
    private Map<TypeBinding, JDTClassNode> inProgress = new IdentityHashMap<TypeBinding, JDTClassNode>();
    private Map<TypeBinding, JDTClassNode> nodeCache = new IdentityHashMap<TypeBinding, JDTClassNode>();
    private Set<ClassNode> resolvedClassNodes = new HashSet<ClassNode>();
    private Set<String> unresolvables = new HashSet<String>();
    private static boolean doInnerResolve;

    static {
        HashMap<String, ClassNode> commonTypes = new HashMap<String, ClassNode>();
        commonTypes.put("boolean", ClassHelper.boolean_TYPE);
        commonTypes.put("byte", ClassHelper.byte_TYPE);
        commonTypes.put("char", ClassHelper.char_TYPE);
        commonTypes.put("double", ClassHelper.double_TYPE);
        commonTypes.put("float", ClassHelper.float_TYPE);
        commonTypes.put("int", ClassHelper.int_TYPE);
        commonTypes.put("long", ClassHelper.long_TYPE);
        commonTypes.put("short", ClassHelper.short_TYPE);
        commonTypes.put("void", ClassHelper.VOID_TYPE);
        commonTypes.put("java.lang.Boolean", ClassHelper.Boolean_TYPE);
        commonTypes.put("java.lang.Byte", ClassHelper.Byte_TYPE);
        commonTypes.put("java.lang.Character", ClassHelper.Character_TYPE);
        commonTypes.put("java.lang.Double", ClassHelper.Double_TYPE);
        commonTypes.put("java.lang.Float", ClassHelper.Float_TYPE);
        commonTypes.put("java.lang.Integer", ClassHelper.Integer_TYPE);
        commonTypes.put("java.lang.Long", ClassHelper.Long_TYPE);
        commonTypes.put("java.lang.Short", ClassHelper.Short_TYPE);
        commonTypes.put("java.lang.Void", ClassHelper.void_WRAPPER_TYPE);
        commonTypes.put("java.lang.Object", ClassHelper.OBJECT_TYPE);
        commonTypes.put("java.lang.String", ClassHelper.STRING_TYPE);
        COMMON_TYPES = Collections.unmodifiableMap(commonTypes);
        recordInstances = false;
        instances = null;
        doInnerResolve = Boolean.getBoolean("greclipse.doInnerResolve");
    }

    private void log(String string) {
        System.err.printf("JDTResolver@%x[%d]: %s%n", System.identityHashCode(this), Thread.currentThread().getId(), string);
    }

    private void log(String string, ClassNode type, boolean foundit) {
        this.log(String.valueOf(string) + " " + type.getName() + "? " + foundit);
    }

    public static JDTClassNode getCachedNode(String name) {
        for (JDTResolver instance : instances) {
            JDTClassNode node = JDTResolver.getCachedNode(instance, name);
            if (node == null) continue;
            return node;
        }
        return null;
    }

    public static JDTClassNode getCachedNode(JDTResolver instance, String name) {
        for (JDTClassNode nodeFromCache : instance.nodeCache.values()) {
            if (!name.equals(String.valueOf(nodeFromCache.getJdtBinding().readableName()))) continue;
            return nodeFromCache;
        }
        return null;
    }

    public GroovyCompilationUnitScope getScope() {
        return this.activeScope;
    }

    public JDTResolver(CompilationUnit groovyCompilationUnit) {
        super(groovyCompilationUnit);
        if (recordInstances) {
            if (instances == null) {
                instances = new ArrayList<JDTResolver>();
            }
            instances.add(this);
        }
    }

    public void cleanUp() {
        this.inProgress.clear();
    }

    public ClassNode resolve(String name) {
        ClassNode commonRedirect;
        if ((name.charAt(0) == 'j' || name.length() <= BOOLEAN_LENGTH) && (commonRedirect = COMMON_TYPES.get(name)) != null) {
            return commonRedirect;
        }
        if (this.unresolvables.contains(name)) {
            return ClassHelper.DYNAMIC_TYPE;
        }
        ClassNode type = ClassHelper.makeWithoutCaching(name);
        if (super.resolve(type, true, true, true)) {
            return type.redirect();
        }
        this.unresolvables.add(name);
        return ClassHelper.DYNAMIC_TYPE;
    }

    @Override
    protected boolean resolve(ClassNode type, boolean testModuleImports, boolean testDefaultImports, boolean testStaticInnerClasses) {
        ClassNode commonRedirect;
        String name = type.getName();
        if ((name.charAt(0) == 'j' || name.length() <= BOOLEAN_LENGTH) && (commonRedirect = COMMON_TYPES.get(name)) != null) {
            type.setRedirect(commonRedirect);
            return true;
        }
        if (this.unresolvables.contains(name)) {
            return false;
        }
        boolean b = super.resolve(type, testModuleImports, testDefaultImports, testStaticInnerClasses);
        if (!b) {
            this.unresolvables.add(name);
        }
        return b;
    }

    @Override
    protected boolean resolveFromModule(ClassNode type, boolean testModuleImports) {
        boolean foundit = super.resolveFromModule(type, testModuleImports);
        this.recordDependency(type.getName());
        if (foundit && type.redirect() instanceof JDTClassNode && ((JDTClassNode)type.redirect()).getJdtBinding().hasRestrictedAccess()) {
            ReferenceBinding binding = ((JDTClassNode)type.redirect()).getJdtBinding();
            AccessRestriction restriction = this.activeScope.environment().getAccessRestriction(binding.erasure());
            if (restriction != null) {
                SingleTypeReference ref = new SingleTypeReference(type.getNameWithoutPackage().toCharArray(), (long)type.getStart() << 32 | (long)type.getEnd() - 1L);
                this.activeScope.problemReporter().forbiddenReference(binding, (ASTNode)ref, restriction.classpathEntryType, restriction.classpathEntryName, restriction.getProblemId());
            }
        }
        return foundit;
    }

    @Override
    protected boolean resolveFromCompileUnit(ClassNode type) {
        ClassNode node;
        boolean foundit = super.resolveFromCompileUnit(type);
        this.recordDependency(type.getName());
        if (foundit) {
            return true;
        }
        if (this.activeScope != null && (node = this.activeScope.lookupClassNodeForSource(type.getName(), this)) != null) {
            type.setRedirect(node);
            return true;
        }
        return false;
    }

    @Override
    protected boolean resolveFromDefaultImports(ClassNode type, boolean testDefaultImports) {
        boolean foundit = super.resolveFromDefaultImports(type, testDefaultImports);
        this.recordDependency(type.getName());
        return foundit;
    }

    @Override
    protected boolean resolveFromStaticInnerClasses(ClassNode type, boolean testStaticInnerClasses) {
        boolean foundit = super.resolveFromStaticInnerClasses(type, testStaticInnerClasses);
        this.recordDependency(type.getName());
        return foundit;
    }

    @Override
    protected boolean resolveToOuter(ClassNode type) {
        ClassNode node;
        if (this.activeScope != null && (node = this.activeScope.lookupClassNodeForBinary(type.getName(), this)) != null) {
            type.setRedirect(node);
            return true;
        }
        GroovyClassLoader loader = this.compilationUnit.getClassLoader();
        if (loader instanceof GroovyParser.GrapeAwareGroovyClassLoader) {
            GroovyParser.GrapeAwareGroovyClassLoader gagcl = (GroovyParser.GrapeAwareGroovyClassLoader)loader;
            if (gagcl.grabbed) {
                Class cls;
                try {
                    cls = loader.loadClass(type.getName(), false, true);
                }
                catch (ClassNotFoundException | CompilationFailedException e) {
                    return false;
                }
                if (cls == null) {
                    return false;
                }
                node = ClassHelper.make(cls);
                type.setRedirect(node);
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean resolveToInner(ClassNode type) {
        if (doInnerResolve) {
            return super.resolveToInner(type);
        }
        return false;
    }

    @Override
    protected boolean resolveToInnerEnum(ClassNode type) {
        if (doInnerResolve) {
            return super.resolveToInnerEnum(type);
        }
        return false;
    }

    protected ClassNode convertToClassNode(TypeBinding jdtBinding) {
        ClassNode existingNode = this.checkForExisting(jdtBinding);
        if (existingNode != null) {
            return existingNode;
        }
        return this.createJDTClassNode(jdtBinding);
    }

    private ClassNode checkForExisting(TypeBinding jdtBinding) {
        ClassNode existing;
        if (jdtBinding.id > 0 && (jdtBinding.id <= 11 || jdtBinding.id <= 34 && jdtBinding.id >= 26) && (existing = COMMON_TYPES.get(String.valueOf(jdtBinding.readableName()))) != null) {
            return existing;
        }
        JDTClassNode node = this.inProgress.get(jdtBinding);
        if (node == null) {
            node = this.nodeCache.get(jdtBinding);
        }
        if (node != null) assert (Arrays.equals(jdtBinding.readableName(), node.getJdtBinding().readableName()));
        return node;
    }

    private ClassNode createJDTClassNode(TypeBinding jdtBinding) {
        JDTClassNodeBuilder cnb = new JDTClassNodeBuilder(this);
        ClassNode classNode = cnb.configureType(jdtBinding);
        if (classNode instanceof JDTClassNode) {
            JDTClassNode jdtNode = (JDTClassNode)classNode;
            assert (!this.inProgress.containsKey(jdtBinding));
            this.inProgress.put(jdtBinding, jdtNode);
            jdtNode.setUpGenerics();
            assert (this.nodeCache.get(jdtBinding) == null) : "not unique";
            this.nodeCache.put(jdtBinding, jdtNode);
            this.inProgress.remove(jdtBinding);
        }
        return classNode;
    }

    @Override
    protected boolean commencingResolution() {
        GroovyTypeDeclaration gtDeclaration = this.scopes.get(this.currentClass);
        if (gtDeclaration == null) {
            if (this.resolvedClassNodes.contains(this.currentClass)) {
                return false;
            }
            throw new GroovyEclipseBug("commencingResolution failed: no declaration found for class " + this.currentClass);
        }
        this.activeScope = null;
        if (gtDeclaration.scope == null) {
            if (gtDeclaration.hasErrors()) {
                return false;
            }
            throw new GroovyEclipseBug("commencingResolution failed: declaration found, but unexpectedly found no scope for " + this.currentClass.getName());
        }
        this.activeScope = (GroovyCompilationUnitScope)gtDeclaration.scope.compilationUnitScope();
        return true;
    }

    @Override
    protected void finishedResolution() {
        this.resolvedClassNodes.add(this.currentClass);
        this.scopes.remove(this.currentClass);
        this.unresolvables.clear();
    }

    public void record(GroovyTypeDeclaration gtDeclaration) {
        GroovyTypeDeclaration[] anonymousTypes;
        int m;
        this.scopes.put(gtDeclaration.getClassNode(), gtDeclaration);
        if (gtDeclaration.memberTypes != null) {
            TypeDeclaration[] members = gtDeclaration.memberTypes;
            m = 0;
            while (m < members.length) {
                this.record((GroovyTypeDeclaration)members[m]);
                ++m;
            }
        }
        if ((anonymousTypes = gtDeclaration.getAnonymousTypes()) != null) {
            m = 0;
            while (m < anonymousTypes.length) {
                this.record(anonymousTypes[m]);
                ++m;
            }
        }
    }

    private void recordDependency(String typename) {
        if (this.activeScope != null) {
            if (typename.indexOf(46) != -1) {
                this.activeScope.recordQualifiedReference(CharOperation.splitOn('.', typename.toCharArray()));
            } else {
                this.activeScope.recordSimpleReference(typename.toCharArray());
            }
        }
    }

    @Override
    public void startResolving(ClassNode node, SourceUnit source) {
        try {
            super.startResolving(node, source);
            this.unresolvables.clear();
        }
        catch (AbortResolutionException abortResolutionException) {
            // empty catch block
        }
    }

    private static String toString(TypeBinding jdtBinding) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(jdtBinding.readableName());
        buffer.append('(').append(jdtBinding.id).append(')');
        try {
            Object lookup = ReflectionUtils.throwableGetPrivateField(jdtBinding.getClass(), "environment", jdtBinding);
            buffer.append("[from lookup ").append(Integer.toHexString(System.identityHashCode(lookup))).append(']');
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return buffer.toString();
    }
}

