/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jdt.groovy.internal.compiler.ast;

import java.util.List;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.jdt.groovy.internal.compiler.ast.JDTAnnotationNode;
import org.codehaus.jdt.groovy.internal.compiler.ast.JDTClassNode;
import org.codehaus.jdt.groovy.internal.compiler.ast.JDTNode;
import org.codehaus.jdt.groovy.internal.compiler.ast.JDTResolver;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;

public class JDTFieldNode
extends FieldNode
implements JDTNode {
    private FieldBinding fieldBinding;
    private JDTResolver resolver;
    private int bits;

    public JDTFieldNode(FieldBinding fieldBinding, JDTResolver resolver, String name, int modifiers, ClassNode type, JDTClassNode declaringType, Expression initializerExpression) {
        super(name, modifiers, type, declaringType, initializerExpression);
        this.fieldBinding = fieldBinding;
        this.resolver = resolver;
    }

    @Override
    public void addAnnotation(AnnotationNode value) {
        throw new IllegalStateException("JDTFieldNode is immutable");
    }

    @Override
    public void addAnnotations(List<AnnotationNode> annotations) {
        throw new IllegalStateException("JDTFieldNode is immutable");
    }

    private void ensureAnnotationsInitialized() {
        if ((this.bits & 1) == 0) {
            AnnotationBinding[] annotationBindings;
            AnnotationBinding[] annotationBindingArray = annotationBindings = this.fieldBinding.getAnnotations();
            int n = annotationBindings.length;
            int n2 = 0;
            while (n2 < n) {
                AnnotationBinding annotationBinding = annotationBindingArray[n2];
                super.addAnnotation(new JDTAnnotationNode(annotationBinding, this.resolver));
                ++n2;
            }
            this.bits |= 1;
        }
    }

    @Override
    public List<AnnotationNode> getAnnotations() {
        this.ensureAnnotationsInitialized();
        return super.getAnnotations();
    }

    @Override
    public List<AnnotationNode> getAnnotations(ClassNode type) {
        this.ensureAnnotationsInitialized();
        return super.getAnnotations(type);
    }

    public FieldBinding getFieldBinding() {
        return this.fieldBinding;
    }

    @Override
    public Binding getJdtBinding() {
        return this.fieldBinding;
    }

    @Override
    public JDTResolver getResolver() {
        return this.resolver;
    }

    @Override
    public boolean isDeprecated() {
        return this.fieldBinding.isDeprecated();
    }
}

