/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jdt.groovy.internal.compiler.ast;

import groovy.lang.GroovyClassLoader;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.JarFile;
import java.util.stream.Stream;
import org.apache.xbean.classloader.NonLockingJarFileClassLoader;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.eclipse.GroovyLogManager;
import org.codehaus.groovy.eclipse.TraceCategory;
import org.codehaus.jdt.groovy.control.EclipseSourceUnit;
import org.codehaus.jdt.groovy.integration.internal.GroovyLanguageSupport;
import org.codehaus.jdt.groovy.internal.compiler.ast.Grails20TestSupport;
import org.codehaus.jdt.groovy.internal.compiler.ast.GrailsGlobalPluginAwareEntityInjector;
import org.codehaus.jdt.groovy.internal.compiler.ast.GrailsInjector;
import org.codehaus.jdt.groovy.internal.compiler.ast.GroovyCompilationUnitDeclaration;
import org.codehaus.jdt.groovy.internal.compiler.ast.GroovyErrorCollectorForJDT;
import org.codehaus.jdt.groovy.internal.compiler.ast.GroovyTypeDeclaration;
import org.codehaus.jdt.groovy.internal.compiler.ast.IGroovyDebugRequestor;
import org.codehaus.jdt.groovy.internal.compiler.ast.JDTResolver;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.groovy.core.util.GroovyUtils;
import org.eclipse.jdt.groovy.core.util.ReflectionUtils;
import org.eclipse.jdt.groovy.core.util.ScriptFolderSelector;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.Compiler;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.batch.CompilationUnit;
import org.eclipse.jdt.internal.compiler.batch.FileSystem;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.jdt.internal.core.builder.BatchImageBuilder;
import org.eclipse.jdt.internal.core.builder.BuildNotifier;

public class GroovyParser {
    public static IGroovyDebugRequestor debugRequestor;
    public Object requestor;
    public ProblemReporter problemReporter;
    private JDTResolver resolver;
    private String projectName;
    private String gclClasspath;
    private GroovyClassLoader batchLoader;
    private org.codehaus.groovy.control.CompilationUnit compilationUnit;
    private CompilerOptions compilerOptions;
    private static Map<String, Map.Entry<String, GroovyClassLoader[]>> projectClassLoaderCache;
    private static Map<String, ScriptFolderSelector> scriptFolderSelectorCache;
    private static final boolean NONLOCKING;

    static {
        projectClassLoaderCache = new ConcurrentHashMap<String, Map.Entry<String, GroovyClassLoader[]>>();
        scriptFolderSelectorCache = new ConcurrentHashMap<String, ScriptFolderSelector>();
        NONLOCKING = Boolean.getBoolean("greclipse.nonlocking");
        if (NONLOCKING) {
            System.out.println("property set: greclipse.nonlocking: will try to avoid locking jars");
        }
    }

    public CompilerOptions getCompilerOptions() {
        return this.compilerOptions;
    }

    protected static void clearCache() {
        projectClassLoaderCache.clear();
    }

    public static void clearCache(String projectName) {
        projectClassLoaderCache.remove(projectName);
        scriptFolderSelectorCache.remove(projectName);
    }

    public static void closeClassLoader(String projectName) {
        Map.Entry<String, GroovyClassLoader[]> entry = projectClassLoaderCache.get(projectName);
        if (entry != null) {
            Stream.of(entry.getValue()).filter(Objects::nonNull).forEach(GroovyParser::close);
        }
    }

    public static void close(GroovyClassLoader groovyClassLoader) {
        try {
            Object[] jarLoaders;
            Object urlClasspath = ReflectionUtils.getPrivateField(URLClassLoader.class, "ucp", groovyClassLoader);
            Object[] objectArray = jarLoaders = ((Collection)ReflectionUtils.getPrivateField(urlClasspath.getClass(), "loaders", urlClasspath)).toArray();
            int n = jarLoaders.length;
            int n2 = 0;
            while (n2 < n) {
                Object jarLoader = objectArray[n2];
                try {
                    JarFile jarFile = (JarFile)ReflectionUtils.getPrivateField(jarLoader.getClass(), "jar", jarLoader);
                    String jarFileName = jarFile.getName();
                    if (jarFileName.indexOf("cache") != -1 || jarFileName.indexOf("plugins") != -1) {
                        jarFile.close();
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                ++n2;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public GroovyParser(CompilerOptions compilerOptions, ProblemReporter problemReporter, boolean allowTransforms, boolean isReconcile) {
        this(null, compilerOptions, problemReporter, allowTransforms, isReconcile);
    }

    public GroovyParser(Object requestor, CompilerOptions compilerOptions, ProblemReporter problemReporter, boolean allowTransforms, boolean isReconcile) {
        this.requestor = requestor;
        this.compilerOptions = compilerOptions;
        this.problemReporter = problemReporter;
        this.projectName = compilerOptions.groovyProjectName;
        this.gclClasspath = compilerOptions.groovyClassLoaderPath;
        this.compilationUnit = this.newCompilationUnit(isReconcile, allowTransforms);
    }

    public void reset() {
        this.compilationUnit = this.newCompilationUnit(this.compilationUnit.isReconcile, this.compilationUnit.allowTransforms);
    }

    private org.codehaus.groovy.control.CompilationUnit newCompilationUnit(boolean isReconcile, boolean allowTransforms) {
        CompilerConfiguration compilerConfiguration = GroovyLanguageSupport.newCompilerConfiguration(this.compilerOptions, this.problemReporter);
        GroovyClassLoader[] classLoaders = this.getGroovyClassLoaders();
        org.codehaus.groovy.control.CompilationUnit cu = new org.codehaus.groovy.control.CompilationUnit(compilerConfiguration, null, classLoaders[0], classLoaders[1], allowTransforms, this.compilerOptions.groovyTransformsToRunOnReconcile, this.compilerOptions.groovyExcludeGlobalASTScan);
        this.resolver = new JDTResolver(cu);
        cu.removeOutputPhaseOperation();
        cu.setResolveVisitor(this.resolver);
        cu.tweak(isReconcile);
        if (allowTransforms && this.compilerOptions != null && (this.compilerOptions.groovyFlags & 1) != 0) {
            cu.addPhaseOperation(new GrailsInjector(classLoaders[1]), 5);
            new Grails20TestSupport(this.compilerOptions, classLoaders[1]).addGrailsTestCompilerCustomizers(cu);
            cu.addPhaseOperation(new GrailsGlobalPluginAwareEntityInjector(classLoaders[1]), 5);
        }
        return cu;
    }

    private GroovyClassLoader[] getGroovyClassLoaders() {
        if (this.gclClasspath == null && this.projectName == null) {
            if (this.batchLoader == null) {
                try {
                    LookupEnvironment lookupEnvironment;
                    if (this.requestor instanceof Compiler && (lookupEnvironment = ((Compiler)this.requestor).lookupEnvironment) != null) {
                        INameEnvironment nameEnvironment = lookupEnvironment.nameEnvironment;
                        if (nameEnvironment.getClass().getName().endsWith("tests.compiler.regression.InMemoryNameEnvironment")) {
                            nameEnvironment = ((INameEnvironment[])ReflectionUtils.getPrivateField(nameEnvironment.getClass(), "classLibs", nameEnvironment))[0];
                        }
                        if (nameEnvironment instanceof FileSystem) {
                            FileSystem.Classpath[] classpaths = (FileSystem.Classpath[])ReflectionUtils.getPrivateField(FileSystem.class, "classpaths", nameEnvironment);
                            if (classpaths != null) {
                                this.batchLoader = new GroovyClassLoader();
                                FileSystem.Classpath[] classpathArray = classpaths;
                                int n = classpaths.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    FileSystem.Classpath classpath = classpathArray[n2];
                                    this.batchLoader.addClasspath(classpath.getPath());
                                    ++n2;
                                }
                            } else {
                                System.err.println("Cannot find field 'classpaths' on FileSystem instance");
                            }
                        }
                    }
                }
                catch (Exception e) {
                    System.err.println("Unexpected problem computing classpath for AST transform loader:");
                    e.printStackTrace();
                }
            }
            return new GroovyClassLoader[]{new GrapeAwareGroovyClassLoader((ClassLoader)this.batchLoader), this.batchLoader};
        }
        if (this.gclClasspath != null && this.projectName != null) {
            Map.Entry entry = projectClassLoaderCache.computeIfAbsent(this.projectName, key -> {
                String[] parts = this.gclClasspath.split("###");
                String classPaths = parts[0];
                String xformPaths = parts[parts.length - 1];
                if (GroovyLogManager.manager.hasLoggers()) {
                    GroovyLogManager.manager.log(TraceCategory.AST_TRANSFORM, "transform classpath: " + xformPaths);
                }
                return new AbstractMap.SimpleEntry<String, GroovyClassLoader[]>(this.gclClasspath, new GroovyClassLoader[]{new GrapeAwareGroovyClassLoader(GroovyParser.newClassLoader(classPaths, null)), new GroovyClassLoader(GroovyParser.newClassLoader(xformPaths, GroovyParser.class.getClassLoader()))});
            });
            if (this.gclClasspath.equals(entry.getKey())) {
                return (GroovyClassLoader[])entry.getValue();
            }
            projectClassLoaderCache.remove(this.projectName);
            return this.getGroovyClassLoaders();
        }
        return new GroovyClassLoader[2];
    }

    private static URLClassLoader newClassLoader(String classpath, ClassLoader parent) {
        URL[] urls = (URL[])Stream.of(classpath.split(File.pathSeparator)).map(file -> {
            try {
                return new File((String)file).toURI().toURL();
            }
            catch (MalformedURLException ignore) {
                return null;
            }
        }).filter(Objects::nonNull).toArray(URL[]::new);
        if (NONLOCKING) {
            return new NonLockingJarFileClassLoader("AST Transform loader", urls, parent);
        }
        return new URLClassLoader(urls, parent);
    }

    public CompilationUnitDeclaration dietParse(ICompilationUnit sourceUnit, CompilationResult compilationResult) {
        BuildNotifier notifier;
        IPath location;
        char[] sourceCode = sourceUnit.getContents();
        if (sourceCode == null) {
            sourceCode = CharOperation.NO_CHAR;
        }
        GroovyErrorCollectorForJDT errorCollector = new GroovyErrorCollectorForJDT(this.compilationUnit.getConfiguration());
        String filepath = null;
        char[] fileName = sourceUnit.getFileName();
        filepath = sourceUnit instanceof CompilationUnit ? String.valueOf(((CompilationUnit)sourceUnit).fileName) : String.valueOf(fileName);
        Path path = new Path(filepath);
        IFile eclipseFile = null;
        if (ResourcesPlugin.getPlugin() != null && path.segmentCount() >= 2 && (location = (eclipseFile = ResourcesPlugin.getWorkspace().getRoot().getFile(path)).getLocation()) != null) {
            filepath = location.toFile().getAbsolutePath();
        }
        EclipseSourceUnit groovySourceUnit = new EclipseSourceUnit(eclipseFile, filepath, String.valueOf(sourceCode), this.compilationUnit.getConfiguration(), this.compilationUnit.getClassLoader(), errorCollector, this.resolver);
        groovySourceUnit.isReconcile = this.compilationUnit.isReconcile;
        GroovyCompilationUnitDeclaration gcuDeclaration = new GroovyCompilationUnitDeclaration(this.problemReporter, compilationResult, sourceCode.length, this.compilationUnit, groovySourceUnit, this.compilerOptions);
        compilationResult.lineSeparatorPositions = GroovyUtils.getSourceLineSeparatorsIn(sourceCode);
        this.compilationUnit.addSource(groovySourceUnit);
        if (this.requestor instanceof Compiler && ((Compiler)this.requestor).requestor instanceof BatchImageBuilder && (notifier = ((BatchImageBuilder)((Compiler)this.requestor).requestor).notifier) != null) {
            this.compilationUnit.setProgressListener(new ProgressListenerImpl(notifier));
        }
        gcuDeclaration.processToPhase(3);
        if (gcuDeclaration.getModuleNode() != null) {
            gcuDeclaration.populateCompilationUnitDeclaration();
            TypeDeclaration[] typeDeclarationArray = gcuDeclaration.types;
            int n = gcuDeclaration.types.length;
            int n2 = 0;
            while (n2 < n) {
                TypeDeclaration decl = typeDeclarationArray[n2];
                this.resolver.record((GroovyTypeDeclaration)decl);
                ++n2;
            }
        }
        if (this.projectName != null && eclipseFile != null) {
            ScriptFolderSelector scriptFolderSelector = scriptFolderSelectorCache.get(this.projectName);
            if (scriptFolderSelector == null) {
                scriptFolderSelector = new ScriptFolderSelector(ResourcesPlugin.getWorkspace().getRoot().getProject(this.projectName));
                scriptFolderSelectorCache.put(this.projectName, scriptFolderSelector);
            }
            if (scriptFolderSelector.isScript(eclipseFile)) {
                gcuDeclaration.tagAsScript();
            }
        }
        if (debugRequestor != null) {
            debugRequestor.acceptCompilationUnitDeclaration(gcuDeclaration);
        }
        return gcuDeclaration;
    }

    protected static class GrapeAwareGroovyClassLoader
    extends GroovyClassLoader {
        protected boolean grabbed;

        protected GrapeAwareGroovyClassLoader(ClassLoader parent) {
            super(parent);
        }

        @Override
        public void addURL(URL url) {
            this.grabbed = true;
            super.addURL(url);
        }
    }

    private static class ProgressListenerImpl
    implements CompilationUnit.ProgressListener {
        private BuildNotifier notifier;

        public ProgressListenerImpl(BuildNotifier notifier) {
            this.notifier = notifier;
        }

        @Override
        public void parseComplete(int phase, String sourceUnitName) {
            try {
                int lastSlash = sourceUnitName.lastIndexOf("/");
                if (lastSlash == -1) {
                    lastSlash = sourceUnitName.lastIndexOf("\\");
                }
                if (lastSlash != -1) {
                    StringBuffer msg = new StringBuffer();
                    msg.append("Parsing groovy source in ");
                    msg.append(sourceUnitName, 0, lastSlash);
                    this.notifier.subTask(msg.toString());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.notifier.checkCancel();
        }

        @Override
        public void generateComplete(int phase, ClassNode classNode) {
            try {
                String pkgName = classNode.getPackageName();
                if (pkgName != null && pkgName.length() > 0) {
                    StringBuffer msg = new StringBuffer();
                    msg.append("Generating groovy classes in ");
                    msg.append(pkgName);
                    this.notifier.subTask(msg.toString());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.notifier.checkCancel();
        }
    }
}

