/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jdt.groovy.internal.compiler.ast;

import groovy.lang.GroovyRuntimeException;
import groovy.transform.PackageScopeTarget;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.math.BigInteger;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.groovy.GroovyBugError;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.CodeVisitorSupport;
import org.codehaus.groovy.ast.Comment;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.ImportNode;
import org.codehaus.groovy.ast.InnerClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.PackageNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.TaskEntry;
import org.codehaus.groovy.ast.expr.AnnotationConstantExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.control.ErrorCollector;
import org.codehaus.groovy.control.Janitor;
import org.codehaus.groovy.control.MultipleCompilationErrorsException;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.io.ReaderSource;
import org.codehaus.groovy.control.messages.ExceptionMessage;
import org.codehaus.groovy.control.messages.LocatedMessage;
import org.codehaus.groovy.control.messages.Message;
import org.codehaus.groovy.control.messages.SimpleMessage;
import org.codehaus.groovy.control.messages.SyntaxErrorMessage;
import org.codehaus.groovy.eclipse.GroovyLogManager;
import org.codehaus.groovy.eclipse.TraceCategory;
import org.codehaus.groovy.syntax.CSTNode;
import org.codehaus.groovy.syntax.PreciseSyntaxException;
import org.codehaus.groovy.syntax.RuntimeParserException;
import org.codehaus.groovy.syntax.SyntaxException;
import org.codehaus.groovy.syntax.Token;
import org.codehaus.groovy.tools.GroovyClass;
import org.codehaus.jdt.groovy.control.EclipseSourceUnit;
import org.codehaus.jdt.groovy.core.dom.GroovyCompilationUnit;
import org.codehaus.jdt.groovy.internal.compiler.ast.AliasImportReference;
import org.codehaus.jdt.groovy.internal.compiler.ast.GroovyClassFile;
import org.codehaus.jdt.groovy.internal.compiler.ast.GroovyCompilationUnitScope;
import org.codehaus.jdt.groovy.internal.compiler.ast.GroovyEclipseBug;
import org.codehaus.jdt.groovy.internal.compiler.ast.GroovyParser;
import org.codehaus.jdt.groovy.internal.compiler.ast.GroovyTypeDeclaration;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.groovy.core.util.GroovyUtils;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.AnnotationMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.ArrayInitializer;
import org.eclipse.jdt.internal.compiler.ast.ArrayQualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.ArrayTypeReference;
import org.eclipse.jdt.internal.compiler.ast.CharLiteral;
import org.eclipse.jdt.internal.compiler.ast.ClassLiteralAccess;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ConstructorDeclaration;
import org.eclipse.jdt.internal.compiler.ast.DoubleLiteral;
import org.eclipse.jdt.internal.compiler.ast.FalseLiteral;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.FloatLiteral;
import org.eclipse.jdt.internal.compiler.ast.ImportReference;
import org.eclipse.jdt.internal.compiler.ast.IntLiteral;
import org.eclipse.jdt.internal.compiler.ast.Javadoc;
import org.eclipse.jdt.internal.compiler.ast.Literal;
import org.eclipse.jdt.internal.compiler.ast.LongLiteral;
import org.eclipse.jdt.internal.compiler.ast.MarkerAnnotation;
import org.eclipse.jdt.internal.compiler.ast.MemberValuePair;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.NormalAnnotation;
import org.eclipse.jdt.internal.compiler.ast.NullLiteral;
import org.eclipse.jdt.internal.compiler.ast.ParameterizedQualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.ParameterizedSingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedAllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.QualifiedNameReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.SingleMemberAnnotation;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.SingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.StringLiteral;
import org.eclipse.jdt.internal.compiler.ast.TrueLiteral;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.ast.Wildcard;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.jdt.internal.core.util.Util;

public class GroovyCompilationUnitDeclaration
extends CompilationUnitDeclaration {
    private org.codehaus.groovy.control.CompilationUnit groovyCompilationUnit;
    private SourceUnit groovySourceUnit;
    private CompilerOptions compilerOptions;
    public static boolean defaultCheckGenerics = false;
    public static boolean earlyTransforms = true;
    private boolean isScript = false;
    private TraitHelper traitHelper = new TraitHelper();
    private static final boolean DEBUG_TASK_TAGS = false;
    private static final boolean DEBUG = false;

    static {
        try {
            String value = System.getProperty("earlyTransforms");
            if (value != null) {
                if (value.equalsIgnoreCase("true")) {
                    GroovyCompilationUnitDeclaration.log("groovyeclipse.earlyTransforms = true");
                    earlyTransforms = true;
                } else if (value.equalsIgnoreCase("false")) {
                    GroovyCompilationUnitDeclaration.log("groovyeclipse.earlyTransforms = false");
                    earlyTransforms = false;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public GroovyCompilationUnitDeclaration(ProblemReporter problemReporter, CompilationResult compilationResult, int sourceLength, org.codehaus.groovy.control.CompilationUnit groovyCompilationUnit, SourceUnit groovySourceUnit, CompilerOptions compilerOptions) {
        super(problemReporter, compilationResult, sourceLength);
        this.groovyCompilationUnit = groovyCompilationUnit;
        this.groovySourceUnit = groovySourceUnit;
        this.compilerOptions = compilerOptions;
    }

    public boolean processToPhase(int phase) {
        block17: {
            if (phase == 5) {
                block6: for (ModuleNode module : this.groovyCompilationUnit.getAST().getModules()) {
                    for (ClassNode classNode : module.getClasses()) {
                        if (!this.traitHelper.isTrait(classNode)) continue;
                        GroovyParser.clearCache();
                        continue block6;
                    }
                }
            }
            boolean alreadyHasErrors = this.compilationResult.hasErrors();
            try {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(this.groovyCompilationUnit.getTransformLoader());
                    this.groovyCompilationUnit.compile(phase);
                }
                finally {
                    Thread.currentThread().setContextClassLoader(cl);
                }
                if (this.groovySourceUnit.getErrorCollector().hasErrors()) {
                    this.recordProblems(this.groovySourceUnit.getErrorCollector().getErrors());
                    return false;
                }
                return true;
            }
            catch (MultipleCompilationErrorsException mce) {
                Exception cause;
                ErrorCollector collector;
                this.fixGroovyRuntimeException(mce);
                if (GroovyLogManager.manager.hasLoggers()) {
                    GroovyLogManager.manager.log(TraceCategory.COMPILER, mce.getMessage());
                }
                if ((collector = mce.getErrorCollector()).getErrorCount() == 1 && mce.getErrorCollector().getError(0) instanceof ExceptionMessage && (cause = ((ExceptionMessage)mce.getErrorCollector().getError(0)).getCause()) instanceof AbortCompilation) {
                    throw (AbortCompilation)cause;
                }
                this.recordProblems(mce.getErrorCollector().getErrors());
            }
            catch (GroovyBugError gbe) {
                if (GroovyLogManager.manager.hasLoggers()) {
                    GroovyLogManager.manager.log(TraceCategory.COMPILER, gbe.getBugText());
                }
                if (gbe.getCause() instanceof AbortCompilation) {
                    AbortCompilation abort = (AbortCompilation)gbe.getCause();
                    if (abort.isSilent) break block17;
                    if (abort.problem != null) {
                        this.problemReporter.record(abort.problem, this.compilationResult, this, true);
                    }
                    throw abort;
                }
                if (alreadyHasErrors) {
                    Util.log(new Status(1, "org.eclipse.jdt.groovy.core", "Ignoring GroovyBugError since it is likely caused by earlier issues", (Throwable)((Object)gbe)));
                }
                Util.log(new Status(4, "org.eclipse.jdt.groovy.core", "Groovy compiler error", (Throwable)((Object)gbe)));
                SyntaxErrorMessage syntaxError = new SyntaxErrorMessage(new SyntaxException("Groovy compiler error: " + gbe.getBugText(), (Throwable)((Object)gbe), 1, 0), this.groovySourceUnit);
                ErrorCollector collector = this.groovySourceUnit.getErrorCollector();
                collector.addError(syntaxError);
                this.recordProblems(collector.getErrors());
            }
        }
        return false;
    }

    private void fixGroovyRuntimeException(MultipleCompilationErrorsException mce) {
        ArrayList<SyntaxException> syntaxErrors = new ArrayList<SyntaxException>();
        Iterator it = mce.getErrorCollector().getErrors().iterator();
        while (it.hasNext()) {
            ExceptionMessage em;
            Message m = (Message)it.next();
            if (!(m instanceof ExceptionMessage) || !((em = (ExceptionMessage)m).getCause() instanceof GroovyRuntimeException) || !(((GroovyRuntimeException)em.getCause()).getCause() instanceof SyntaxException)) continue;
            syntaxErrors.add((SyntaxException)em.getCause().getCause());
            it.remove();
        }
        for (SyntaxException se : syntaxErrors) {
            mce.getErrorCollector().addError(se, this.groovySourceUnit);
        }
    }

    public org.codehaus.groovy.control.CompilationUnit getCompilationUnit() {
        return this.groovyCompilationUnit;
    }

    public void populateCompilationUnitDeclaration() {
        UnitPopulator populator = new UnitPopulator();
        populator.populate(this, this.groovySourceUnit);
    }

    @Override
    public void generateCode() {
        block9: {
            block8: {
                boolean successful = this.processToPhase(9);
                if (!successful) break block8;
                List classes = this.groovyCompilationUnit.getClasses();
                for (GroovyClass clazz : classes) {
                    GroovyCompilationUnitScope gcuScope;
                    ClassNode classnode = clazz.getClassNode();
                    if (clazz.getSourceUnit() != this.groovySourceUnit) continue;
                    String classname = clazz.getName();
                    SourceTypeBinding binding = null;
                    if (this.types != null && this.types.length != 0) {
                        binding = GroovyCompilationUnitDeclaration.findBinding(this.types, clazz.getClassNode());
                    }
                    if (binding == null) {
                        ClassNode current = classnode;
                        while (current instanceof InnerClassNode && binding == null) {
                            current = ((InnerClassNode)current).getOuterClass();
                            binding = GroovyCompilationUnitDeclaration.findBinding(this.types, current);
                        }
                    }
                    boolean isScript = false;
                    if (binding != null && binding.scope != null && binding.scope.parent instanceof GroovyCompilationUnitScope && (gcuScope = (GroovyCompilationUnitScope)binding.scope.parent).isScript()) {
                        isScript = true;
                    }
                    if (isScript) continue;
                    byte[] classbytes = clazz.getBytes();
                    String path = clazz.getName().replace('.', '/');
                    GroovyClassFile classFile = new GroovyClassFile(classname, classbytes, binding, path);
                    char[] classNameChars = classname.toCharArray();
                    if (binding == null) {
                        Map compiledTypes = (Map)Map.class.cast(this.compilationResult.compiledTypes);
                        compiledTypes.put(classNameChars, classFile);
                        continue;
                    }
                    this.compilationResult.record(classNameChars, classFile);
                }
                break block9;
            }
            if (this.types == null) break block9;
            TypeDeclaration[] typeDeclarationArray = this.types;
            int n = this.types.length;
            int n2 = 0;
            while (n2 < n) {
                TypeDeclaration type = typeDeclarationArray[n2];
                if (type.binding != null) {
                    ClassFile.createProblemType(type, this.compilationResult);
                }
                ++n2;
            }
        }
    }

    private static void log(String message) {
        System.out.println(message);
    }

    private static SourceTypeBinding findBinding(TypeDeclaration[] typedeclarations, ClassNode cnode) {
        TypeDeclaration[] typeDeclarationArray = typedeclarations;
        int n = typedeclarations.length;
        int n2 = 0;
        while (n2 < n) {
            SourceTypeBinding binding;
            TypeDeclaration typedeclaration = typeDeclarationArray[n2];
            GroovyTypeDeclaration groovyTypeDeclaration = (GroovyTypeDeclaration)typedeclaration;
            if (groovyTypeDeclaration.getClassNode().equals(cnode)) {
                return groovyTypeDeclaration.binding;
            }
            if (typedeclaration.memberTypes != null && (binding = GroovyCompilationUnitDeclaration.findBinding(typedeclaration.memberTypes, cnode)) != null) {
                return binding;
            }
            ++n2;
        }
        return null;
    }

    private void recordProblems(List<?> errors) {
        ArrayList<Message> errorsRecorded = new ArrayList<Message>();
        Iterator<?> iterator = errors.iterator();
        while (iterator.hasNext()) {
            CSTNode context;
            SyntaxException syntaxException = null;
            Message message = (Message)iterator.next();
            StringWriter sw = new StringWriter();
            message.write(new PrintWriter(sw));
            String msg = sw.toString();
            CategorizedProblem p = null;
            int line = 0;
            int sev = 0;
            int scol = 0;
            int ecol = 0;
            if (message instanceof LocatedMessage && (context = ((LocatedMessage)message).getContext()) instanceof Token) {
                line = context.getStartLine();
                scol = context.getStartColumn();
                String text = ((Token)context).getText();
                ecol = scol + (text == null ? 1 : text.length() - 1);
            }
            if (message instanceof SimpleMessage) {
                SimpleMessage simpleMessage = (SimpleMessage)message;
                sev |= 1;
                String simpleText = simpleMessage.getMessage();
                if (simpleText.length() > 1 && simpleText.charAt(0) == '\n') {
                    simpleText = simpleText.substring(1);
                }
                if ((msg = "Groovy:" + simpleText).indexOf("\n") != -1) {
                    msg = msg.substring(0, msg.indexOf("\n"));
                }
            }
            if (message instanceof SyntaxErrorMessage) {
                SyntaxErrorMessage errorMessage = (SyntaxErrorMessage)message;
                syntaxException = errorMessage.getCause();
                sev |= 1;
                String actualMessage = syntaxException.getMessage();
                if (actualMessage.length() > 1 && actualMessage.charAt(0) == '\n') {
                    actualMessage = actualMessage.substring(1);
                }
                if ((msg = "Groovy:" + actualMessage).indexOf("\n") != -1) {
                    msg = msg.substring(0, msg.indexOf("\n"));
                }
                line = syntaxException.getLine();
                scol = errorMessage.getCause().getStartColumn();
                ecol = errorMessage.getCause().getEndColumn() - 1;
            }
            int soffset = -1;
            int eoffset = -1;
            if (message instanceof ExceptionMessage) {
                ExceptionMessage em = (ExceptionMessage)message;
                sev |= 1;
                if (em.getCause() instanceof RuntimeParserException) {
                    ModuleNode thisModuleNode;
                    ModuleNode errorModuleNode;
                    RuntimeParserException rpe = (RuntimeParserException)em.getCause();
                    sev |= 1;
                    msg = "Groovy:" + rpe.getMessage();
                    if (msg.indexOf("\n") != -1) {
                        msg = msg.substring(0, msg.indexOf("\n"));
                    }
                    if (!(errorModuleNode = rpe.getModule()).equals(thisModuleNode = this.getModuleNode())) continue;
                    soffset = rpe.getNode().getStart();
                    eoffset = rpe.getNode().getEnd() - 1;
                    line = 0;
                    while (this.compilationResult.lineSeparatorPositions[line] < soffset && line < this.compilationResult.lineSeparatorPositions.length) {
                        ++line;
                    }
                    ++line;
                }
            }
            if (syntaxException instanceof PreciseSyntaxException) {
                soffset = ((PreciseSyntaxException)syntaxException).getStartOffset();
                eoffset = ((PreciseSyntaxException)syntaxException).getEndOffset();
                line = 0;
                while (line < this.compilationResult.lineSeparatorPositions.length && this.compilationResult.lineSeparatorPositions[line] < soffset) {
                    ++line;
                }
                ++line;
            } else {
                if (soffset == -1) {
                    soffset = this.getOffset(this.compilationResult.lineSeparatorPositions, line, scol);
                }
                if (eoffset == -1) {
                    eoffset = this.getOffset(this.compilationResult.lineSeparatorPositions, line, ecol);
                }
            }
            if (soffset > eoffset) {
                eoffset = soffset;
            }
            if (soffset > this.sourceEnd) {
                soffset = this.sourceEnd;
                eoffset = this.sourceEnd;
            }
            p = new DefaultProblemFactory().createProblem(this.getFileName(), 0, new String[]{msg}, 0, new String[]{msg}, sev, soffset, eoffset, line, scol);
            this.problemReporter.record(p, this.compilationResult, this, false);
            errorsRecorded.add(message);
            GroovyCompilationUnitDeclaration.log(String.valueOf(String.valueOf(this.compilationResult.getFileName())) + ": " + line + " " + msg);
        }
        errors.removeAll(errorsRecorded);
    }

    private int getOffset(int[] lineSeparatorPositions, int line, int col) {
        if (lineSeparatorPositions.length > line - 2 && line > 1) {
            return lineSeparatorPositions[line - 2] + col;
        }
        return col;
    }

    @Override
    public CompilationUnitScope buildCompilationUnitScope(LookupEnvironment lookupEnvironment) {
        GroovyCompilationUnitScope gcus = new GroovyCompilationUnitScope(this, lookupEnvironment);
        gcus.setIsScript(this.isScript);
        return gcus;
    }

    public ModuleNode getModuleNode() {
        return this.groovySourceUnit == null ? null : this.groovySourceUnit.getAST();
    }

    public SourceUnit getSourceUnit() {
        return this.groovySourceUnit;
    }

    @Override
    public CompilationUnit getSpecialDomCompilationUnit(AST ast) {
        return new GroovyCompilationUnit(ast);
    }

    public String print() {
        return this.toString();
    }

    public GroovyCompilationUnitScope getScope() {
        return (GroovyCompilationUnitScope)this.scope;
    }

    @Override
    public void resolve() {
        this.processToPhase(4);
        this.checkForTags();
        this.setComments();
    }

    private void checkForTags() {
        if (this.compilerOptions == null) {
            return;
        }
        List<Comment> comments = this.groovySourceUnit.getComments();
        if (comments == null || comments.isEmpty()) {
            return;
        }
        char[][] taskTags = this.compilerOptions.taskTags;
        char[][] taskPriorities = this.compilerOptions.taskPriorities;
        boolean caseSensitiveTags = this.compilerOptions.isTaskCaseSensitive;
        try {
            if (taskTags != null) {
                for (Comment comment : comments) {
                    ArrayList<TaskEntry> allTasksInComment = new ArrayList<TaskEntry>();
                    int t = 0;
                    while (t < taskTags.length) {
                        String taskTag = String.valueOf(taskTags[t]);
                        String taskPriority = null;
                        if (taskPriorities != null) {
                            taskPriority = String.valueOf(taskPriorities[t]);
                        }
                        allTasksInComment.addAll(comment.getPositionsOf(taskTag, taskPriority, this.compilationResult.lineSeparatorPositions, caseSensitiveTags));
                        ++t;
                    }
                    if (allTasksInComment.isEmpty()) continue;
                    int t1 = 0;
                    while (t1 < allTasksInComment.size()) {
                        int t2 = 0;
                        while (t2 < allTasksInComment.size()) {
                            if (t1 != t2) {
                                TaskEntry taskOne = (TaskEntry)allTasksInComment.get(t1);
                                TaskEntry taskTwo = (TaskEntry)allTasksInComment.get(t2);
                                if (taskOne.start + taskOne.taskTag.length() + 1 == taskTwo.start) {
                                    taskOne.isAdjacentTo = taskTwo;
                                } else if (taskOne.getEnd() > taskTwo.start && taskOne.start < taskTwo.start) {
                                    taskOne.setEnd(taskTwo.start - 1);
                                } else if (taskTwo.getEnd() > taskOne.start && taskTwo.start < taskOne.start) {
                                    taskTwo.setEnd(taskOne.start - 1);
                                }
                            }
                            ++t2;
                        }
                        ++t1;
                    }
                    for (TaskEntry taskEntry : allTasksInComment) {
                        this.problemReporter.referenceContext = this;
                        this.problemReporter.task(taskEntry.taskTag, taskEntry.getText(), taskEntry.taskPriority, taskEntry.start, taskEntry.getEnd());
                    }
                }
            }
        }
        catch (AbortCompilation comment) {
        }
        catch (Throwable t) {
            Util.log(t, "Unexpected problem processing task tags in " + this.groovySourceUnit.getName());
            new RuntimeException("Unexpected problem processing task tags in " + this.groovySourceUnit.getName(), t).printStackTrace();
        }
    }

    private void setComments() {
        List<Comment> groovyComments = this.groovySourceUnit.getComments();
        if (groovyComments == null || groovyComments.size() == 0) {
            return;
        }
        this.comments = new int[groovyComments.size()][2];
        int c = 0;
        int max = groovyComments.size();
        while (c < max) {
            Comment groovyComment = groovyComments.get(c);
            this.comments[c] = groovyComment.getPositions(this.compilationResult.lineSeparatorPositions);
            ++c;
        }
    }

    @Override
    public void analyseCode() {
        this.processToPhase(5);
    }

    @Override
    public void cleanUp() {
        super.cleanUp();
        if (this.groovySourceUnit instanceof EclipseSourceUnit) {
            ((EclipseSourceUnit)this.groovySourceUnit).resolver.cleanUp();
        }
    }

    public void tagAsScript() {
        this.isScript = true;
    }

    public static class FieldDeclarationWithInitializer
    extends FieldDeclaration {
        private Expression initializer;

        public FieldDeclarationWithInitializer(char[] name, int sourceStart, int sourceEnd) {
            super(name, sourceStart, sourceEnd);
        }

        public Expression getGroovyInitializer() {
            return this.initializer;
        }
    }

    private class TraitHelper {
        private boolean toBeInitialized = true;
        private boolean lookForTraitAlias = false;

        private TraitHelper() {
        }

        private void initialize() {
            if (GroovyCompilationUnitDeclaration.this.imports != null) {
                ImportReference[] importReferenceArray = GroovyCompilationUnitDeclaration.this.imports;
                int n = GroovyCompilationUnitDeclaration.this.imports.length;
                int n2 = 0;
                while (n2 < n) {
                    ImportReference i = importReferenceArray[n2];
                    String importedType = i.toString();
                    if ("groovy.transform.Trait".equals(importedType)) {
                        this.lookForTraitAlias = true;
                        break;
                    }
                    if (importedType.endsWith(".Trait")) {
                        this.lookForTraitAlias = false;
                        break;
                    }
                    if ("groovy.transform.*".equals(importedType)) {
                        this.lookForTraitAlias = true;
                    }
                    ++n2;
                }
                this.toBeInitialized = true;
            }
        }

        private boolean isTrait(ClassNode classNode) {
            List<AnnotationNode> annotations;
            if (classNode == null) {
                return false;
            }
            if (this.toBeInitialized) {
                this.initialize();
            }
            if ((annotations = classNode.getAnnotations()).size() > 0) {
                for (AnnotationNode annotation : annotations) {
                    if ("groovy.transform.Trait".equals(annotation.getClassNode().getName())) {
                        return true;
                    }
                    if (!this.lookForTraitAlias || !"Trait".equals(annotation.getClassNode().getName())) continue;
                    return true;
                }
            }
            return false;
        }
    }

    public static class UnitPopulator {
        private Janitor janitor;
        private SourceUnit sourceUnit;
        private GroovyCompilationUnitDeclaration unitDeclaration;
        private Map<ClassNode, Object> anonymousLocations;
        private boolean checkGenerics = defaultCheckGenerics;
        private static final Pattern AND = Pattern.compile("^\\s*&\\s*");
        private static final Pattern EXTENDS = Pattern.compile("^\\s*extends\\s+");
        private static final Map<Character, Integer> charToTypeId = new HashMap<Character, Integer>();
        private static final Map<String, Integer> nameToPrimitiveTypeId = new HashMap<String, Integer>();
        private static final NumberFormat Prefix;
        private static long NON_EXISTENT_POSITION;

        static {
            charToTypeId.put(Character.valueOf('D'), 8);
            charToTypeId.put(Character.valueOf('I'), 10);
            charToTypeId.put(Character.valueOf('F'), 9);
            charToTypeId.put(Character.valueOf('J'), 7);
            charToTypeId.put(Character.valueOf('Z'), 5);
            charToTypeId.put(Character.valueOf('B'), 3);
            charToTypeId.put(Character.valueOf('C'), 2);
            charToTypeId.put(Character.valueOf('S'), 4);
            nameToPrimitiveTypeId.put("double", 8);
            nameToPrimitiveTypeId.put("int", 10);
            nameToPrimitiveTypeId.put("float", 9);
            nameToPrimitiveTypeId.put("long", 7);
            nameToPrimitiveTypeId.put("boolean", 5);
            nameToPrimitiveTypeId.put("byte", 3);
            nameToPrimitiveTypeId.put("char", 2);
            nameToPrimitiveTypeId.put("short", 4);
            nameToPrimitiveTypeId.put("void", 6);
            Prefix = NumberFormat.getInstance();
            Prefix.setMinimumIntegerDigits(5);
            Prefix.setGroupingUsed(false);
            NON_EXISTENT_POSITION = -2L;
        }

        void populate(GroovyCompilationUnitDeclaration target, SourceUnit source) {
            this.unitDeclaration = target;
            this.sourceUnit = source;
            ModuleNode moduleNode = this.sourceUnit.getAST();
            try {
                this.createPackageDeclaration(moduleNode);
                this.createImportDeclarations(moduleNode);
                this.createTypeDeclarations(moduleNode);
            }
            finally {
                if (this.janitor != null) {
                    this.janitor.cleanup();
                    this.janitor = null;
                }
            }
        }

        private void createPackageDeclaration(ModuleNode moduleNode) {
            if (moduleNode.hasPackageName()) {
                String packageName = moduleNode.getPackageName();
                if (packageName.endsWith(".")) {
                    packageName = packageName.substring(0, packageName.length() - 1);
                }
                PackageNode packageNode = moduleNode.getPackage();
                char[][] splits = CharOperation.splitOn('.', packageName.toCharArray());
                long[] positions = this.positionsFor(splits, this.startOffset(packageNode), this.endOffset(packageNode));
                ImportReference ref = new ImportReference(splits, positions, true, 0);
                ref.annotations = this.createAnnotations(packageNode.getAnnotations());
                ref.declarationEnd = ref.sourceEnd + this.trailerLength(packageNode);
                ref.declarationSourceStart = Math.max(0, ref.sourceStart - "package ".length());
                ref.declarationSourceEnd = ref.sourceEnd;
                this.unitDeclaration.currentPackage = ref;
            }
        }

        private void createImportDeclarations(ModuleNode moduleNode) {
            List<ImportNode> importNodes = moduleNode.getImports();
            List<ImportNode> importPackages = moduleNode.getStarImports();
            Map<String, ImportNode> importStatics = moduleNode.getStaticImports();
            Map<String, ImportNode> importStaticStars = moduleNode.getStaticStarImports();
            int importCount = importNodes.size() + importPackages.size() + importStatics.size() + importStaticStars.size();
            if (importCount > 0) {
                ImportReference ref;
                int endOffset;
                char[][] splits;
                int typeStartOffset;
                TreeMap<String, ImportReference> importReferences = new TreeMap<String, ImportReference>();
                for (ImportNode importNode : importNodes) {
                    AliasImportReference ref2;
                    long[] positions;
                    int endOffset2 = this.endOffset(importNode);
                    int typeEndOffset = -2;
                    typeStartOffset = -1;
                    if (endOffset2 > 0) {
                        typeEndOffset = importNode.getTypeEnd();
                        typeStartOffset = importNode.getTypeStart();
                        if (typeStartOffset < 1) continue;
                    }
                    splits = CharOperation.splitOn('.', importNode.getClassName().toCharArray());
                    if (importNode.getAlias() == null || importNode.getAlias().length() < 1 || importNode.getAlias().equals(String.valueOf(splits[splits.length - 1]))) {
                        endOffset2 = typeEndOffset;
                        positions = this.positionsFor(splits, typeStartOffset, endOffset2);
                        ImportReference ref22 = new ImportReference(splits, positions, false, 0);
                    } else {
                        positions = this.positionsFor(splits, typeStartOffset, endOffset2);
                        ref2 = new AliasImportReference(importNode.getAlias().toCharArray(), splits, positions, false, 0);
                    }
                    ref2.annotations = this.createAnnotations(importNode.getAnnotations());
                    ref2.sourceEnd = Math.max(endOffset2 - 1, ref2.sourceStart);
                    if (ref2.sourceEnd < 0) {
                        ref2.declarationSourceStart = -1;
                        ref2.declarationSourceEnd = -2;
                        ref2.declarationEnd = -2;
                        ref2.sourceEnd = -2;
                    } else {
                        ref2.declarationEnd = ref2.sourceEnd + this.trailerLength(importNode);
                        ref2.declarationSourceStart = this.startOffset(importNode);
                        ref2.declarationSourceEnd = ref2.sourceEnd;
                    }
                    importReferences.put(UnitPopulator.lexicalKey(ref2), ref2);
                }
                for (ImportNode importNode : importPackages) {
                    String importText = importNode.getText();
                    endOffset = this.endOffset(importNode);
                    int packageEndOffset = -2;
                    int packageStartOffset = -1;
                    if (endOffset > 0) {
                        packageStartOffset = importNode.getStart() + "import ".length();
                        packageEndOffset = packageStartOffset + importText.length() - "import ".length() - ".*".length();
                    }
                    char[][] splits2 = CharOperation.splitOn('.', importNode.getPackageName().substring(0, importNode.getPackageName().length() - 1).toCharArray());
                    ref = new ImportReference(splits2, this.positionsFor(splits2, packageStartOffset, packageEndOffset), true, 0);
                    ref.annotations = this.createAnnotations(importNode.getAnnotations());
                    ref.sourceEnd = Math.max(endOffset - 1, ref.sourceStart);
                    if (ref.sourceEnd < 0) {
                        ref.declarationSourceStart = -1;
                        ref.declarationSourceEnd = -2;
                        ref.declarationEnd = -2;
                        ref.sourceEnd = -2;
                    } else {
                        ref.declarationEnd = ref.sourceEnd + this.trailerLength(importNode);
                        ref.declarationSourceStart = importNode.getStart();
                        ref.declarationSourceEnd = ref.sourceEnd;
                    }
                    importReferences.put(UnitPopulator.lexicalKey(ref), ref);
                }
                for (Map.Entry entry : importStatics.entrySet()) {
                    ImportNode importNode = (ImportNode)entry.getValue();
                    endOffset = this.endOffset(importNode);
                    typeStartOffset = importNode.getTypeStart();
                    splits = CharOperation.splitOn('.', (String.valueOf(importNode.getClassName()) + '.' + importNode.getFieldName()).toCharArray());
                    long[] positions = this.positionsFor(splits, typeStartOffset, endOffset);
                    ref = importNode.getAlias() == null || importNode.getAlias().length() < 1 || importNode.getAlias().equals(importNode.getFieldName()) ? new ImportReference(splits, positions, false, 8) : new AliasImportReference(importNode.getAlias().toCharArray(), splits, positions, false, 8);
                    ref.annotations = this.createAnnotations(importNode.getAnnotations());
                    ref.sourceEnd = Math.max(endOffset - 1, ref.sourceStart);
                    if (ref.sourceEnd < 0) {
                        ref.declarationSourceStart = -1;
                        ref.declarationSourceEnd = -2;
                        ref.declarationEnd = -2;
                        ref.sourceEnd = -2;
                    } else {
                        ref.declarationEnd = ref.sourceEnd + this.trailerLength(importNode);
                        ref.declarationSourceStart = this.startOffset(importNode);
                        ref.declarationSourceEnd = ref.sourceEnd;
                    }
                    importReferences.put(UnitPopulator.lexicalKey(ref), ref);
                }
                for (Map.Entry entry : importStaticStars.entrySet()) {
                    String classname = (String)entry.getKey();
                    ImportNode importNode = (ImportNode)entry.getValue();
                    int endOffset3 = this.endOffset(importNode);
                    int typeEndOffset = -2;
                    int typeStartOffset2 = -1;
                    if (endOffset3 > 0) {
                        typeEndOffset = importNode.getTypeEnd();
                        typeStartOffset2 = importNode.getTypeStart();
                    }
                    char[][] splits3 = CharOperation.splitOn('.', classname.toCharArray());
                    long[] positions = this.positionsFor(splits3, typeStartOffset2, typeEndOffset);
                    ImportReference ref3 = new ImportReference(splits3, positions, true, 8);
                    ref3.annotations = this.createAnnotations(importNode.getAnnotations());
                    ref3.sourceEnd = Math.max(endOffset3 - 1, ref3.sourceStart);
                    if (ref3.sourceEnd < 0) {
                        ref3.declarationSourceStart = -1;
                        ref3.declarationSourceEnd = -2;
                        ref3.declarationEnd = -2;
                        ref3.sourceEnd = -2;
                    } else {
                        ref3.declarationEnd = ref3.sourceEnd + this.trailerLength(importNode);
                        ref3.declarationSourceStart = importNode.getStart();
                        ref3.declarationSourceEnd = ref3.sourceEnd;
                    }
                    importReferences.put(UnitPopulator.lexicalKey(ref3), ref3);
                }
                if (!importReferences.isEmpty()) {
                    ImportReference[] importReferenceArray;
                    ImportReference[] importReferenceArray2 = importReferenceArray = importReferences.values().toArray(new ImportReference[0]);
                    int n = importReferenceArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ImportReference ref4 = importReferenceArray2[n2];
                        if (ref4.declarationSourceStart > 0 && ref4.declarationEnd - ref4.declarationSourceStart + 1 < 0) {
                            throw new IllegalStateException(String.format("Import reference alongside class %s will trigger later failure: %s declSourceStart=%d declEnd=%d", moduleNode.getClasses().get(0), ref4.toString(), ref4.declarationSourceStart, ref4.declarationEnd));
                        }
                        ++n2;
                    }
                    this.unitDeclaration.imports = importReferenceArray;
                }
            }
        }

        private void createTypeDeclarations(ModuleNode moduleNode) {
            List<ClassNode> moduleClassNodes = moduleNode.getClasses();
            for (ClassNode classNode : moduleClassNodes) {
                if (!classNode.isPrimaryClassNode() || !GroovyUtils.isAnonymous(classNode)) continue;
                this.anonymousLocations = new HashMap<ClassNode, Object>();
                break;
            }
            ArrayList<GroovyTypeDeclaration> typeDeclarations = new ArrayList<GroovyTypeDeclaration>();
            HashMap<ClassNode, GroovyTypeDeclaration> fromClassNodeToDecl = new HashMap<ClassNode, GroovyTypeDeclaration>();
            CompilationResult compilationResult = this.unitDeclaration.compilationResult;
            char[] mainName = UnitPopulator.toMainName(compilationResult.getFileName());
            HashMap<ClassNode, ArrayList<GroovyTypeDeclaration>> innersToRecord = new HashMap<ClassNode, ArrayList<GroovyTypeDeclaration>>();
            for (ClassNode classNode : moduleClassNodes) {
                boolean isInner;
                if (!classNode.isPrimaryClassNode()) continue;
                GroovyTypeDeclaration typeDeclaration = new GroovyTypeDeclaration(compilationResult, classNode);
                typeDeclaration.annotations = this.createAnnotations(classNode.getAnnotations());
                if (classNode instanceof InnerClassNode) {
                    isInner = true;
                } else {
                    isInner = false;
                    typeDeclaration.name = classNode.getNameWithoutPackage().toCharArray();
                    if (!CharOperation.equals(typeDeclaration.name, mainName)) {
                        typeDeclaration.bits |= 0x1000;
                    }
                }
                typeDeclaration.modifiers = this.getModifiers(classNode, isInner);
                this.fixupSourceLocationsForTypeDeclaration(typeDeclaration, classNode);
                GenericsType[] generics = classNode.getGenericsTypes();
                if (generics != null && generics.length > 0) {
                    typeDeclaration.typeParameters = this.createTypeParametersForGenerics(classNode.getGenericsTypes());
                }
                boolean isEnum = classNode.isEnum();
                this.configureSuperClass(typeDeclaration, classNode.getSuperClass(), isEnum, this.isTrait(classNode));
                this.configureSuperInterfaces(typeDeclaration, classNode);
                typeDeclaration.fields = this.createFieldDeclarations(classNode, isEnum);
                typeDeclaration.methods = this.createMethodAndConstructorDeclarations(classNode, isEnum, typeDeclaration, compilationResult);
                typeDeclaration.properties = classNode.getProperties();
                if (isInner) {
                    InnerClassNode innerClassNode = (InnerClassNode)classNode;
                    ClassNode outerClassNode = innerClassNode.getOuterClass();
                    typeDeclaration.name = innerClassNode.getNameWithoutPackage().substring(outerClassNode.getNameWithoutPackage().length() + 1).toCharArray();
                    ArrayList<GroovyTypeDeclaration> inners = (ArrayList<GroovyTypeDeclaration>)innersToRecord.get(outerClassNode);
                    if (inners == null) {
                        inners = new ArrayList<GroovyTypeDeclaration>();
                        innersToRecord.put(outerClassNode, inners);
                    }
                    inners.add(typeDeclaration);
                    if (GroovyUtils.isAnonymous(classNode)) {
                        typeDeclaration.bits |= 0x300;
                        typeDeclaration.allocation = new QualifiedAllocationExpression(typeDeclaration);
                        typeDeclaration.allocation.enclosingInstance = new NullLiteral(typeDeclaration.sourceStart, typeDeclaration.sourceEnd);
                        typeDeclaration.allocation.sourceStart = typeDeclaration.sourceStart;
                        typeDeclaration.allocation.sourceEnd = typeDeclaration.bodyEnd;
                        typeDeclaration.allocation.statementEnd = typeDeclaration.bodyEnd;
                        typeDeclaration.allocation.type = typeDeclaration.superclass;
                        typeDeclaration.name = CharOperation.NO_CHAR;
                    }
                } else {
                    typeDeclarations.add(typeDeclaration);
                }
                fromClassNodeToDecl.put(classNode, typeDeclaration);
            }
            for (Map.Entry entry : innersToRecord.entrySet()) {
                ClassNode outer = (ClassNode)entry.getKey();
                TypeDeclaration outerTypeDeclaration = (TypeDeclaration)fromClassNodeToDecl.get(outer);
                if (outerTypeDeclaration == null) {
                    throw new GroovyEclipseBug("Failed to find the type declaration for " + outer.getText());
                }
                List newInnersList = (List)entry.getValue();
                Iterator iterator = newInnersList.iterator();
                while (iterator.hasNext()) {
                    Object location;
                    GroovyTypeDeclaration innerTypeDeclaration = (GroovyTypeDeclaration)iterator.next();
                    if ((innerTypeDeclaration.bits & 0x200) == 0) continue;
                    iterator.remove();
                    if (this.unitDeclaration.scope == null) {
                        CompilerOptions opts = this.unitDeclaration.compilerOptions != null ? this.unitDeclaration.compilerOptions : new CompilerOptions();
                        this.unitDeclaration.scope = this.unitDeclaration.buildCompilationUnitScope(new LookupEnvironment(null, opts, this.unitDeclaration.problemReporter, null));
                    }
                    if (outerTypeDeclaration.scope == null) {
                        outerTypeDeclaration.scope = new ClassScope(this.unitDeclaration.scope, outerTypeDeclaration);
                    }
                    if ((location = this.anonymousLocations.get(innerTypeDeclaration.getClassNode())) instanceof AbstractMethodDeclaration) {
                        AbstractMethodDeclaration methodDeclaration = (AbstractMethodDeclaration)location;
                        methodDeclaration.bits |= 2;
                        innerTypeDeclaration.enclosingScope = new MethodScope(outerTypeDeclaration.scope, methodDeclaration, methodDeclaration.isStatic());
                    } else if (location instanceof FieldNode) {
                        FieldNode fieldNode = (FieldNode)location;
                        if (!fieldNode.isStatic()) {
                            if (outerTypeDeclaration.initializerScope == null) {
                                outerTypeDeclaration.initializerScope = new MethodScope(outerTypeDeclaration.scope, outerTypeDeclaration.scope.referenceContext, false);
                            }
                            innerTypeDeclaration.enclosingScope = outerTypeDeclaration.initializerScope;
                        } else {
                            if (outerTypeDeclaration.staticInitializerScope == null) {
                                outerTypeDeclaration.staticInitializerScope = new MethodScope(outerTypeDeclaration.scope, outerTypeDeclaration.scope.referenceContext, true);
                            }
                            innerTypeDeclaration.enclosingScope = outerTypeDeclaration.staticInitializerScope;
                        }
                    } else if (!innerTypeDeclaration.getClassNode().isEnum()) {
                        throw new GroovyEclipseBug("Enclosing scope not found for anon. inner class: " + innerTypeDeclaration.getClassNode().getName());
                    }
                    ((GroovyTypeDeclaration)outerTypeDeclaration).addAnonymousType(innerTypeDeclaration);
                }
                outerTypeDeclaration.memberTypes = newInnersList.toArray(new TypeDeclaration[newInnersList.size()]);
            }
            this.anonymousLocations = null;
            this.unitDeclaration.types = typeDeclarations.toArray(new TypeDeclaration[typeDeclarations.size()]);
        }

        private FieldDeclaration[] createFieldDeclarations(ClassNode classNode, boolean isEnum) {
            ArrayList<FieldDeclarationWithInitializer> fieldDeclarations = new ArrayList<FieldDeclarationWithInitializer>();
            List<FieldNode> fieldNodes = classNode.getFields();
            boolean isTrait = this.isTrait(classNode);
            if (fieldNodes != null) {
                for (final FieldNode fieldNode : fieldNodes) {
                    if (isTrait && (!fieldNode.isPublic() || !fieldNode.isStatic() || !fieldNode.isFinal()) || isEnum && (fieldNode.getName().equals("MAX_VALUE") || fieldNode.getName().equals("MIN_VALUE"))) continue;
                    boolean isEnumField = fieldNode.isEnum();
                    boolean isSynthetic = GroovyUtils.isSynthetic(fieldNode);
                    if (isSynthetic) continue;
                    FieldDeclarationWithInitializer fieldDeclaration = new FieldDeclarationWithInitializer(fieldNode.getName().toCharArray(), 0, 0);
                    fieldDeclaration.annotations = this.createAnnotations(fieldNode.getAnnotations());
                    if (!isEnumField) {
                        fieldDeclaration.modifiers = this.getModifiers(fieldNode);
                        fieldDeclaration.type = this.createTypeReferenceForClassNode(fieldNode.getType());
                        if (fieldNode.isStatic() && fieldNode.isFinal() && fieldNode.getInitialExpression() instanceof ConstantExpression) {
                            fieldDeclaration.initialization = this.createConstantExpression((ConstantExpression)fieldNode.getInitialExpression());
                        }
                        if (this.anonymousLocations != null && fieldNode.getInitialExpression() != null) {
                            fieldNode.getInitialExpression().visit(new CodeVisitorSupport(){

                                @Override
                                public void visitConstructorCallExpression(ConstructorCallExpression call) {
                                    if (call.isUsingAnonymousInnerClass()) {
                                        anonymousLocations.put(call.getType(), fieldNode);
                                    }
                                    super.visitConstructorCallExpression(call);
                                }
                            });
                        }
                    }
                    fieldDeclaration.initializer = fieldNode.getInitialExpression();
                    this.fixupSourceLocationsForFieldDeclaration(fieldDeclaration, fieldNode, isEnumField);
                    fieldDeclarations.add(fieldDeclaration);
                }
            }
            return fieldDeclarations.toArray(new FieldDeclaration[fieldDeclarations.size()]);
        }

        private AbstractMethodDeclaration[] createMethodAndConstructorDeclarations(ClassNode classNode, boolean isEnum, GroovyTypeDeclaration typeDeclaration, CompilationResult compilationResult) {
            ArrayList<AbstractMethodDeclaration> accumulatedDeclarations = new ArrayList<AbstractMethodDeclaration>();
            this.createConstructorDeclarations(classNode, isEnum, accumulatedDeclarations);
            this.createMethodDeclarations(classNode, isEnum, typeDeclaration, accumulatedDeclarations);
            return accumulatedDeclarations.toArray(new AbstractMethodDeclaration[accumulatedDeclarations.size()]);
        }

        private void createConstructorDeclarations(ClassNode classNode, boolean isEnum, List<AbstractMethodDeclaration> accumulatedMethodDeclarations) {
            boolean needsDefaultCtor;
            if (this.isTrait(classNode)) {
                return;
            }
            List<ConstructorNode> constructorNodes = classNode.getDeclaredConstructors();
            char[] ctorName = null;
            if (classNode instanceof InnerClassNode) {
                InnerClassNode innerClassNode = (InnerClassNode)classNode;
                ClassNode outerClass = innerClassNode.getOuterClass();
                String outername = outerClass.getNameWithoutPackage();
                String newInner = innerClassNode.getNameWithoutPackage().substring(outername.length() + 1);
                ctorName = newInner.toCharArray();
            } else {
                ctorName = classNode.getNameWithoutPackage().toCharArray();
            }
            boolean bl = needsDefaultCtor = constructorNodes.size() == 0 && !classNode.isInterface();
            if (needsDefaultCtor) {
                ConstructorDeclaration constructor = new ConstructorDeclaration(this.unitDeclaration.compilationResult);
                constructor.bits |= 0x80;
                constructor.modifiers = isEnum ? 2 : 1;
                constructor.selector = ctorName;
                accumulatedMethodDeclarations.add(constructor);
            }
            for (ConstructorNode constructorNode : constructorNodes) {
                final ConstructorDeclaration constructorDeclaration = new ConstructorDeclaration(this.unitDeclaration.compilationResult);
                this.fixupSourceLocationsForConstructorDeclaration(constructorDeclaration, constructorNode);
                constructorDeclaration.annotations = this.createAnnotations(constructorNode.getAnnotations());
                constructorDeclaration.modifiers = isEnum ? 2 : this.getModifiers(constructorNode);
                constructorDeclaration.selector = ctorName;
                constructorDeclaration.arguments = this.createArguments(constructorNode.getParameters(), false);
                constructorDeclaration.thrownExceptions = this.createTypeReferencesForClassNodes(constructorNode.getExceptions());
                if (constructorNode.hasDefaultValue()) {
                    this.createConstructorVariants(constructorNode, constructorDeclaration, accumulatedMethodDeclarations, this.unitDeclaration.compilationResult, isEnum);
                } else {
                    accumulatedMethodDeclarations.add(constructorDeclaration);
                }
                if (this.anonymousLocations == null || constructorNode.getCode() == null) continue;
                constructorNode.getCode().visit(new CodeVisitorSupport(){

                    @Override
                    public void visitConstructorCallExpression(ConstructorCallExpression call) {
                        if (call.isUsingAnonymousInnerClass()) {
                            anonymousLocations.put(call.getType(), constructorDeclaration);
                        }
                        super.visitConstructorCallExpression(call);
                    }
                });
            }
            if (earlyTransforms) {
                this.applyEarlyTransforms(ctorName, classNode, accumulatedMethodDeclarations);
            }
        }

        private void createMethodDeclarations(ClassNode classNode, boolean isEnum, GroovyTypeDeclaration typeDeclaration, List<AbstractMethodDeclaration> accumulatedDeclarations) {
            boolean isTrait = this.isTrait(classNode);
            List<MethodNode> methods = classNode.getMethods();
            for (MethodNode methodNode : methods) {
                if (isTrait && (methodNode.isPrivate() || methodNode.isStatic()) || isEnum && methodNode.isSynthetic()) continue;
                final MethodDeclaration methodDeclaration = this.createMethodDeclaration(classNode, isEnum, methodNode, this.unitDeclaration.compilationResult);
                if (methodNode.isAbstract()) {
                    typeDeclaration.bits |= 0x800;
                }
                if (methodNode.hasDefaultValue()) {
                    this.createMethodVariants(classNode, methodNode, isEnum, methodDeclaration, accumulatedDeclarations, this.unitDeclaration.compilationResult);
                } else {
                    accumulatedDeclarations.add(methodDeclaration);
                }
                if (this.anonymousLocations == null || methodNode.getCode() == null) continue;
                methodNode.getCode().visit(new CodeVisitorSupport(){

                    @Override
                    public void visitConstructorCallExpression(ConstructorCallExpression call) {
                        if (call.isUsingAnonymousInnerClass()) {
                            anonymousLocations.put(call.getType(), methodDeclaration);
                        }
                        super.visitConstructorCallExpression(call);
                    }
                });
            }
        }

        private MethodDeclaration createMethodDeclaration(ClassNode classNode, boolean isEnum, MethodNode methodNode, CompilationResult compilationResult) {
            Parameter p;
            if (classNode.isAnnotationDefinition()) {
                AnnotationMethodDeclaration methodDeclaration = new AnnotationMethodDeclaration(compilationResult);
                int modifiers = this.getModifiers(methodNode);
                methodDeclaration.annotations = this.createAnnotations(methodNode.getAnnotations());
                methodDeclaration.modifiers = modifiers;
                if (methodNode.hasAnnotationDefault()) {
                    methodDeclaration.modifiers |= 0x20000;
                }
                methodDeclaration.selector = methodNode.getName().toCharArray();
                this.fixupSourceLocationsForMethodDeclaration(methodDeclaration, methodNode);
                ClassNode returnType = methodNode.getReturnType();
                methodDeclaration.returnType = this.createTypeReferenceForClassNode(returnType);
                return methodDeclaration;
            }
            MethodDeclaration methodDeclaration = new MethodDeclaration(compilationResult);
            GenericsType[] generics = methodNode.getGenericsTypes();
            if (generics != null && generics.length > 0) {
                methodDeclaration.typeParameters = this.createTypeParametersForGenerics(generics);
            }
            boolean isMain = false;
            int modifiers = this.getModifiers(methodNode);
            methodDeclaration.annotations = this.createAnnotations(methodNode.getAnnotations());
            methodDeclaration.modifiers = modifiers;
            methodDeclaration.selector = methodNode.getName().toCharArray();
            Parameter[] params = methodNode.getParameters();
            ClassNode returnType = methodNode.getReturnType();
            if (Flags.isStatic(modifiers) && params != null && params.length == 1 && methodNode.getName().equals("main") && ((p = params[0]).getType() == null || p.getType().getName().equals("java.lang.Object"))) {
                String name = p.getName();
                params = new Parameter[]{new Parameter(ClassHelper.STRING_TYPE.makeArray(), name)};
                if (returnType.getName().equals("java.lang.Object")) {
                    returnType = ClassHelper.VOID_TYPE;
                }
            }
            methodDeclaration.arguments = this.createArguments(params, isMain);
            methodDeclaration.returnType = this.createTypeReferenceForClassNode(returnType);
            methodDeclaration.thrownExceptions = this.createTypeReferencesForClassNodes(methodNode.getExceptions());
            this.fixupSourceLocationsForMethodDeclaration(methodDeclaration, methodNode);
            return methodDeclaration;
        }

        private void createConstructorVariants(ConstructorNode constructorNode, ConstructorDeclaration constructorDecl, List<AbstractMethodDeclaration> accumulatedDeclarations, CompilationResult compilationResult, boolean isEnum) {
            List<Argument[]> variants = this.getVariantsAllowingForDefaulting(constructorNode.getParameters(), constructorDecl.arguments);
            for (Argument[] variant : variants) {
                ConstructorDeclaration constructorDeclaration = new ConstructorDeclaration(compilationResult);
                constructorDeclaration.annotations = this.createAnnotations(constructorNode.getAnnotations());
                constructorDeclaration.modifiers = isEnum ? 2 : 1;
                constructorDeclaration.selector = constructorDecl.selector;
                constructorDeclaration.arguments = variant;
                this.fixupSourceLocationsForConstructorDeclaration(constructorDeclaration, constructorNode);
                this.addUnlessDuplicate(accumulatedDeclarations, constructorDeclaration);
            }
        }

        private void createMethodVariants(ClassNode classNode, MethodNode method, boolean isEnum, MethodDeclaration methodDecl, List<AbstractMethodDeclaration> accumulatedDeclarations, CompilationResult compilationResult) {
            List<Argument[]> variants = this.getVariantsAllowingForDefaulting(method.getParameters(), methodDecl.arguments);
            for (Argument[] variant : variants) {
                MethodDeclaration variantMethodDeclaration = this.genMethodDeclarationVariant(classNode, method, isEnum, variant, methodDecl.returnType, compilationResult);
                this.addUnlessDuplicate(accumulatedDeclarations, variantMethodDeclaration);
            }
        }

        private void configureSuperClass(TypeDeclaration typeDeclaration, ClassNode superclass, boolean isEnum, boolean isTrait) {
            if (isEnum && superclass.getName().equals("java.lang.Enum") || isTrait) {
                typeDeclaration.superclass = null;
            } else if (superclass.getStart() != 0 || !superclass.equals(ClassHelper.OBJECT_TYPE)) {
                typeDeclaration.superclass = this.createTypeReferenceForClassNode(superclass);
            }
        }

        private void configureSuperInterfaces(TypeDeclaration typeDeclaration, ClassNode classNode) {
            ClassNode[] interfaces = classNode.getInterfaces();
            if (interfaces != null && interfaces.length > 0) {
                typeDeclaration.superInterfaces = new TypeReference[interfaces.length];
                int i = 0;
                while (i < interfaces.length) {
                    typeDeclaration.superInterfaces[i] = this.createTypeReferenceForClassNode(interfaces[i]);
                    ++i;
                }
            } else {
                typeDeclaration.superInterfaces = new TypeReference[0];
            }
        }

        private Annotation[] createAnnotations(List<AnnotationNode> groovyAnnotations) {
            if (groovyAnnotations != null && !groovyAnnotations.isEmpty()) {
                ArrayList<Annotation> annotations = new ArrayList<Annotation>(groovyAnnotations.size());
                for (AnnotationNode annotationNode : groovyAnnotations) {
                    Annotation annotation;
                    ClassNode annoType = annotationNode.getClassNode();
                    TypeReference annotationReference = this.createTypeReferenceForClassNode(annoType);
                    annotationReference.sourceStart = annotationNode.getStart();
                    annotationReference.sourceEnd = annotationNode.getEnd();
                    Map<String, Expression> memberValuePairs = annotationNode.getMembers();
                    if (memberValuePairs == null || memberValuePairs.isEmpty()) {
                        annotation = new MarkerAnnotation(annotationReference, annotationNode.getStart());
                        annotation.declarationSourceEnd = annotation.sourceEnd;
                        annotations.add(annotation);
                        continue;
                    }
                    if (memberValuePairs.size() == 1 && memberValuePairs.containsKey("value")) {
                        Map.Entry<String, Expression> memberValuePair = memberValuePairs.entrySet().iterator().next();
                        Expression value = memberValuePair.getValue();
                        SingleMemberAnnotation annotation2 = new SingleMemberAnnotation(annotationReference, annotationNode.getStart());
                        annotation2.declarationSourceEnd = annotation2.sourceStart + annoType.getNameWithoutPackage().length() - 1;
                        annotation2.memberValue = this.createAnnotationMemberExpression(value);
                        annotations.add(annotation2);
                        continue;
                    }
                    annotation = new NormalAnnotation(annotationReference, annotationNode.getStart());
                    ((NormalAnnotation)annotation).declarationSourceEnd = ((NormalAnnotation)annotation).sourceStart + annoType.getNameWithoutPackage().length() - 1;
                    ((NormalAnnotation)annotation).memberValuePairs = this.createAnnotationMemberValuePairs(memberValuePairs);
                    annotations.add(annotation);
                }
                return annotations.toArray(new Annotation[annotations.size()]);
            }
            return null;
        }

        private org.eclipse.jdt.internal.compiler.ast.Expression createAnnotationMemberExpression(Expression expr) {
            if (expr instanceof ListExpression) {
                ListExpression list = (ListExpression)expr;
                ArrayInitializer arrayInitializer = new ArrayInitializer();
                arrayInitializer.sourceStart = expr.getStart();
                arrayInitializer.sourceEnd = expr.getEnd();
                int n = list.getExpressions().size();
                arrayInitializer.expressions = new org.eclipse.jdt.internal.compiler.ast.Expression[n];
                int i = 0;
                while (i < n) {
                    arrayInitializer.expressions[i] = this.createAnnotationMemberExpression(list.getExpression(i));
                    ++i;
                }
                return arrayInitializer;
            }
            if (expr instanceof AnnotationConstantExpression) {
                Annotation[] annos = this.createAnnotations(Collections.singletonList((AnnotationNode)((AnnotationConstantExpression)expr).getValue()));
                assert (annos != null && annos.length == 1);
                return annos[0];
            }
            if (expr instanceof ConstantExpression) {
                Literal literal = this.createConstantExpression((ConstantExpression)expr);
                if (literal != null) {
                    return literal;
                }
            } else {
                if (expr instanceof PropertyExpression) {
                    PropertyExpression prop = (PropertyExpression)expr;
                    assert (prop.getProperty() instanceof ConstantExpression);
                    if (prop.getPropertyAsString().equals("class")) {
                        return new ClassLiteralAccess(expr.getEnd(), this.createTypeReferenceForClassLiteral(prop));
                    }
                    char[][] tokens = CharOperation.splitOn('.', prop.getText().toCharArray());
                    int n = tokens.length;
                    int s = prop.getObjectExpression().getStart();
                    long[] positions = new long[n];
                    int i = 0;
                    while (i < n) {
                        positions[i] = UnitPopulator.toPos(s, s + tokens[i].length - 1);
                        s += tokens[i].length;
                        ++i;
                    }
                    assert (s <= expr.getEnd());
                    return new QualifiedNameReference(tokens, positions, expr.getStart(), expr.getEnd());
                }
                if (expr instanceof VariableExpression) {
                    String name = ((VariableExpression)expr).getName();
                    return new SingleNameReference(name.toCharArray(), UnitPopulator.toPos(expr.getStart(), expr.getEnd() - 1));
                }
                if (expr instanceof ClosureExpression) {
                    return new ClassLiteralAccess(expr.getEnd(), new SingleTypeReference("Closure".toCharArray(), UnitPopulator.toPos(expr.getStart(), expr.getEnd())));
                }
                if (!(expr instanceof BinaryExpression)) {
                    Util.log(2, "Unhandled annotation value type: " + expr.getClass().getSimpleName());
                }
            }
            return new NullLiteral(expr.getStart(), expr.getEnd());
        }

        private MemberValuePair[] createAnnotationMemberValuePairs(Map<String, Expression> memberValuePairs) {
            ArrayList<MemberValuePair> mvps = new ArrayList<MemberValuePair>(memberValuePairs.size());
            for (Map.Entry<String, Expression> memberValuePair : memberValuePairs.entrySet()) {
                char[] name = memberValuePair.getKey().toCharArray();
                int start = Math.max(0, memberValuePair.getValue().getStart() - name.length - 1);
                int until = memberValuePair.getValue().getEnd();
                org.eclipse.jdt.internal.compiler.ast.Expression value = this.createAnnotationMemberExpression(memberValuePair.getValue());
                mvps.add(new MemberValuePair(name, start, until, value));
            }
            return mvps.toArray(new MemberValuePair[mvps.size()]);
        }

        private Literal createConstantExpression(ConstantExpression expr) {
            int start = expr.getStart();
            int until = expr.getEnd();
            String type = expr.getType().getName();
            Object value = expr.getValue();
            if (type.equals("java.lang.Object")) {
                assert (value == null);
                return new NullLiteral(start, until);
            }
            if (type.equals("java.lang.String")) {
                return new StringLiteral(((String)value).toCharArray(), start, until - 1, expr.getLineNumber());
            }
            if (type.equals("boolean") || type.equals("java.lang.Boolean")) {
                if (value.toString().equals("true")) {
                    return new TrueLiteral(start, until);
                }
                return new FalseLiteral(start, until);
            }
            if (type.equals("int") || type.equals("java.lang.Integer")) {
                char[] chars = String.valueOf(Math.abs((Integer)value)).toCharArray();
                return IntLiteral.buildIntLiteral(chars, start, start + chars.length);
            }
            if (type.equals("long") || type.equals("java.lang.Long")) {
                char[] chars = (String.valueOf(String.valueOf(Math.abs((Long)value))) + 'L').toCharArray();
                return LongLiteral.buildLongLiteral(chars, start, start + chars.length);
            }
            if (type.equals("double") || type.equals("java.lang.Double")) {
                return new DoubleLiteral(value.toString().toCharArray(), start, until);
            }
            if (type.equals("float") || type.equals("java.lang.Float")) {
                return new FloatLiteral(value.toString().toCharArray(), start, until);
            }
            if (type.equals("char") || type.equals("java.lang.Character")) {
                return new CharLiteral(value.toString().toCharArray(), start, until);
            }
            if (type.equals("java.math.BigDecimal")) {
                return new DoubleLiteral(value.toString().toCharArray(), start, until);
            }
            if (type.equals("java.math.BigInteger")) {
                long thing = ((BigInteger)value).abs().longValue();
                char[] chars = (String.valueOf(String.valueOf(thing)) + 'L').toCharArray();
                return LongLiteral.buildLongLiteral(chars, start, start + chars.length);
            }
            Util.log(2, "Unhandled annotation constant type: " + expr.getType().getName());
            return null;
        }

        private Argument[] createArguments(Parameter[] ps, boolean isMain) {
            if (ps == null || ps.length == 0) {
                return null;
            }
            Argument[] arguments = new Argument[ps.length];
            int i = 0;
            while (i < ps.length) {
                long pos;
                Parameter parameter = ps[i];
                TypeReference parameterTypeReference = this.createTypeReferenceForClassNode(parameter.getType());
                int pstart = parameter.getStart();
                if (parameter.getStart() == 0 && parameter.getEnd() == 0) {
                    pos = UnitPopulator.toPos(-1L, -2L);
                    pstart = -1;
                } else {
                    pos = UnitPopulator.toPos(parameter.getStart(), parameter.getEnd() - 1);
                }
                arguments[i] = new Argument(parameter.getName().toCharArray(), pos, parameterTypeReference, 1);
                arguments[i].annotations = this.createAnnotations(parameter.getAnnotations());
                arguments[i].declarationSourceStart = pstart;
                ++i;
            }
            if (this.isVargs(ps)) {
                arguments[ps.length - 1].type.bits |= 0x4000;
            }
            return arguments;
        }

        private TypeReference createTypeReferenceForArrayNameTrailingBrackets(ClassNode node, int start, int until) {
            String name = node.getName();
            int dim = 0;
            int pos = name.length() - 2;
            ClassNode componentType = node;
            while (pos > 0 && name.charAt(pos) == '[') {
                ++dim;
                pos -= 2;
                componentType = componentType.getComponentType();
            }
            if (componentType.isPrimitive()) {
                Integer ii = charToTypeId.get(Character.valueOf(name.charAt(dim)));
                if (ii == null) {
                    throw new IllegalStateException("node " + node + " reported it had a primitive component type, but it does not...");
                }
                TypeReference baseTypeReference = TypeReference.baseTypeReference(ii, dim);
                baseTypeReference.sourceStart = start;
                baseTypeReference.sourceEnd = start + componentType.getName().length();
                return baseTypeReference;
            }
            if (dim == 0) {
                throw new IllegalStateException("Array classnode with dimensions 0?? node:" + node.getName());
            }
            String arrayComponentTypename = name.substring(0, pos + 2);
            return this.createTypeReferenceForArrayName(arrayComponentTypename, componentType, dim, start, until);
        }

        private TypeReference createTypeReferenceForArrayNameLeadingBrackets(ClassNode node, int start, int until) {
            String name = node.getName();
            int dim = 0;
            ClassNode componentType = node;
            while (name.charAt(dim) == '[') {
                ++dim;
                componentType = componentType.getComponentType();
            }
            if (componentType.isPrimitive()) {
                Integer ii = charToTypeId.get(Character.valueOf(name.charAt(dim)));
                if (ii == null) {
                    throw new IllegalStateException("node " + node + " reported it had a primitive component type, but it does not...");
                }
                TypeReference baseTypeReference = TypeReference.baseTypeReference(ii, dim);
                baseTypeReference.sourceStart = start;
                baseTypeReference.sourceEnd = start + componentType.getName().length();
                return baseTypeReference;
            }
            String arrayComponentTypename = name.substring(dim);
            if (arrayComponentTypename.charAt(arrayComponentTypename.length() - 1) == ';') {
                arrayComponentTypename = name.substring(dim + 1, name.length() - 1);
            }
            return this.createTypeReferenceForArrayName(arrayComponentTypename, componentType, dim, start, until);
        }

        private TypeReference createTypeReferenceForArrayName(String typeName, ClassNode typeNode, int dim, int start, int until) {
            if (!typeNode.isUsingGenerics()) {
                if (typeName.indexOf(46) < 0) {
                    ArrayTypeReference atr = new ArrayTypeReference(typeName.toCharArray(), dim, UnitPopulator.toPos(start, until - 1));
                    atr.originalSourceEnd = atr.sourceStart + typeName.length() - 1;
                    return atr;
                }
                char[][] compoundName = CharOperation.splitOn('.', typeName.toCharArray());
                ArrayQualifiedTypeReference aqtr = new ArrayQualifiedTypeReference(compoundName, dim, this.positionsFor(compoundName, start, until == -2 ? -2 : until - dim * 2));
                aqtr.sourceEnd = until == -2 ? -2 : until - 1;
                return aqtr;
            }
            GenericsType[] generics = typeNode.getGenericsTypes();
            TypeReference[] typeArgs = new TypeReference[generics.length];
            int i = 0;
            while (i < generics.length) {
                typeArgs[i] = this.createTypeReferenceForGenerics(generics[i]);
                ++i;
            }
            if (typeName.indexOf(46) < 0) {
                ParameterizedSingleTypeReference pstr = new ParameterizedSingleTypeReference(typeName.toCharArray(), typeArgs, dim, UnitPopulator.toPos(start, until - 1));
                pstr.originalSourceEnd = pstr.sourceStart + typeName.length() - 1;
                return pstr;
            }
            char[][] compoundName = CharOperation.splitOn('.', typeName.toCharArray());
            TypeReference[][] compoundArgs = new TypeReference[compoundName.length][];
            compoundArgs[compoundName.length - 1] = typeArgs;
            ParameterizedQualifiedTypeReference pqtr = new ParameterizedQualifiedTypeReference(compoundName, compoundArgs, dim, this.positionsFor(compoundName, start, until == -2 ? -2 : until - dim * 2));
            pqtr.sourceEnd = until == -2 ? -2 : until - 1;
            return pqtr;
        }

        private TypeReference createTypeReferenceForClassLiteral(PropertyExpression expression) {
            Expression candidate = expression.getObjectExpression();
            LinkedList<char[]> nameParts = new LinkedList<char[]>();
            while (candidate instanceof PropertyExpression) {
                nameParts.add(0, ((PropertyExpression)candidate).getPropertyAsString().toCharArray());
                candidate = ((PropertyExpression)candidate).getObjectExpression();
            }
            if (candidate instanceof VariableExpression) {
                nameParts.add(0, ((VariableExpression)candidate).getName().toCharArray());
            }
            char[][] namePartsArr = (char[][])nameParts.toArray((T[])new char[nameParts.size()][]);
            long[] poss = this.positionsFor(namePartsArr, expression.getObjectExpression().getStart(), expression.getObjectExpression().getEnd());
            TypeReference ref = namePartsArr.length > 1 ? new QualifiedTypeReference(namePartsArr, poss) : (namePartsArr.length == 1 ? new SingleTypeReference(namePartsArr[0], poss[0]) : TypeReference.baseTypeReference(nameToPrimitiveTypeId.get("void"), 0));
            return ref;
        }

        private TypeReference[] createTypeReferencesForClassNodes(ClassNode[] classNodes) {
            if (classNodes == null) {
                return null;
            }
            int n = classNodes.length;
            if (n == 0) {
                return null;
            }
            TypeReference[] refs = new TypeReference[n];
            int i = 0;
            while (i < n) {
                refs[i] = this.createTypeReferenceForClassNode(classNodes[i]);
                ++i;
            }
            return refs;
        }

        private TypeReference createTypeReferenceForClassNode(ClassNode classNode) {
            return this.createTypeReferenceForClassNode(classNode, this.startOffset(classNode), this.endOffset(classNode));
        }

        private TypeReference createTypeReferenceForClassNode(ClassNode classNode, int start, int end) {
            String name;
            TypeReference tr;
            GenericsType[] genericsInfo;
            ArrayList<TypeReference> typeArguments = null;
            if (classNode.isUsingGenerics() && (genericsInfo = classNode.getGenericsTypes()) != null) {
                int g = 0;
                while (g < genericsInfo.length) {
                    tr = this.createTypeReferenceForGenerics(genericsInfo[g]);
                    if (tr != null) {
                        if (typeArguments == null) {
                            typeArguments = new ArrayList<TypeReference>();
                        }
                        typeArguments.add(tr);
                    }
                    ++g;
                }
            }
            if ((name = classNode.getName()).length() == 1 && name.charAt(0) == '?') {
                Wildcard tr2 = new Wildcard(0);
                tr2.sourceStart = start;
                tr2.sourceEnd = end;
                return tr2;
            }
            int arrayLoc = name.indexOf("[");
            if (arrayLoc == 0) {
                return this.createTypeReferenceForArrayNameLeadingBrackets(classNode, start, end);
            }
            if (arrayLoc > 0) {
                return this.createTypeReferenceForArrayNameTrailingBrackets(classNode, start, end);
            }
            if (nameToPrimitiveTypeId.containsKey(name)) {
                tr = TypeReference.baseTypeReference(nameToPrimitiveTypeId.get(name), 0);
                tr.sourceStart = start;
                tr.sourceEnd = end;
                return tr;
            }
            if (name.indexOf(".") == -1) {
                if (typeArguments == null) {
                    tr = UnitPopulator.verify(new SingleTypeReference(name.toCharArray(), UnitPopulator.toPos(start, end - 1)));
                    if (!this.checkGenerics) {
                        tr.bits |= 0x40000000;
                    }
                    return tr;
                }
                long l = UnitPopulator.toPos(start, end - 1);
                return new ParameterizedSingleTypeReference(name.toCharArray(), typeArguments.toArray(new TypeReference[typeArguments.size()]), 0, l);
            }
            char[][] compoundName = CharOperation.splitOn('.', name.toCharArray());
            if (typeArguments == null) {
                QualifiedTypeReference tr3 = new QualifiedTypeReference(compoundName, this.positionsFor(compoundName, start, end));
                if (!this.checkGenerics) {
                    tr3.bits |= 0x40000000;
                }
                return tr3;
            }
            TypeReference[][] typeReferences = new TypeReference[compoundName.length][];
            typeReferences[compoundName.length - 1] = typeArguments.toArray(new TypeReference[typeArguments.size()]);
            return new ParameterizedQualifiedTypeReference(compoundName, typeReferences, 0, this.positionsFor(compoundName, start, end));
        }

        private TypeReference createTypeReferenceForGenerics(GenericsType genericsType) {
            if (genericsType.isWildcard()) {
                ClassNode[] bounds = genericsType.getUpperBounds();
                if (bounds != null) {
                    TypeReference boundReference = this.createTypeReferenceForClassNode(bounds[0]);
                    Wildcard wildcard = new Wildcard(1);
                    wildcard.sourceStart = genericsType.getStart();
                    wildcard.sourceEnd = boundReference.sourceEnd();
                    wildcard.bound = boundReference;
                    return wildcard;
                }
                if (genericsType.getLowerBound() != null) {
                    TypeReference boundReference = this.createTypeReferenceForClassNode(genericsType.getLowerBound());
                    Wildcard wildcard = new Wildcard(2);
                    wildcard.sourceStart = genericsType.getStart();
                    wildcard.sourceEnd = boundReference.sourceEnd();
                    wildcard.bound = boundReference;
                    return wildcard;
                }
                Wildcard w = new Wildcard(0);
                w.sourceStart = genericsType.getStart();
                w.sourceEnd = genericsType.getStart();
                return w;
            }
            if (!genericsType.getType().isGenericsPlaceHolder()) {
                TypeReference typeReference = this.createTypeReferenceForClassNode(genericsType.getType());
                return typeReference;
            }
            return null;
        }

        private TypeParameter[] createTypeParametersForGenerics(GenericsType[] generics) {
            int n = generics.length;
            TypeParameter[] typeParameters = new TypeParameter[n];
            int i = 0;
            while (i < n) {
                TypeParameter typeParameter;
                typeParameters[i] = typeParameter = new TypeParameter();
                typeParameter.name = generics[i].getName().toCharArray();
                int offset = generics[i].getStart();
                int length = typeParameter.name.length;
                typeParameter.sourceStart = offset;
                typeParameter.sourceEnd = offset + length;
                ClassNode[] upperBounds = generics[i].getUpperBounds();
                if (upperBounds != null && upperBounds.length > 0) {
                    String source = String.valueOf(GroovyUtils.readSourceRange(this.sourceUnit, generics[i].getStart(), generics[i].getLength()));
                    int _start = this.startOffset(upperBounds[0]);
                    int _until = this.endOffset(upperBounds[0]);
                    if (_until > 0) {
                        source = source.substring(_start - offset);
                        length = _until - _start;
                        offset = _start;
                    } else {
                        offset += length;
                        Matcher m = EXTENDS.matcher(source = source.substring(length));
                        if (m.find()) {
                            length = m.group().length();
                            offset += length;
                            source = source.substring(length);
                        }
                        length = upperBounds[0].getName().length();
                        String name = GroovyUtils.splitName(upperBounds[0])[1];
                        assert (length == source.indexOf(name) + name.length());
                        assert (source.length() == length || source.charAt(length) != '<');
                    }
                    typeParameter.type = this.createTypeReferenceForClassNode(upperBounds[0], offset, offset + length);
                    int j = 1;
                    int k = upperBounds.length;
                    while (j < k) {
                        if (j == 1) {
                            typeParameter.bounds = new TypeReference[k - 1];
                        }
                        _start = this.startOffset(upperBounds[j]);
                        _until = this.endOffset(upperBounds[j]);
                        if (_until > 0) {
                            source = source.substring(_start - offset);
                            length = _until - _start;
                            offset = _start;
                        } else {
                            offset += length;
                            Matcher m = AND.matcher(source = source.substring(length));
                            if (m.find()) {
                                length = m.group().length();
                                offset += length;
                                source = source.substring(length);
                            }
                            length = upperBounds[0].getName().length();
                        }
                        typeParameter.bounds[j - 1] = this.createTypeReferenceForClassNode(upperBounds[j], offset, offset + length);
                        typeParameter.bounds[j - 1].bits |= 0x10;
                        ++j;
                    }
                }
                ++i;
            }
            return typeParameters;
        }

        private long[] positionsFor(char[][] reference, long start, long end) {
            long[] result = new long[reference.length];
            if (start == -1L && end == -2L) {
                int i = 0;
                int max = result.length;
                while (i < max) {
                    result[i] = -2L;
                    ++i;
                }
                return result;
            }
            if (start < end) {
                long pos = start;
                int i = 0;
                int max = result.length;
                while (i < max) {
                    long s = pos;
                    pos = pos + (long)reference[i].length - 1L;
                    result[i] = s << 32 | pos;
                    pos += 2L;
                    ++i;
                }
            } else {
                long pos = start << 32 | start;
                int i = 0;
                int max = result.length;
                while (i < max) {
                    result[i] = pos;
                    ++i;
                }
            }
            return result;
        }

        private int trailerLength(ASTNode node) {
            int length = 0;
            if (this.sourceUnit != null && node.getLastLineNumber() > 0) {
                if (this.janitor == null) {
                    this.janitor = new Janitor();
                }
                ReaderSource source = this.sourceUnit.getSource();
                String line = source.getLine(node.getLastLineNumber(), this.janitor);
                StringBuilder sb = null;
                char c = '\u0000';
                int endPos = node.getLastColumnNumber() - 1;
                while (endPos < line.length() && ((c = line.charAt(endPos++)) == ';' || c == ' ' || c == '\t')) {
                    (sb != null ? sb : new StringBuilder()).appendCodePoint(c);
                }
                if (sb != null) {
                    length += sb.length();
                }
            }
            return length;
        }

        private int startOffset(ASTNode node) {
            int s = node.getStart();
            int e = node.getEnd();
            if (s == 0 && e == 0) {
                return -1;
            }
            return s;
        }

        private int endOffset(ASTNode node) {
            int s = node.getStart();
            int e = node.getEnd();
            if (s == 0 && e == 0) {
                return -2;
            }
            return e;
        }

        private int getModifiers(ClassNode node, boolean isInner) {
            int modifiers = node.getModifiers();
            if (this.isTrait(node)) {
                modifiers |= 0x200;
            }
            if (node.isInterface()) {
                modifiers &= 0xFFFFFBFF;
            }
            if (node.isEnum()) {
                modifiers &= 0xFFFFFBEF;
            }
            if (!isInner) {
                modifiers &= 0xFFFFFFF1;
            }
            if (this.hasPackageScopeXform(node, PackageScopeTarget.CLASS)) {
                modifiers &= 0xFFFFFFFE;
            }
            return modifiers;
        }

        private int getModifiers(FieldNode node) {
            int modifiers = node.getModifiers();
            if (node.getDeclaringClass().getProperty(node.getName()) != null && this.hasPackageScopeXform(node, PackageScopeTarget.FIELDS)) {
                modifiers &= 0xFFFFFFFD;
            }
            return modifiers;
        }

        private int getModifiers(MethodNode node) {
            int modifiers = node.getModifiers();
            modifiers &= 0xFFFFEF7F;
            if (node.isSyntheticPublic() && this.hasPackageScopeXform(node, PackageScopeTarget.METHODS)) {
                modifiers &= 0xFFFFFFFE;
            }
            return modifiers;
        }

        private int getModifiers(ConstructorNode node) {
            int modifiers = node.getModifiers();
            try {
                PackageScopeTarget type = PackageScopeTarget.valueOf("CONSTRUCTORS");
                if (node.isSyntheticPublic() && this.hasPackageScopeXform(node, type)) {
                    modifiers &= 0xFFFFFFFE;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            return modifiers;
        }

        private boolean hasPackageScopeXform(AnnotatedNode node, final PackageScopeTarget type) {
            boolean member = !(node instanceof ClassNode) && type != PackageScopeTarget.CLASS;
            for (AnnotationNode anno : node.getAnnotations()) {
                if (!this.isType("groovy.transform.PackageScope", anno.getClassNode().getName())) continue;
                Expression expr = anno.getMember("value");
                if (expr == null) {
                    return member || node instanceof ClassNode && type == PackageScopeTarget.CLASS;
                }
                final boolean[] val = new boolean[1];
                expr.visit(new CodeVisitorSupport(){

                    @Override
                    public void visitPropertyExpression(PropertyExpression property) {
                        if (this.isType("groovy.transform.PackageScopeTarget", property.getObjectExpression().getText()) && property.getPropertyAsString().equals(type.name())) {
                            val[0] = true;
                        }
                    }

                    @Override
                    public void visitVariableExpression(VariableExpression variable) {
                        if (variable.getName().equals(type.name())) {
                            ModuleNode mod = sourceUnit.getAST();
                            ImportNode imp = mod.getStaticImports().get(type.name());
                            if (imp != null && this.isType("groovy.transform.PackageScopeTarget", imp.getType().getName())) {
                                val[0] = true;
                            } else if (imp == null && mod.getStaticStarImports().get("groovy.transform.PackageScopeTarget") != null) {
                                val[0] = true;
                            }
                        }
                    }
                });
                return val[0];
            }
            if (member) {
                return this.hasPackageScopeXform(node.getDeclaringClass(), type);
            }
            return false;
        }

        private boolean isTrait(ClassNode classNode) {
            return this.unitDeclaration.traitHelper.isTrait(classNode);
        }

        private boolean isVargs(Parameter[] parameters) {
            if (parameters.length == 0) {
                return false;
            }
            Parameter last = parameters[parameters.length - 1];
            ClassNode type = last.getType();
            return type.isArray();
        }

        private boolean isType(String expect, String actual) {
            if (actual.equals(expect)) {
                return true;
            }
            int dot = expect.lastIndexOf(46);
            if (dot != -1 && actual.equals(expect.substring(dot + 1))) {
                ModuleNode mod = this.sourceUnit.getAST();
                ClassNode imp = mod.getImportType(actual);
                if (imp != null) {
                    return imp.getName().equals(expect);
                }
                String pkg = expect.substring(0, dot + 1);
                for (ImportNode sin : mod.getStarImports()) {
                    if (!sin.getPackageName().equals(pkg)) continue;
                    return true;
                }
            }
            return false;
        }

        private static String lexicalKey(ImportReference ref) {
            StringBuilder key = new StringBuilder();
            key.append(Prefix.format(ref.declarationSourceStart));
            key.append(CharOperation.concatWith(ref.tokens, '.'));
            if ((ref.bits & 0x20000) == 0) {
                key.append(" as ").append(ref.getSimpleName());
            }
            return key.toString();
        }

        private static char[] toMainName(char[] fileName) {
            int end;
            if (fileName == null) {
                return CharOperation.NO_CHAR;
            }
            int start = CharOperation.lastIndexOf('/', fileName) + 1;
            if (start == 0 || start < CharOperation.lastIndexOf('\\', fileName)) {
                start = CharOperation.lastIndexOf('\\', fileName) + 1;
            }
            if ((end = CharOperation.lastIndexOf('.', fileName)) == -1) {
                end = fileName.length;
            }
            return CharOperation.subarray(fileName, start, end);
        }

        private static long toPos(long start, long end) {
            if (start == 0L && end <= 0L) {
                return NON_EXISTENT_POSITION;
            }
            if (start < 0L || end < 0L) {
                return NON_EXISTENT_POSITION;
            }
            return start << 32 | end;
        }

        private Javadoc findJavadoc(int line) {
            for (Comment comment : this.sourceUnit.getComments()) {
                if (!comment.isJavadoc() || comment.getLastLine() + 1 != line && (comment.getLastLine() + 2 != line || comment.usedUp)) continue;
                int[] pos = comment.getPositions(this.unitDeclaration.compilationResult.lineSeparatorPositions);
                comment.usedUp = true;
                return new Javadoc(pos[0], pos[1]);
            }
            return null;
        }

        private void fixupSourceLocationsForTypeDeclaration(GroovyTypeDeclaration typeDeclaration, ClassNode classNode) {
            if (classNode instanceof InnerClassNode) {
                typeDeclaration.sourceStart = classNode.getNameStart();
                typeDeclaration.sourceEnd = classNode.getNameEnd();
            } else {
                typeDeclaration.sourceStart = Math.max(classNode.getNameStart(), classNode.getStart());
                typeDeclaration.sourceEnd = Math.max(classNode.getNameEnd(), classNode.getStart());
            }
            int line = classNode.getLineNumber();
            Javadoc doc = this.findJavadoc(line);
            if (doc != null) {
                if (this.unitDeclaration.imports != null && this.unitDeclaration.imports.length > 0) {
                    if (doc.sourceStart < this.unitDeclaration.imports[this.unitDeclaration.imports.length - 1].sourceStart) {
                        doc = null;
                    }
                } else if (this.unitDeclaration.currentPackage != null && doc.sourceStart < this.unitDeclaration.currentPackage.sourceStart) {
                    doc = null;
                }
            }
            typeDeclaration.javadoc = doc;
            typeDeclaration.declarationSourceStart = doc == null ? classNode.getStart() : doc.sourceStart;
            typeDeclaration.declarationSourceEnd = classNode.getEnd() - 1;
            typeDeclaration.bodyStart = Math.max(classNode.getNameEnd(), classNode.getStart());
            typeDeclaration.bodyEnd = classNode.getEnd() - 1;
            typeDeclaration.modifiersSourceStart = classNode.getStart();
        }

        private void fixupSourceLocationsForConstructorDeclaration(ConstructorDeclaration ctorDeclaration, ConstructorNode ctorNode) {
            Javadoc doc;
            ctorDeclaration.sourceStart = ctorNode.getNameStart();
            ctorDeclaration.sourceEnd = ctorNode.getNameEnd();
            int line = ctorNode.getLineNumber();
            ctorDeclaration.javadoc = doc = this.findJavadoc(line);
            ctorDeclaration.declarationSourceStart = doc == null ? ctorNode.getStart() : doc.sourceStart;
            ctorDeclaration.declarationSourceEnd = ctorNode.getEnd() - 1;
            ctorDeclaration.modifiersSourceStart = ctorNode.getStart();
            ctorDeclaration.bodyStart = ctorNode.getCode() != null ? ctorNode.getCode().getStart() : ctorNode.getNameEnd();
            ctorDeclaration.bodyEnd = ctorNode.getEnd() - 1;
        }

        private void fixupSourceLocationsForMethodDeclaration(MethodDeclaration methodDeclaration, MethodNode methodNode) {
            Javadoc doc;
            methodDeclaration.sourceStart = Math.max(methodNode.getNameStart(), methodNode.getStart());
            methodDeclaration.sourceEnd = Math.max(methodNode.getNameEnd(), methodNode.getStart());
            int line = methodNode.getLineNumber();
            methodDeclaration.javadoc = doc = this.findJavadoc(line);
            methodDeclaration.declarationSourceStart = doc == null ? methodNode.getStart() : doc.sourceStart;
            methodDeclaration.declarationSourceEnd = methodNode.getEnd() - 1;
            methodDeclaration.modifiersSourceStart = methodNode.getStart();
            methodDeclaration.bodyStart = methodNode.getCode() != null ? methodNode.getCode().getStart() : Math.max(methodNode.getNameEnd(), methodNode.getStart());
            methodDeclaration.bodyEnd = methodNode.getEnd() - 1;
        }

        private void fixupSourceLocationsForFieldDeclaration(FieldDeclaration fieldDeclaration, FieldNode fieldNode, boolean isEnumField) {
            Javadoc doc;
            fieldDeclaration.sourceStart = fieldNode.getNameStart();
            fieldDeclaration.sourceEnd = fieldNode.getNameEnd();
            int line = fieldNode.getLineNumber();
            fieldDeclaration.javadoc = doc = this.findJavadoc(line);
            if (isEnumField) {
                fieldDeclaration.declarationSourceStart = doc == null ? fieldNode.getStart() : doc.sourceStart;
                fieldDeclaration.declarationSourceEnd = fieldNode.getEnd() - 1;
            } else {
                fieldDeclaration.declarationSourceStart = doc == null ? fieldNode.getStart() : doc.sourceStart;
                fieldDeclaration.declarationSourceEnd = fieldNode.getEnd() - 1;
            }
            fieldDeclaration.modifiersSourceStart = fieldNode.getStart();
            fieldDeclaration.declarationEnd = fieldNode.getEnd();
            fieldDeclaration.endPart1Position = fieldNode.getNameStart();
            fieldDeclaration.endPart2Position = fieldNode.getEnd() - 1;
        }

        private MethodDeclaration genMethodDeclarationVariant(ClassNode classNode, MethodNode methodNode, boolean isEnum, Argument[] alternativeArguments, TypeReference returnType, CompilationResult compilationResult) {
            MethodDeclaration methodDeclaration = this.createMethodDeclaration(classNode, isEnum, methodNode, compilationResult);
            methodDeclaration.arguments = alternativeArguments;
            this.fixupSourceLocationsForMethodDeclaration(methodDeclaration, methodNode);
            return methodDeclaration;
        }

        private List<Argument[]> getVariantsAllowingForDefaulting(Parameter[] groovyParams, Argument[] jdtArguments) {
            ArrayList<Argument[]> variants = new ArrayList<Argument[]>();
            int psCount = groovyParams.length;
            Parameter[] wipableParameters = new Parameter[psCount];
            System.arraycopy(groovyParams, 0, wipableParameters, 0, psCount);
            ArrayList<Argument> oneVariation = new ArrayList<Argument>();
            int nextToLetDefault = -1;
            do {
                oneVariation.clear();
                nextToLetDefault = -1;
                int p = 0;
                while (p < psCount) {
                    if (wipableParameters[p] != null) {
                        oneVariation.add(jdtArguments[p]);
                        if (wipableParameters[p].hasInitialExpression()) {
                            nextToLetDefault = p;
                        }
                    }
                    ++p;
                }
                if (nextToLetDefault != -1) {
                    wipableParameters[nextToLetDefault] = null;
                }
                Argument[] argumentsVariant = oneVariation.size() == 0 ? null : oneVariation.toArray(new Argument[oneVariation.size()]);
                variants.add(argumentsVariant);
            } while (nextToLetDefault != -1);
            return variants;
        }

        private void addUnlessDuplicate(List<AbstractMethodDeclaration> methodDeclarations, AbstractMethodDeclaration newDeclaration) {
            boolean isDuplicate = false;
            for (AbstractMethodDeclaration aMethodDecl : methodDeclarations) {
                int vmdArgsLen;
                if (!CharOperation.equals(aMethodDecl.selector, newDeclaration.selector)) continue;
                Argument[] mdArgs = aMethodDecl.arguments;
                Argument[] vmdArgs = newDeclaration.arguments;
                int mdArgsLen = mdArgs == null ? 0 : mdArgs.length;
                int n = vmdArgsLen = vmdArgs == null ? 0 : vmdArgs.length;
                if (mdArgsLen != vmdArgsLen) continue;
                boolean argsTheSame = true;
                int i = 0;
                while (i < mdArgsLen) {
                    if (!CharOperation.equals(mdArgs[i].type.getTypeName(), vmdArgs[i].type.getTypeName())) {
                        argsTheSame = false;
                        break;
                    }
                    ++i;
                }
                if (!argsTheSame) continue;
                isDuplicate = true;
                break;
            }
            if (!isDuplicate) {
                methodDeclarations.add(newDeclaration);
            }
        }

        private void applyEarlyTransforms(char[] ctorName, ClassNode classNode, List<AbstractMethodDeclaration> methodDeclarations) {
            ConstructorDeclaration decl;
            List<FieldNode> fields;
            int n;
            boolean sortable = false;
            boolean immutable = false;
            boolean inheritCtors = false;
            for (AnnotationNode anno : classNode.getAnnotations()) {
                String name = anno.getClassNode().getName();
                if (this.isType("groovy.transform.Sortable", name)) {
                    sortable = true;
                    continue;
                }
                if (this.isType("groovy.transform.Immutable", name)) {
                    immutable = true;
                    continue;
                }
                if (!this.isType("groovy.transform.InheritConstructors", name)) continue;
                inheritCtors = true;
            }
            if (sortable) {
                MethodDeclaration decl2 = new MethodDeclaration(this.unitDeclaration.compilationResult);
                Parameter p = new Parameter(classNode, "that");
                p.setSourcePosition(classNode);
                decl2.arguments = this.createArguments(new Parameter[]{p}, false);
                decl2.modifiers = 1;
                decl2.returnType = this.createTypeReferenceForClassNode(ClassHelper.int_TYPE);
                decl2.selector = "compareTo".toCharArray();
                decl2.sourceEnd = classNode.getEnd();
                decl2.sourceStart = classNode.getEnd() - 1;
                decl2.declarationSourceEnd = decl2.sourceEnd;
                decl2.declarationSourceStart = decl2.sourceStart;
                this.addUnlessDuplicate(methodDeclarations, decl2);
            }
            if (immutable && (n = (fields = classNode.getFields()).size()) > 0) {
                Parameter[] params = new Parameter[n];
                int i = 0;
                while (i < n) {
                    FieldNode field = fields.get(i);
                    params[i] = new Parameter(field.getType(), field.getName());
                    params[i].setStart(field.getStart());
                    params[i].setEnd(field.getEnd());
                    ++i;
                }
                decl = new ConstructorDeclaration(this.unitDeclaration.compilationResult);
                decl.arguments = this.createArguments(params, false);
                decl.modifiers = 1;
                decl.selector = ctorName;
                decl.sourceEnd = classNode.getNameEnd();
                decl.declarationSourceStart = decl.sourceStart = classNode.getNameStart();
                this.addUnlessDuplicate(methodDeclarations, decl);
            }
            if (inheritCtors) {
                ClassNode superClassNode = classNode.getSuperClass();
                for (ConstructorNode ctor : superClassNode.getDeclaredConstructors()) {
                    decl = new ConstructorDeclaration(this.unitDeclaration.compilationResult);
                    decl.arguments = this.createArguments(ctor.getParameters(), false);
                    decl.modifiers = ctor.getModifiers();
                    decl.selector = ctorName;
                    decl.sourceEnd = classNode.getNameEnd();
                    decl.declarationSourceStart = decl.sourceStart = classNode.getNameStart();
                    this.addUnlessDuplicate(methodDeclarations, decl);
                }
            }
        }

        private static TypeReference verify(TypeReference toVerify) {
            if (toVerify.getClass().equals(SingleTypeReference.class)) {
                SingleTypeReference str = (SingleTypeReference)toVerify;
                if (str.sourceStart == -1) {
                    if (str.sourceEnd != -2) {
                        throw new IllegalStateException("TypeReference '" + String.valueOf(str.token) + " should end at -2");
                    }
                } else if (str.sourceEnd < str.sourceStart) {
                    throw new IllegalStateException("TypeReference '" + String.valueOf(str.token) + " should end at " + str.sourceStart + " or later");
                }
            } else {
                throw new IllegalStateException("Cannot verify type reference of this class " + toVerify.getClass());
            }
            return toVerify;
        }
    }
}

