/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jdt.groovy.integration.internal;

import java.util.Collections;
import org.codehaus.jdt.groovy.internal.compiler.ast.GroovyParser;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.groovy.core.util.ContentTypeUtils;
import org.eclipse.jdt.groovy.core.util.ReflectionUtils;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.ISourceElementRequestor;
import org.eclipse.jdt.internal.compiler.SourceElementNotifier;
import org.eclipse.jdt.internal.compiler.SourceElementParser;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ImportReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedAllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.jdt.internal.compiler.util.HashtableOfObjectToInt;
import org.eclipse.jdt.internal.core.AnnotatableInfo;
import org.eclipse.jdt.internal.core.CompilationUnitStructureRequestor;
import org.eclipse.jdt.internal.core.ImportContainerInfo;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.util.Util;

public class MultiplexingSourceElementRequestorParser
extends SourceElementParser {
    private GroovyParser groovyParser;
    private boolean groovyReportReferenceInfo;

    public MultiplexingSourceElementRequestorParser(ProblemReporter problemReporter, ISourceElementRequestor requestor, IProblemFactory problemFactory, CompilerOptions options, boolean reportLocalDeclarations, boolean optimizeStringLiterals) {
        super(requestor, problemFactory, options, reportLocalDeclarations, optimizeStringLiterals);
        this.groovyParser = new GroovyParser(requestor, this.options, problemReporter, false, true);
        if (requestor instanceof CompilationUnitStructureRequestor) {
            final CompilationUnitStructureRequestor compUnitStructureRequestor = (CompilationUnitStructureRequestor)requestor;
            ReflectionUtils.setPrivateField(SourceElementParser.class, "notifier", this, new SourceElementNotifier(requestor, reportLocalDeclarations){

                @Override
                protected void notifySourceElementRequestor(ImportReference importReference, boolean isPackage) {
                    super.notifySourceElementRequestor(importReference, isPackage);
                    if (!isPackage && importReference.annotations != null) {
                        try {
                            ImportContainerInfo importContainerInfo = (ImportContainerInfo)ReflectionUtils.getPrivateField(CompilationUnitStructureRequestor.class, "importContainerInfo", compUnitStructureRequestor);
                            Annotation[] annotationArray = importReference.annotations;
                            int n = importReference.annotations.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Annotation annotation = annotationArray[n2];
                                IJavaElement[] imports = (IJavaElement[])ReflectionUtils.throwableExecutePrivateMethod(CompilationUnitStructureRequestor.class, "getChildren", new Class[]{Object.class}, compUnitStructureRequestor, new Object[]{importContainerInfo});
                                Object[] objectArray = new Object[3];
                                objectArray[0] = annotation;
                                objectArray[2] = imports[imports.length - 1];
                                ReflectionUtils.throwableExecutePrivateMethod(CompilationUnitStructureRequestor.class, "acceptAnnotation", new Class[]{Annotation.class, AnnotatableInfo.class, JavaElement.class}, compUnitStructureRequestor, objectArray);
                                ++n2;
                            }
                        }
                        catch (Throwable t) {
                            Util.log(t);
                        }
                    }
                }
            });
        }
    }

    @Override
    public void reset() {
        this.groovyParser.reset();
    }

    @Override
    public CompilationUnitDeclaration parseCompilationUnit(ICompilationUnit unit, boolean fullParse, IProgressMonitor pm) {
        if (ContentTypeUtils.isGroovyLikeFileName(unit.getFileName())) {
            CompilationResult compilationResult = new CompilationResult(unit, 0, 0, this.options.maxProblemsPerUnit);
            GroovyParser groovyParser = new GroovyParser(this.groovyParser.requestor, this.options, this.problemReporter, false, true);
            CompilationUnitDeclaration cud = groovyParser.dietParse(unit, compilationResult);
            SourceElementNotifier notifier = (SourceElementNotifier)ReflectionUtils.getPrivateField(SourceElementParser.class, "notifier", this);
            notifier.notifySourceElementRequestor(cud, 0, unit.getContents().length, this.groovyReportReferenceInfo, MultiplexingSourceElementRequestorParser.createSourceEnds(cud), Collections.EMPTY_MAP);
            return cud;
        }
        return super.parseCompilationUnit(unit, fullParse, pm);
    }

    @Override
    public CompilationUnitDeclaration dietParse(ICompilationUnit sourceUnit, CompilationResult compilationResult) {
        if (ContentTypeUtils.isGroovyLikeFileName(sourceUnit.getFileName())) {
            return this.groovyParser.dietParse(sourceUnit, compilationResult);
        }
        return super.dietParse(sourceUnit, compilationResult);
    }

    private static HashtableOfObjectToInt createSourceEnds(CompilationUnitDeclaration cDecl) {
        HashtableOfObjectToInt table = new HashtableOfObjectToInt();
        if (cDecl.types != null) {
            TypeDeclaration[] typeDeclarationArray = cDecl.types;
            int n = cDecl.types.length;
            int n2 = 0;
            while (n2 < n) {
                TypeDeclaration tDecl = typeDeclarationArray[n2];
                MultiplexingSourceElementRequestorParser.createSourceEndsForType(tDecl, table);
                ++n2;
            }
        }
        return table;
    }

    private static void createSourceEndsForType(TypeDeclaration tDecl, HashtableOfObjectToInt table) {
        int n;
        int n2;
        ASTNode[] aSTNodeArray;
        table.put(tDecl, tDecl.sourceEnd);
        if (tDecl.fields != null) {
            aSTNodeArray = tDecl.fields;
            n2 = tDecl.fields.length;
            n = 0;
            while (n < n2) {
                ASTNode fDecl = aSTNodeArray[n];
                table.put(fDecl, ((FieldDeclaration)fDecl).sourceEnd);
                ++n;
            }
        }
        if (tDecl.methods != null) {
            aSTNodeArray = tDecl.methods;
            n2 = tDecl.methods.length;
            n = 0;
            while (n < n2) {
                ASTNode mDecl = aSTNodeArray[n];
                table.put(mDecl, ((AbstractMethodDeclaration)mDecl).sourceEnd);
                if (((AbstractMethodDeclaration)mDecl).statements != null && ((AbstractMethodDeclaration)mDecl).statements.length > 0) {
                    Statement[] statementArray = ((AbstractMethodDeclaration)mDecl).statements;
                    int n3 = ((AbstractMethodDeclaration)mDecl).statements.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Statement expr = statementArray[n4];
                        if (expr instanceof QualifiedAllocationExpression) {
                            MultiplexingSourceElementRequestorParser.createSourceEndsForType(((QualifiedAllocationExpression)expr).anonymousType, table);
                        }
                        ++n4;
                    }
                }
                ++n;
            }
        }
        if (tDecl.memberTypes != null) {
            aSTNodeArray = tDecl.memberTypes;
            n2 = tDecl.memberTypes.length;
            n = 0;
            while (n < n2) {
                ASTNode innerTDecl = aSTNodeArray[n];
                MultiplexingSourceElementRequestorParser.createSourceEndsForType((TypeDeclaration)innerTDecl, table);
                ++n;
            }
        }
    }
}

