/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.transform;

import groovy.lang.GroovyClassLoader;
import groovy.transform.AnnotationCollector;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.messages.ExceptionMessage;
import org.codehaus.groovy.control.messages.SimpleMessage;
import org.codehaus.groovy.control.messages.SyntaxErrorMessage;
import org.codehaus.groovy.syntax.SyntaxException;
import org.codehaus.groovy.transform.ASTTransformation;
import org.codehaus.groovy.transform.AnnotationCollectorTransform;
import org.codehaus.groovy.transform.GroovyASTTransformation;
import org.codehaus.groovy.transform.GroovyASTTransformationClass;
import org.codehaus.groovy.transform.trait.TraitASTTransformation;
import org.codehaus.groovy.transform.trait.Traits;

public class ASTTransformationCollectorCodeVisitor
extends ClassCodeVisitorSupport {
    private SourceUnit source;
    private ClassNode classNode;
    private GroovyClassLoader transformLoader;
    private boolean allowTransforms;
    private List<String> localTransformsAllowed;
    private static final String[] NONE = new String[0];
    private static final Class[] NO_CLASSES = new Class[0];

    public ASTTransformationCollectorCodeVisitor(SourceUnit source, GroovyClassLoader transformLoader, boolean allowTransforms, List<String> localTransformsAllowed) {
        this(source, transformLoader);
        this.allowTransforms = allowTransforms;
        this.localTransformsAllowed = localTransformsAllowed;
    }

    public ASTTransformationCollectorCodeVisitor(SourceUnit source, GroovyClassLoader transformLoader) {
        this.source = source;
        this.transformLoader = transformLoader;
    }

    @Override
    protected SourceUnit getSourceUnit() {
        return this.source;
    }

    @Override
    public void visitClass(ClassNode klassNode) {
        ClassNode oldClass = this.classNode;
        this.classNode = klassNode;
        super.visitClass(this.classNode);
        this.classNode = oldClass;
    }

    @Override
    public void visitAnnotations(AnnotatedNode node) {
        super.visitAnnotations(node);
        ArrayList<AnnotationNode> collected = new ArrayList<AnnotationNode>();
        Iterator<AnnotationNode> it = node.getAnnotations().iterator();
        while (it.hasNext()) {
            AnnotationNode annotation = it.next();
            if (!this.addCollectedAnnotations(collected, annotation, node)) continue;
            it.remove();
        }
        node.getAnnotations().addAll(collected);
        for (AnnotationNode annotation : node.getAnnotations()) {
            if (!this.allowTransforms && !this.isAllowed(annotation.getClassNode().getName())) continue;
            String[] transformClassNames = this.getTransformClassNames(annotation.getClassNode());
            Class[] transformClasses = this.getTransformClasses(annotation.getClassNode());
            if (transformClassNames == null && transformClasses == null) continue;
            if (transformClassNames == null) {
                transformClassNames = NONE;
            }
            if (transformClasses == null) {
                transformClasses = NO_CLASSES;
            }
            this.addTransformsToClassNode(annotation, transformClassNames, transformClasses);
        }
    }

    private void assertStringConstant(Expression exp) {
        ConstantExpression ce;
        if (exp == null) {
            return;
        }
        if (!(exp instanceof ConstantExpression)) {
            this.source.getErrorCollector().addErrorAndContinue(new SyntaxErrorMessage(new SyntaxException("Expected a String constant.", exp.getLineNumber(), exp.getColumnNumber()), this.source));
        }
        if (!((ce = (ConstantExpression)exp).getValue() instanceof String)) {
            this.source.getErrorCollector().addErrorAndContinue(new SyntaxErrorMessage(new SyntaxException("Expected a String constant.", exp.getLineNumber(), exp.getColumnNumber()), this.source));
        }
    }

    private boolean addCollectedAnnotations(List<AnnotationNode> collected, AnnotationNode aliasNode, AnnotatedNode origin) {
        ClassNode classNode = aliasNode.getClassNode();
        boolean ret = false;
        for (AnnotationNode annotation : classNode.getAnnotations()) {
            if (!annotation.getClassNode().getName().equals(AnnotationCollector.class.getName())) continue;
            Expression processorExp = annotation.getMember("processor");
            AnnotationCollectorTransform act = null;
            this.assertStringConstant(processorExp);
            if (processorExp != null) {
                String className = (String)((ConstantExpression)processorExp).getValue();
                Class klass = this.loadTransformClass(className, aliasNode);
                if (klass != null) {
                    try {
                        act = (AnnotationCollectorTransform)klass.newInstance();
                    }
                    catch (InstantiationException e) {
                        this.source.getErrorCollector().addErrorAndContinue(new ExceptionMessage(e, true, this.source));
                    }
                    catch (IllegalAccessException e) {
                        this.source.getErrorCollector().addErrorAndContinue(new ExceptionMessage(e, true, this.source));
                    }
                }
            } else {
                act = new AnnotationCollectorTransform();
            }
            if (act != null) {
                List<AnnotationNode> visitResult = act.visit(annotation, aliasNode, origin, this.source);
                for (AnnotationNode annotationNode : visitResult) {
                    HashSet<AnnotationNode> aliases = (HashSet<AnnotationNode>)annotationNode.getNodeMetaData("AnnotationCollector");
                    if (aliases == null) {
                        aliases = new HashSet<AnnotationNode>(1);
                        annotationNode.setNodeMetaData("AnnotationCollector", aliases);
                    }
                    aliases.add(aliasNode);
                }
                collected.addAll(visitResult);
            }
            ret = true;
        }
        return ret;
    }

    private void addTransformsToClassNode(AnnotationNode annotation, String[] transformClassNames, Class[] transformClasses) {
        if (transformClassNames.length == 0 && transformClasses.length == 0) {
            this.source.getErrorCollector().addError(new SimpleMessage("@GroovyASTTransformationClass in " + annotation.getClassNode().getName() + " does not specify any transform class names/classes", this.source));
        } else if (transformClassNames.length > 0 && transformClasses.length > 0) {
            this.source.getErrorCollector().addError(new SimpleMessage("@GroovyASTTransformationClass in " + annotation.getClassNode().getName() + " should specify transforms by class names or by classes, not by both", this.source));
        }
        Object[] objectArray = transformClassNames;
        int n = transformClassNames.length;
        int n2 = 0;
        while (n2 < n) {
            String transformClass = objectArray[n2];
            try {
                Class klass = this.transformLoader.loadClass(transformClass, false, true, false);
                this.verifyAndAddTransform(annotation, klass);
            }
            catch (ClassNotFoundException e) {
                this.source.getErrorCollector().addErrorAndContinue(new SimpleMessage("Could not find class for Transformation Processor " + transformClass + " declared by " + annotation.getClassNode().getName(), this.source));
            }
            ++n2;
        }
        objectArray = transformClasses;
        n = transformClasses.length;
        n2 = 0;
        while (n2 < n) {
            Object klass = objectArray[n2];
            this.verifyAndAddTransform(annotation, (Class)klass);
            ++n2;
        }
    }

    private String[] getTransformClassNames(Annotation transformClassAnnotation) {
        try {
            Method valueMethod = transformClassAnnotation.getClass().getMethod("value", new Class[0]);
            return (String[])valueMethod.invoke((Object)transformClassAnnotation, new Object[0]);
        }
        catch (Exception e) {
            this.source.addException(e);
            return NONE;
        }
    }

    private Class[] getTransformClasses(Annotation transformClassAnnotation) {
        try {
            Method classesMethod = transformClassAnnotation.getClass().getMethod("classes", new Class[0]);
            return (Class[])classesMethod.invoke((Object)transformClassAnnotation, new Object[0]);
        }
        catch (Exception e) {
            this.source.addException(e);
            return NO_CLASSES;
        }
    }

    private Class loadTransformClass(String transformClass, AnnotationNode annotation) {
        try {
            return this.transformLoader.loadClass(transformClass, false, true, false);
        }
        catch (ClassNotFoundException e) {
            this.source.getErrorCollector().addErrorAndContinue(new SimpleMessage("Could not find class for Transformation Processor " + transformClass + " declared by " + annotation.getClassNode().getName(), this.source));
            return null;
        }
    }

    private void verifyAndAddTransform(AnnotationNode annotation, Class klass) {
        this.verifyClass(annotation, klass);
        this.verifyCompilePhase(annotation, klass);
        this.addTransform(annotation, klass);
    }

    private void verifyCompilePhase(AnnotationNode annotation, Class<?> klass) {
        GroovyASTTransformation transformationClass = klass.getAnnotation(GroovyASTTransformation.class);
        if (transformationClass != null) {
            CompilePhase specifiedCompilePhase = transformationClass.phase();
            if (specifiedCompilePhase.getPhaseNumber() < CompilePhase.SEMANTIC_ANALYSIS.getPhaseNumber()) {
                this.source.getErrorCollector().addError(new SimpleMessage(String.valueOf(annotation.getClassNode().getName()) + " is defined to be run in compile phase " + (Object)((Object)specifiedCompilePhase) + ". Local AST transformations must run in " + (Object)((Object)CompilePhase.SEMANTIC_ANALYSIS) + " or later!", this.source));
            }
        } else {
            this.source.getErrorCollector().addError(new SimpleMessage("AST transformation implementation classes must be annotated with " + GroovyASTTransformation.class.getName() + ". " + klass.getName() + " lacks this annotation.", this.source));
        }
    }

    private void verifyClass(AnnotationNode annotation, Class klass) {
        if (!ASTTransformation.class.isAssignableFrom(klass)) {
            this.source.getErrorCollector().addError(new SimpleMessage("Not an ASTTransformation: " + klass.getName() + " declared by " + annotation.getClassNode().getName(), this.source));
        }
    }

    private void addTransform(AnnotationNode annotation, Class klass) {
        boolean apply;
        boolean bl = apply = !Traits.isTrait(this.classNode) || klass == TraitASTTransformation.class;
        if (apply) {
            this.classNode.addTransform(klass, annotation);
        }
    }

    private static Annotation getTransformClassAnnotation(ClassNode annotatedType) {
        if (!annotatedType.isResolved()) {
            return null;
        }
        Annotation[] annotationArray = annotatedType.getTypeClass().getAnnotations();
        int n = annotationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation ann = annotationArray[n2];
            if (ann.annotationType().getName().equals(GroovyASTTransformationClass.class.getName())) {
                return ann;
            }
            ++n2;
        }
        return null;
    }

    private String[] getTransformClassNames(ClassNode cn) {
        if (!cn.hasClass()) {
            List<AnnotationNode> annotations = cn.getAnnotations();
            AnnotationNode transformAnnotation = null;
            for (AnnotationNode anno : annotations) {
                if (!anno.getClassNode().getName().equals(GroovyASTTransformationClass.class.getName())) continue;
                transformAnnotation = anno;
                break;
            }
            if (transformAnnotation != null) {
                Expression expr2 = transformAnnotation.getMember("value");
                String[] values = null;
                if (expr2 == null) {
                    return NONE;
                }
                if (expr2 instanceof ListExpression) {
                    ListExpression expression = (ListExpression)expr2;
                    List<Expression> expressions = expression.getExpressions();
                    values = new String[expressions.size()];
                    int e = 0;
                    for (Expression expr : expressions) {
                        values[e++] = ((ConstantExpression)expr).getText();
                    }
                } else if (expr2 instanceof ConstantExpression) {
                    values = new String[]{((ConstantExpression)expr2).getText()};
                } else {
                    throw new IllegalStateException("NYI: eclipse doesn't understand this kind of expression in an Ast transform definition: " + expr2 + " (class=" + expr2.getClass().getName() + ")");
                }
                return values;
            }
            return null;
        }
        Annotation transformClassAnnotation = ASTTransformationCollectorCodeVisitor.getTransformClassAnnotation(cn);
        if (transformClassAnnotation == null) {
            return null;
        }
        return this.getTransformClassNames(transformClassAnnotation);
    }

    private Class[] getTransformClasses(ClassNode classNode) {
        if (!classNode.hasClass()) {
            List<AnnotationNode> annotations = classNode.getAnnotations();
            AnnotationNode transformAnnotation = null;
            for (AnnotationNode anno : annotations) {
                if (!anno.getClassNode().getName().equals(GroovyASTTransformationClass.class.getName())) continue;
                transformAnnotation = anno;
                break;
            }
            if (transformAnnotation != null) {
                Expression expr = transformAnnotation.getMember("classes");
                if (expr == null) {
                    return NO_CLASSES;
                }
                Class[] values = NO_CLASSES;
                if (expr instanceof ListExpression) {
                    ArrayList loadedClasses = new ArrayList();
                    ListExpression expression = (ListExpression)expr;
                    List<Expression> expressions = expression.getExpressions();
                    for (Expression oneExpr : expressions) {
                        String classname = ((ClassExpression)oneExpr).getType().getName();
                        try {
                            Class<?> clazz = Class.forName(classname, false, this.transformLoader);
                            loadedClasses.add(clazz);
                        }
                        catch (ClassNotFoundException cnfe) {
                            this.source.getErrorCollector().addError(new SimpleMessage("Ast transform processing, cannot find " + classname, this.source));
                        }
                    }
                    if (!loadedClasses.isEmpty()) {
                        values = loadedClasses.toArray(new Class[loadedClasses.size()]);
                    }
                    return values;
                }
                throw new RuntimeException("nyi implemented in eclipse: need to support: " + expr + " (class=" + expr.getClass() + ")");
            }
            return null;
        }
        Annotation transformClassAnnotation = ASTTransformationCollectorCodeVisitor.getTransformClassAnnotation(classNode);
        if (transformClassAnnotation == null) {
            return null;
        }
        return this.getTransformClasses(transformClassAnnotation);
    }

    private boolean isAllowed(String transformName) {
        if (this.localTransformsAllowed == null || "groovy.transform.TypeChecked".equals(transformName) || "groovy.transform.CompileStatic".equals(transformName) || "grails.transaction.Transactional".equals(transformName)) {
            return true;
        }
        for (String localTransformAllowed : this.localTransformsAllowed) {
            if (localTransformAllowed.equals("*")) {
                return true;
            }
            if (!(localTransformAllowed.endsWith("$") ? transformName.endsWith(localTransformAllowed.substring(0, localTransformAllowed.length() - 1)) : transformName.indexOf(localTransformAllowed) != -1)) continue;
            return true;
        }
        return false;
    }
}

