/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jdt.groovy.model;

import java.util.ArrayList;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.jdt.groovy.internal.compiler.ast.GroovyCompilationUnitDeclaration;
import org.codehaus.jdt.groovy.internal.compiler.ast.JDTResolver;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.codehaus.jdt.groovy.model.ModuleNodeMapper;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.util.IClassFileReader;
import org.eclipse.jdt.groovy.core.Activator;
import org.eclipse.jdt.groovy.core.util.ReflectionUtils;
import org.eclipse.jdt.internal.core.BinaryType;
import org.eclipse.jdt.internal.core.BufferManager;
import org.eclipse.jdt.internal.core.ClassFile;
import org.eclipse.jdt.internal.core.ClassFileWorkingCopy;
import org.eclipse.jdt.internal.core.CompilationUnitElementInfo;
import org.eclipse.jdt.internal.core.DefaultWorkingCopyOwner;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.JavaModelStatus;
import org.eclipse.jdt.internal.core.PackageFragment;
import org.eclipse.jdt.internal.core.PackageFragmentRoot;
import org.eclipse.jdt.internal.core.util.Disassembler;
import org.eclipse.jdt.internal.core.util.Util;

public class GroovyClassFileWorkingCopy
extends GroovyCompilationUnit {
    public final ClassFile classFile;
    private final JavaModelManager.PerWorkingCopyInfo info;
    private CompilationUnitElementInfo elementInfo;
    private ModuleNode moduleNode;
    private ModuleNodeMapper.ModuleNodeInfo moduleNodeInfo;

    public GroovyClassFileWorkingCopy(ClassFile classFile, WorkingCopyOwner owner) {
        super((PackageFragment)classFile.getParent(), ((BinaryType)classFile.getType()).getSourceFileName(null), owner);
        this.classFile = classFile;
        if (this.owner == null) {
            this.owner = DefaultWorkingCopyOwner.PRIMARY;
        }
        this.info = new JavaModelManager.PerWorkingCopyInfo(this, null);
    }

    @Override
    public void commitWorkingCopy(boolean force, IProgressMonitor monitor) throws JavaModelException {
        throw new JavaModelException(new JavaModelStatus(967, this));
    }

    @Override
    public IBuffer getBuffer() throws JavaModelException {
        return this.classFile.getBuffer();
    }

    @Override
    public char[] getContents() {
        try {
            IBuffer buffer = this.getBuffer();
            if (buffer == null) {
                return CharOperation.NO_CHAR;
            }
            char[] characters = buffer.getCharacters();
            if (characters == null) {
                return CharOperation.NO_CHAR;
            }
            return characters;
        }
        catch (JavaModelException e) {
            return CharOperation.NO_CHAR;
        }
    }

    @Override
    public IPath getPath() {
        return this.classFile.getPath();
    }

    @Override
    public IJavaElement getPrimaryElement(boolean checkOwner) {
        if (checkOwner && this.isPrimary()) {
            return this;
        }
        return new ClassFileWorkingCopy(this.classFile, DefaultWorkingCopyOwner.PRIMARY);
    }

    @Override
    public IResource resource(PackageFragmentRoot root) {
        if (root.isArchive()) {
            return root.resource(root);
        }
        return this.classFile.resource(root);
    }

    @Override
    protected IBuffer openBuffer(IProgressMonitor pm, Object info) throws JavaModelException {
        IBuffer buffer = this.owner.createBuffer(this);
        if (buffer == null) {
            return null;
        }
        if (buffer.getCharacters() == null) {
            IBuffer classFileBuffer = this.classFile.getBuffer();
            if (classFileBuffer != null) {
                buffer.setContents(classFileBuffer.getCharacters());
            } else {
                IClassFileReader reader = ToolFactory.createDefaultClassFileReader(this.classFile, 65535);
                Disassembler disassembler = new Disassembler();
                String contents = disassembler.disassemble(reader, Util.getLineSeparator("", this.getJavaProject()), 16);
                buffer.setContents(contents);
            }
        }
        BufferManager bufManager = this.getBufferManager();
        if (buffer.getContents() != null) {
            ReflectionUtils.executePrivateMethod(BufferManager.class, "addBuffer", new Class[]{IBuffer.class}, bufManager, new Object[]{buffer});
        }
        buffer.addBufferChangedListener(this);
        return buffer;
    }

    @Override
    protected void toStringName(StringBuffer buffer) {
        buffer.append(this.classFile.getElementName());
    }

    @Override
    public JavaModelManager.PerWorkingCopyInfo getPerWorkingCopyInfo() {
        if (this.elementInfo == null) {
            try {
                this.elementInfo = (CompilationUnitElementInfo)this.createElementInfo();
                this.openWhenClosed(this.elementInfo, true, new NullProgressMonitor());
            }
            catch (JavaModelException e) {
                this.elementInfo = null;
                Activator.getDefault().getLog().log(e.getJavaModelStatus());
            }
        }
        return this.info;
    }

    @Override
    protected void maybeCacheModuleNode(JavaModelManager.PerWorkingCopyInfo perWorkingCopyInfo, GroovyCompilationUnitDeclaration compilationUnitDeclaration) {
        if (compilationUnitDeclaration != null) {
            this.moduleNode = compilationUnitDeclaration.getModuleNode();
            this.moduleNode.setDescription(this.name);
            JDTResolver resolver = ModuleNodeMapper.shouldStoreResovler() ? (JDTResolver)compilationUnitDeclaration.getCompilationUnit().getResolveVisitor() : null;
            this.moduleNodeInfo = new ModuleNodeMapper.ModuleNodeInfo(this.moduleNode, resolver);
        }
    }

    @Override
    public ModuleNodeMapper.ModuleNodeInfo getModuleInfo(boolean force) {
        if (this.moduleNodeInfo == null) {
            try {
                this.reconcile(true, null);
            }
            catch (JavaModelException e) {
                Util.log(e);
            }
        }
        return this.moduleNodeInfo;
    }

    @Override
    public ModuleNodeMapper.ModuleNodeInfo getNewModuleInfo() {
        if (this.moduleNodeInfo == null) {
            try {
                this.open(null);
            }
            catch (JavaModelException e) {
                Util.log(e);
            }
        }
        return this.moduleNodeInfo;
    }

    @Override
    public ModuleNode getModuleNode() {
        this.getPerWorkingCopyInfo();
        return this.moduleNode;
    }

    @Override
    public IResource resource() {
        return this.getJavaProject().getResource();
    }

    @Override
    public char[] getFileName() {
        return this.name.toCharArray();
    }

    @Override
    public boolean isOnBuildPath() {
        return true;
    }

    public IJavaElement convertToBinary(IJavaElement source) {
        if (source.isReadOnly()) {
            return source;
        }
        if (source.getElementType() == 5) {
            return this.classFile;
        }
        if (!(source instanceof IMember)) {
            return this.classFile;
        }
        ArrayList<IJavaElement> srcAncestors = new ArrayList<IJavaElement>(3);
        IJavaElement srcCandidate = source;
        while (srcCandidate != null && srcCandidate != this) {
            srcAncestors.add(srcCandidate);
            srcCandidate = srcCandidate.getParent();
        }
        IJavaElement binCandidate = this.classFile;
        try {
            while (srcAncestors.size() > 0) {
                srcCandidate = (IJavaElement)srcAncestors.remove(srcAncestors.size() - 1);
                if (srcCandidate instanceof IParent) {
                    String candidateName = srcCandidate.getElementName();
                    IJavaElement[] binChildren = ((IParent)((Object)binCandidate)).getChildren();
                    boolean found = false;
                    IJavaElement[] iJavaElementArray = binChildren;
                    int n = binChildren.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IJavaElement binChild = iJavaElementArray[n2];
                        if (binChild.getElementName().equals(candidateName) || binChild.getElementType() == 7 && binChild.getParent().getElementName().equals(String.valueOf(candidateName) + '$' + binChild.getElementName() + ".class")) {
                            binCandidate = binChild;
                            found = true;
                            break;
                        }
                        ++n2;
                    }
                    if (found) {
                        continue;
                    }
                }
                break;
            }
        }
        catch (JavaModelException e) {
            Util.log(e);
        }
        return binCandidate;
    }
}

