/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.groovy.search;

import groovy.lang.Tuple;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.ImmutableClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.runtime.DateGroovyMethods;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.DefaultGroovyStaticMethods;
import org.codehaus.groovy.runtime.EncodingGroovyMethods;
import org.codehaus.groovy.runtime.ProcessGroovyMethods;
import org.codehaus.groovy.runtime.SwingGroovyMethods;
import org.codehaus.groovy.runtime.XmlGroovyMethods;
import org.codehaus.jdt.groovy.internal.compiler.ast.JDTMethodNode;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.groovy.core.util.GroovyUtils;
import org.eclipse.jdt.groovy.core.util.ReflectionUtils;
import org.eclipse.jdt.groovy.search.AccessorSupport;
import org.eclipse.jdt.groovy.search.GenericsMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VariableScope
implements Iterable<VariableInfo> {
    public static final VariableScope[] EMPTY_ARRAY = new VariableScope[0];
    public static final ClassNode NULL_TYPE = new ImmutableClassNode(Object.class);
    public static final ClassNode VOID_CLASS_NODE = ClassHelper.make(Void.TYPE);
    public static final ClassNode VOID_WRAPPER_CLASS_NODE = ClassHelper.void_WRAPPER_TYPE;
    public static final ClassNode OBJECT_CLASS_NODE = ClassHelper.OBJECT_TYPE;
    public static final ClassNode GROOVY_OBJECT_CLASS_NODE = ClassHelper.GROOVY_OBJECT_TYPE;
    public static final ClassNode GROOVY_SUPPORT_CLASS_NODE = ClassHelper.GROOVY_OBJECT_SUPPORT_TYPE;
    public static final ClassNode CLOSURE_CLASS_NODE = ClassHelper.CLOSURE_TYPE;
    public static final ClassNode ENUMERATION_CLASS = ClassHelper.make(Enumeration.class);
    public static final ClassNode ITERATOR_CLASS = ClassHelper.Iterator_TYPE;
    public static final ClassNode LIST_CLASS_NODE = ClassHelper.LIST_TYPE;
    public static final ClassNode MAP_CLASS_NODE = ClassHelper.MAP_TYPE;
    public static final ClassNode RANGE_CLASS_NODE = ClassHelper.RANGE_TYPE;
    public static final ClassNode TUPLE_CLASS_NODE = ClassHelper.make(Tuple.class);
    public static final ClassNode STRING_CLASS_NODE = ClassHelper.STRING_TYPE;
    public static final ClassNode GSTRING_CLASS_NODE = ClassHelper.GSTRING_TYPE;
    public static final ClassNode NUMBER_CLASS_NODE = ClassHelper.Number_TYPE;
    public static final ClassNode BIG_DECIMAL_CLASS = ClassHelper.BigDecimal_TYPE;
    public static final ClassNode BIG_INTEGER_CLASS = ClassHelper.BigInteger_TYPE;
    public static final ClassNode PATTERN_CLASS_NODE = ClassHelper.PATTERN_TYPE;
    public static final ClassNode MATCHER_CLASS_NODE = ClassHelper.make(Matcher.class);
    public static final ClassNode FILE_CLASS_NODE = ClassHelper.make(File.class);
    public static final ClassNode INPUT_STREAM_CLASS = ClassHelper.make(InputStream.class);
    public static final ClassNode OUTPUT_STREAM_CLASS = ClassHelper.make(OutputStream.class);
    public static final ClassNode DATA_INPUT_STREAM_CLASS = ClassHelper.make(DataInputStream.class);
    public static final ClassNode DATA_OUTPUT_STREAM_CLASS = ClassHelper.make(DataOutputStream.class);
    public static final ClassNode OBJECT_OUTPUT_STREAM = ClassHelper.make(ObjectOutputStream.class);
    public static final ClassNode OBJECT_INPUT_STREAM = ClassHelper.make(ObjectInputStream.class);
    public static final ClassNode BUFFERED_READER_CLASS_NODE = ClassHelper.make(BufferedReader.class);
    public static final ClassNode BUFFERED_WRITER_CLASS_NODE = ClassHelper.make(BufferedWriter.class);
    public static final ClassNode PRINT_WRITER_CLASS_NODE = ClassHelper.make(PrintWriter.class);
    public static final ClassNode DGM_CLASS_NODE = ClassHelper.make(DefaultGroovyMethods.class);
    public static final ClassNode EGM_CLASS_NODE = ClassHelper.make(EncodingGroovyMethods.class);
    public static final ClassNode PGM_CLASS_NODE = ClassHelper.make(ProcessGroovyMethods.class);
    public static final ClassNode SGM_CLASS_NODE = ClassHelper.make(SwingGroovyMethods.class);
    public static final ClassNode XGM_CLASS_NODE = ClassHelper.make(XmlGroovyMethods.class);
    public static final ClassNode DGSM_CLASS_NODE = ClassHelper.make(DefaultGroovyStaticMethods.class);
    public static final ClassNode DATE_GM_CLASS_NODE = ClassHelper.make(DateGroovyMethods.class);
    public static ClassNode RESOURCE_GROOVY_METHODS;
    public static ClassNode STRING_GROOVY_METHODS;
    public static ClassNode IO_GROOVY_METHODS;
    public static ClassNode DELEGATES_TO;
    public static Set<ClassNode> ALL_DEFAULT_CATEGORIES;
    public static final ClassNode CLASS_CLASS_NODE;
    public static final ClassNode CLASS_ARRAY_CLASS_NODE;
    public static final ClassNode BOOLEAN_CLASS_NODE;
    public static final ClassNode CHARACTER_CLASS_NODE;
    public static final ClassNode BYTE_CLASS_NODE;
    public static final ClassNode INTEGER_CLASS_NODE;
    public static final ClassNode SHORT_CLASS_NODE;
    public static final ClassNode LONG_CLASS_NODE;
    public static final ClassNode FLOAT_CLASS_NODE;
    public static final ClassNode DOUBLE_CLASS_NODE;
    private VariableScope parent;
    private SharedState shared;
    ASTNode scopeNode;
    private boolean isPrimaryNode;
    private final boolean isStaticScope;
    private ClassNode categoryBeingDeclared;
    private int enclosingCallStackDepth;
    private List<ClassNode> methodCallArgumentTypes;
    private GenericsType[] methodCallGenericsTypes;
    private final Map<String, VariableInfo> nameVariableMap = new HashMap<String, VariableInfo>();

    static {
        try {
            RESOURCE_GROOVY_METHODS = ClassHelper.make(Class.forName("org.codehaus.groovy.runtime.ResourceGroovyMethods"));
            STRING_GROOVY_METHODS = ClassHelper.make(Class.forName("org.codehaus.groovy.runtime.StringGroovyMethods"));
            IO_GROOVY_METHODS = ClassHelper.make(Class.forName("org.codehaus.groovy.runtime.IOGroovyMethods"));
        }
        catch (ClassNotFoundException e) {
            RESOURCE_GROOVY_METHODS = null;
            STRING_GROOVY_METHODS = null;
            IO_GROOVY_METHODS = null;
        }
        try {
            DELEGATES_TO = ClassHelper.make(Class.forName("groovy.lang.DelegatesTo"));
        }
        catch (ClassNotFoundException e) {
            DELEGATES_TO = null;
        }
        ArrayList<ClassNode> dgm_classes = new ArrayList<ClassNode>(10);
        if (STRING_GROOVY_METHODS != null) {
            dgm_classes.add(STRING_GROOVY_METHODS);
        }
        if (RESOURCE_GROOVY_METHODS != null) {
            dgm_classes.add(RESOURCE_GROOVY_METHODS);
        }
        if (IO_GROOVY_METHODS != null) {
            dgm_classes.add(IO_GROOVY_METHODS);
        }
        dgm_classes.add(EGM_CLASS_NODE);
        dgm_classes.add(PGM_CLASS_NODE);
        dgm_classes.add(SGM_CLASS_NODE);
        dgm_classes.add(XGM_CLASS_NODE);
        dgm_classes.add(DATE_GM_CLASS_NODE);
        dgm_classes.add(DGSM_CLASS_NODE);
        dgm_classes.add(DGM_CLASS_NODE);
        ALL_DEFAULT_CATEGORIES = Collections.unmodifiableSet(new LinkedHashSet(dgm_classes));
        CLASS_CLASS_NODE = ClassHelper.makeWithoutCaching(Class.class);
        VariableScope.initializeProperties(CLASS_CLASS_NODE);
        CLASS_ARRAY_CLASS_NODE = CLASS_CLASS_NODE.makeArray();
        BOOLEAN_CLASS_NODE = ClassHelper.Boolean_TYPE;
        CHARACTER_CLASS_NODE = ClassHelper.Character_TYPE;
        BYTE_CLASS_NODE = ClassHelper.Byte_TYPE;
        INTEGER_CLASS_NODE = ClassHelper.Integer_TYPE;
        SHORT_CLASS_NODE = ClassHelper.Short_TYPE;
        LONG_CLASS_NODE = ClassHelper.Long_TYPE;
        FLOAT_CLASS_NODE = ClassHelper.Float_TYPE;
        DOUBLE_CLASS_NODE = ClassHelper.Double_TYPE;
    }

    public VariableScope(VariableScope parent, ASTNode enclosingNode, boolean isStatic) {
        this.parent = parent;
        this.scopeNode = enclosingNode;
        this.shared = parent != null ? parent.shared : new SharedState();
        this.enclosingCallStackDepth = this.shared.enclosingCallStack.size();
        boolean bl = this.isStaticScope = (isStatic || parent != null && parent.isStaticScope) && this.getEnclosingClosureScope() == null;
        if (enclosingNode instanceof ClassNode || enclosingNode instanceof FieldNode) {
            this.shared.isRunMethod = false;
        } else if (enclosingNode instanceof MethodNode) {
            this.shared.isRunMethod = ((MethodNode)enclosingNode).isScriptBody();
        }
        if (enclosingNode instanceof ClassNode) {
            ClassNode type = (ClassNode)enclosingNode;
            this.addVariable("this", VariableScope.newClassClassNode(type), type);
        } else if (!isStatic && parent != null && parent.scopeNode instanceof ClassNode) {
            ClassNode type = (ClassNode)parent.scopeNode;
            this.addVariable("this", type, type);
        }
    }

    public Map<String, Object> getWormhole() {
        return this.shared.wormhole;
    }

    public ASTNode getEnclosingNode() {
        int n = this.shared.nodeStack.size();
        if (n > 1) {
            return this.shared.nodeStack.get(n - 2);
        }
        return null;
    }

    public void setCurrentNode(ASTNode currentNode) {
        this.shared.nodeStack.add(currentNode);
    }

    public void forgetCurrentNode() {
        if (!this.shared.nodeStack.isEmpty()) {
            this.shared.nodeStack.removeLast();
        }
    }

    public ASTNode getCurrentNode() {
        if (!this.shared.nodeStack.isEmpty()) {
            return this.shared.nodeStack.getLast();
        }
        return null;
    }

    public void setPrimaryNode(boolean isPrimaryNode) {
        this.isPrimaryNode = isPrimaryNode;
    }

    public boolean isPrimaryNode() {
        return this.isPrimaryNode;
    }

    public Set<ClassNode> getCategoryNames() {
        if (this.parent != null) {
            Set<ClassNode> categories = this.parent.getCategoryNames();
            if (this.parent.isCategoryBeingDeclared()) {
                categories.add(this.parent.categoryBeingDeclared);
            }
            return categories;
        }
        return new LinkedHashSet<ClassNode>(ALL_DEFAULT_CATEGORIES);
    }

    private boolean isCategoryBeingDeclared() {
        return this.categoryBeingDeclared != null;
    }

    public void setCategoryBeingDeclared(ClassNode categoryBeingDeclared) {
        this.categoryBeingDeclared = categoryBeingDeclared;
    }

    public VariableInfo lookupName(String name) {
        ClassNode type;
        if ("super".equals(name) && (type = this.getThis()) != null) {
            ClassNode superType = type;
            VariableScope scope = this.getEnclosingClosureScope();
            if (scope == null || !scope.isOwnerStatic()) {
                if (!this.isStatic()) {
                    superType = type.getSuperClass();
                } else {
                    assert (type.equals(CLASS_CLASS_NODE) && type.isUsingGenerics());
                    superType = type.getGenericsTypes()[0].getType().getSuperClass();
                    if (superType != null && !superType.equals(OBJECT_CLASS_NODE)) {
                        superType = VariableScope.newClassClassNode(superType);
                    }
                }
            }
            return new VariableInfo(name, superType, superType);
        }
        VariableInfo var = this.lookupNameInCurrentScope(name);
        if (var == null && this.parent != null) {
            var = this.parent.lookupName(name);
        }
        return var;
    }

    public VariableInfo lookupNameInCurrentScope(String name) {
        VariableInfo info = this.nameVariableMap.get(name);
        if (info != null) {
            info = new VariableInfo(info, this.scopeNode);
        }
        return info;
    }

    public ClassNode getThis() {
        VariableInfo info = this.lookupName("this");
        return info != null ? info.type : null;
    }

    public ClassNode getOwner() {
        VariableInfo info = this.lookupName("getOwner");
        return info != null ? info.type : null;
    }

    public ClassNode getDelegate() {
        VariableInfo info = this.lookupName("getDelegate");
        return info != null ? info.type : null;
    }

    public ClassNode getDelegateOrThis() {
        ClassNode type = this.getDelegate();
        if (type == null) {
            type = this.getThis();
        }
        return type;
    }

    public boolean isStatic() {
        return this.isStaticScope;
    }

    public boolean isOwnerStatic() {
        MethodNode method;
        FieldNode field;
        return this.isStatic() || (field = this.getEnclosingFieldDeclaration()) != null && field.isStatic() || (method = this.getEnclosingMethodDeclaration()) != null && method.isStatic();
    }

    public boolean isFieldAccessDirect() {
        return !this.isOwnerStatic() && this.getEnclosingClosureScope() == null;
    }

    public void addVariable(String name, ClassNode type, ClassNode declaringType) {
        this.nameVariableMap.put(name, new VariableInfo(name, type, declaringType != null ? declaringType : OBJECT_CLASS_NODE));
    }

    public void addVariable(Variable var) {
        this.addVariable(var.getName(), var.getType(), var.getOriginType());
    }

    public ModuleNode getEnclosingModuleNode() {
        if (this.scopeNode instanceof ModuleNode) {
            return (ModuleNode)this.scopeNode;
        }
        if (this.parent != null) {
            return this.parent.getEnclosingModuleNode();
        }
        return null;
    }

    public ClassNode getEnclosingTypeDeclaration() {
        if (this.scopeNode instanceof ClassNode) {
            return (ClassNode)this.scopeNode;
        }
        if (this.parent != null) {
            return this.parent.getEnclosingTypeDeclaration();
        }
        return null;
    }

    public FieldNode getEnclosingFieldDeclaration() {
        if (this.scopeNode instanceof FieldNode) {
            return (FieldNode)this.scopeNode;
        }
        if (this.parent != null) {
            return this.parent.getEnclosingFieldDeclaration();
        }
        return null;
    }

    public MethodNode getEnclosingMethodDeclaration() {
        if (this.scopeNode instanceof MethodNode) {
            return (MethodNode)this.scopeNode;
        }
        if (this.parent != null) {
            return this.parent.getEnclosingMethodDeclaration();
        }
        return null;
    }

    public ClosureExpression getEnclosingClosure() {
        VariableScope scope = this.getEnclosingClosureScope();
        return scope != null ? (ClosureExpression)scope.scopeNode : null;
    }

    public int getEnclosingClosureResolveStrategy() {
        CallAndType cat;
        VariableScope scope = this.getEnclosingClosureScope();
        int resolveStrategy = 0;
        if (scope != null && (cat = scope.getEnclosingMethodCallExpression()) != null) {
            resolveStrategy = cat.getResolveStrategy((ClosureExpression)scope.scopeNode);
        }
        return resolveStrategy;
    }

    VariableScope getEnclosingClosureScope() {
        VariableScope scope = this;
        do {
            if (!(scope.scopeNode instanceof ClosureExpression)) continue;
            return scope;
        } while ((scope = scope.parent) != null);
        return null;
    }

    private static PropertyNode createPropertyNodeForMethodNode(MethodNode methodNode) {
        ClassNode propertyType = methodNode.getReturnType();
        String methodName = methodNode.getName();
        StringBuffer propertyName = new StringBuffer();
        propertyName.append(Character.toLowerCase(methodName.charAt(3)));
        if (methodName.length() > 4) {
            propertyName.append(methodName.substring(4));
        }
        int mods = methodNode.getModifiers();
        ClassNode declaringClass = methodNode.getDeclaringClass();
        PropertyNode property = new PropertyNode(propertyName.toString(), mods, propertyType, declaringClass, null, null, null);
        property.setDeclaringClass(declaringClass);
        property.getField().setDeclaringClass(declaringClass);
        return property;
    }

    private static void initializeProperties(ClassNode node) {
        for (MethodNode methodNode : node.getMethods()) {
            if (!AccessorSupport.isGetter(methodNode)) continue;
            node.addProperty(VariableScope.createPropertyNodeForMethodNode(methodNode));
        }
    }

    public void updateOrAddVariable(String name, ClassNode type, ClassNode declaringType) {
        if (!this.internalUpdateVariable(name, type, declaringType)) {
            this.addVariable(name, type, declaringType);
        }
    }

    public boolean updateVariable(String name, ClassNode type, ClassNode declaringType) {
        return this.internalUpdateVariable(name, type, declaringType);
    }

    private boolean internalUpdateVariable(String name, ClassNode type, ClassNode declaringType) {
        VariableInfo info = this.lookupNameInCurrentScope(name);
        if (info != null) {
            this.nameVariableMap.put(name, new VariableInfo(name, type, declaringType == null ? info.declaringType : declaringType));
            return true;
        }
        if (this.parent != null) {
            return this.parent.internalUpdateVariable(name, type, declaringType);
        }
        return false;
    }

    public static ClassNode resolveTypeParameterization(GenericsMapper mapper, ClassNode type) {
        GenericsType[] parameterizedTypes;
        if (mapper.hasGenerics() && (parameterizedTypes = GroovyUtils.getGenericsTypes(type)).length > 0) {
            int i = 0;
            int n = parameterizedTypes.length;
            while (i < n) {
                GenericsType parameterizedType = parameterizedTypes[i];
                ClassNode maybe = VariableScope.resolveTypeParameterization(mapper, parameterizedType, type);
                if (maybe != type) {
                    assert (n == 1);
                    type = maybe;
                    break;
                }
                ++i;
            }
        }
        return type;
    }

    /*
     * Unable to fully structure code
     */
    public static ClassNode resolveTypeParameterization(GenericsMapper mapper, GenericsType generic, ClassNode unresolved) {
        block6: {
            block5: {
                if (generic.isWildcard()) break block5;
                VariableScope.resolveTypeParameterization(mapper, generic.getType());
                toParameterizeName = generic.getName();
                resolved = mapper.findParameter(toParameterizeName, generic.getType());
                if (!VariableScope.typeParameterExistsInRedirected(unresolved, toParameterizeName)) ** GOTO lbl19
                Assert.isLegal(unresolved.redirect() != unresolved, "Error: trying to resolve type parameters of a type declaration: " + unresolved);
                generic.setLowerBound(null);
                generic.setUpperBounds(null);
                generic.setPlaceholder(false);
                generic.setWildcard(false);
                generic.setResolved(true);
                generic.setType(resolved);
                generic.setName(generic.getType().getName());
                break block6;
lbl-1000:
                // 1 sources

                {
                    unresolved = unresolved.getComponentType();
                    resolved = resolved.makeArray();
lbl19:
                    // 2 sources

                    ** while (unresolved.isArray())
                }
lbl20:
                // 1 sources

                return resolved;
            }
            if (generic.getLowerBound() != null) {
                resolved = VariableScope.resolveTypeParameterization(mapper, generic.getLowerBound());
                generic.setLowerBound(resolved);
                generic.setResolved(true);
            } else if (generic.getUpperBounds() != null) {
                parameterizedTypeUpperBounds = generic.getUpperBounds();
                j = 0;
                k = parameterizedTypeUpperBounds.length;
                while (j < k) {
                    parameterizedTypeUpperBounds[j] = resolved = VariableScope.resolveTypeParameterization(mapper, parameterizedTypeUpperBounds[j]);
                    ++j;
                }
                generic.setResolved(true);
            }
        }
        return unresolved;
    }

    public static MethodNode resolveTypeParameterization(GenericsMapper mapper, MethodNode method) {
        if (mapper.hasGenerics() && (GroovyUtils.getGenericsTypes(method).length > 0 || GroovyUtils.getGenericsTypes(method.getDeclaringClass()).length > 0)) {
            MethodNode resolved;
            ClassNode returnType = VariableScope.resolveTypeParameterization(mapper, VariableScope.clone(method.getReturnType()));
            Parameter[] parameters = method.getParameters();
            if (parameters != null && parameters.length > 0) {
                int n = parameters.length;
                parameters = new Parameter[n];
                int i = 0;
                while (i < n) {
                    Parameter original = method.getParameters()[i];
                    ClassNode parameterType = VariableScope.resolveTypeParameterization(mapper, VariableScope.clone(original.getType()));
                    parameters[i] = new Parameter(parameterType, original.getName(), original.getInitialExpression());
                    parameters[i].addAnnotations(original.getAnnotations());
                    parameters[i].setClosureSharedVariable(original.isClosureSharedVariable());
                    parameters[i].setDeclaringClass(original.getDeclaringClass());
                    parameters[i].setHasNoRealSourcePosition(original.hasNoRealSourcePosition());
                    parameters[i].setInStaticContext(original.isInStaticContext());
                    parameters[i].setModifiers(original.getModifiers());
                    parameters[i].copyNodeMetaData(original);
                    parameters[i].setOriginType(original.getOriginType());
                    parameters[i].setSourcePosition(original);
                    parameters[i].setSynthetic(original.isSynthetic());
                    ++i;
                }
            }
            if (method instanceof JDTMethodNode) {
                resolved = new JDTMethodNode(((JDTMethodNode)method).getMethodBinding(), ((JDTMethodNode)method).getResolver(), method.getName(), method.getModifiers(), returnType, parameters, method.getExceptions(), method.getCode());
            } else {
                resolved = new MethodNode(method.getName(), method.getModifiers(), returnType, parameters, method.getExceptions(), method.getCode());
                resolved.addAnnotations(method.getAnnotations());
            }
            resolved.setAnnotationDefault(method.hasAnnotationDefault());
            resolved.setDeclaringClass(VariableScope.resolveTypeParameterization(mapper, VariableScope.clone(method.getDeclaringClass())));
            resolved.setGenericsTypes(method.getGenericsTypes());
            resolved.setHasNoRealSourcePosition(method.hasNoRealSourcePosition());
            resolved.copyNodeMetaData(method);
            resolved.setOriginal(method.getOriginal());
            resolved.setSourcePosition(method);
            resolved.setSynthetic(method.isSynthetic());
            resolved.setSyntheticPublic(method.isSyntheticPublic());
            resolved.setVariableScope(method.getVariableScope());
            method = resolved;
        }
        return method;
    }

    private static boolean typeParameterExistsInRedirected(ClassNode type, String toParameterizeName) {
        ClassNode redirect = type.redirect();
        GenericsType[] genericsTypes = redirect.getGenericsTypes();
        return genericsTypes != null;
    }

    public static ClassNode clone(ClassNode type) {
        return VariableScope.cloneInternal(type, 0);
    }

    public static ClassNode clonedMap() {
        ClassNode clone = VariableScope.clone(MAP_CLASS_NODE);
        VariableScope.cleanGenerics(clone.getGenericsTypes()[0]);
        VariableScope.cleanGenerics(clone.getGenericsTypes()[1]);
        return clone;
    }

    public static ClassNode clonedList() {
        ClassNode clone = VariableScope.clone(LIST_CLASS_NODE);
        VariableScope.cleanGenerics(clone.getGenericsTypes()[0]);
        return clone;
    }

    public static ClassNode clonedRange() {
        ClassNode clone = VariableScope.clone(RANGE_CLASS_NODE);
        VariableScope.cleanGenerics(clone.getGenericsTypes()[0]);
        return clone;
    }

    private static void cleanGenerics(GenericsType gt) {
        gt.getType().setGenericsTypes(null);
        gt.setName("java.lang.Object");
        gt.setPlaceholder(false);
        gt.setWildcard(false);
        gt.setResolved(true);
        gt.setUpperBounds(null);
        gt.setLowerBound(null);
    }

    private static ClassNode cloneInternal(ClassNode type, int depth) {
        GenericsType[] generics;
        if (type == null || type.isPrimitive()) {
            return type;
        }
        ClassNode newType = type.getPlainNodeReference();
        newType.setSourcePosition(type);
        newType.setGenericsPlaceHolder(type.isGenericsPlaceHolder());
        ReflectionUtils.setPrivateField(ClassNode.class, "componentType", newType, VariableScope.cloneInternal(type.getComponentType(), depth + 1));
        if (depth < 11 && (generics = type.getGenericsTypes()) != null) {
            int n = generics.length;
            GenericsType[] clones = new GenericsType[n];
            int i = 0;
            while (i < n) {
                clones[i] = VariableScope.clone(generics[i], depth);
                ++i;
            }
            newType.setGenericsTypes(clones);
        }
        return newType;
    }

    public static GenericsType clone(GenericsType origgt, int depth) {
        GenericsType newgt = new GenericsType();
        newgt.setType(VariableScope.cloneInternal(origgt.getType(), depth + 1));
        newgt.setLowerBound(VariableScope.cloneInternal(origgt.getLowerBound(), depth + 1));
        ClassNode[] oldUpperBounds = origgt.getUpperBounds();
        if (oldUpperBounds != null) {
            int n = oldUpperBounds.length;
            ClassNode[] newUpperBounds = new ClassNode[n];
            int i = 0;
            while (i < n) {
                newUpperBounds[i] = VariableScope.cloneInternal(oldUpperBounds[i], depth + 1);
                ++i;
            }
            newgt.setUpperBounds(newUpperBounds);
        }
        newgt.setName(origgt.getName());
        newgt.setPlaceholder(origgt.isPlaceholder());
        newgt.setWildcard(origgt.isWildcard());
        newgt.setResolved(origgt.isResolved());
        newgt.setSourcePosition(origgt);
        return newgt;
    }

    public static ClassNode newClassClassNode(ClassNode type) {
        ClassNode classType = ClassHelper.makeWithoutCaching("java.lang.Class");
        classType.setGenericsTypes(new GenericsType[]{new GenericsType(type)});
        classType.setRedirect(CLASS_CLASS_NODE);
        return classType;
    }

    public List<CallAndType> getAllEnclosingMethodCallExpressions() {
        return this.shared.enclosingCallStack.subList(0, this.enclosingCallStackDepth);
    }

    public CallAndType getEnclosingMethodCallExpression() {
        List<CallAndType> enclosingCalls = this.getAllEnclosingMethodCallExpressions();
        return !enclosingCalls.isEmpty() ? enclosingCalls.get(enclosingCalls.size() - 1) : null;
    }

    public void addEnclosingMethodCall(CallAndType enclosingMethodCall) {
        assert (this.enclosingCallStackDepth == this.shared.enclosingCallStack.size());
        this.shared.enclosingCallStack.add(enclosingMethodCall);
        ++this.enclosingCallStackDepth;
    }

    public void forgetEnclosingMethodCall() {
        assert (this.enclosingCallStackDepth == this.shared.enclosingCallStack.size());
        this.shared.enclosingCallStack.remove(this.enclosingCallStackDepth - 1);
        --this.enclosingCallStackDepth;
    }

    public boolean isTopLevel() {
        return this.parent == null;
    }

    public boolean containsInThisScope(String name) {
        return this.nameVariableMap.containsKey(name);
    }

    void setMethodCallArgumentTypes(List<ClassNode> methodCallArgumentTypes) {
        this.methodCallArgumentTypes = methodCallArgumentTypes;
    }

    public List<ClassNode> getMethodCallArgumentTypes() {
        return this.methodCallArgumentTypes;
    }

    void setMethodCallGenericsTypes(GenericsType[] methodCallGenericsTypes) {
        this.methodCallGenericsTypes = methodCallGenericsTypes;
    }

    public GenericsType[] getMethodCallGenericsTypes() {
        return this.methodCallGenericsTypes;
    }

    int getMethodCallNumberOfArguments() {
        return this.isMethodCall() ? this.methodCallArgumentTypes.size() : 0;
    }

    public boolean isMethodCall() {
        return this.methodCallArgumentTypes != null;
    }

    @Override
    public Iterator<VariableInfo> iterator() {
        return new Iterator<VariableInfo>(){
            VariableScope currentScope;
            Iterator<VariableInfo> currentIter;
            {
                this.currentScope = VariableScope.this;
                this.currentIter = this.currentScope.nameVariableMap.values().iterator();
            }

            @Override
            public boolean hasNext() {
                if (this.currentIter == null) {
                    return false;
                }
                if (!this.currentIter.hasNext()) {
                    this.currentScope = this.currentScope.parent;
                    Iterator<Object> iterator = this.currentIter = this.currentScope == null ? null : this.currentScope.nameVariableMap.values().iterator();
                }
                return this.currentIter != null && this.currentIter.hasNext();
            }

            @Override
            public VariableInfo next() {
                return new VariableInfo(this.currentIter.next(), this.currentScope.scopeNode);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static void findAllInterfaces(ClassNode type, LinkedHashSet<ClassNode> allInterfaces, boolean useResolved) {
        boolean isInterface;
        if (!useResolved) {
            type = type.redirect();
        }
        if (!(isInterface = type.isInterface()) || !allInterfaces.contains(type)) {
            ClassNode superType;
            ClassNode[] faces;
            if (isInterface) {
                allInterfaces.add(type);
            }
            ClassNode[] classNodeArray = faces = !useResolved ? type.getInterfaces() : type.getUnresolvedInterfaces();
            if (faces != null) {
                ClassNode[] classNodeArray2 = faces;
                int n = faces.length;
                int n2 = 0;
                while (n2 < n) {
                    ClassNode face = classNodeArray2[n2];
                    VariableScope.findAllInterfaces(face, allInterfaces, useResolved);
                    ++n2;
                }
            }
            if (!isInterface && (superType = type.getSuperClass()) != null && !OBJECT_CLASS_NODE.equals(superType)) {
                VariableScope.findAllInterfaces(superType, allInterfaces, useResolved);
            }
        }
    }

    public static void createTypeHierarchy(ClassNode type, LinkedHashSet<ClassNode> allClasses, boolean useResolved) {
        if (!useResolved) {
            type = type.redirect();
        }
        if (!allClasses.contains(type)) {
            if (!type.isInterface()) {
                allClasses.add(type);
                ClassNode superClass = useResolved ? type.getUnresolvedSuperClass() : type.getSuperClass();
                if (superClass != null) {
                    VariableScope.createTypeHierarchy(superClass, allClasses, useResolved);
                }
            }
            VariableScope.findAllInterfaces(type, allClasses, useResolved);
        }
    }

    public static ClassNode extractElementType(ClassNode collectionType) {
        if (collectionType.isArray()) {
            return collectionType.getComponentType();
        }
        MethodNode iterator = collectionType.getMethod("iterator", Parameter.EMPTY_ARRAY);
        ClassNode typeToResolve = null;
        if (iterator == null && collectionType.isInterface()) {
            MethodNode entrySetMethod;
            if (collectionType.implementsInterface(LIST_CLASS_NODE) && collectionType.getGenericsTypes() != null && collectionType.getGenericsTypes().length == 1) {
                typeToResolve = collectionType;
            } else if (collectionType.declaresInterface(ITERATOR_CLASS) || collectionType.equals(ITERATOR_CLASS) || collectionType.declaresInterface(ENUMERATION_CLASS) || collectionType.equals(ENUMERATION_CLASS)) {
                typeToResolve = collectionType;
            } else if ((collectionType.declaresInterface(MAP_CLASS_NODE) || collectionType.equals(MAP_CLASS_NODE)) && (entrySetMethod = collectionType.getMethod("entrySet", Parameter.EMPTY_ARRAY)) != null) {
                typeToResolve = entrySetMethod.getReturnType();
            }
        } else if (iterator != null) {
            typeToResolve = iterator.getReturnType();
        }
        if (typeToResolve != null) {
            typeToResolve = VariableScope.clone(typeToResolve);
            ClassNode unresolvedCollectionType = collectionType.redirect();
            GenericsMapper mapper = GenericsMapper.gatherGenerics(collectionType, unresolvedCollectionType);
            ClassNode resolved = VariableScope.resolveTypeParameterization(mapper, typeToResolve);
            GenericsType[] resolvedReturnGenerics = resolved.getGenericsTypes();
            if (resolvedReturnGenerics != null && resolvedReturnGenerics.length > 0) {
                return resolvedReturnGenerics[0].getType();
            }
        }
        if (collectionType.declaresInterface(INPUT_STREAM_CLASS) || collectionType.declaresInterface(DATA_INPUT_STREAM_CLASS) || collectionType.equals(INPUT_STREAM_CLASS) || collectionType.equals(DATA_INPUT_STREAM_CLASS)) {
            return BYTE_CLASS_NODE;
        }
        return collectionType;
    }

    public boolean inScriptRunMethod() {
        return this.shared.isRunMethod;
    }

    public static boolean isPlainClosure(ClassNode type) {
        return CLOSURE_CLASS_NODE.equals(type) && !type.isUsingGenerics();
    }

    public static boolean isParameterizedClosure(ClassNode type) {
        return CLOSURE_CLASS_NODE.equals(type) && type.isUsingGenerics();
    }

    public static boolean isThisOrSuper(Variable var) {
        return var.getName().equals("this") || var.getName().equals("super");
    }

    public static boolean isVoidOrObject(ClassNode type) {
        return type != null && (type.getName().equals(VOID_CLASS_NODE.getName()) || type.getName().equals(VOID_WRAPPER_CLASS_NODE.getName()) || type.getName().equals(OBJECT_CLASS_NODE.getName()));
    }

    public static class CallAndType {
        public final ASTNode declaration;
        public final ClassNode declaringType;
        public final MethodCallExpression call;
        private Map<ClosureExpression, Object[]> delegatesTo;

        public CallAndType(MethodCallExpression call, ASTNode declaration, ClassNode declaringType, ModuleNode enclosingModule) {
            MethodNode methodNode;
            Parameter[] parameters;
            this.call = call;
            this.declaration = declaration;
            this.declaringType = declaringType;
            if (DELEGATES_TO != null && declaration instanceof MethodNode && (parameters = (methodNode = (MethodNode)declaration).getParameters()) != null && parameters.length > 0) {
                List<Expression> arguments = null;
                if (call.getArguments() instanceof TupleExpression) {
                    arguments = ((TupleExpression)call.getArguments()).getExpressions();
                }
                if (arguments != null && !arguments.isEmpty()) {
                    if (!methodNode.getDeclaringClass().equals(this.getPerceivedDeclaringType())) {
                        ArrayList<Expression> categoryMethodArguments = new ArrayList<Expression>(arguments.size() + 1);
                        categoryMethodArguments.add(new ClassExpression(declaringType));
                        categoryMethodArguments.addAll(arguments);
                        arguments = categoryMethodArguments;
                    }
                    int i = 0;
                    int n = parameters.length;
                    while (i < n) {
                        List<AnnotationNode> annotations = parameters[i].getAnnotations();
                        if (annotations != null && !annotations.isEmpty()) {
                            for (AnnotationNode annotation : annotations) {
                                int j;
                                if (!annotation.getClassNode().getName().equals(DELEGATES_TO.getName()) || i >= arguments.size() || !(arguments.get(i) instanceof ClosureExpression)) continue;
                                ClosureExpression closure = (ClosureExpression)arguments.get(i);
                                Expression delegatesToType = annotation.getMember("type");
                                Expression delegatesToValue = annotation.getMember("value");
                                Expression delegatesToTarget = annotation.getMember("target");
                                Expression delegatesToStrategy = annotation.getMember("strategy");
                                Expression delegatesToGenericTypeIndex = annotation.getMember("genericTypeIndex");
                                Integer strategy = null;
                                Integer generics = null;
                                if (delegatesToStrategy instanceof ConstantExpression) {
                                    strategy = Integer.valueOf(delegatesToStrategy.getText());
                                }
                                if (delegatesToGenericTypeIndex instanceof ConstantExpression) {
                                    generics = Integer.valueOf(delegatesToGenericTypeIndex.getText());
                                }
                                if (delegatesToValue instanceof ClassExpression && !delegatesToValue.getType().getName().equals("groovy.lang.DelegatesTo$Target")) {
                                    this.addDelegatesToClosure(closure, delegatesToValue.getType(), strategy);
                                    continue;
                                }
                                if (delegatesToType instanceof ConstantExpression && !"".equals(delegatesToType.getText()) || delegatesToValue != null && (!(delegatesToValue instanceof ClassExpression) || !delegatesToValue.getType().getName().equals("groovy.lang.DelegatesTo$Target")) || (j = this.indexOfDelegatesToTarget(parameters, delegatesToTarget.getText())) < 0 || j >= arguments.size()) continue;
                                Expression target = arguments.get(j);
                                ClassNode targetType = target.getType();
                                if (generics != null && generics >= 0 && targetType.isUsingGenerics()) {
                                    targetType.getGenericsTypes()[generics].getType();
                                }
                                this.addDelegatesToClosure(closure, targetType, strategy);
                            }
                        }
                        ++i;
                    }
                    if (this.delegatesTo == null) {
                        if (arguments.get(0) instanceof ClosureExpression && methodNode.getName().matches("build|do(Later|Outside)|edt(Builder)?") && methodNode.getDeclaringClass().getName().equals("groovy.swing.SwingBuilder")) {
                            this.addDelegatesToClosure((ClosureExpression)arguments.get(0), methodNode.getDeclaringClass(), 0);
                        } else if (arguments.size() > 1 && arguments.get(1) instanceof ClosureExpression && methodNode.getName().matches("identity|with") && DGM_CLASS_NODE.equals(methodNode.getDeclaringClass())) {
                            this.addDelegatesToClosure((ClosureExpression)arguments.get(1), declaringType, 1);
                        }
                    }
                }
            }
            if (this.delegatesTo == null) {
                this.delegatesTo = Collections.emptyMap();
            }
        }

        public ClassNode getPerceivedDeclaringType() {
            if (this.declaringType.equals(CLASS_CLASS_NODE)) {
                if (this.declaringType.isUsingGenerics()) {
                    GenericsType genericsType = this.declaringType.getGenericsTypes()[0];
                    return genericsType.getType();
                }
                return OBJECT_CLASS_NODE;
            }
            return this.declaringType;
        }

        public ClassNode getDelegateType(ClosureExpression closure) {
            Object[] tuple = this.delegatesTo.get(closure);
            return tuple != null ? (ClassNode)tuple[0] : null;
        }

        public int getResolveStrategy(ClosureExpression closure) {
            Object[] tuple = this.delegatesTo.get(closure);
            return tuple != null && tuple[1] != null ? (Integer)tuple[1] : 0;
        }

        private void addDelegatesToClosure(ClosureExpression closure, ClassNode delegateType, Integer resolveStrategy) {
            if (this.delegatesTo == null) {
                this.delegatesTo = new HashMap<ClosureExpression, Object[]>();
            }
            this.delegatesTo.put(closure, new Object[]{delegateType, resolveStrategy});
        }

        private int indexOfDelegatesToTarget(Parameter[] parameters, String target) {
            int i = 0;
            int n = parameters.length;
            while (i < n) {
                List<AnnotationNode> annotations = parameters[i].getAnnotations();
                if (annotations != null && !annotations.isEmpty()) {
                    for (AnnotationNode annotation : annotations) {
                        String value;
                        if (!annotation.getClassNode().getName().equals("groovy.lang.DelegatesTo$Target") || !(annotation.getMember("value") instanceof ConstantExpression) || !(value = annotation.getMember("value").getText()).equals(target)) continue;
                        return i;
                    }
                }
                ++i;
            }
            return -1;
        }
    }

    private static class SharedState {
        final Map<String, Object> wormhole = new HashMap<String, Object>();
        final List<CallAndType> enclosingCallStack = new ArrayList<CallAndType>();
        final LinkedList<ASTNode> nodeStack = new LinkedList();
        boolean isRunMethod;

        private SharedState() {
        }
    }

    public static class VariableInfo {
        public ASTNode scopeNode;
        public final String name;
        public final ClassNode type;
        public final ClassNode declaringType;

        public VariableInfo(String name, ClassNode type, ClassNode declaringType) {
            this.name = name;
            this.type = type;
            this.declaringType = declaringType;
        }

        private VariableInfo(VariableInfo info, ASTNode node) {
            this(info.name, info.type, info.declaringType);
            this.scopeNode = node;
        }

        public String getTypeSignature() {
            return GroovyUtils.getTypeSignature(this.type, true, false);
        }
    }
}

