/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.groovy.search;

import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ImportNode;
import org.codehaus.groovy.ast.PackageNode;
import org.codehaus.jdt.groovy.model.GroovyClassFileWorkingCopy;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.search.PackageReferenceMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.groovy.core.util.ReflectionUtils;
import org.eclipse.jdt.groovy.search.ITypeRequestor;
import org.eclipse.jdt.groovy.search.TypeLookupResult;
import org.eclipse.jdt.internal.core.search.matching.PackageReferencePattern;
import org.eclipse.jdt.internal.core.util.Util;

public class PackageReferenceSearchRequestor
implements ITypeRequestor {
    private final String packageName;
    private final SearchRequestor requestor;
    private final SearchParticipant participant;

    public PackageReferenceSearchRequestor(PackageReferencePattern pattern, SearchRequestor requestor, SearchParticipant participant) {
        this.requestor = requestor;
        this.participant = participant;
        this.packageName = String.valueOf(String.valueOf((char[])ReflectionUtils.getPrivateField(PackageReferencePattern.class, "pkgName", pattern))) + '.';
    }

    public ITypeRequestor.VisitStatus acceptASTNode(ASTNode node, TypeLookupResult result, IJavaElement enclosingElement) {
        try {
            String name;
            if (node instanceof PackageNode) {
                String name2 = ((PackageNode)node).getName();
                if (name2.startsWith(this.packageName)) {
                    this.notifyRequestor(enclosingElement, node.getStart());
                }
            } else if (node instanceof ImportNode) {
                ImportNode i = (ImportNode)node;
                String name3 = i.getClassName();
                if (i.isStar() && !i.isStatic()) {
                    name3 = i.getPackageName();
                }
                if (name3.startsWith(this.packageName)) {
                    this.notifyRequestor(enclosingElement, i.getType().getStart());
                }
            } else if (node instanceof ClassNode && enclosingElement.getElementType() != 13 && (name = ((ClassNode)node).getName()).startsWith(this.packageName) && name.length() <= node.getLength() && enclosingElement instanceof ISourceReference) {
                ISourceRange range = ((ISourceReference)((Object)enclosingElement)).getSourceRange();
                if (node.getStart() >= range.getOffset() && node.getLength() < range.getLength()) {
                    this.notifyRequestor(enclosingElement, node.getStart());
                }
            }
        }
        catch (CoreException e) {
            Util.log(e, "Error accepting " + node.getClass().getSimpleName() + " for " + enclosingElement);
        }
        return ITypeRequestor.VisitStatus.CONTINUE;
    }

    protected void notifyRequestor(IJavaElement element, int offset) throws CoreException {
        if (element.getOpenable() instanceof GroovyClassFileWorkingCopy) {
            element = ((GroovyClassFileWorkingCopy)element.getOpenable()).convertToBinary(element);
        }
        PackageReferenceMatch match = new PackageReferenceMatch(element, 0, offset, this.packageName.length() - 1, false, this.participant, element.getResource());
        this.requestor.acceptSearchMatch(match);
    }
}

