/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.groovy.search;

import java.util.ArrayList;
import java.util.List;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.ImportNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.AttributeExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.reflection.ParameterTypes;
import org.codehaus.groovy.runtime.MetaClassHelper;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.eclipse.jdt.groovy.core.util.GroovyUtils;
import org.eclipse.jdt.groovy.search.AccessorSupport;
import org.eclipse.jdt.groovy.search.ITypeLookup;
import org.eclipse.jdt.groovy.search.SimpleTypeLookup;
import org.eclipse.jdt.groovy.search.TypeLookupResult;
import org.eclipse.jdt.groovy.search.VariableScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CategoryTypeLookup
implements ITypeLookup {
    @Override
    public TypeLookupResult lookupType(Expression node, VariableScope scope, ClassNode objectExpressionType) {
        if (node instanceof VariableExpression || CategoryTypeLookup.isCompatibleConstantExpression(node, scope)) {
            String simpleName = node.getText();
            ClassNode expectedType = objectExpressionType;
            if (expectedType == null) {
                expectedType = scope.getDelegateOrThis();
            }
            ClassNode normalizedType = GroovyUtils.getWrapperTypeIfPrimitive(expectedType);
            ArrayList<MethodNode> candidates = new ArrayList<MethodNode>();
            for (ClassNode category : scope.getCategoryNames()) {
                String setterName;
                for (MethodNode method : category.getMethods(simpleName)) {
                    if (!CategoryTypeLookup.isCompatibleCategoryMethod(method, normalizedType)) continue;
                    candidates.add(method);
                }
                String getterName = AccessorSupport.GETTER.createAccessorName(simpleName);
                if (getterName != null) {
                    for (MethodNode method : category.getMethods(getterName)) {
                        if (AccessorSupport.findAccessorKind(method, true) != AccessorSupport.GETTER || !CategoryTypeLookup.isCompatibleCategoryMethod(method, normalizedType)) continue;
                        candidates.add(method);
                    }
                }
                if ((setterName = AccessorSupport.SETTER.createAccessorName(simpleName)) == null) continue;
                for (MethodNode method : category.getMethods(setterName)) {
                    if (AccessorSupport.findAccessorKind(method, true) != AccessorSupport.SETTER || !CategoryTypeLookup.isCompatibleCategoryMethod(method, normalizedType)) continue;
                    candidates.add(method);
                }
            }
            if (!candidates.isEmpty()) {
                MethodNode method;
                int args = 1 + scope.getMethodCallNumberOfArguments();
                ArrayList<ClassNode> argumentTypes = new ArrayList<ClassNode>(args);
                argumentTypes.add(normalizedType);
                if (args > 1) {
                    argumentTypes.addAll(scope.getMethodCallArgumentTypes());
                }
                method = CategoryTypeLookup.selectBestMatch(candidates, argumentTypes);
                TypeLookupResult result = new TypeLookupResult(method.getReturnType(), method.getDeclaringClass(), method, CategoryTypeLookup.isDefaultGroovyMethod(method) ? TypeLookupResult.TypeConfidence.LOOSELY_INFERRED : TypeLookupResult.TypeConfidence.INFERRED, scope);
                result.isGroovy = true;
                return result;
            }
        }
        return null;
    }

    protected static boolean isCompatibleConstantExpression(Expression node, VariableScope scope) {
        if (node instanceof ConstantExpression && !(scope.getEnclosingNode() instanceof AttributeExpression)) {
            return VariableScope.STRING_CLASS_NODE.equals(node.getType()) && node.getLength() <= node.getText().length();
        }
        return false;
    }

    protected static boolean isCompatibleCategoryMethod(MethodNode method, ClassNode firstArgumentType) {
        Parameter[] paramters;
        if (method.isStatic() && (paramters = method.getParameters()) != null && paramters.length > 0) {
            ClassNode parameterType = paramters[0].getType();
            if (VariableScope.DGSM_CLASS_NODE.equals(method.getDeclaringClass())) {
                parameterType = VariableScope.newClassClassNode(parameterType);
            }
            if (CategoryTypeLookup.isTypeCompatible(firstArgumentType, parameterType)) {
                return !CategoryTypeLookup.isDefaultGroovyMethod(method) || !GroovyUtils.isDeprecated(method);
            }
        }
        return false;
    }

    protected static boolean isTypeCompatible(ClassNode source, ClassNode target) {
        if (SimpleTypeLookup.isTypeCompatible(source, target) != Boolean.FALSE) {
            if (!VariableScope.CLASS_CLASS_NODE.equals(source) || !source.isUsingGenerics() || VariableScope.OBJECT_CLASS_NODE.equals(target) || !target.isUsingGenerics()) {
                return true;
            }
            if (SimpleTypeLookup.isTypeCompatible(source = source.getGenericsTypes()[0].getType(), target = target.getGenericsTypes()[0].getType()) != Boolean.FALSE) {
                return true;
            }
        }
        return false;
    }

    protected static boolean isDefaultGroovyMethod(MethodNode method) {
        return VariableScope.ALL_DEFAULT_CATEGORIES.contains(method.getDeclaringClass());
    }

    protected static MethodNode selectBestMatch(List<MethodNode> candidates, List<ClassNode> argumentTypes) {
        MethodNode method = null;
        for (MethodNode candidate : candidates) {
            if (argumentTypes.size() != candidate.getParameters().length) continue;
            Boolean compatible = SimpleTypeLookup.isTypeCompatible(argumentTypes, candidate.getParameters());
            if (compatible == Boolean.TRUE) {
                method = candidate;
                break;
            }
            if (compatible != Boolean.FALSE) {
                long d2;
                long d1;
                if (method != null && (d1 = CategoryTypeLookup.calculateParameterDistance(argumentTypes, method.getParameters())) <= (d2 = CategoryTypeLookup.calculateParameterDistance(argumentTypes, candidate.getParameters()))) continue;
                method = candidate;
                continue;
            }
            if (method != null) continue;
            method = candidate;
        }
        return method != null ? method : candidates.get(0);
    }

    protected static long calculateParameterDistance(List<ClassNode> arguments, Parameter[] parameters) {
        try {
            int n = 1 + arguments.size();
            Class[] args = new Class[n];
            int i = 1;
            while (i < n) {
                args[i] = arguments.get(i - 1).getTypeClass();
                ++i;
            }
            args[0] = args[1];
            n = 1 + parameters.length;
            Class[] prms = new Class[n];
            int i2 = 1;
            while (i2 < n) {
                prms[i2] = parameters[i2 - 1].getType().getTypeClass();
                ++i2;
            }
            prms[0] = prms[1];
            return MetaClassHelper.calculateParameterDistance(args, new ParameterTypes(prms));
        }
        catch (Throwable t) {
            return Long.MAX_VALUE;
        }
    }

    @Override
    public TypeLookupResult lookupType(AnnotationNode node, VariableScope scope) {
        return null;
    }

    @Override
    public TypeLookupResult lookupType(ImportNode node, VariableScope scope) {
        return null;
    }

    @Override
    public TypeLookupResult lookupType(ClassNode node, VariableScope scope) {
        return null;
    }

    @Override
    public TypeLookupResult lookupType(FieldNode node, VariableScope scope) {
        return null;
    }

    @Override
    public TypeLookupResult lookupType(MethodNode node, VariableScope scope) {
        return null;
    }

    @Override
    public TypeLookupResult lookupType(Parameter node, VariableScope scope) {
        return null;
    }

    @Override
    public void initialize(GroovyCompilationUnit unit, VariableScope topLevelScope) {
    }
}

