/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.groovy.core.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GroovyClassVisitor;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.ImportNode;
import org.codehaus.groovy.ast.InnerClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.PackageNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ArrayExpression;
import org.codehaus.groovy.ast.expr.AttributeExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.BitwiseNegationExpression;
import org.codehaus.groovy.ast.expr.BooleanExpression;
import org.codehaus.groovy.ast.expr.CastExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ClosureListExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.ElvisOperatorExpression;
import org.codehaus.groovy.ast.expr.EmptyExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.FieldExpression;
import org.codehaus.groovy.ast.expr.GStringExpression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.MapEntryExpression;
import org.codehaus.groovy.ast.expr.MapExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.MethodPointerExpression;
import org.codehaus.groovy.ast.expr.NotExpression;
import org.codehaus.groovy.ast.expr.PostfixExpression;
import org.codehaus.groovy.ast.expr.PrefixExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.RangeExpression;
import org.codehaus.groovy.ast.expr.SpreadExpression;
import org.codehaus.groovy.ast.expr.SpreadMapExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.ast.expr.TernaryExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.expr.UnaryMinusExpression;
import org.codehaus.groovy.ast.expr.UnaryPlusExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.AssertStatement;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.BreakStatement;
import org.codehaus.groovy.ast.stmt.CaseStatement;
import org.codehaus.groovy.ast.stmt.CatchStatement;
import org.codehaus.groovy.ast.stmt.ContinueStatement;
import org.codehaus.groovy.ast.stmt.DoWhileStatement;
import org.codehaus.groovy.ast.stmt.EmptyStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.ForStatement;
import org.codehaus.groovy.ast.stmt.IfStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.ast.stmt.SwitchStatement;
import org.codehaus.groovy.ast.stmt.SynchronizedStatement;
import org.codehaus.groovy.ast.stmt.ThrowStatement;
import org.codehaus.groovy.ast.stmt.TryCatchStatement;
import org.codehaus.groovy.ast.stmt.WhileStatement;
import org.codehaus.groovy.classgen.BytecodeExpression;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.transform.FieldASTTransformation;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.groovy.core.util.GroovyUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DepthFirstVisitor
implements GroovyClassVisitor,
GroovyCodeVisitor {
    protected MethodNode runMethod;

    public void visitModule(ModuleNode node) {
        this.runMethod = null;
        if (node.getPackage() != null) {
            this.visitPackage(node.getPackage());
        }
        for (ImportNode importNode : GroovyUtils.getAllImportNodes(node)) {
            this.visitImport(importNode);
        }
        for (ClassNode classNode : node.getClasses()) {
            if (classNode.isScript()) {
                this.runMethod = classNode.getMethod("run", Parameter.EMPTY_ARRAY);
                Assert.isNotNull(this.runMethod);
            }
            this.visitClass(classNode);
        }
        if (this.runMethod != null) {
            MethodNode run = this.runMethod;
            this.runMethod = null;
            this.visitMethod(run);
        }
    }

    public void visitPackage(PackageNode node) {
        this.visitAnnotations(node.getAnnotations());
    }

    public void visitImport(ImportNode node) {
        this.visitAnnotations(node.getAnnotations());
        if (node.getType() != null) {
            this.visitIfPresent(node.getFieldNameExpr());
            this.visitIfPresent(node.getAliasExpr());
        }
    }

    @Override
    public void visitClass(ClassNode node) {
        List traitMethods;
        this.visitAnnotations(node.getAnnotations());
        MethodNode clinit = node.getMethod("<clinit>", Parameter.EMPTY_ARRAY);
        if (clinit != null && !node.isEnum()) {
            this.visitIfPresent(clinit.getCode());
        }
        for (Statement stmt : node.getObjectInitializerStatements()) {
            stmt.visit(this);
        }
        node.visitContents(this);
        List traitFields = (List)node.getNodeMetaData("trait.fields");
        if (traitFields != null) {
            for (FieldNode field : traitFields) {
                this.visitField(field);
            }
        }
        if ((traitMethods = (List)node.getNodeMetaData("trait.methods")) != null) {
            for (MethodNode method : traitMethods) {
                this.visitMethod(method);
            }
        }
        Iterator<InnerClassNode> it = node.getInnerClasses();
        while (it.hasNext()) {
            InnerClassNode inner = it.next();
            if (inner.isSynthetic() || inner instanceof GeneratedClosure || GroovyUtils.isAnonymous(inner)) continue;
            this.visitClass(inner);
        }
    }

    @Override
    public void visitProperty(PropertyNode node) {
        this.visitAnnotations(node.getAnnotations());
        this.visitIfPresent(node.getInitialExpression());
        this.visitIfPresent(node.getGetterBlock());
        this.visitIfPresent(node.getSetterBlock());
    }

    @Override
    public void visitField(FieldNode node) {
        this.visitAnnotations(node.getAnnotations());
        if (node.getEnd() > 0 && node.getDeclaringClass().isScript()) {
            for (ASTNode anno : GroovyUtils.getTransformNodes(node.getDeclaringClass(), FieldASTTransformation.class)) {
                if (anno.getStart() < node.getStart() || anno.getEnd() >= node.getEnd()) continue;
                this.visitAnnotation((AnnotationNode)anno);
            }
        }
        this.visitIfPresent(node.getInitialExpression());
        if (node.isEnum() && node.isStatic() && !node.getName().matches("(MAX|MIN)_VALUE|\\$VALUES")) {
            MethodNode clinit = node.getDeclaringClass().getMethod("<clinit>", Parameter.EMPTY_ARRAY);
            for (Statement stmt : ((BlockStatement)clinit.getCode()).getStatements()) {
                if (!(stmt instanceof ExpressionStatement) || !(((ExpressionStatement)stmt).getExpression() instanceof BinaryExpression)) continue;
                Expression lhs = ((BinaryExpression)((ExpressionStatement)stmt).getExpression()).getLeftExpression();
                Expression rhs = ((BinaryExpression)((ExpressionStatement)stmt).getExpression()).getRightExpression();
                if (!(lhs instanceof FieldExpression) || ((FieldExpression)lhs).getField() != node) continue;
                rhs.visit(this);
                break;
            }
        }
    }

    @Override
    public void visitConstructor(ConstructorNode node) {
        this.visitMethod(node);
    }

    @Override
    public void visitMethod(MethodNode node) {
        if (node == this.runMethod || "<clinit>".equals(node.getName())) {
            return;
        }
        this.visitAnnotations(node.getAnnotations());
        this.visitParameters(node.getParameters());
        this.visitIfPresent(node.getCode());
    }

    @Override
    public void visitAssertStatement(AssertStatement statement) {
        this.visitIfPresent(statement.getBooleanExpression());
        this.visitIfPresent(statement.getMessageExpression());
        this.visitStatement(statement);
    }

    @Override
    public void visitBlockStatement(BlockStatement statement) {
        for (Statement stmt : statement.getStatements()) {
            this.visitIfPresent(stmt);
        }
        this.visitStatement(statement);
    }

    @Override
    public void visitBreakStatement(BreakStatement statement) {
        this.visitStatement(statement);
    }

    @Override
    public void visitCaseStatement(CaseStatement statement) {
        this.visitIfPresent(statement.getExpression());
        this.visitIfPresent(statement.getCode());
        this.visitStatement(statement);
    }

    @Override
    public void visitCatchStatement(CatchStatement statement) {
        this.visitParameter(statement.getVariable());
        this.visitIfPresent(statement.getCode());
        this.visitStatement(statement);
    }

    @Override
    public void visitContinueStatement(ContinueStatement statement) {
        this.visitStatement(statement);
    }

    @Override
    public void visitDoWhileLoop(DoWhileStatement statement) {
        this.visitIfPresent(statement.getLoopBlock());
        this.visitIfPresent(statement.getBooleanExpression());
        this.visitStatement(statement);
    }

    public void visitEmptyStatement(EmptyStatement statement) {
        this.visitStatement(statement);
    }

    @Override
    public void visitExpressionStatement(ExpressionStatement statement) {
        this.visitIfPresent(statement.getExpression());
        this.visitStatement(statement);
    }

    @Override
    public void visitForLoop(ForStatement statement) {
        this.visitParameter(statement.getVariable());
        this.visitIfPresent(statement.getCollectionExpression());
        this.visitIfPresent(statement.getLoopBlock());
        this.visitStatement(statement);
    }

    @Override
    public void visitIfElse(IfStatement statement) {
        this.visitIfPresent(statement.getBooleanExpression());
        this.visitIfPresent(statement.getIfBlock());
        if (statement.getElseBlock() instanceof EmptyStatement) {
            this.visitEmptyStatement((EmptyStatement)statement.getElseBlock());
        } else {
            this.visitIfPresent(statement.getElseBlock());
        }
        this.visitStatement(statement);
    }

    @Override
    public void visitReturnStatement(ReturnStatement statement) {
        this.visitIfPresent(statement.getExpression());
        this.visitStatement(statement);
    }

    @Override
    public void visitSwitch(SwitchStatement statement) {
        this.visitIfPresent(statement.getExpression());
        for (Statement statement2 : statement.getCaseStatements()) {
            statement2.visit(this);
        }
        this.visitIfPresent(statement.getDefaultStatement());
        this.visitStatement(statement);
    }

    @Override
    public void visitSynchronizedStatement(SynchronizedStatement statement) {
        this.visitIfPresent(statement.getExpression());
        this.visitIfPresent(statement.getCode());
        this.visitStatement(statement);
    }

    @Override
    public void visitThrowStatement(ThrowStatement statement) {
        this.visitIfPresent(statement.getExpression());
        this.visitStatement(statement);
    }

    @Override
    public void visitTryCatchFinally(TryCatchStatement statement) {
        this.visitIfPresent(statement.getTryStatement());
        for (Statement statement2 : statement.getCatchStatements()) {
            statement2.visit(this);
        }
        if (statement.getFinallyStatement() instanceof EmptyStatement) {
            this.visitEmptyStatement((EmptyStatement)statement.getFinallyStatement());
        } else {
            this.visitIfPresent(statement.getFinallyStatement());
        }
        this.visitStatement(statement);
    }

    @Override
    public void visitWhileLoop(WhileStatement statement) {
        statement.getBooleanExpression().visit(this);
        statement.getLoopBlock().visit(this);
        this.visitStatement(statement);
    }

    @Override
    public void visitArgumentlistExpression(ArgumentListExpression expression) {
        this.visitTupleExpression(expression);
    }

    @Override
    public void visitArrayExpression(ArrayExpression expression) {
        this.visitAnnotations(expression.getAnnotations());
        this.visitExpressions(expression.getSizeExpression());
        this.visitExpressions(expression.getExpressions());
        this.visitExpression(expression);
    }

    @Override
    public void visitAttributeExpression(AttributeExpression expression) {
        this.visitPropertyExpression(expression);
    }

    @Override
    public void visitBinaryExpression(BinaryExpression expression) {
        this.visitAnnotations(expression.getAnnotations());
        expression.getLeftExpression().visit(this);
        expression.getRightExpression().visit(this);
        this.visitExpression(expression);
    }

    @Override
    public void visitBitwiseNegationExpression(BitwiseNegationExpression expression) {
        this.visitAnnotations(expression.getAnnotations());
        expression.getExpression().visit(this);
        this.visitExpression(expression);
    }

    @Override
    public void visitBooleanExpression(BooleanExpression expression) {
        this.visitAnnotations(expression.getAnnotations());
        expression.getExpression().visit(this);
        this.visitExpression(expression);
    }

    @Override
    public void visitBytecodeExpression(BytecodeExpression expression) {
        this.visitExpression(expression);
    }

    @Override
    public void visitCastExpression(CastExpression expression) {
        this.visitAnnotations(expression.getAnnotations());
        expression.getExpression().visit(this);
        this.visitExpression(expression);
    }

    @Override
    public void visitClassExpression(ClassExpression expression) {
        this.visitAnnotations(expression.getAnnotations());
        this.visitExpression(expression);
    }

    @Override
    public void visitClosureExpression(ClosureExpression expression) {
        this.visitAnnotations(expression.getAnnotations());
        this.visitParameters(expression.getParameters());
        expression.getCode().visit(this);
        this.visitExpression(expression);
    }

    @Override
    public void visitClosureListExpression(ClosureListExpression expression) {
        this.visitAnnotations(expression.getAnnotations());
        this.visitExpressions(expression.getExpressions());
        this.visitExpression(expression);
    }

    @Override
    public void visitConstantExpression(ConstantExpression expression) {
        this.visitExpression(expression);
    }

    @Override
    public void visitConstructorCallExpression(ConstructorCallExpression expression) {
        this.visitAnnotations(expression.getAnnotations());
        if (expression.isUsingAnonymousInnerClass()) {
            this.visitClass(expression.getType());
        }
        expression.getArguments().visit(this);
        this.visitExpression(expression);
    }

    @Override
    public void visitDeclarationExpression(DeclarationExpression expression) {
        this.visitBinaryExpression(expression);
    }

    @Override
    public void visitEmptyExpression(EmptyExpression expression) {
        this.visitExpression(expression);
    }

    @Override
    public void visitFieldExpression(FieldExpression expression) {
        this.visitAnnotations(expression.getAnnotations());
        this.visitExpression(expression);
    }

    @Override
    public void visitGStringExpression(GStringExpression expression) {
        this.visitAnnotations(expression.getAnnotations());
        this.visitExpressions(expression.getStrings());
        this.visitExpressions(expression.getValues());
        this.visitExpression(expression);
    }

    @Override
    public void visitListExpression(ListExpression expression) {
        this.visitAnnotations(expression.getAnnotations());
        this.visitExpressions(expression.getExpressions());
        this.visitExpression(expression);
    }

    @Override
    public void visitMapExpression(MapExpression expression) {
        this.visitAnnotations(expression.getAnnotations());
        this.visitExpressions(expression.getMapEntryExpressions());
        this.visitExpression(expression);
    }

    @Override
    public void visitMapEntryExpression(MapEntryExpression expression) {
        this.visitAnnotations(expression.getAnnotations());
        expression.getKeyExpression().visit(this);
        expression.getValueExpression().visit(this);
        this.visitExpression(expression);
    }

    @Override
    public void visitMethodCallExpression(MethodCallExpression expression) {
        this.visitAnnotations(expression.getAnnotations());
        expression.getObjectExpression().visit(this);
        expression.getMethod().visit(this);
        expression.getArguments().visit(this);
        this.visitIfPresent(GroovyUtils.getTraitFieldExpression(expression));
        ClassNode type = expression.getType();
        if (type.isEnum() && GroovyUtils.isAnonymous(type.redirect()) && expression.getMethodAsString().equals("$INIT")) {
            this.visitClass(type.redirect());
        }
        this.visitExpression(expression);
    }

    @Override
    public void visitMethodPointerExpression(MethodPointerExpression expression) {
        this.visitAnnotations(expression.getAnnotations());
        expression.getExpression().visit(this);
        expression.getMethodName().visit(this);
        this.visitExpression(expression);
    }

    @Override
    public void visitNotExpression(NotExpression expression) {
        this.visitBooleanExpression(expression);
    }

    @Override
    public void visitPostfixExpression(PostfixExpression expression) {
        this.visitAnnotations(expression.getAnnotations());
        expression.getExpression().visit(this);
        this.visitExpression(expression);
    }

    @Override
    public void visitPrefixExpression(PrefixExpression expression) {
        this.visitAnnotations(expression.getAnnotations());
        expression.getExpression().visit(this);
        this.visitExpression(expression);
    }

    @Override
    public void visitPropertyExpression(PropertyExpression expression) {
        this.visitAnnotations(expression.getAnnotations());
        expression.getObjectExpression().visit(this);
        expression.getProperty().visit(this);
        this.visitExpression(expression);
    }

    @Override
    public void visitRangeExpression(RangeExpression expression) {
        this.visitAnnotations(expression.getAnnotations());
        expression.getFrom().visit(this);
        expression.getTo().visit(this);
        this.visitExpression(expression);
    }

    @Override
    public void visitShortTernaryExpression(ElvisOperatorExpression expression) {
        this.visitTernaryExpression(expression);
    }

    @Override
    public void visitSpreadExpression(SpreadExpression expression) {
        this.visitAnnotations(expression.getAnnotations());
        expression.getExpression().visit(this);
        this.visitExpression(expression);
    }

    @Override
    public void visitSpreadMapExpression(SpreadMapExpression expression) {
        this.visitAnnotations(expression.getAnnotations());
        expression.getExpression().visit(this);
        this.visitExpression(expression);
    }

    @Override
    public void visitStaticMethodCallExpression(StaticMethodCallExpression expression) {
        this.visitAnnotations(expression.getAnnotations());
        ClassNode ownerType = expression.getOwnerType();
        expression.getArguments().visit(this);
        if (GroovyUtils.isAnonymous(ownerType)) {
            this.visitClass(ownerType);
        }
        this.visitExpression(expression);
    }

    @Override
    public void visitTernaryExpression(TernaryExpression expression) {
        this.visitAnnotations(expression.getAnnotations());
        expression.getBooleanExpression().visit(this);
        expression.getTrueExpression().visit(this);
        expression.getFalseExpression().visit(this);
        this.visitExpression(expression);
    }

    @Override
    public void visitTupleExpression(TupleExpression expression) {
        this.visitAnnotations(expression.getAnnotations());
        this.visitExpressions(expression.getExpressions());
        this.visitExpression(expression);
    }

    @Override
    public void visitVariableExpression(VariableExpression expression) {
        this.visitAnnotations(expression.getAnnotations());
        if (expression.getAccessedVariable() == expression) {
            this.visitIfPresent(expression.getInitialExpression());
        }
        this.visitExpression(expression);
    }

    @Override
    public void visitUnaryMinusExpression(UnaryMinusExpression expression) {
        this.visitAnnotations(expression.getAnnotations());
        expression.getExpression().visit(this);
        this.visitExpression(expression);
    }

    @Override
    public void visitUnaryPlusExpression(UnaryPlusExpression expression) {
        this.visitAnnotations(expression.getAnnotations());
        expression.getExpression().visit(this);
        this.visitExpression(expression);
    }

    protected void visitAnnotations(Collection<? extends AnnotationNode> nodes) {
        if (DepthFirstVisitor.isNotEmpty(nodes)) {
            for (AnnotationNode annotationNode : nodes) {
                if (annotationNode.isBuiltIn()) continue;
                this.visitAnnotations((Collection)annotationNode.getNodeMetaData("AnnotationCollector"));
                this.visitAnnotation(annotationNode);
            }
        }
    }

    protected void visitAnnotation(AnnotationNode node) {
        this.visitExpressions(node.getMembers().values());
    }

    protected void visitExpressions(Collection<? extends Expression> nodes) {
        if (DepthFirstVisitor.isNotEmpty(nodes)) {
            for (Expression expression : nodes) {
                this.visitIfPresent(expression);
            }
        }
    }

    protected void visitExpression(Expression expression) {
        this.visitIfPresent((Expression)expression.getNodeMetaData("OriginalExpression"));
    }

    protected void visitParameters(Parameter[] nodes) {
        if (DepthFirstVisitor.isNotEmpty(nodes)) {
            Parameter[] parameterArray = nodes;
            int n = nodes.length;
            int n2 = 0;
            while (n2 < n) {
                Parameter node = parameterArray[n2];
                this.visitParameter(node);
                ++n2;
            }
        }
    }

    protected void visitParameter(Parameter parameter) {
        if (parameter != null) {
            this.visitAnnotations(parameter.getAnnotations());
            this.visitIfPresent(parameter.getInitialExpression());
        }
    }

    protected void visitStatement(Statement statement) {
    }

    protected final void visitIfPresent(ASTNode node) {
        if (node != null) {
            node.visit(this);
        }
    }

    protected static boolean isNotEmpty(Object[] array) {
        return array != null && array.length > 0;
    }

    protected static boolean isNotEmpty(Collection<?> collection) {
        return collection != null && !collection.isEmpty();
    }
}

