/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jdt.groovy.model;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.InnerClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.groovy.core.util.GroovyUtils;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.LocalVariable;
import org.eclipse.jdt.internal.core.ResolvedSourceField;
import org.eclipse.jdt.internal.core.ResolvedSourceMethod;
import org.eclipse.jdt.internal.core.ResolvedSourceType;
import org.eclipse.jdt.internal.core.SourceFieldElementInfo;
import org.eclipse.jdt.internal.core.SourceMethodInfo;
import org.eclipse.jdt.internal.core.SourceType;
import org.eclipse.jdt.internal.core.SourceTypeElementInfo;
import org.eclipse.jdt.internal.core.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroovyProjectFacade {
    private IType parent;
    private IJavaProject project;

    public GroovyProjectFacade(IJavaElement element) {
        this(element.getJavaProject());
        this.parent = element instanceof IType ? (IType)element : (IType)element.getAncestor(7);
    }

    public GroovyProjectFacade(IJavaProject project) {
        this.project = project;
    }

    public IJavaProject getProject() {
        return this.project;
    }

    public IJavaElement groovyNodeToJavaElement(ASTNode node, IFile file) {
        ICompilationUnit unit = JavaCore.createCompilationUnitFrom(file);
        if (!(unit instanceof GroovyCompilationUnit)) {
            Util.log(2, "Trying to get a groovy element from a non-groovy file: " + file.getName());
            return unit;
        }
        try {
            int start = node.getStart();
            IJavaElement elt = unit.getElementAt(start);
            if (node instanceof DeclarationExpression) {
                String var = ((DeclarationExpression)node).getVariableExpression().getName();
                int end = start + var.length() - 1;
                String sig = Signature.createTypeSignature(((DeclarationExpression)node).getVariableExpression().getType().getName(), false);
                return new LocalVariable((JavaElement)elt, var, start, end, start, end, sig, null, 0, false);
            }
            return elt;
        }
        catch (Exception e) {
            Util.log(e, "Error converting from Groovy Element to Java Element: " + node.getText());
            return null;
        }
    }

    public IType groovyClassToJavaType(ClassNode node) {
        if (this.parent != null && this.parent.getFullyQualifiedName().equals(node.getName())) {
            return this.parent;
        }
        try {
            ClassNode toLookFor = node;
            if (GroovyUtils.isAnonymous(node)) {
                toLookFor = node.getOuterClass();
                IType enclosing = this.groovyClassToJavaType(toLookFor);
                if (enclosing != null && !enclosing.isBinary()) {
                    return this.fakeAnonymousInnerClass(enclosing, (InnerClassNode)node);
                }
                return this.project.findType(node.getName(), (IProgressMonitor)null);
            }
            String name = toLookFor.getName().replace('$', '.');
            IType type = this.project.findType(name, (IProgressMonitor)null);
            if (type != null && toLookFor != node && !(type = type.getType("", 1)).exists()) {
                type = null;
            }
            return type;
        }
        catch (JavaModelException e) {
            Util.log(e, "Error converting from Groovy Element to Java Element: " + node.getName());
            return null;
        }
    }

    private IType fakeAnonymousInnerClass(IType outer, final InnerClassNode inner) {
        return new ResolvedSourceType((JavaElement)((Object)outer), inner.getName(), GroovyUtils.getTypeSignature(inner, true, true)){

            public Object getElementInfo() throws JavaModelException {
                try {
                    return super.getElementInfo();
                }
                catch (JavaModelException jme) {
                    if (!jme.getJavaModelStatus().isDoesNotExist()) {
                        throw jme;
                    }
                    1 anonType = this;
                    return new SourceTypeElementInfo(anonType, inner){
                        {
                            this.setHandle(iType);
                            this.setFlags(innerClassNode.getModifiers());
                            ClassNode[] faces = innerClassNode.getInterfaces();
                            char[][] names = new char[faces.length][];
                            int i = 0;
                            while (i < faces.length) {
                                names[i] = faces[i].getName().toCharArray();
                                ++i;
                            }
                            this.setSuperInterfaceNames(names);
                            this.setSuperclassName(innerClassNode.getUnresolvedSuperClass().getName().toCharArray());
                            this.setNameSourceStart(innerClassNode.getNameStart());
                            this.setNameSourceEnd(innerClassNode.getNameEnd());
                            this.setSourceRangeStart(innerClassNode.getStart());
                            this.setSourceRangeEnd(innerClassNode.getEnd());
                        }
                    };
                }
            }

            public IField getField(String fieldName) {
                final FieldNode fieldNode = inner.getDeclaredField(fieldName);
                if (fieldNode == null) {
                    return super.getField(fieldName);
                }
                String uniqueKey = String.valueOf(GroovyUtils.getTypeSignature(fieldNode.getDeclaringClass(), true, true)) + '.' + fieldName + ")" + GroovyUtils.getTypeSignature(fieldNode.getType(), true, true);
                return new ResolvedSourceField(this, fieldName, uniqueKey){

                    public Object getElementInfo() throws JavaModelException {
                        try {
                            return super.getElementInfo();
                        }
                        catch (JavaModelException jme) {
                            if (!jme.getJavaModelStatus().isDoesNotExist()) {
                                throw jme;
                            }
                            return new SourceFieldElementInfo(fieldNode){
                                {
                                    this.setTypeName(fieldNode.getType().toString(false).toCharArray());
                                    this.setNameSourceStart(fieldNode.getNameStart());
                                    this.setNameSourceEnd(fieldNode.getNameEnd());
                                    this.setSourceRangeStart(fieldNode.getStart());
                                    this.setSourceRangeEnd(fieldNode.getEnd());
                                    this.setFlags(fieldNode.getModifiers());
                                }
                            };
                        }
                    }
                };
            }

            public IMethod getMethod(String methodName, String[] parameterTypeSignatures) {
                final MethodNode methodNode = inner.getDeclaredMethod(methodName, GroovyProjectFacade.this.getParametersForTypes(parameterTypeSignatures));
                if (methodNode == null) {
                    return super.getMethod(methodName, parameterTypeSignatures);
                }
                String uniqueKey = String.valueOf(GroovyUtils.getTypeSignature(methodNode.getDeclaringClass(), true, true)) + '.' + methodName + '(' + ')' + GroovyUtils.getTypeSignature(methodNode.getReturnType(), true, true);
                return new ResolvedSourceMethod(this, methodName, parameterTypeSignatures, uniqueKey){

                    public Object getElementInfo() throws JavaModelException {
                        try {
                            return super.getElementInfo();
                        }
                        catch (JavaModelException jme) {
                            if (!jme.getJavaModelStatus().isDoesNotExist()) {
                                throw jme;
                            }
                            return new SourceMethodInfo(methodNode){
                                {
                                    this.setReturnType(methodNode.getReturnType().getNameWithoutPackage().toCharArray());
                                    this.setNameSourceStart(methodNode.getNameStart());
                                    this.setNameSourceEnd(methodNode.getNameEnd());
                                    this.setSourceRangeStart(methodNode.getStart());
                                    this.setSourceRangeEnd(methodNode.getEnd());
                                    this.setFlags(methodNode.getModifiers());
                                }
                            };
                        }
                    }
                };
            }
        };
    }

    GroovyCompilationUnit groovyModuleToCompilationUnit(ModuleNode node) {
        IType type;
        ClassNode classNode;
        List<ClassNode> classes = node.getClasses();
        ClassNode classNode2 = classNode = classes.size() > 0 ? classes.get(0) : null;
        if (classNode != null && (type = this.groovyClassToJavaType(classNode)) instanceof SourceType) {
            return (GroovyCompilationUnit)type.getCompilationUnit();
        }
        Util.log(2, "Trying to get GroovyCompilationUnit for non-groovy module: " + node.getDescription());
        return null;
    }

    public ClassNode getClassNodeForName(String name) {
        try {
            IType type = this.project.findType(name, (IProgressMonitor)null);
            if (type instanceof SourceType) {
                return this.javaTypeToGroovyClass(type);
            }
        }
        catch (JavaModelException e) {
            Util.log(e);
        }
        return null;
    }

    private Parameter[] getParametersForTypes(String[] signatures) {
        int n = signatures.length;
        Parameter[] parameters = new Parameter[n];
        int i = 0;
        while (i < n) {
            parameters[i] = new Parameter(ClassHelper.makeWithoutCaching(Signature.toString(signatures[i])), null);
            ++i;
        }
        return parameters;
    }

    private ClassNode javaTypeToGroovyClass(IType type) {
        ICompilationUnit unit = type.getCompilationUnit();
        if (unit instanceof GroovyCompilationUnit) {
            ModuleNode module = ((GroovyCompilationUnit)unit).getModuleNode();
            List<ClassNode> classes = module.getClasses();
            for (ClassNode classNode : classes) {
                if (!classNode.getNameWithoutPackage().equals(type.getElementName())) continue;
                return classNode;
            }
        }
        return null;
    }

    public List<IType> findAllRunnableTypes() throws JavaModelException {
        IPackageFragmentRoot[] roots;
        ArrayList<IType> results = new ArrayList<IType>();
        IPackageFragmentRoot[] iPackageFragmentRootArray = roots = this.project.getAllPackageFragmentRoots();
        int n = roots.length;
        int n2 = 0;
        while (n2 < n) {
            IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
            if (!root.isReadOnly()) {
                IJavaElement[] children;
                IJavaElement[] iJavaElementArray = children = root.getChildren();
                int n3 = children.length;
                int n4 = 0;
                while (n4 < n3) {
                    IJavaElement child = iJavaElementArray[n4];
                    if (child.getElementType() == 4) {
                        ICompilationUnit[] units;
                        ICompilationUnit[] iCompilationUnitArray = units = ((IPackageFragment)child).getCompilationUnits();
                        int n5 = units.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            ICompilationUnit unit = iCompilationUnitArray[n6];
                            results.addAll(GroovyProjectFacade.findAllRunnableTypes(unit));
                            ++n6;
                        }
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return results;
    }

    public static List<IType> findAllRunnableTypes(ICompilationUnit unit) throws JavaModelException {
        IType[] types;
        LinkedList<IType> results = new LinkedList<IType>();
        IType[] iTypeArray = types = unit.getAllTypes();
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            IType type = iTypeArray[n2];
            if (GroovyProjectFacade.hasRunnableMain(type)) {
                results.add(type);
            }
            ++n2;
        }
        return results;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean hasRunnableMain(IType type) {
        try {
            IMethod[] allMethods;
            IMethod[] iMethodArray = allMethods = type.getMethods();
            int n = allMethods.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                IMethod method = iMethodArray[n2];
                if (method.getElementName().equals("main") && Flags.isStatic(method.getFlags()) && (method.getReturnType().equals("V") || method.getReturnType().endsWith("java.lang.Object;")) && GroovyProjectFacade.hasAppropriateArrayArgsForMain(method.getParameterTypes())) {
                    return true;
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            Util.log(e, "Exception searching for main method in " + type);
        }
        return false;
    }

    private static boolean hasAppropriateArrayArgsForMain(String[] params) {
        String typeName;
        if (params == null || params.length != 1) {
            return false;
        }
        int array = Signature.getArrayCount(params[0]);
        if (array == 1) {
            typeName = "String";
        } else if (array == 0) {
            typeName = "Object";
        } else {
            return false;
        }
        String sigNoArray = Signature.getElementType(params[0]);
        String name = Signature.getSignatureSimpleName(sigNoArray);
        String qual = Signature.getSignatureQualifier(sigNoArray);
        return name.equals(typeName) && (qual == null || qual.equals("java.lang") || qual.equals(""));
    }

    public boolean isGroovyScript(IType type) {
        ClassNode node = this.javaTypeToGroovyClass(type);
        if (node != null) {
            return node.isScript();
        }
        return false;
    }

    public List<IType> findAllScripts() throws JavaModelException {
        IPackageFragmentRoot[] roots;
        ArrayList<IType> results = new ArrayList<IType>();
        IPackageFragmentRoot[] iPackageFragmentRootArray = roots = this.project.getAllPackageFragmentRoots();
        int n = roots.length;
        int n2 = 0;
        while (n2 < n) {
            IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
            if (!root.isReadOnly()) {
                IJavaElement[] children;
                IJavaElement[] iJavaElementArray = children = root.getChildren();
                int n3 = children.length;
                int n4 = 0;
                while (n4 < n3) {
                    IJavaElement child = iJavaElementArray[n4];
                    if (child.getElementType() == 4) {
                        ICompilationUnit[] units;
                        ICompilationUnit[] iCompilationUnitArray = units = ((IPackageFragment)child).getCompilationUnits();
                        int n5 = units.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            ICompilationUnit unit = iCompilationUnitArray[n6];
                            if (unit instanceof GroovyCompilationUnit) {
                                IType[] iTypeArray = unit.getTypes();
                                int n7 = iTypeArray.length;
                                int n8 = 0;
                                while (n8 < n7) {
                                    IType type = iTypeArray[n8];
                                    if (this.isGroovyScript(type)) {
                                        results.add(type);
                                    }
                                    ++n8;
                                }
                            }
                            ++n6;
                        }
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return results;
    }

    public boolean isGroovyScript(ICompilationUnit unit) {
        GroovyCompilationUnit gunit;
        ModuleNode module;
        if (unit instanceof GroovyCompilationUnit && (module = (gunit = (GroovyCompilationUnit)unit).getModuleNode()) != null) {
            for (ClassNode clazz : module.getClasses()) {
                if (!clazz.isScript()) continue;
                return true;
            }
        }
        return false;
    }
}

