/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jdt.groovy.internal.compiler.ast;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.ErrorCollector;
import org.codehaus.groovy.control.messages.Message;
import org.codehaus.groovy.control.messages.SimpleMessage;
import org.codehaus.groovy.eclipse.GroovyLogManager;
import org.codehaus.groovy.eclipse.TraceCategory;
import org.eclipse.jdt.internal.core.util.Util;

public class GroovyErrorCollectorForJDT
extends ErrorCollector {
    public GroovyErrorCollectorForJDT(CompilerConfiguration configuration) {
        super(configuration);
    }

    public void addErrorAndContinue(Message message) {
        try {
            String error;
            if (message instanceof SimpleMessage) {
                error = ((SimpleMessage)message).getMessage();
            } else {
                StringWriter writer = new StringWriter();
                message.write(new PrintWriter(writer));
                error = writer.toString().trim();
            }
            if (GroovyLogManager.manager.hasLoggers()) {
                GroovyLogManager.manager.log(TraceCategory.COMPILER, error);
            }
        }
        catch (Throwable t) {
            Util.log(t);
        }
        super.addErrorAndContinue(message);
    }

    protected void failIfErrors() throws CompilationFailedException {
        if (this.transformActive) {
            super.failIfErrors();
        }
    }
}

